/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNStreamGobbler
extends Thread {
    private InputStreamReader is;
    private final StringBuffer result = new StringBuffer();
    private IOException error;
    private boolean myIsEOF;
    private boolean myIsClosed;

    public SVNStreamGobbler(InputStream is) {
        try {
            this.is = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.is = new InputStreamReader(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        char[] buffer = new char[1024];
        StringBuffer stringBuffer = this.result;
        synchronized (stringBuffer) {
            block6: {
                try {
                    int r;
                    while ((r = this.is.read(buffer)) >= 0) {
                        if (r <= 0) continue;
                        this.result.append(buffer, 0, r);
                    }
                }
                catch (IOException e) {
                    if (this.myIsClosed) break block6;
                    this.error = e;
                }
            }
            this.myIsEOF = true;
            this.result.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitFor() {
        StringBuffer stringBuffer = this.result;
        synchronized (stringBuffer) {
            while (true) {
                if (this.myIsEOF) {
                    return;
                }
                try {
                    this.result.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        StringBuffer stringBuffer = this.result;
        synchronized (stringBuffer) {
            this.myIsEOF = true;
            this.result.notifyAll();
            this.myIsClosed = true;
            SVNFileUtil.closeFile(this.is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResult() {
        StringBuffer stringBuffer = this.result;
        synchronized (stringBuffer) {
            return this.result.toString();
        }
    }

    public IOException getError() {
        return this.error;
    }
}

