/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNCharsetOutputStream;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDiffCallback
extends AbstractDiffCallback {
    private ISVNDiffGenerator myGenerator;
    private OutputStream myResult;
    private long myRevision2;
    private long myRevision1;
    private static final SVNStatusType[] EMPTY_STATUS = new SVNStatusType[]{SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN};

    public SVNDiffCallback(SVNAdminArea adminArea, ISVNDiffGenerator generator, long rev1, long rev2, OutputStream result) {
        super(adminArea);
        this.myGenerator = generator;
        this.myResult = result;
        this.myRevision1 = rev1;
        this.myRevision2 = rev2;
    }

    public File createTempDirectory() throws SVNException {
        return this.myGenerator.createTempDirectory();
    }

    public boolean isDiffUnversioned() {
        return this.myGenerator.isDiffUnversioned();
    }

    public boolean isDiffCopiedAsAdded() {
        return this.myGenerator.isDiffCopied();
    }

    public SVNStatusType directoryAdded(String path, long revision, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        this.myGenerator.displayAddedDirectory(this.getDisplayPath(path), this.getRevision(this.myRevision1), this.getRevision(revision));
        return SVNStatusType.UNKNOWN;
    }

    public SVNStatusType directoryDeleted(String path) throws SVNException {
        this.myGenerator.displayDeletedDirectory(this.getDisplayPath(path), this.getRevision(this.myRevision1), this.getRevision(this.myRevision2));
        return SVNStatusType.UNKNOWN;
    }

    public SVNStatusType[] fileAdded(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, SVNProperties originalProperties, SVNProperties diff, boolean[] isTreeConflicted) throws SVNException {
        if (!this.myGenerator.isDiffAdded()) {
            return EMPTY_STATUS;
        }
        if (file2 != null) {
            this.displayFileDiff(path, null, file2, revision1, revision2, mimeType1, mimeType2, originalProperties, diff);
        }
        if (diff != null && !diff.isEmpty()) {
            this.propertiesChanged(path, originalProperties, diff, null);
        }
        return EMPTY_STATUS;
    }

    public SVNStatusType[] fileChanged(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, SVNProperties originalProperties, SVNProperties diff, boolean[] isTreeConflicted) throws SVNException {
        if (file1 != null) {
            this.displayFileDiff(path, file1, file2, revision1, revision2, mimeType1, mimeType2, originalProperties, diff);
        }
        if (diff != null && !diff.isEmpty()) {
            this.propertiesChanged(path, originalProperties, diff, null);
        }
        return EMPTY_STATUS;
    }

    public SVNStatusType fileDeleted(String path, File file1, File file2, String mimeType1, String mimeType2, SVNProperties originalProperties, boolean[] isTreeConflicted) throws SVNException {
        if (!this.myGenerator.isDiffDeleted()) {
            return SVNStatusType.UNKNOWN;
        }
        if (file1 != null) {
            this.displayFileDiff(path, file1, file2, this.myRevision1, this.myRevision2, mimeType1, mimeType2, originalProperties, null);
        }
        return SVNStatusType.UNKNOWN;
    }

    private void displayFileDiff(String path, File file1, File file2, long revision1, long revision2, String mimeType1, String mimeType2, SVNProperties originalProperties, SVNProperties diff) throws SVNException {
        boolean resetEncoding = false;
        OutputStream result = this.myResult;
        String encoding = this.defineEncoding(originalProperties, diff);
        if (encoding != null) {
            this.myGenerator.setEncoding(encoding);
            resetEncoding = true;
        } else {
            String conversionEncoding = this.defineConversionEncoding(originalProperties, diff);
            if (conversionEncoding != null) {
                resetEncoding = this.adjustDiffGenerator("UTF-8");
                result = new SVNCharsetOutputStream(result, Charset.forName("UTF-8"), Charset.forName(conversionEncoding), CodingErrorAction.IGNORE, CodingErrorAction.IGNORE);
            }
        }
        try {
            this.myGenerator.displayFileDiff(this.getDisplayPath(path), file1, file2, this.getRevision(revision1), this.getRevision(revision2), mimeType1, mimeType2, result);
        }
        finally {
            if (resetEncoding) {
                this.myGenerator.setEncoding(null);
                this.myGenerator.setEOL(null);
            }
            if (result instanceof SVNCharsetOutputStream) {
                try {
                    result.flush();
                }
                catch (IOException e) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e), e, SVNLogType.WC);
                }
            }
        }
    }

    private boolean adjustDiffGenerator(String charset) {
        if (this.myGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator generator = (DefaultSVNDiffGenerator)this.myGenerator;
            boolean encodingAdjusted = false;
            if (!generator.hasEncoding()) {
                generator.setEncoding(charset);
                encodingAdjusted = true;
            }
            if (!generator.hasEOL()) {
                byte[] eol;
                String eolString = System.getProperty("line.separator");
                try {
                    eol = eolString.getBytes(charset);
                }
                catch (UnsupportedEncodingException e) {
                    eol = eolString.getBytes();
                }
                generator.setEOL(eol);
            }
            return encodingAdjusted;
        }
        return false;
    }

    public SVNStatusType propertiesChanged(String path, SVNProperties originalProperties, SVNProperties diff, boolean[] isTreeConflicted) throws SVNException {
        originalProperties = originalProperties == null ? new SVNProperties() : originalProperties;
        diff = diff == null ? new SVNProperties() : diff;
        SVNProperties regularDiff = new SVNProperties();
        this.categorizeProperties(diff, regularDiff, null, null);
        if (regularDiff.isEmpty()) {
            return SVNStatusType.UNKNOWN;
        }
        this.myGenerator.displayPropDiff(this.getDisplayPath(path), originalProperties, regularDiff, this.myResult);
        return SVNStatusType.UNKNOWN;
    }

    private String getRevision(long revision) {
        if (revision >= 0L) {
            return "(revision " + revision + ")";
        }
        return "(working copy)";
    }

    private String defineEncoding(SVNProperties properties, SVNProperties diff) {
        if (this.myGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator defaultGenerator = (DefaultSVNDiffGenerator)this.myGenerator;
            if (defaultGenerator.hasEncoding()) {
                return null;
            }
            String originalEncoding = this.getCharsetByMimeType(properties, defaultGenerator);
            if (originalEncoding != null) {
                return originalEncoding;
            }
            String changedEncoding = this.getCharsetByMimeType(diff, defaultGenerator);
            if (changedEncoding != null) {
                return changedEncoding;
            }
        }
        return null;
    }

    private String defineConversionEncoding(SVNProperties properties, SVNProperties diff) {
        if (this.myGenerator instanceof DefaultSVNDiffGenerator) {
            DefaultSVNDiffGenerator defaultGenerator = (DefaultSVNDiffGenerator)this.myGenerator;
            if (defaultGenerator.hasEncoding()) {
                return null;
            }
            String originalCharset = this.getCharset(properties, defaultGenerator);
            if (originalCharset != null) {
                return originalCharset;
            }
            String changedCharset = this.getCharset(diff, defaultGenerator);
            if (changedCharset != null) {
                return changedCharset;
            }
            String globalEncoding = this.getCharset(defaultGenerator.getGlobalEncoding(), defaultGenerator, false);
            if (globalEncoding != null) {
                return globalEncoding;
            }
        }
        return null;
    }

    private String getCharsetByMimeType(SVNProperties properties, DefaultSVNDiffGenerator generator) {
        if (properties == null) {
            return null;
        }
        String mimeType = properties.getStringValue("svn:mime-type");
        String charset = SVNPropertiesManager.determineEncodingByMimeType(mimeType);
        return this.getCharset(charset, generator, false);
    }

    private String getCharset(SVNProperties properties, DefaultSVNDiffGenerator generator) {
        if (properties == null) {
            return null;
        }
        String charset = properties.getStringValue("svnkit:charset");
        return this.getCharset(charset, generator, true);
    }

    private String getCharset(String charset, DefaultSVNDiffGenerator generator, boolean allowNative) {
        if (charset == null) {
            return null;
        }
        if (allowNative && "native".equals(charset)) {
            return generator.getEncoding();
        }
        if (Charset.isSupported(charset)) {
            return charset;
        }
        return null;
    }

    public SVNStatusType directoryDeleted(String path, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        return this.directoryDeleted(path);
    }

    public void directoryOpened(String path, long revision, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
    }

    public SVNStatusType[] directoryClosed(String path, boolean[] isTreeConflicted) throws SVNException {
        this.setIsConflicted(isTreeConflicted, false);
        return EMPTY_STATUS;
    }
}

