/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNFileListUtil {
    private static boolean ourIsCompositionEnabled = Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("svnkit.fs.composeFileNames", "true"));

    public static synchronized void setCompositionEnabled(boolean enabled) {
        ourIsCompositionEnabled = enabled;
    }

    public static synchronized boolean isCompositionEnabled() {
        return ourIsCompositionEnabled;
    }

    private static String[] list(File directory) {
        if (!SVNFileUtil.isOSX) {
            return directory.list();
        }
        String[] fileNames = directory.list();
        if (fileNames == null) {
            return null;
        }
        String[] composedFileNames = new String[fileNames.length];
        int i = 0;
        while (i < composedFileNames.length) {
            composedFileNames[i] = !SVNFileListUtil.isCompositionEnabled() ? SVNFileListUtil.decompose(fileNames[i]) : SVNFileListUtil.compose(fileNames[i]);
            ++i;
        }
        return composedFileNames;
    }

    public static File[] listFiles(File directory) {
        if (SVNFileUtil.isOSX) {
            String[] fileNames = SVNFileListUtil.list(directory);
            if (fileNames == null) {
                return null;
            }
            File[] files = new File[fileNames.length];
            int i = 0;
            while (i < files.length) {
                files[i] = new File(directory.getPath(), fileNames[i]);
                ++i;
            }
            return files;
        }
        if (SVNFileUtil.isOpenVMS) {
            File[] files = directory.listFiles();
            if (files == null || files.length == 0) {
                return files;
            }
            File[] processed = new File[files.length];
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                String name = file.getName();
                processed[i] = file.isFile() && name.endsWith(".") && (file = new File(directory, name = name.substring(0, name.lastIndexOf(46)))).exists() && file.isFile() ? file : file;
                ++i;
            }
            return processed;
        }
        File[] files = directory.listFiles();
        return files != null ? SVNFileListUtil.sort(files) : null;
    }

    private static File[] sort(File[] files) {
        SVNHashMap map = new SVNHashMap();
        int i = 0;
        while (i < files.length) {
            map.put(files[i].getName(), files[i]);
            ++i;
        }
        return map.values().toArray(new File[map.size()]);
    }

    private static String compose(String decomposedString) {
        if (decomposedString == null) {
            return null;
        }
        StringBuffer buffer = null;
        int i = 1;
        int length = decomposedString.length();
        while (i < length) {
            char chr = decomposedString.charAt(i);
            if (chr == '\u0300') {
                buffer = SVNFileListUtil.compose(i, "AaEeIiOoUu", "\u00c0\u00e0\u00c8\u00e8\u00cc\u00ec\u00d2\u00f2\u00d9\u00f9", decomposedString, buffer);
            } else if (chr == '\u0301') {
                buffer = SVNFileListUtil.compose(i, "AaEeIiOoUuYy", "\u00c1\u00e1\u00c9\u00e9\u00cd\u00ed\u00d3\u00f3\u00da\u00fa\u00dd\u00fd", decomposedString, buffer);
            } else if (chr == '\u0302') {
                buffer = SVNFileListUtil.compose(i, "AaEeIiOoUuYy", "\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177", decomposedString, buffer);
            } else if (chr == '\u0303') {
                buffer = SVNFileListUtil.compose(i, "AaNnOoUu", "\u00c3\u00e3\u00d1\u00f1\u00d5\u00f5\u0168\u0169", decomposedString, buffer);
            } else if (chr == '\u0308') {
                buffer = SVNFileListUtil.compose(i, "AaEeIiOoUuYy", "\u00c4\u00e4\u00cb\u00eb\u00cf\u00ef\u00d6\u00f6\u00dc\u00fc\u0178\u00ff", decomposedString, buffer);
            } else if (chr == '\u030a') {
                buffer = SVNFileListUtil.compose(i, "Aa", "\u00c5\u00e5", decomposedString, buffer);
            } else if (chr == '\u0327') {
                buffer = SVNFileListUtil.compose(i, "Cc", "\u00c7\u00e7", decomposedString, buffer);
            } else if (buffer != null) {
                buffer.append(chr);
            }
            ++i;
        }
        if (buffer == null) {
            return decomposedString;
        }
        return buffer.toString();
    }

    private static String decompose(String composedString) {
        if (composedString == null) {
            return null;
        }
        StringBuffer buffer = null;
        int i = 0;
        int length = composedString.length();
        while (i < length) {
            char chr = composedString.charAt(i);
            switch (chr) {
                case '\u00c0': {
                    buffer = SVNFileListUtil.decompose("A\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00c1': {
                    buffer = SVNFileListUtil.decompose("A\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00c2': {
                    buffer = SVNFileListUtil.decompose("A\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00c3': {
                    buffer = SVNFileListUtil.decompose("A\u0303", i, composedString, buffer);
                    break;
                }
                case '\u00c4': {
                    buffer = SVNFileListUtil.decompose("A\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00c5': {
                    buffer = SVNFileListUtil.decompose("A\u030a", i, composedString, buffer);
                    break;
                }
                case '\u00c7': {
                    buffer = SVNFileListUtil.decompose("C\u0327", i, composedString, buffer);
                    break;
                }
                case '\u00c8': {
                    buffer = SVNFileListUtil.decompose("E\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00c9': {
                    buffer = SVNFileListUtil.decompose("E\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00ca': {
                    buffer = SVNFileListUtil.decompose("E\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00cb': {
                    buffer = SVNFileListUtil.decompose("E\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00cc': {
                    buffer = SVNFileListUtil.decompose("I\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00cd': {
                    buffer = SVNFileListUtil.decompose("I\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00ce': {
                    buffer = SVNFileListUtil.decompose("I\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00cf': {
                    buffer = SVNFileListUtil.decompose("I\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00d1': {
                    buffer = SVNFileListUtil.decompose("N\u0303", i, composedString, buffer);
                    break;
                }
                case '\u00d2': {
                    buffer = SVNFileListUtil.decompose("O\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00d3': {
                    buffer = SVNFileListUtil.decompose("O\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00d4': {
                    buffer = SVNFileListUtil.decompose("O\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00d5': {
                    buffer = SVNFileListUtil.decompose("O\u0303", i, composedString, buffer);
                    break;
                }
                case '\u00d6': {
                    buffer = SVNFileListUtil.decompose("O\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00d9': {
                    buffer = SVNFileListUtil.decompose("U\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00da': {
                    buffer = SVNFileListUtil.decompose("U\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00db': {
                    buffer = SVNFileListUtil.decompose("U\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00dc': {
                    buffer = SVNFileListUtil.decompose("U\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00dd': {
                    buffer = SVNFileListUtil.decompose("Y\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00e0': {
                    buffer = SVNFileListUtil.decompose("a\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00e1': {
                    buffer = SVNFileListUtil.decompose("a\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00e2': {
                    buffer = SVNFileListUtil.decompose("a\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00e3': {
                    buffer = SVNFileListUtil.decompose("a\u0303", i, composedString, buffer);
                    break;
                }
                case '\u00e4': {
                    buffer = SVNFileListUtil.decompose("a\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00e5': {
                    buffer = SVNFileListUtil.decompose("a\u030a", i, composedString, buffer);
                    break;
                }
                case '\u00e7': {
                    buffer = SVNFileListUtil.decompose("c\u0327", i, composedString, buffer);
                    break;
                }
                case '\u00e8': {
                    buffer = SVNFileListUtil.decompose("e\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00e9': {
                    buffer = SVNFileListUtil.decompose("e\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00ea': {
                    buffer = SVNFileListUtil.decompose("e\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00eb': {
                    buffer = SVNFileListUtil.decompose("e\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00ec': {
                    buffer = SVNFileListUtil.decompose("i\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00ed': {
                    buffer = SVNFileListUtil.decompose("i\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00ee': {
                    buffer = SVNFileListUtil.decompose("i\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00ef': {
                    buffer = SVNFileListUtil.decompose("i\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00ff': {
                    buffer = SVNFileListUtil.decompose("y\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00f1': {
                    buffer = SVNFileListUtil.decompose("n\u0303", i, composedString, buffer);
                    break;
                }
                case '\u00f2': {
                    buffer = SVNFileListUtil.decompose("o\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00f3': {
                    buffer = SVNFileListUtil.decompose("o\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00f4': {
                    buffer = SVNFileListUtil.decompose("o\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00f5': {
                    buffer = SVNFileListUtil.decompose("o\u0303", i, composedString, buffer);
                    break;
                }
                case '\u00f6': {
                    buffer = SVNFileListUtil.decompose("o\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00f9': {
                    buffer = SVNFileListUtil.decompose("u\u0300", i, composedString, buffer);
                    break;
                }
                case '\u00fa': {
                    buffer = SVNFileListUtil.decompose("u\u0301", i, composedString, buffer);
                    break;
                }
                case '\u00fb': {
                    buffer = SVNFileListUtil.decompose("u\u0302", i, composedString, buffer);
                    break;
                }
                case '\u00fc': {
                    buffer = SVNFileListUtil.decompose("u\u0308", i, composedString, buffer);
                    break;
                }
                case '\u00fd': {
                    buffer = SVNFileListUtil.decompose("y\u0301", i, composedString, buffer);
                    break;
                }
                case '\u0168': {
                    buffer = SVNFileListUtil.decompose("U\u0303", i, composedString, buffer);
                    break;
                }
                case '\u0169': {
                    buffer = SVNFileListUtil.decompose("u\u0303", i, composedString, buffer);
                    break;
                }
                case '\u0176': {
                    buffer = SVNFileListUtil.decompose("Y\u0302", i, composedString, buffer);
                    break;
                }
                case '\u0177': {
                    buffer = SVNFileListUtil.decompose("y\u0302", i, composedString, buffer);
                    break;
                }
                case '\u0178': {
                    buffer = SVNFileListUtil.decompose("Y\u0308", i, composedString, buffer);
                    break;
                }
                default: {
                    if (buffer == null) break;
                    buffer.append(chr);
                }
            }
            ++i;
        }
        if (buffer == null) {
            return composedString;
        }
        return buffer.toString();
    }

    private static StringBuffer decompose(String replacement, int index, String composedString, StringBuffer buffer) {
        if (buffer == null) {
            buffer = new StringBuffer(composedString.length());
            buffer.append(composedString, 0, index);
        }
        buffer.append(replacement);
        return buffer;
    }

    private static StringBuffer compose(int i, String decomposedChars, String composedChars, String decomposedString, StringBuffer buffer) {
        char previousChar = decomposedString.charAt(i - 1);
        int decomposedIndex = decomposedChars.indexOf(previousChar);
        if (decomposedIndex >= 0) {
            if (buffer == null) {
                buffer = new StringBuffer(decomposedString.length() + 2);
                buffer.append(decomposedString.substring(0, i - 1));
            } else {
                buffer.delete(buffer.length() - 1, buffer.length());
            }
            buffer.append(composedChars.charAt(decomposedIndex));
        } else if (buffer == null) {
            buffer = new StringBuffer(decomposedString.length() + 2);
            buffer.append(decomposedString.substring(0, i));
        }
        return buffer;
    }
}

