/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPath {
    private String myTarget;
    private SVNRevision myPegRevision = SVNRevision.UNDEFINED;
    private File myFile;

    public SVNPath(String target, SVNRevision pegRevision) {
        this.myTarget = target;
        this.myPegRevision = pegRevision;
    }

    public SVNPath(String target) throws SVNException {
        this(target, false);
    }

    public SVNPath(String target, boolean keepPegRevision) throws SVNException {
        this.myTarget = target;
        this.parsePegRevision(keepPegRevision);
        this.myTarget = SVNPathUtil.canonicalizePath(this.myTarget);
        SVNPath.assertControlChars(this.isURL() ? SVNEncodingUtil.uriDecode(this.myTarget) : this.myTarget);
    }

    public SVNPath(String target, boolean keepPegRevision, boolean parsePegRevision) throws SVNException {
        this.myTarget = target;
        if (parsePegRevision) {
            this.parsePegRevision(keepPegRevision);
        }
        this.myTarget = SVNPathUtil.canonicalizePath(this.myTarget);
        SVNPath.assertControlChars(this.isURL() ? SVNEncodingUtil.uriDecode(this.myTarget) : this.myTarget);
    }

    public String getTarget() {
        return this.myTarget;
    }

    public boolean isURL() {
        return SVNPathUtil.isURL(this.myTarget);
    }

    public boolean isFile() {
        return !this.isURL();
    }

    public File getFile() {
        if (this.myFile != null) {
            return this.myFile;
        }
        if (this.isFile()) {
            return new File(this.myTarget).getAbsoluteFile();
        }
        return null;
    }

    public SVNURL getURL() throws SVNException {
        if (this.isURL()) {
            return SVNURL.parseURIEncoded(this.myTarget);
        }
        return null;
    }

    public SVNRevision getPegRevision() {
        return this.myPegRevision;
    }

    private void parsePegRevision(boolean use) throws SVNException {
        int index = this.myTarget.lastIndexOf(64);
        if (index > 0) {
            SVNRevision revision;
            String revStr = this.myTarget.substring(index + 1);
            if (revStr.indexOf(47) >= 0) {
                return;
            }
            if (revStr.length() == 0) {
                if (use) {
                    this.myPegRevision = this.isURL() ? SVNRevision.HEAD : SVNRevision.BASE;
                }
                this.myTarget = this.myTarget.substring(0, index);
                return;
            }
            if (this.isURL() && revStr.length() > 6 && revStr.toLowerCase().startsWith("%7b") && revStr.toLowerCase().endsWith("%7d")) {
                revStr = SVNEncodingUtil.uriDecode(revStr);
            }
            if (revStr.startsWith("r")) {
                revStr = revStr.substring("r".length());
            }
            if ((revision = SVNRevision.parse(revStr)) != SVNRevision.UNDEFINED) {
                if (use) {
                    this.myPegRevision = revision;
                }
                this.myTarget = this.myTarget.substring(0, index);
                return;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Syntax error parsing peg revision ''{0}''", (Object)this.myTarget.substring(index + 1));
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        } else if (index == 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "''{0}'' is just a peg revision. May be try ''{0}@'' instead?", (Object)this.myTarget);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
    }

    protected static void assertControlChars(String path) throws SVNException {
        if (path != null) {
            int i = 0;
            while (i < path.length()) {
                char ch = path.charAt(i);
                String code = Integer.toHexString(ch);
                if (code.length() < 2) {
                    code = "0" + code;
                }
                if (SVNEncodingUtil.isASCIIControlChar(ch)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_PATH_SYNTAX, "Invalid control character '0x" + code + "' in path '" + path + "'");
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
                ++i;
            }
        }
    }
}

