/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminArea14Factory
extends SVNAdminAreaFactory {
    public static final int WC_FORMAT = 8;

    protected void doCreateVersionedDirectory(File path, String url, String rootURL, String uuid, long revNumber, SVNDepth depth) throws SVNException {
        SVNAdminArea14 adminArea = new SVNAdminArea14(path);
        ((SVNAdminArea)adminArea).createVersionedDirectory(path, url, rootURL, uuid, revNumber, true, depth);
    }

    protected SVNAdminArea doOpen(File path, int version) throws SVNException {
        if (version != this.getSupportedVersion()) {
            return null;
        }
        return new SVNAdminArea14(path);
    }

    protected SVNAdminArea doChangeWCFormat(SVNAdminArea adminArea) throws SVNException {
        if (adminArea == null || adminArea.getClass() == SVNAdminArea14.class) {
            return adminArea;
        }
        SVNAdminArea14 newestAdminArea = new SVNAdminArea14(adminArea.getRoot());
        newestAdminArea.setLocked(true);
        return newestAdminArea.formatWC(adminArea);
    }

    public int getSupportedVersion() {
        return 8;
    }

    protected int doCheckWC(File path, Level logLevel) throws SVNException {
        SVNErrorMessage err;
        String line;
        int formatVersion;
        File entriesFile;
        block11: {
            File adminDir = new File(path, SVNFileUtil.getAdminDirectoryName());
            entriesFile = new File(adminDir, "entries");
            formatVersion = -1;
            BufferedReader reader = null;
            line = null;
            try {
                reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(entriesFile, logLevel, SVNLogType.WC), "UTF-8"));
                line = reader.readLine();
            }
            catch (FileNotFoundException e) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", entriesFile, e.getLocalizedMessage());
                throw new SVNException(err2);
            }
            catch (IOException e) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", entriesFile, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
                SVNFileUtil.closeFile(reader);
                break block11;
            }
            catch (SVNException svne) {
                block12: {
                    block13: {
                        try {
                            SVNFileType type = SVNFileType.getType(path);
                            if (type == SVNFileType.DIRECTORY && entriesFile.exists()) break block12;
                            if (type != SVNFileType.NONE) break block13;
                            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' does not exist", (Object)path);
                            SVNErrorManager.error(err3, SVNLogType.WC);
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(reader);
                            throw throwable;
                        }
                    }
                    SVNFileUtil.closeFile(reader);
                    return 0;
                }
                throw svne;
            }
            SVNFileUtil.closeFile(reader);
        }
        if (line == null || line.length() == 0) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", (Object)entriesFile);
            SVNErrorManager.error(err4, SVNLogType.WC);
        }
        try {
            formatVersion = Integer.parseInt(line.trim());
        }
        catch (NumberFormatException e) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)entriesFile);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return formatVersion;
    }

    protected int getVersion(File path) throws SVNException {
        return SVNAdminUtil.getVersion(path);
    }
}

