/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;

public class SVNAdminArea15
extends SVNAdminArea14 {
    public static final int WC_FORMAT = 9;
    protected static final String ATTRIBUTE_KEEP_LOCAL = "keep-local";
    private static final Set INAPPLICABLE_PROPERTIES = new SVNHashSet();

    static {
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-path");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:file-external-peg-revision");
        INAPPLICABLE_PROPERTIES.add("svn:entry:tree-conflicts");
    }

    public SVNAdminArea15(File dir) {
        super(dir);
    }

    public int getFormatVersion() {
        return 9;
    }

    protected boolean readExtraOptions(BufferedReader reader, SVNEntry entry) throws SVNException, IOException {
        String line = reader.readLine();
        if (this.isEntryFinished(line)) {
            return true;
        }
        String changelist = this.parseString(line);
        if (changelist != null) {
            entry.setChangelistName(changelist);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        boolean keepLocal = this.parseBoolean(line, ATTRIBUTE_KEEP_LOCAL);
        if (keepLocal) {
            entry.setKeepLocal(keepLocal);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        String workingSize = this.parseString(line);
        if (workingSize != null) {
            try {
                long size = Long.parseLong(workingSize);
                entry.setWorkingSize(size);
            }
            catch (NumberFormatException nfe) {
                entry.setWorkingSize(-1L);
            }
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        String depthStr = this.parseValue(line);
        if (depthStr == null) {
            entry.setDepth(SVNDepth.INFINITY);
        } else {
            SVNDepth depth = SVNDepth.fromString(depthStr);
            entry.setDepth(depth);
        }
        return false;
    }

    protected int writeExtraOptions(Writer writer, String entryName, SVNEntry entry, int emptyFields) throws SVNException, IOException {
        emptyFields = super.writeExtraOptions(writer, entryName, entry, emptyFields);
        String changelist = entry.getChangelistName();
        emptyFields = this.writeString(writer, changelist, emptyFields) ? 0 : ++emptyFields;
        boolean keepLocalAttr = entry.isKeepLocal();
        if (keepLocalAttr) {
            this.writeValue(writer, ATTRIBUTE_KEEP_LOCAL, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
        long size = entry.getWorkingSize();
        String workingSize = Long.toString(size);
        String string = workingSize = "-1".equals(workingSize) ? null : workingSize;
        emptyFields = this.writeString(writer, workingSize, emptyFields) ? 0 : ++emptyFields;
        boolean isThisDir = this.getThisDirName().equals(entryName);
        boolean isSubDir = !isThisDir && entry.isDirectory();
        SVNDepth depth = entry.getDepth();
        emptyFields = isSubDir && depth != SVNDepth.EXCLUDE || depth == SVNDepth.INFINITY ? ++emptyFields : (this.writeValue(writer, depth.toString(), emptyFields) ? 0 : ++emptyFields);
        return emptyFields;
    }

    protected SVNAdminArea createAdminAreaForDir(File dir) {
        return new SVNAdminArea15(dir);
    }

    protected boolean isEntryPropertyApplicable(String propName) {
        return propName != null && !INAPPLICABLE_PROPERTIES.contains(propName);
    }
}

