/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.patch;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPatchFileStream {
    private File path;
    private boolean write;
    private long start = 0L;
    private long end = -1L;
    private RandomAccessFile file;
    private SVNPatchFileLineFilter lineFilter;
    private SVNPatchFileLineTransformer lineTransformer;

    private SVNPatchFileStream(File path, boolean write, long start, long end) {
        this(path, write);
        if (start < 0L || end < 0L || start > end) {
            throw new IllegalArgumentException("Bad start or end");
        }
        this.start = start;
        this.end = end;
    }

    private SVNPatchFileStream(File path, boolean write) {
        if (path == null) {
            throw new IllegalArgumentException("Bad path");
        }
        this.path = path;
        this.write = write;
    }

    public static SVNPatchFileStream openReadOnly(File path) throws IOException, SVNException {
        SVNPatchFileStream stream = new SVNPatchFileStream(path, false);
        stream.reset();
        return stream;
    }

    public static SVNPatchFileStream openRangeReadOnly(File path, long start, long end) throws IOException, SVNException {
        SVNPatchFileStream stream = new SVNPatchFileStream(path, false, start, end);
        stream.reset();
        return stream;
    }

    public static SVNPatchFileStream openForWrite(File path) throws IOException, SVNException {
        SVNPatchFileStream stream = new SVNPatchFileStream(path, true);
        stream.reset();
        return stream;
    }

    public File getPath() {
        return this.path;
    }

    public void setLineFilter(SVNPatchFileLineFilter lineFilter) {
        this.lineFilter = lineFilter;
    }

    public void setLineTransformer(SVNPatchFileLineTransformer lineTransfomer) {
        this.lineTransformer = lineTransfomer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessFile getFile() throws SVNException {
        if (this.file == null) {
            SVNPatchFileStream sVNPatchFileStream = this;
            synchronized (sVNPatchFileStream) {
                if (this.file == null) {
                    this.file = this.write ? SVNFileUtil.openRAFileForWriting(this.path, false) : SVNFileUtil.openRAFileForReading(this.path);
                }
            }
        }
        return this.file;
    }

    public void reset() throws IOException, SVNException {
        RandomAccessFile file = this.getFile();
        if (this.start != file.getFilePointer()) {
            file.seek(this.start);
        }
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public boolean isEOF() throws IOException, SVNException {
        RandomAccessFile file = this.getFile();
        return file.getFilePointer() >= (this.end > 0L ? this.end : file.length());
    }

    public long getSeekPosition() throws SVNException, IOException {
        RandomAccessFile file = this.getFile();
        return file.getFilePointer();
    }

    public void setSeekPosition(long pos) throws SVNException, IOException {
        this.checkPos(pos);
        RandomAccessFile file = this.getFile();
        file.seek(pos);
    }

    private void checkPos(long pos) throws SVNException {
        if (!this.isPosValid(pos)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Bad position for file ''{0}'': {1}. Range is {2}..{3}.", this.path, new Long(pos), new Long(this.start), new Long(this.end));
            SVNErrorManager.error(err, Level.FINE, SVNLogType.DEFAULT);
        }
    }

    private boolean isPosValid(long pos) {
        return this.start <= pos && (this.end <= 0L || pos <= this.end);
    }

    public void write(String str) throws SVNException, IOException {
        RandomAccessFile file = this.getFile();
        long pos = file.getFilePointer();
        this.checkPos(pos + (long)str.length());
        file.write(str.getBytes());
    }

    public void write(StringBuffer str) throws SVNException, IOException {
        this.write(str.toString());
    }

    public void tryWrite(StringBuffer lineBuf) throws SVNException, IOException {
        this.write(lineBuf);
    }

    public boolean readLineWithEol(StringBuffer lineBuf, StringBuffer eolStr) throws IOException, SVNException {
        return this.readLine(lineBuf, eolStr, true);
    }

    public boolean readLine(StringBuffer lineBuf) throws IOException, SVNException {
        return this.readLine(lineBuf, null);
    }

    public boolean readLine(StringBuffer lineBuf, String eolStr) throws IOException, SVNException {
        StringBuffer eol = eolStr != null ? new StringBuffer(eolStr) : null;
        return this.readLine(lineBuf, eol, false);
    }

    private boolean readLine(StringBuffer input, StringBuffer eolStr, boolean detectEol) throws IOException, SVNException {
        boolean filtered;
        do {
            int c = -1;
            boolean eol = false;
            filtered = false;
            input.setLength(0);
            if (eolStr != null) {
                eolStr.setLength(0);
            }
            while (!eol) {
                c = this.file.read();
                switch (c) {
                    case -1: 
                    case 10: {
                        if (detectEol && eolStr != null) {
                            eolStr.append((char)c);
                        }
                        eol = true;
                        break;
                    }
                    case 13: {
                        if (detectEol && eolStr != null) {
                            eolStr.append((char)c);
                        }
                        long cur = this.file.getFilePointer();
                        int c2 = this.file.read();
                        if (c2 != 10) {
                            this.file.seek(cur);
                        } else if (detectEol && eolStr != null) {
                            eolStr.append((char)c2);
                        }
                        eol = true;
                        break;
                    }
                    default: {
                        input.append((char)c);
                    }
                }
            }
            if (this.lineFilter == null || !(filtered = this.lineFilter.lineFilter(input.toString()))) continue;
            input.setLength(0);
        } while (filtered && !this.isEOF());
        if (this.lineTransformer != null) {
            String line = this.lineTransformer.lineTransformer(input.toString());
            input.setLength(0);
            input.append(line);
        }
        return input.length() == 0 && this.isEOF();
    }

    public static interface SVNPatchFileLineFilter {
        public boolean lineFilter(String var1);
    }

    public static interface SVNPatchFileLineTransformer {
        public String lineTransformer(String var1);
    }
}

