/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.OutputStream;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAmbientDepthFilterEditor17
implements ISVNUpdateEditor {
    private ISVNEditor myDelegate;
    private SVNWCContext myWcContext;
    private File myAnchor;
    private String myTarget;
    private boolean myReadBase;
    private LinkedList<DirBaton> myDirs;
    private DirBaton myCurrentDirBaton;
    private FileBaton myCurrentFileBaton;

    public SVNAmbientDepthFilterEditor17(ISVNUpdateEditor editor, SVNWCContext wcContext, File anchor, String target, boolean readBase) {
        this.myDelegate = editor;
        this.myWcContext = wcContext;
        this.myAnchor = anchor;
        this.myTarget = target;
        this.myReadBase = readBase;
        this.myDirs = new LinkedList();
    }

    public static ISVNEditor wrap(SVNWCContext wcContext, File anchor, String target, ISVNUpdateEditor editor, boolean depthIsSticky) {
        if (!depthIsSticky) {
            return new SVNAmbientDepthFilterEditor17(editor, wcContext, anchor, target, true);
        }
        return editor;
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.applyTextDelta(path, baseChecksum);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return SVNFileUtil.DUMMY_OUT;
        }
        return this.myDelegate.textDeltaChunk(path, diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.textDeltaEnd(path);
    }

    public void targetRevision(long revision) throws SVNException {
        this.myDelegate.targetRevision(revision);
    }

    public void openRoot(long revision) throws SVNException {
        this.myCurrentDirBaton = this.makeDirBaton(null, null);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        if (this.myTarget == null || "".equals(this.myTarget)) {
            AmbientReadInfo aInfo = this.ambientReadInfo(this.myAnchor, this.myReadBase);
            if (aInfo.kind != ISVNWCDb.SVNWCDbKind.Unknown && !aInfo.hidden) {
                this.myCurrentDirBaton.myAmbientDepth = aInfo.depth;
            }
        }
        this.myDelegate.openRoot(revision);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        if (this.myCurrentDirBaton.myAmbientDepth.compareTo(SVNDepth.IMMEDIATES) < 0) {
            File abspath = SVNFileUtil.createFilePath(this.myAnchor, SVNWCUtils.getPathAsChild(this.myAnchor, SVNFileUtil.createFilePath(path)));
            AmbientReadInfo aInfo = this.ambientReadInfo(abspath, this.myReadBase);
            if (aInfo.kind == ISVNWCDb.SVNWCDbKind.Unknown || aInfo.hidden) {
                return;
            }
        }
        this.myDelegate.deleteEntry(path, revision);
    }

    public void absentDir(String path) throws SVNException {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.absentDir(path);
    }

    public void absentFile(String path) throws SVNException {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.absentFile(path);
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        DirBaton parentBaton = this.myCurrentDirBaton;
        this.myCurrentDirBaton = this.makeDirBaton(path, parentBaton);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myCurrentDirBaton.myAmbientDepth = path.equals(this.myTarget) ? SVNDepth.INFINITY : (parentBaton.myAmbientDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : SVNDepth.INFINITY);
        this.myDelegate.addDir(path, copyFromPath, copyFromRevision);
    }

    public void openDir(String path, long revision) throws SVNException {
        DirBaton parentBaton = this.myCurrentDirBaton;
        this.myCurrentDirBaton = this.makeDirBaton(path, parentBaton);
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.openDir(path, revision);
        File abspath = SVNFileUtil.createFilePath(this.myAnchor, SVNWCUtils.skipAncestor(this.myAnchor, SVNFileUtil.createFilePath(path)));
        AmbientReadInfo aInfo = this.ambientReadInfo(abspath, this.myReadBase);
        if (aInfo.kind != ISVNWCDb.SVNWCDbKind.Unknown && !aInfo.hidden) {
            this.myCurrentDirBaton.myAmbientDepth = aInfo.depth;
        }
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (this.myCurrentDirBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.changeDirProperty(name, value);
    }

    public void closeDir() throws SVNException {
        DirBaton closedDir = this.myDirs.removeLast();
        this.myCurrentDirBaton = this.myDirs.isEmpty() ? null : this.myDirs.getLast();
        if (closedDir.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.closeDir();
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFileBaton = this.makeFileBaton(this.myCurrentDirBaton, path);
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.addFile(path, copyFromPath, copyFromRevision);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFileBaton = this.makeFileBaton(this.myCurrentDirBaton, path);
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.openFile(path, revision);
    }

    public void changeFileProperty(String path, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.changeFileProperty(path, propertyName, propertyValue);
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        if (this.myCurrentFileBaton.myIsAmbientlyExcluded) {
            return;
        }
        this.myDelegate.closeFile(path, textChecksum);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return this.myDelegate.closeEdit();
    }

    public void abortEdit() throws SVNException {
    }

    private DirBaton makeDirBaton(String path, DirBaton parentBaton) throws SVNException {
        if (parentBaton != null && path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "aborting in SVNAmbientDepthFilterEditor17.makeDirBation(): parentBaton != null while path == null");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (parentBaton != null && parentBaton.myIsAmbientlyExcluded) {
            this.myDirs.addLast(parentBaton);
            return parentBaton;
        }
        DirBaton dirBaton = new DirBaton();
        this.myDirs.addLast(dirBaton);
        if (parentBaton != null && parentBaton.myAmbientDepth != SVNDepth.UNKNOWN) {
            boolean exclude;
            boolean exists;
            File abspath = SVNFileUtil.createFilePath(this.myAnchor, SVNWCUtils.getPathAsChild(this.myAnchor, SVNFileUtil.createFilePath(path)));
            AmbientReadInfo aInfo = this.ambientReadInfo(abspath, this.myReadBase);
            ISVNWCDb.SVNWCDbStatus status = aInfo.status;
            ISVNWCDb.SVNWCDbKind kind = aInfo.kind;
            boolean bl = exists = kind != ISVNWCDb.SVNWCDbKind.Unknown;
            if (parentBaton.myAmbientDepth == SVNDepth.EMPTY || parentBaton.myAmbientDepth == SVNDepth.FILES) {
                exclude = !exists;
            } else {
                boolean bl2 = exclude = exists && status == ISVNWCDb.SVNWCDbStatus.Excluded;
            }
            if (exclude) {
                dirBaton.myIsAmbientlyExcluded = true;
                return dirBaton;
            }
        }
        dirBaton.myAmbientDepth = SVNDepth.UNKNOWN;
        return dirBaton;
    }

    private FileBaton makeFileBaton(DirBaton parentBaton, String path) throws SVNException {
        if (path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "aborting in SVNAmbientDepthFilterEditor.makeFileBation(): path == null");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        FileBaton fileBaton = new FileBaton();
        if (parentBaton.myIsAmbientlyExcluded) {
            fileBaton.myIsAmbientlyExcluded = true;
            return fileBaton;
        }
        File abspath = SVNFileUtil.createFilePath(this.myAnchor, SVNWCUtils.getPathAsChild(this.myAnchor, SVNFileUtil.createFilePath(path)));
        AmbientReadInfo aInfo = this.ambientReadInfo(abspath, this.myReadBase);
        if (parentBaton.myAmbientDepth == SVNDepth.EMPTY && (aInfo.hidden || aInfo.kind == ISVNWCDb.SVNWCDbKind.Unknown)) {
            fileBaton.myIsAmbientlyExcluded = true;
        }
        if (parentBaton.myAmbientDepth != SVNDepth.UNKNOWN && aInfo.status == ISVNWCDb.SVNWCDbStatus.Excluded) {
            fileBaton.myIsAmbientlyExcluded = true;
        }
        return fileBaton;
    }

    private AmbientReadInfo ambientReadInfo(File localAbspath, boolean readBase) throws SVNException {
        AmbientReadInfo info = new AmbientReadInfo();
        try {
            if (readBase) {
                ISVNWCDb.WCDbBaseInfo baseInfo = this.myWcContext.getDb().getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth);
                info.status = baseInfo.status;
                info.kind = baseInfo.kind;
                info.depth = baseInfo.depth;
            } else {
                ISVNWCDb.WCDbInfo readInfo = this.myWcContext.getDb().readInfo(localAbspath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.depth);
                info.status = readInfo.status;
                info.kind = readInfo.kind;
                info.depth = readInfo.depth;
            }
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                info.status = ISVNWCDb.SVNWCDbStatus.Normal;
                info.kind = ISVNWCDb.SVNWCDbKind.Unknown;
                info.depth = SVNDepth.UNKNOWN;
            }
            throw e;
        }
        info.hidden = false;
        switch (info.status) {
            case ServerExcluded: 
            case Excluded: 
            case NotPresent: {
                info.hidden = true;
                break;
            }
        }
        return info;
    }

    public long getTargetRevision() {
        if (this.myDelegate instanceof ISVNUpdateEditor) {
            return ((ISVNUpdateEditor)this.myDelegate).getTargetRevision();
        }
        return -1L;
    }

    private class AmbientReadInfo {
        public boolean hidden;
        public ISVNWCDb.SVNWCDbStatus status;
        public ISVNWCDb.SVNWCDbKind kind;
        public SVNDepth depth;

        private AmbientReadInfo() {
        }
    }

    private class DirBaton {
        boolean myIsAmbientlyExcluded;
        SVNDepth myAmbientDepth;

        private DirBaton() {
        }
    }

    private class FileBaton {
        boolean myIsAmbientlyExcluded;

        private FileBaton() {
        }
    }
}

