/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.util.HashMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNStatusReporter17
implements ISVNReporterBaton,
ISVNReporter {
    private SVNRepository repository;
    private SVNReporter17 reportBaton;
    private SVNStatusEditor17 editor;
    private SVNURL repositoryLocation;
    private HashMap<String, SVNLock> locks;
    private ISVNReporter reporter;
    private SVNURL repositoryRoot;

    public SVNStatusReporter17(SVNRepository repository, SVNReporter17 reportBaton, SVNStatusEditor17 editor) {
        this.repository = repository;
        this.reportBaton = reportBaton;
        this.editor = editor;
        this.repositoryLocation = repository.getLocation();
        this.locks = new HashMap();
    }

    public void report(ISVNReporter reporter) throws SVNException {
        this.reporter = reporter;
        this.reportBaton.report(this);
    }

    public void setPath(String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        this.setPath(path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
    }

    public void setPath(String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
        this.reporter.setPath(path, lockToken, revision, depth, startEmpty);
    }

    public void deletePath(String path) throws SVNException {
        this.reporter.deletePath(path);
    }

    public void linkPath(SVNURL url, String path, String lockToken, long revision, boolean startEmpty) throws SVNException {
        this.setPath(path, lockToken, revision, SVNDepth.INFINITY, startEmpty);
    }

    public void linkPath(SVNURL url, String path, String lockToken, long revision, SVNDepth depth, boolean startEmpty) throws SVNException {
        SVNURL ancestor = SVNURLUtil.getCommonURLAncestor(url, this.repositoryLocation);
        if (SVNPathUtil.getPathAsChild(ancestor.getPath(), this.repositoryLocation.getPath()) != null) {
            this.repositoryLocation = ancestor;
        }
        this.reporter.linkPath(url, path, lockToken, revision, depth, startEmpty);
    }

    public void finishReport() throws SVNException {
        SVNLock[] locks;
        block8: {
            locks = null;
            SVNURL oldLocation = this.repository.getLocation();
            try {
                try {
                    this.repositoryRoot = this.repository.getRepositoryRoot(true);
                    this.repository.setLocation(this.repositoryLocation, false);
                    locks = this.repository.getLocks("");
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() == null || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                        throw e;
                    }
                    this.repository.setLocation(oldLocation, false);
                    this.repository.closeSession();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.repository.setLocation(oldLocation, false);
                this.repository.closeSession();
                throw throwable;
            }
            this.repository.setLocation(oldLocation, false);
            this.repository.closeSession();
        }
        if (locks != null) {
            int i = 0;
            while (i < locks.length) {
                SVNLock lock = locks[i];
                this.locks.put(lock.getPath(), lock);
                ++i;
            }
        }
        this.editor.setRepositoryInfo(this.repositoryRoot, this.locks);
        this.reporter.finishReport();
    }

    public void abortReport() throws SVNException {
        this.reporter.abortReport();
    }
}

