/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNodesPristineTrigger
implements ISVNSqlJetTrigger {
    private Map<String, Integer> checksumTriggerValues;

    @Override
    public void beforeUpdate(ISqlJetCursor cursor, Map<String, Object> values) throws SqlJetException {
        if (values.containsKey(SVNWCDbSchema.NODES__Fields.checksum.toString())) {
            String newChecksum = (String)values.get(SVNWCDbSchema.NODES__Fields.checksum.toString());
            String oldChecksum = cursor.getString(SVNWCDbSchema.NODES__Fields.checksum.toString());
            this.changeRefCount(oldChecksum, -1);
            this.changeRefCount(newChecksum, 1);
        }
    }

    @Override
    public void beforeDelete(ISqlJetCursor cursor) throws SqlJetException {
        String checksumValue = cursor.getString(SVNWCDbSchema.NODES__Fields.checksum.toString());
        this.changeRefCount(checksumValue, -1);
    }

    @Override
    public void beforeInsert(SqlJetConflictAction conflictAction, ISqlJetTable table, Map<String, Object> newValues) throws SqlJetException {
        if (conflictAction == SqlJetConflictAction.REPLACE) {
            Object o1 = newValues.get(SVNWCDbSchema.NODES__Fields.wc_id.toString());
            Object o2 = newValues.get(SVNWCDbSchema.NODES__Fields.local_relpath.toString());
            Object o3 = newValues.get(SVNWCDbSchema.NODES__Fields.op_depth.toString());
            ISqlJetCursor cursor = table.lookup(null, new Object[]{o1, o2, o3});
            try {
                if (!cursor.eof()) {
                    this.changeRefCount(cursor.getString(SVNWCDbSchema.NODES__Fields.checksum.toString()), -1);
                }
            }
            finally {
                cursor.close();
            }
        }
        String newChecksumValue = (String)newValues.get(SVNWCDbSchema.NODES__Fields.checksum.toString());
        this.changeRefCount(newChecksumValue, 1);
    }

    private void changeRefCount(String checksum, int delta) {
        if (checksum != null) {
            if (!this.getTriggerValues().containsKey(checksum)) {
                this.getTriggerValues().put(checksum, delta);
            } else {
                this.getTriggerValues().put(checksum, this.getTriggerValues().get(checksum) + delta);
            }
        }
    }

    private Map<String, Integer> getTriggerValues() {
        if (this.checksumTriggerValues == null) {
            this.checksumTriggerValues = new HashMap<String, Integer>();
        }
        return this.checksumTriggerValues;
    }

    @Override
    public void statementStarted(SqlJetDb db) throws SqlJetException {
    }

    @Override
    public void statementCompleted(SqlJetDb db, SqlJetException error) throws SqlJetException {
        try {
            if (error == null && !this.getTriggerValues().isEmpty()) {
                HashMap<String, Long> values = new HashMap<String, Long>();
                ISqlJetTable pristineTable = db.getTable(SVNWCDbSchema.PRISTINE.toString());
                for (String checksum : this.getTriggerValues().keySet()) {
                    long delta = this.getTriggerValues().get(checksum).intValue();
                    if (delta == 0L) continue;
                    ISqlJetCursor cursor = pristineTable.lookup(null, new Object[]{checksum});
                    if (cursor != null && !cursor.eof()) {
                        long refcount = cursor.getInteger(SVNWCDbSchema.PRISTINE__Fields.refcount.toString());
                        if ((refcount += delta) < 0L) {
                            refcount = 0L;
                        }
                        values.put(SVNWCDbSchema.PRISTINE__Fields.refcount.toString(), refcount);
                        cursor.updateByFieldNames(values);
                    }
                    cursor.close();
                }
            }
        }
        finally {
            this.checksumTriggerValues = null;
        }
    }
}

