/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetUpdateStatement;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnWcDbRelocate
extends SvnWcDbShared {
    public static void relocate(SVNWCContext context, File localAbspath, SVNURL from, SVNURL to, ISvnRelocateValidator validator) throws SVNException {
        if (!context.getDb().isWCRoot(localAbspath)) {
            try {
                File wcRoot = context.getDb().getWCRoot(localAbspath);
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Cannot relocate ''{0}'' as it is not the root of the working copy; try relocating ''{1}'' instead", localAbspath, wcRoot);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            catch (SVNException e) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Cannot relocate ''{0}'' as it is not the root of the working copy", (Object)localAbspath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            return;
        }
        Structure<StructureFields.NodeInfo> info = context.getDb().readInfo(localAbspath, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.reposRootUrl, StructureFields.NodeInfo.reposUuid);
        if (info.get(StructureFields.NodeInfo.kind) != ISVNWCDb.SVNWCDbKind.Dir) {
            info.release();
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "Cannot relocate a single file");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File relPath = (File)info.get(StructureFields.NodeInfo.reposRelPath);
        SVNURL oldUrl = (SVNURL)info.get(StructureFields.NodeInfo.reposRootUrl);
        String uuid = info.text(StructureFields.NodeInfo.reposUuid);
        info.release();
        oldUrl = SVNWCUtils.join(oldUrl, relPath);
        if (from != null && !oldUrl.toString().startsWith(from.toString())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_RELOCATION, "Invalid source URL prefix: ''{0}'' (does not overlap target''s URL ''{1}''", from, oldUrl);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNURL newUrl = from == null || oldUrl.equals(from) ? to : SVNURL.parseURIEncoded(String.valueOf(to.toString()) + oldUrl.toString().substring(from.toString().length()));
        String relPathStr = SVNFileUtil.getFilePath(relPath);
        String newReposRootPath = newUrl.getPath();
        if (!newReposRootPath.endsWith(relPathStr)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_RELOCATION, "Invalid relocation destination: ''{0}'' (does not point to target)", (Object)newUrl);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        newReposRootPath = newReposRootPath.substring(0, newReposRootPath.length() - relPathStr.length());
        SVNURL newReposRoot = newUrl.setPath(newReposRootPath, false);
        if (validator != null) {
            validator.validateRelocation(uuid, newUrl, newReposRoot);
        }
        SvnWcDbRelocate.relocate((SVNWCDb)context.getDb(), localAbspath, newReposRoot);
    }

    private static void relocate(SVNWCDb db, File localAbspath, SVNURL repositoryRootUrl) throws SVNException {
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbspath);
        File localRelpath = dirInfo.localRelPath;
        SVNWCDbRoot root = dirInfo.wcDbDir.getWCRoot();
        Structure<StructureFields.NodeInfo> nodeInfo = SvnWcDbShared.readInfo(root, localRelpath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.reposId, StructureFields.NodeInfo.haveBase);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
        long oldReposId = nodeInfo.lng(StructureFields.NodeInfo.reposId);
        boolean haveBase = nodeInfo.is(StructureFields.NodeInfo.haveBase);
        nodeInfo.release();
        if (status == ISVNWCDb.SVNWCDbStatus.Excluded) {
            File parentRelPath = SVNFileUtil.getFileDir(localRelpath);
            nodeInfo = SvnWcDbShared.readInfo(root, localRelpath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.reposId);
            status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
            oldReposId = nodeInfo.lng(StructureFields.NodeInfo.reposId);
            localRelpath = parentRelPath;
            nodeInfo.release();
        }
        if (oldReposId == -1L) {
            if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                Structure<StructureFields.DeletionInfo> deletionInfo = SvnWcDbRelocate.scanDeletion(root, localRelpath);
                if (deletionInfo.hasValue(StructureFields.DeletionInfo.workDelRelPath)) {
                    status = ISVNWCDb.SVNWCDbStatus.Added;
                    localRelpath = SVNFileUtil.getFileDir((File)deletionInfo.get(StructureFields.DeletionInfo.workDelRelPath));
                }
                deletionInfo.release();
            }
            if (status == ISVNWCDb.SVNWCDbStatus.Added) {
                Structure<StructureFields.AdditionInfo> additionInfo = SvnWcDbRelocate.scanAddition(root, localRelpath, StructureFields.AdditionInfo.reposId);
                oldReposId = additionInfo.lng(StructureFields.AdditionInfo.reposId);
                additionInfo.release();
            } else {
                Structure<StructureFields.NodeInfo> baseInfo = SvnWcDbRelocate.getDepthInfo(root, localRelpath, 0L, StructureFields.NodeInfo.reposId);
                oldReposId = baseInfo.lng(StructureFields.NodeInfo.reposId);
                baseInfo.release();
            }
        }
        Structure<StructureFields.RepositoryInfo> repositoryInfo = db.fetchRepositoryInfo(root.getSDb(), oldReposId);
        String reposUuid = repositoryInfo.text(StructureFields.RepositoryInfo.reposUuid);
        repositoryInfo.release();
        SvnWcDbRelocate.begingWriteTransaction(root);
        try {
            try {
                SvnWcDbRelocate.relocate(root, localRelpath, repositoryRootUrl, reposUuid, haveBase, oldReposId);
            }
            catch (SVNException e) {
                SvnWcDbRelocate.rollbackTransaction(root);
                throw e;
            }
        }
        finally {
            SvnWcDbRelocate.commitTransaction(root);
        }
    }

    private static void relocate(SVNWCDbRoot root, File localRelPath, SVNURL reposRootUrl, String reposUuid, boolean haveBaseNode, long oldReposId) throws SVNException {
        long newReposId = root.getDb().createReposId(root.getSDb(), reposRootUrl, reposUuid);
        SVNSqlJetUpdateStatement stmt = new RecursiveUpdateNodeRepo(root.getSDb());
        try {
            stmt.bindf("isii", root.getWcId(), localRelPath, oldReposId, newReposId);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        if (haveBaseNode) {
            stmt = new UpdateLockReposId(root.getSDb());
            try {
                stmt.bindf("ii", oldReposId, newReposId);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
        }
    }

    public static interface ISvnRelocateValidator {
        public void validateRelocation(String var1, SVNURL var2, SVNURL var3) throws SVNException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecursiveUpdateNodeRepo
    extends SVNSqlJetUpdateStatement {
        private Map<String, Object> updateValues;

        public RecursiveUpdateNodeRepo(SVNSqlJetDb sDb) throws SVNException {
            super(sDb, SVNWCDbSchema.NODES);
        }

        @Override
        public Map<String, Object> getUpdateValues() throws SVNException {
            if (this.updateValues == null) {
                this.updateValues = new HashMap<String, Object>();
            } else {
                this.updateValues.clear();
            }
            this.updateValues.put(SVNWCDbSchema.NODES__Fields.repos_id.toString(), this.getBind(4));
            this.updateValues.put(SVNWCDbSchema.NODES__Fields.dav_cache.toString(), null);
            this.updateValues.put(SVNWCDbSchema.NODES__Fields.properties.toString(), this.getColumnBlob(SVNWCDbSchema.NODES__Fields.properties));
            return this.updateValues;
        }

        @Override
        protected Object[] getWhere() throws SVNException {
            return new Object[]{this.getBind(1)};
        }

        @Override
        protected boolean isFilterPassed() throws SVNException {
            if (super.isFilterPassed()) {
                long queryReposId = (Long)this.getBind(3);
                if (this.getColumnLong(SVNWCDbSchema.NODES__Fields.repos_id) == queryReposId) {
                    String queryPath = (String)this.getBind(2);
                    if ("".equals(queryPath)) {
                        return true;
                    }
                    String rowPath = this.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath);
                    return rowPath.equals(queryPath) || rowPath.startsWith(String.valueOf(queryPath) + "/");
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateLockReposId
    extends SVNSqlJetUpdateStatement {
        private Map<String, Object> updateValues;

        public UpdateLockReposId(SVNSqlJetDb sDb) throws SVNException {
            super(sDb, SVNWCDbSchema.LOCK);
        }

        @Override
        public Map<String, Object> getUpdateValues() throws SVNException {
            if (this.updateValues == null) {
                this.updateValues = new HashMap<String, Object>();
            } else {
                this.updateValues.clear();
            }
            this.updateValues.put(SVNWCDbSchema.LOCK__Fields.repos_id.toString(), this.getBind(2));
            return this.updateValues;
        }

        @Override
        protected Object[] getWhere() throws SVNException {
            return new Object[0];
        }

        @Override
        protected boolean isFilterPassed() throws SVNException {
            long queryReposId = (Long)this.getBind(1);
            return this.getColumnLong(SVNWCDbSchema.LOCK__Fields.repos_id) == queryReposId;
        }
    }
}

