/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeinfoUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnLog;
import org.tmatesoft.svn.core.wc2.SvnLogMergeInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgLogMergeInfo
extends SvnNgOperationRunner<SVNLogEntry, SvnLogMergeInfo> {
    @Override
    public boolean isApplicable(SvnLogMergeInfo operation, SvnWcGeneration wcGeneration) throws SVNException {
        boolean sourceOk;
        boolean targetOk = operation.getFirstTarget().isURL() || SvnOperationFactory.detectWcGeneration(operation.getFirstTarget().getFile(), true) == SvnWcGeneration.V17;
        boolean bl = sourceOk = operation.getSource().isURL() || SvnOperationFactory.detectWcGeneration(operation.getSource().getFile(), true) == SvnWcGeneration.V17;
        return targetOk && sourceOk;
    }

    @Override
    public SvnWcGeneration getWcGeneration() {
        return SvnWcGeneration.NOT_DETECTED;
    }

    @Override
    protected SVNLogEntry run(SVNWCContext context) throws SVNException {
        SVNURL[] root = new SVNURL[1];
        Map<String, Map<String, SVNMergeRangeList>> mergeInfoCatalog = SvnNgMergeinfoUtil.getMergeInfo(this.getWcContext(), this.getRepositoryAccess(), ((SvnLogMergeInfo)this.getOperation()).getFirstTarget(), ((SvnLogMergeInfo)this.getOperation()).getDepth() == SVNDepth.INFINITY, true, root);
        SvnTarget target = ((SvnLogMergeInfo)this.getOperation()).getFirstTarget();
        File reposRelPath = null;
        reposRelPath = target.isURL() ? SVNFileUtil.createFilePath(SVNPathUtil.getRelativePath(root[0].getPath(), target.getURL().getPath())) : this.getWcContext().getNodeReposRelPath(((SvnLogMergeInfo)this.getOperation()).getFirstTarget().getFile());
        if (mergeInfoCatalog == null) {
            if (((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
                return (SVNLogEntry)((SvnLogMergeInfo)this.getOperation()).first();
            }
            mergeInfoCatalog = new TreeMap<String, Map<String, SVNMergeRangeList>>();
            mergeInfoCatalog.put(SVNFileUtil.getFilePath(reposRelPath), new TreeMap());
        }
        Map<String, SVNMergeRangeList> history = null;
        Map<String, SVNMergeRangeList> sourceHistory = null;
        if (!((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
            history = this.getRepositoryAccess().getHistoryAsMergeInfo(null, target, -1L, -1L);
        }
        sourceHistory = this.getRepositoryAccess().getHistoryAsMergeInfo(null, ((SvnLogMergeInfo)this.getOperation()).getSource(), -1L, -1L);
        String reposRelPathStr = SVNFileUtil.getFilePath(reposRelPath);
        SVNMergeRangeList masterNonInheritableRangeList = new SVNMergeRangeList(null);
        SVNMergeRangeList masterInheritableRangeList = new SVNMergeRangeList(null);
        TreeMap<String, SVNMergeRangeList> inheritableSubtreeMerges = new TreeMap<String, SVNMergeRangeList>();
        for (String subtreePath : mergeInfoCatalog.keySet()) {
            Map<String, SVNMergeRangeList> subtreeSourceHistory;
            boolean isSubtree;
            Map<String, SVNMergeRangeList> subtreeMergeInfo = mergeInfoCatalog.get(subtreePath);
            Map<String, SVNMergeRangeList> subtreeHistory = null;
            boolean bl = isSubtree = !subtreePath.equals(reposRelPathStr);
            if (isSubtree) {
                String subtreeRelPath = subtreePath.substring(reposRelPathStr.length() + 1);
                subtreeSourceHistory = SVNMergeInfoUtil.appendSuffix(sourceHistory, subtreeRelPath);
                if (!((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
                    subtreeHistory = SVNMergeInfoUtil.appendSuffix(history, subtreeRelPath);
                }
            } else {
                subtreeSourceHistory = sourceHistory;
                if (!((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
                    subtreeHistory = history;
                }
            }
            if (!((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
                Map<String, SVNMergeRangeList> mergedViaHistory = SVNMergeInfoUtil.intersectMergeInfo(subtreeHistory, subtreeSourceHistory, true);
                subtreeMergeInfo = SVNMergeInfoUtil.mergeMergeInfos(subtreeMergeInfo, mergedViaHistory);
            }
            Map<String, SVNMergeRangeList> subtreeInheritableMergeInfo = SVNMergeInfoUtil.getInheritableMergeInfo(subtreeMergeInfo, null, -1L, -1L, true);
            Map<String, SVNMergeRangeList> subtreeNonInheritableMergeInfo = SVNMergeInfoUtil.getInheritableMergeInfo(subtreeMergeInfo, null, -1L, -1L, false);
            Map<String, SVNMergeRangeList> mergedNonInheritableMergeInfo = SVNMergeInfoUtil.intersectMergeInfo(subtreeNonInheritableMergeInfo, subtreeSourceHistory, false);
            if (!mergedNonInheritableMergeInfo.isEmpty()) {
                for (SVNMergeRangeList rl : mergedNonInheritableMergeInfo.values()) {
                    rl.setInheritable(false);
                    masterNonInheritableRangeList = masterNonInheritableRangeList.merge(rl.dup());
                }
            }
            Map<String, SVNMergeRangeList> mergedMergeInfo = SVNMergeInfoUtil.intersectMergeInfo(subtreeInheritableMergeInfo, subtreeSourceHistory, false);
            SVNMergeRangeList subtreeMergeRangeList = new SVNMergeRangeList(null);
            if (!mergedMergeInfo.isEmpty()) {
                for (SVNMergeRangeList rl : mergedMergeInfo.values()) {
                    masterInheritableRangeList = masterInheritableRangeList.merge(rl.dup());
                    subtreeMergeRangeList = subtreeMergeRangeList.merge(rl.dup());
                }
            }
            inheritableSubtreeMerges.put(subtreePath, subtreeMergeRangeList);
        }
        if (!masterInheritableRangeList.isEmpty()) {
            for (String path : inheritableSubtreeMerges.keySet()) {
                SVNMergeRangeList subtreeMergedRangeList = (SVNMergeRangeList)inheritableSubtreeMerges.get(path);
                SVNMergeRangeList deletedRanges = masterInheritableRangeList.diff(subtreeMergedRangeList, true);
                if (deletedRanges.isEmpty()) continue;
                deletedRanges.setInheritable(false);
                masterNonInheritableRangeList = masterNonInheritableRangeList.merge(deletedRanges);
                masterInheritableRangeList = masterInheritableRangeList.remove(deletedRanges, false);
            }
        }
        if (((SvnLogMergeInfo)this.getOperation()).isFindMerged()) {
            masterInheritableRangeList = masterInheritableRangeList.merge(masterNonInheritableRangeList);
        } else {
            SVNMergeRangeList sourceMasterRangeList = new SVNMergeRangeList(null);
            for (SVNMergeRangeList rl : sourceHistory.values()) {
                sourceMasterRangeList = sourceMasterRangeList.merge(rl);
            }
            sourceMasterRangeList = sourceMasterRangeList.remove(masterNonInheritableRangeList, false);
            sourceMasterRangeList = sourceMasterRangeList.merge(masterNonInheritableRangeList);
            masterInheritableRangeList = sourceMasterRangeList.remove(masterInheritableRangeList, true);
        }
        if (masterInheritableRangeList.isEmpty()) {
            return (SVNLogEntry)((SvnLogMergeInfo)this.getOperation()).first();
        }
        ArrayList<String> mergeSourcePaths = new ArrayList<String>();
        String logTarget = null;
        SVNMergeRange youngestRange = masterInheritableRangeList.getRanges()[masterInheritableRangeList.getSize() - 1].dup();
        SVNMergeRangeList youngestRangeList = new SVNMergeRangeList(youngestRange.getEndRevision() - 1L, youngestRange.getEndRevision(), youngestRange.isInheritable());
        for (String key : sourceHistory.keySet()) {
            SVNMergeRangeList subtreeMergedList = sourceHistory.get(key);
            SVNMergeRangeList intersection = youngestRangeList.intersect(subtreeMergedList, false);
            mergeSourcePaths.add(key);
            if (intersection.isEmpty()) continue;
            logTarget = key;
        }
        if (logTarget != null && logTarget.startsWith("/")) {
            logTarget = logTarget.substring(1);
        }
        SVNURL logTargetURL = logTarget != null ? SVNWCUtils.join(root[0], SVNFileUtil.createFilePath(logTarget)) : root[0];
        this.logForMergeInfoRangeList(logTargetURL, mergeSourcePaths, ((SvnLogMergeInfo)this.getOperation()).isFindMerged(), masterInheritableRangeList, mergeInfoCatalog, "/" + reposRelPathStr, ((SvnLogMergeInfo)this.getOperation()).isDiscoverChangedPaths(), ((SvnLogMergeInfo)this.getOperation()).getRevisionProperties(), (ISvnObjectReceiver)this.getOperation());
        return (SVNLogEntry)((SvnLogMergeInfo)this.getOperation()).first();
    }

    private void logForMergeInfoRangeList(SVNURL sourceURL, List<String> mergeSourcePaths, boolean filteringMerged, SVNMergeRangeList rangelist, Map<String, Map<String, SVNMergeRangeList>> targetCatalog, String absReposTargetPath, boolean discoverChangedPaths, String[] revprops, ISvnObjectReceiver<SVNLogEntry> receiver) throws SVNException {
        if (rangelist.isEmpty()) {
            return;
        }
        if (targetCatalog == null) {
            targetCatalog = new TreeMap<String, Map<String, SVNMergeRangeList>>();
        }
        TreeMap<String, Map<String, SVNMergeRangeList>> adjustedCatalog = new TreeMap<String, Map<String, SVNMergeRangeList>>();
        for (String relativePath : targetCatalog.keySet()) {
            Map<String, SVNMergeRangeList> mi = targetCatalog.get(relativePath);
            if (!relativePath.startsWith("/")) {
                relativePath = "/" + relativePath;
            }
            adjustedCatalog.put(relativePath, mi);
        }
        List<SVNMergeRange> ranges = rangelist.getRangesAsList();
        Collections.sort(ranges);
        SVNMergeRange youngestRange = ranges.get(ranges.size() - 1);
        SVNMergeRange oldestRange = ranges.get(0);
        long youngestRev = youngestRange.getEndRevision();
        long oldestRev = oldestRange.getStartRevision();
        LogEntryReceiver filteringReceiver = new LogEntryReceiver();
        filteringReceiver.receiver = receiver;
        filteringReceiver.rangelist = rangelist;
        filteringReceiver.isFilteringMerged = filteringMerged;
        filteringReceiver.targetCatalog = adjustedCatalog;
        filteringReceiver.mergeSourcePaths = mergeSourcePaths;
        filteringReceiver.reposTargertAbsPath = absReposTargetPath;
        SvnLog log = ((SvnLogMergeInfo)this.getOperation()).getOperationFactory().createLog();
        log.setSingleTarget(SvnTarget.fromURL(sourceURL, SVNRevision.create(youngestRev)));
        log.setDiscoverChangedPaths(true);
        log.setRevisionProperties(((SvnLogMergeInfo)this.getOperation()).getRevisionProperties());
        log.setLimit(-1L);
        log.setStopOnCopy(false);
        log.setUseMergeHistory(false);
        log.addRange(SvnRevisionRange.create(SVNRevision.create(oldestRev), SVNRevision.create(youngestRev)));
        log.setReceiver(filteringReceiver);
        log.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogEntryReceiver
    implements ISvnObjectReceiver<SVNLogEntry> {
        private boolean isFilteringMerged;
        private List<String> mergeSourcePaths;
        private String reposTargertAbsPath;
        private Map<String, Map<String, SVNMergeRangeList>> targetCatalog;
        private SVNMergeRangeList rangelist;
        private ISvnObjectReceiver<SVNLogEntry> receiver;

        @Override
        public void receive(SvnTarget target, SVNLogEntry logEntry) throws SVNException {
            if (logEntry.getRevision() == 0L) {
                return;
            }
            SVNMergeRangeList thisRangeList = new SVNMergeRangeList(logEntry.getRevision() - 1L, logEntry.getRevision(), true);
            SVNMergeRangeList intersection = this.rangelist.intersect(thisRangeList, false);
            if (intersection == null || intersection.isEmpty()) {
                return;
            }
            intersection = thisRangeList.intersect(this.rangelist, true);
            logEntry.setNonInheriable(intersection.isEmpty());
            if ((logEntry.isNonInheritable() || !this.isFilteringMerged) && logEntry.getChangedPaths() != null) {
                boolean allSubtreesHaveThisRev = true;
                SVNMergeRangeList thisRevRangeList = new SVNMergeRangeList(logEntry.getRevision() - 1L, logEntry.getRevision(), true);
                for (String changedPath : logEntry.getChangedPaths().keySet()) {
                    SVNMergeRangeList rlist;
                    SVNMergeRange youngestRange;
                    String mergeSourceRelTarget = null;
                    boolean interrupted = false;
                    String mSourcePath = null;
                    Iterator<String> iterator = this.mergeSourcePaths.iterator();
                    while (iterator.hasNext()) {
                        String mergeSourcePath;
                        mSourcePath = mergeSourcePath = iterator.next();
                        String string = mergeSourceRelTarget = mergeSourcePath.equals(changedPath) ? "" : SVNPathUtil.getPathAsChild(mergeSourcePath, changedPath);
                        if (mergeSourceRelTarget == null) continue;
                        interrupted = true;
                        if (!"".equals(mergeSourceRelTarget) || logEntry.getChangedPaths().get(changedPath).getType() == 'M') break;
                        interrupted = false;
                        break;
                    }
                    if (!interrupted) continue;
                    String targetPathAffected = SVNPathUtil.append(this.reposTargertAbsPath, mergeSourceRelTarget);
                    if (!targetPathAffected.startsWith("/")) {
                        targetPathAffected = "/" + targetPathAffected;
                    }
                    Map<String, SVNMergeRangeList> nearestAncestorMergeInfo = null;
                    boolean ancestorIsSelf = false;
                    for (String path : this.targetCatalog.keySet()) {
                        if (!SVNPathUtil.isAncestor(path, targetPathAffected)) continue;
                        nearestAncestorMergeInfo = this.targetCatalog.get(path);
                        ancestorIsSelf = path.equals(targetPathAffected);
                        if (ancestorIsSelf) break;
                    }
                    if (nearestAncestorMergeInfo != null && ancestorIsSelf && logEntry.getChangedPaths().get(changedPath).getType() != 'M' && (youngestRange = (rlist = nearestAncestorMergeInfo.get(changedPath)).getRanges()[rlist.getSize() - 1]).getEndRevision() > logEntry.getRevision()) continue;
                    boolean foundThisRevision = false;
                    if (nearestAncestorMergeInfo != null) {
                        for (String path : nearestAncestorMergeInfo.keySet()) {
                            SVNMergeRangeList inter;
                            SVNMergeRangeList rlist2 = nearestAncestorMergeInfo.get(path);
                            if (!SVNPathUtil.isAncestor(mSourcePath, path) || (inter = rlist2.intersect(thisRevRangeList, false)).isEmpty()) continue;
                            if (ancestorIsSelf) {
                                foundThisRevision = true;
                                break;
                            }
                            inter = rlist2.intersect(thisRevRangeList, true);
                            if (inter.isEmpty()) continue;
                            foundThisRevision = true;
                            break;
                        }
                    }
                    if (foundThisRevision) continue;
                    allSubtreesHaveThisRev = false;
                    break;
                }
                if (allSubtreesHaveThisRev) {
                    if (this.isFilteringMerged) {
                        logEntry.setNonInheriable(false);
                    } else {
                        return;
                    }
                }
            }
            this.receiver.receive(target, logEntry);
        }
    }
}

