/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeDriver;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnMerge;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgMerge
extends SvnNgOperationRunner<Void, SvnMerge> {
    @Override
    public boolean isApplicable(SvnMerge operation, SvnWcGeneration wcGeneration) throws SVNException {
        return super.isApplicable(operation, wcGeneration) && !operation.isReintegrate() && operation.getSource() == null && operation.getRevisionRanges() == null && operation.getFirstSource() != null && operation.getSecondSource() != null;
    }

    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        File lockPath = this.getLockPath(this.getFirstTarget());
        if (((SvnMerge)this.getOperation()).isDryRun()) {
            this.merge(this.getFirstTarget());
        } else {
            try {
                lockPath = context.acquireWriteLock(lockPath, false, true);
                this.merge(this.getFirstTarget());
            }
            finally {
                context.releaseWriteLock(lockPath);
                this.sleepForTimestamp();
            }
        }
        return null;
    }

    private File getLockPath(File firstTarget) throws SVNException {
        SVNNodeKind kind = this.getWcContext().readKind(firstTarget, false);
        if (kind == SVNNodeKind.DIR) {
            return firstTarget;
        }
        return SVNFileUtil.getParentFile(firstTarget);
    }

    private void merge(File target) throws SVNException {
        SVNNodeKind targetKind;
        SVNURL url2;
        SVNURL url1;
        SVNErrorMessage err;
        SVNFileType ft = SVNFileType.getType(target);
        if (ft == SVNFileType.NONE) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "Path ''{0}'' does not exist", (Object)target);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        SvnTarget source1 = ((SvnMerge)this.getOperation()).getFirstSource();
        SvnTarget source2 = ((SvnMerge)this.getOperation()).getSecondSource();
        if (source1.getResolvedPegRevision() == SVNRevision.UNDEFINED || source2.getResolvedPegRevision() == SVNRevision.UNDEFINED) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all revisions are specified");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (source1.isURL() != source2.isURL()) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Merge sources must both be either paths or URLs");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if ((url1 = this.getRepositoryAccess().getTargetURL(source1)) == null) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)source1.getFile());
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
        if ((url2 = this.getRepositoryAccess().getTargetURL(source2)) == null) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "''{0}'' has no URL", (Object)source2.getFile());
            SVNErrorManager.error(err4, SVNLogType.WC);
        }
        if ((targetKind = this.getWcContext().readKind(target, false)) != SVNNodeKind.DIR && targetKind != SVNNodeKind.FILE) {
            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Merge target ''{0}'' does not exist in the working copy", (Object)target);
            SVNErrorManager.error(err5, SVNLogType.WC);
        }
        SvnNgMergeDriver mergeDriver = new SvnNgMergeDriver(this.getWcContext(), (SvnMerge)this.getOperation(), this.getRepositoryAccess(), ((SvnMerge)this.getOperation()).getMergeOptions());
        mergeDriver.ensureWcIsSuitableForMerge(target, ((SvnMerge)this.getOperation()).isAllowMixedRevisions(), true, true);
        SVNURL wcReposRootURL = this.getWcContext().getNodeReposInfo((File)target).reposRootUrl;
        SVNRepository repos1 = this.getRepositoryAccess().createRepository(url1, null, false);
        SVNRepository repos2 = this.getRepositoryAccess().createRepository(url2, null, false);
        try {
            Structure<SvnRepositoryAccess.RevisionsPair> pair = this.getRepositoryAccess().getRevisionNumber(repos1, SvnTarget.fromURL(url1), source1.getResolvedPegRevision(), null);
            long rev1 = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            pair.release();
            pair = this.getRepositoryAccess().getRevisionNumber(repos2, SvnTarget.fromURL(url2), source2.getResolvedPegRevision(), null);
            long rev2 = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            pair.release();
            String uuid1 = repos1.getRepositoryUUID(true);
            String uuid2 = repos2.getRepositoryUUID(true);
            if (!uuid1.equals(uuid2)) {
                SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.RA_UUID_MISMATCH, "''{0}'' isn''t in the same repository as ''{1}''", url1, url2);
                SVNErrorManager.error(err6, SVNLogType.WC);
            }
            boolean sameRepos = true;
            SVNURL sourceReposRootURL = repos1.getRepositoryRoot(true);
            if (!wcReposRootURL.equals(sourceReposRootURL)) {
                String targetUuid = this.getWcContext().getNodeReposInfo((File)target).reposUuid;
                sameRepos = targetUuid.equals(uuid1);
            }
            SVNLocationSegment yc = null;
            if (!((SvnMerge)this.getOperation()).isIgnoreAncestry()) {
                yc = this.getRepositoryAccess().getYoungestCommonAncestor(url1, rev1, url2, rev2);
            }
            List<SvnNgMergeDriver.MergeSource> sources = new ArrayList<SvnNgMergeDriver.MergeSource>();
            boolean sourcesAncestral = false;
            boolean sourcesRelated = false;
            if (yc != null && yc.getPath() != null && yc.getStartRevision() >= 0L) {
                sourcesRelated = true;
                SVNURL ycURL = sourceReposRootURL.appendPath(yc.getPath(), false);
                if (url2.equals(ycURL) && yc.getStartRevision() == rev2) {
                    sourcesAncestral = true;
                    SVNRevisionRange range = new SVNRevisionRange(SVNRevision.create(rev1), SVNRevision.create(yc.getStartRevision()));
                    ArrayList<SVNRevisionRange> ranges = new ArrayList<SVNRevisionRange>();
                    ranges.add(range);
                    sources = mergeDriver.normalizeMergeSources(SvnTarget.fromURL(url1), url1, sourceReposRootURL, SVNRevision.create(rev1), ranges, repos1);
                } else if (url1.equals(ycURL) && yc.getStartRevision() == rev1) {
                    sourcesAncestral = true;
                    SVNRevisionRange range = new SVNRevisionRange(SVNRevision.create(yc.getStartRevision()), SVNRevision.create(rev2));
                    ArrayList<SVNRevisionRange> ranges = new ArrayList<SVNRevisionRange>();
                    ranges.add(range);
                    sources = mergeDriver.normalizeMergeSources(SvnTarget.fromURL(url2), url2, sourceReposRootURL, SVNRevision.create(rev2), ranges, repos2);
                } else {
                    mergeDriver.mergeCousinsAndSupplementMergeInfo(target, repos1, repos2, url1, rev1, url2, rev2, yc.getStartRevision(), sourceReposRootURL, wcReposRootURL, ((SvnMerge)this.getOperation()).getDepth(), ((SvnMerge)this.getOperation()).isIgnoreAncestry(), ((SvnMerge)this.getOperation()).isForce(), ((SvnMerge)this.getOperation()).isRecordOnly(), ((SvnMerge)this.getOperation()).isDryRun());
                }
            } else {
                SvnNgMergeDriver.MergeSource source = new SvnNgMergeDriver.MergeSource();
                source.rev1 = rev1;
                source.rev2 = rev2;
                source.url1 = url1;
                source.url2 = url2;
                sources.add(source);
            }
            mergeDriver.doMerge(null, sources, target, sourcesAncestral, sourcesRelated, sameRepos, ((SvnMerge)this.getOperation()).isIgnoreAncestry(), ((SvnMerge)this.getOperation()).isForce(), ((SvnMerge)this.getOperation()).isDryRun(), ((SvnMerge)this.getOperation()).isRecordOnly(), null, false, false, ((SvnMerge)this.getOperation()).getDepth(), ((SvnMerge)this.getOperation()).getMergeOptions());
        }
        finally {
            repos1.closeSession();
            repos2.closeSession();
        }
    }
}

