/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.List;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnScheduleForRemoval;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgRemove
extends SvnNgOperationRunner<Void, SvnScheduleForRemoval> {
    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        for (SvnTarget target : ((SvnScheduleForRemoval)this.getOperation()).getTargets()) {
            File path = target.getFile();
            this.checkCancelled();
            File lockRoot = this.getWcContext().acquireWriteLock(path, true, true);
            try {
                if (!((SvnScheduleForRemoval)this.getOperation()).isForce() && ((SvnScheduleForRemoval)this.getOperation()).isDeleteFiles()) {
                    SvnNgRemove.checkCanDelete(((SvnScheduleForRemoval)this.getOperation()).getOperationFactory(), context, path);
                }
                if (((SvnScheduleForRemoval)this.getOperation()).isDryRun()) continue;
                SvnNgRemove.delete(context, path, !((SvnScheduleForRemoval)this.getOperation()).isDeleteFiles(), true, ((SvnScheduleForRemoval)this.getOperation()).getEventHandler());
            }
            finally {
                this.getWcContext().releaseWriteLock(lockRoot);
            }
        }
        return null;
    }

    public static void checkCanDelete(SvnOperationFactory opFactory, SVNWCContext context, File path) throws SVNException {
        block10: {
            Structure<StructureFields.ExternalNodeInfo> info = null;
            try {
                try {
                    info = SvnWcDbExternals.readExternal(context, path, path, StructureFields.ExternalNodeInfo.kind);
                    if (info != null && info.get(StructureFields.ExternalNodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CANNOT_DELETE_FILE_EXTERNAL, "Cannot remove the external at ''{0}''; please edit or delete the svn:externals property on ''{1}''", path, SVNFileUtil.getParentFile(path));
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                        throw e;
                    }
                    if (info != null) {
                        info.release();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (info != null) {
                    info.release();
                }
                throw throwable;
            }
            if (info != null) {
                info.release();
            }
        }
        SvnGetStatus status = opFactory.createGetStatus();
        status.setSingleTarget(SvnTarget.fromFile(path));
        status.setDepth(SVNDepth.INFINITY);
        status.setReceiver(new ISvnObjectReceiver<SvnStatus>(){

            @Override
            public void receive(SvnTarget target, SvnStatus status) throws SVNException {
                SVNErrorMessage err = null;
                if (status.getNodeStatus() == SVNStatusType.STATUS_OBSTRUCTED) {
                    err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "''{0}'' is in the way of the resource actually under version control", (Object)target.getFile());
                } else if (!status.isVersioned()) {
                    err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", (Object)target.getFile());
                } else if (status.getNodeStatus() != SVNStatusType.STATUS_NORMAL && status.getNodeStatus() != SVNStatusType.STATUS_DELETED && status.getNodeStatus() != SVNStatusType.STATUS_MISSING || status.getPropertiesStatus() != SVNStatusType.STATUS_NONE && status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL) {
                    err = SVNErrorMessage.create(SVNErrorCode.CLIENT_MODIFIED, "''{0}'' has local modifications -- commit or revert them first", (Object)target.getFile());
                }
                if (err != null) {
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
        });
        status.run();
    }

    public static void delete(SVNWCContext context, File path, boolean keepLocal, boolean deleteUnversioned, ISVNEventHandler handler) throws SVNException {
        SVNErrorMessage err;
        Structure<StructureFields.NodeInfo> info = null;
        try {
            info = context.getDb().readInfo(path, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.conflicted);
        }
        catch (SVNException e) {
            if (deleteUnversioned && e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                if (SVNFileType.getType(path) == SVNFileType.NONE) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "''{0}'' does not exist", (Object)path);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
                if (!keepLocal) {
                    SVNFileUtil.deleteAll(path, handler);
                }
                return;
            }
            throw e;
        }
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)info.get(StructureFields.NodeInfo.status));
        if (status == ISVNWCDb.SVNWCDbStatus.Excluded || status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' cannot be deleted", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (status == ISVNWCDb.SVNWCDbStatus.Normal && info.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir && context.getDb().isWCRoot(path)) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "''{0}'' is the root of a working copy and cannot be deleted", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        context.writeCheck(SVNFileUtil.getParentFile(path));
        List<SVNConflictDescription> conflicts = null;
        if (!keepLocal && info.is(StructureFields.NodeInfo.conflicted)) {
            conflicts = context.getDb().readConflicts(path);
        }
        info.release();
        context.getDb().opDelete(path, handler);
        if (!keepLocal && conflicts != null) {
            for (SVNConflictDescription conflict : conflicts) {
                if (conflict.isTextConflict()) {
                    if (conflict.getMergeFiles() == null) continue;
                    SVNFileUtil.deleteFile(conflict.getMergeFiles().getBaseFile());
                    SVNFileUtil.deleteFile(conflict.getMergeFiles().getRepositoryFile());
                    SVNFileUtil.deleteFile(conflict.getMergeFiles().getLocalFile());
                    continue;
                }
                if (!conflict.isPropertyConflict() || conflict.getMergeFiles() == null) continue;
                SVNFileUtil.deleteFile(conflict.getMergeFiles().getRepositoryFile());
            }
        }
        if (!keepLocal) {
            SVNFileUtil.deleteAll(path, handler);
        }
    }
}

