/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.old;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRunner;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldUpgradeEntries;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.ISvnOperationOptionsProvider;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpgrade;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnOldUpgrade
extends SvnOldRunner<SvnWcGeneration, SvnUpgrade> {
    private static final String SVN_WC__BASE_EXT = ".svn-base";
    private static final String SVN_WC__REVERT_EXT = ".svn-revert";
    private static final String WCPROPS_SUBDIR_FOR_FILES = "wcprops";
    private static final String WCPROPS_FNAME_FOR_DIR = "dir-wcprops";
    private static final String WCPROPS_ALL_DATA = "all-wcprops";
    private static final String PROPS_SUBDIR = "props";
    private static final String PROP_BASE_SUBDIR = "prop-base";
    private static final String PROP_BASE_FOR_DIR = "dir-prop-base";
    private static final String PROP_REVERT_FOR_DIR = "dir-prop-revert";
    private static final String PROP_WORKING_FOR_DIR = "dir-props";
    private static final String TEXT_BASE_SUBDIR = "text-base";
    private static final String ADM_README = "README.txt";
    private static final String ADM_EMPTY_FILE = "empty-file";
    private static final String ADM_LOG = "log";
    private static final String ADM_LOCK = "lock";
    private static final String PRISTINE_STORAGE_RELPATH = "pristine";
    private static final String SDB_FILE = "wc.db";
    private SVNWCAccess access = null;

    public static SVNURL getEntryRepositoryRootURL(SVNEntry entry) throws SVNException {
        return SvnOldUpgrade.getCanonicalURL(entry.getRepositoryRootURL());
    }

    public static SVNURL getEntryURL(SVNEntry entry) throws SVNException {
        return SvnOldUpgrade.getCanonicalURL(entry.getSVNURL());
    }

    public static SVNURL getEntryCopyFromURL(SVNEntry entry) throws SVNException {
        return SvnOldUpgrade.getCanonicalURL(entry.getCopyFromSVNURL());
    }

    private static SVNURL getCanonicalURL(SVNURL original) throws SVNException {
        if (original == null) {
            return null;
        }
        SVNURL canonical = SVNUpdateClient16.canonicalizeURL(original, true);
        return canonical != null ? canonical : original;
    }

    private SVNWCAccess getWCAccess() {
        if (this.access == null) {
            this.access = SVNWCAccess.newInstance(((SvnUpgrade)this.getOperation()).getEventHandler());
            this.access.setOptions(((SvnUpgrade)this.getOperation()).getOptions());
        }
        return this.access;
    }

    @Override
    protected SvnWcGeneration run() throws SVNException {
        if (((SvnUpgrade)this.getOperation()).getFirstTarget().isURL()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "'{0}' is not a local path", (Object)((SvnUpgrade)this.getOperation()).getFirstTarget().getURL());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File localAbsPath = ((SvnUpgrade)this.getOperation()).getFirstTarget().getFile().getAbsoluteFile();
        RepositoryInfo reposInfo = new RepositoryInfo();
        this.wcUpgrade(localAbsPath, reposInfo);
        final HashMap externals = new HashMap();
        SvnGetProperties getProperties = ((SvnUpgrade)this.getOperation()).getOperationFactory().createGetProperties();
        getProperties.addTarget(((SvnUpgrade)this.getOperation()).getFirstTarget());
        getProperties.setDepth(SVNDepth.INFINITY);
        getProperties.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                String value = object.getStringValue("svn:externals");
                if (value != null) {
                    externals.put(target, value);
                }
            }
        });
        getProperties.run();
        for (SvnTarget target : externals.keySet()) {
            SVNExternal[] externalDefs = SVNExternal.parseExternals(target.getFile(), (String)externals.get(target));
            int i = 0;
            while (i < externalDefs.length) {
                File externalPath = SVNFileUtil.createFilePath(target.getFile(), externalDefs[i].getPath());
                try {
                    this.getWcContext().readKind(externalPath.getAbsoluteFile(), false);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_UNSUPPORTED_FORMAT) {
                        getProperties.getOperationFactory().getWcContext().getDb().close();
                        SvnUpgrade upgradeExternal = ((SvnUpgrade)this.getOperation()).getOperationFactory().createUpgrade();
                        upgradeExternal.setSingleTarget(SvnTarget.fromFile(externalPath));
                        upgradeExternal.run();
                    }
                    throw e;
                }
                ++i;
            }
        }
        return SvnWcGeneration.V17;
    }

    /*
     * Unable to fully structure code
     */
    private void checkIsOldWCRoot(File localAbsPath) throws SVNException {
        wcAccess = this.getWCAccess();
        try {
            SvnOldUpgrade.readEntries(wcAccess, localAbsPath);
        }
        catch (SVNException e) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Can''t upgrade ''{0}'' as it is not a pre-1.7 working copy directory", (Object)localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNFileUtil.getParentFile(localAbsPath) == null) {
            return;
        }
        parentAbsPath = SVNFileUtil.getParentFile(localAbsPath);
        entry = null;
        entries = null;
        try {
            entries = SvnOldUpgrade.readEntries(wcAccess, parentAbsPath);
        }
        catch (SVNException ex) {
            return;
        }
        entry = entries.get(localAbsPath.getName());
        if (entry != null && !entry.isAbsent() && (!entry.isDeleted() || entry.isScheduledForAddition()) && entry.getDepth() != SVNDepth.EXCLUDE) ** GOTO lbl34
        return;
lbl-1000:
        // 1 sources

        {
            childAbsPath = parentAbsPath;
            parentAbsPath = SVNFileUtil.getParentFile(parentAbsPath);
            try {
                entries = SvnOldUpgrade.readEntries(wcAccess, parentAbsPath);
            }
            catch (SVNException e) {
                parentAbsPath = childAbsPath;
                break;
            }
            entry = entries.get(localAbsPath.getName());
            if (entry != null && !entry.isAbsent() && (!entry.isDeleted() || entry.isScheduledForAddition()) && entry.getDepth() != SVNDepth.EXCLUDE) continue;
            parentAbsPath = childAbsPath;
            break;
lbl34:
            // 2 sources

            ** while (SVNFileUtil.getParentFile((File)parentAbsPath) != null)
        }
lbl35:
        // 3 sources

        err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Can''t upgrade ''{0}'' as it is not a pre-1.7 working copy root, the root is ''{1}''", new Object[]{localAbsPath, parentAbsPath});
        SVNErrorManager.error(err, SVNLogType.WC);
    }

    private void fetchReposInfo(SVNEntry entry, RepositoryInfo lastRepositoryInfo) throws SVNException {
        if (lastRepositoryInfo.repositoryRootUrl != null && SVNURLUtil.isAncestor(lastRepositoryInfo.repositoryRootUrl, SvnOldUpgrade.getEntryURL(entry))) {
            entry.setRepositoryRootURL(lastRepositoryInfo.repositoryRootUrl);
            entry.setUUID(lastRepositoryInfo.UUID);
            return;
        }
        SvnOldRepositoryAccess repAccess = new SvnOldRepositoryAccess((ISvnOperationOptionsProvider)this.getOperation());
        SVNRepository repository = repAccess.createRepository(SvnOldUpgrade.getEntryURL(entry), null, true);
        entry.setRepositoryRootURL(repository.getRepositoryRoot(true));
        entry.setUUID(repository.getRepositoryUUID(true));
        lastRepositoryInfo.repositoryRootUrl = SvnOldUpgrade.getEntryRepositoryRootURL(entry);
        lastRepositoryInfo.UUID = entry.getUUID();
    }

    private void ensureReposInfo(SVNEntry entry, File localAbsPath, RepositoryInfo lastRepositoryInfo, Map<SVNURL, String> reposCache) throws SVNException {
        if (SvnOldUpgrade.getEntryRepositoryRootURL(entry) != null && entry.getUUID() != null) {
            return;
        }
        if ((SvnOldUpgrade.getEntryRepositoryRootURL(entry) == null || entry.getUUID() == null) && SvnOldUpgrade.getEntryURL(entry) != null) {
            for (SVNURL reposRootUrl : reposCache.keySet()) {
                if (!SVNURLUtil.isAncestor(reposRootUrl, SvnOldUpgrade.getEntryURL(entry))) continue;
                if (SvnOldUpgrade.getEntryRepositoryRootURL(entry) == null) {
                    entry.setRepositoryRootURL(reposRootUrl);
                }
                if (entry.getUUID() == null) {
                    entry.setUUID(reposCache.get(reposRootUrl));
                }
                return;
            }
        }
        if (SvnOldUpgrade.getEntryURL(entry) == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "Working copy ''{0}'' can't be upgraded because it doesn't have a url", (Object)localAbsPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.fetchReposInfo(entry, lastRepositoryInfo);
    }

    private void wcUpgrade(File localAbsPath, RepositoryInfo reposInfo) throws SVNException {
        ISVNWCDb.SVNWCDbUpgradeData upgradeData = new ISVNWCDb.SVNWCDbUpgradeData();
        this.checkIsOldWCRoot(localAbsPath);
        SVNWCDb db = new SVNWCDb();
        db.open(ISVNWCDb.SVNWCDbOpenMode.ReadWrite, null, false, false);
        SVNWCContext wcContext = new SVNWCContext(db, ((SvnUpgrade)this.getOperation()).getEventHandler());
        SVNWCAccess wcAccess = this.getWCAccess();
        SVNEntry thisDir = null;
        try {
            wcAccess.probeOpen(localAbsPath, false, 0);
            thisDir = wcAccess.getEntry(localAbsPath, false);
        }
        finally {
            wcAccess.close();
        }
        HashMap<SVNURL, String> reposCache = new HashMap<SVNURL, String>();
        this.ensureReposInfo(thisDir, localAbsPath, reposInfo, reposCache);
        if (!reposCache.containsKey(SvnOldUpgrade.getEntryRepositoryRootURL(thisDir))) {
            reposCache.put(SvnOldUpgrade.getEntryRepositoryRootURL(thisDir), thisDir.getUUID());
        }
        upgradeData.rootAbsPath = SVNFileUtil.createFilePath(SVNWCUtils.admChild(localAbsPath, "tmp"), "wcng");
        File rootAdmAbsPath = SVNWCUtils.admChild(upgradeData.rootAbsPath, "");
        try {
            SVNFileUtil.deleteAll(rootAdmAbsPath, true);
            SVNFileUtil.ensureDirectoryExists(rootAdmAbsPath);
            db.upgradeBegin(upgradeData.rootAbsPath, upgradeData, SvnOldUpgrade.getEntryRepositoryRootURL(thisDir), thisDir.getUUID());
            db.obtainWCLock(upgradeData.rootAbsPath, 0, false);
            upgradeData.root.getSDb().beginTransaction(SqlJetTransactionMode.WRITE);
            try {
                try {
                    this.upgradeWorkingCopy(null, db, localAbsPath, upgradeData, reposCache, reposInfo);
                }
                catch (SVNException ex) {
                    upgradeData.root.getSDb().rollback();
                    throw ex;
                }
            }
            finally {
                upgradeData.root.getSDb().commit();
            }
            File pristineFrom = SVNWCUtils.admChild(upgradeData.rootAbsPath, PRISTINE_STORAGE_RELPATH);
            File pristineTo = SVNWCUtils.admChild(localAbsPath, PRISTINE_STORAGE_RELPATH);
            SVNFileUtil.ensureDirectoryExists(pristineFrom);
            SVNSkel workItems = null;
            SVNSkel workItem = wcContext.wqBuildFileMove(localAbsPath, pristineFrom, pristineTo);
            workItems = wcContext.wqMerge(workItems, workItem);
            workItem = wcContext.wqBuildPostUpgrade();
            workItems = wcContext.wqMerge(workItems, workItem);
            db.addWorkQueue(upgradeData.rootAbsPath, workItems);
            db.releaseWCLock(upgradeData.rootAbsPath);
            db.close();
            File dbFrom = SVNWCUtils.admChild(upgradeData.rootAbsPath, SDB_FILE);
            File dbTo = SVNWCUtils.admChild(localAbsPath, SDB_FILE);
            SVNFileUtil.rename(dbFrom, dbTo);
            db.open(ISVNWCDb.SVNWCDbOpenMode.ReadWrite, null, false, false);
            wcContext = new SVNWCContext(db, ((SvnUpgrade)this.getOperation()).getEventHandler());
            wcContext.wqRun(localAbsPath);
        }
        finally {
            db.close();
            SVNFileUtil.deleteAll(upgradeData.rootAbsPath, true);
        }
        if (((SvnUpgrade)this.getOperation()).getEventHandler() != null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPGRADE, null, null, null);
            ((SvnUpgrade)this.getOperation()).getEventHandler().handleEvent(event, -1.0);
        }
    }

    private void upgradeWorkingCopy(SvnOldUpgradeEntries.WriteBaton parentDirBaton, SVNWCDb db, File dirAbsPath, ISVNWCDb.SVNWCDbUpgradeData data, Map<SVNURL, String> reposCache, RepositoryInfo reposInfo) throws SVNException {
        int oldFormat;
        SvnOldUpgradeEntries.WriteBaton dirBaton = null;
        if (((SvnUpgrade)this.getOperation()).getEventHandler() != null) {
            ((SvnUpgrade)this.getOperation()).getEventHandler().checkCancelled();
        }
        if ((oldFormat = db.getFormatTemp(dirAbsPath)) >= 12) {
            if (((SvnUpgrade)this.getOperation()).getEventHandler() != null) {
                SVNEvent event = SVNEventFactory.createSVNEvent(dirAbsPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPGRADED_PATH, null, null);
                ((SvnUpgrade)this.getOperation()).getEventHandler().handleEvent(event, -1.0);
            }
            return;
        }
        ArrayList<File> children = new ArrayList<File>();
        try {
            SvnOldUpgrade.getVersionedSubdirs(this.getWCAccess(), dirAbsPath, children, false, false);
        }
        catch (SVNException ex) {
            if (ex.isEnoent() && ((SvnUpgrade)this.getOperation()).getEventHandler() != null) {
                SVNEvent event = SVNEventFactory.createSVNEvent(dirAbsPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.SKIP, SVNEventAction.UPGRADED_PATH, null, null);
                ((SvnUpgrade)this.getOperation()).getEventHandler().handleEvent(event, -1.0);
            }
            return;
        }
        dirBaton = this.upgradeToWcng(parentDirBaton, db, dirAbsPath, oldFormat, data, reposCache, reposInfo);
        if (((SvnUpgrade)this.getOperation()).getEventHandler() != null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(dirAbsPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.UPGRADED_PATH, null, null, null);
            ((SvnUpgrade)this.getOperation()).getEventHandler().handleEvent(event, -1.0);
        }
        for (File childAbsPath : children) {
            this.upgradeWorkingCopy(dirBaton, db, childAbsPath, data, reposCache, reposInfo);
        }
    }

    private SvnOldUpgradeEntries.WriteBaton upgradeToWcng(SvnOldUpgradeEntries.WriteBaton parentDirBaton, SVNWCDb db, File dirAbsPath, int oldFormat, ISVNWCDb.SVNWCDbUpgradeData data, Map<SVNURL, String> reposCache, RepositoryInfo reposInfo) throws SVNException {
        SvnOldUpgradeEntries.WriteBaton dirBaton = null;
        File logFilePath = SVNWCUtils.admChild(dirAbsPath, ADM_LOG);
        SVNNodeKind logFileKind = SVNFileType.getNodeKind(SVNFileType.getType(logFilePath));
        if (logFileKind == SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "Cannot upgrade with existing logs; run a cleanup operation on this working copy using a client version which is compatible with this working copy's format (such as the version you are upgrading from), then retry the upgrade with the current version");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.createPhysicalLock(dirAbsPath);
        SVNWCAccess access = this.getWCAccess();
        Map entries = null;
        try {
            File dirRelPath;
            SVNAdminArea area;
            block11: {
                area = access.probeOpen(dirAbsPath, false, 0);
                entries = area.getEntries();
                SVNEntry thisDir = (SVNEntry)entries.get("");
                this.ensureReposInfo(thisDir, dirAbsPath, reposInfo, reposCache);
                if (!reposCache.containsKey(SvnOldUpgrade.getEntryRepositoryRootURL(thisDir))) {
                    reposCache.put(SvnOldUpgrade.getEntryRepositoryRootURL(thisDir), thisDir.getUUID());
                }
                String dirAbsPathString = SVNFileUtil.getFilePath(dirAbsPath);
                String oldWcRootAbsPath = SVNPathUtil.getCommonPathAncestor(dirAbsPathString, SVNFileUtil.getFilePath(data.rootAbsPath));
                dirRelPath = new File(SVNPathUtil.getRelativePath(oldWcRootAbsPath, dirAbsPathString));
                SVNHashMap textBases = this.migrateTextBases(dirAbsPath, data.rootAbsPath, data.root);
                try {
                    dirBaton = SvnOldUpgradeEntries.writeUpgradedEntries(parentDirBaton, db, data, dirAbsPath, entries, textBases);
                }
                catch (SVNException ex) {
                    if (ex.getErrorMessage().getErrorCode() == SVNErrorCode.WC_CORRUPT) {
                        SVNErrorMessage err = ex.getErrorMessage().wrap("This working copy is corrupt and cannot be upgraded. Please check out a new working copy.");
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if (ex.getErrorMessage().getErrorCode() != SVNErrorCode.WC_INVALID_SCHEDULE) break block11;
                    throw ex;
                }
            }
            if (oldFormat != 12) {
                SVNHashMap cachedProps = new SVNHashMap();
                SVNVersionedProperties verProps = area.getWCProperties("");
                if (verProps != null) {
                    cachedProps.put("", verProps.asMap());
                }
                Set<File> children = this.getVersionedFiles(dirRelPath, data.root.getSDb(), data.workingCopyId);
                for (File file : children) {
                    verProps = area.getWCProperties(SVNFileUtil.getFileName(file));
                    if (verProps == null) continue;
                    cachedProps.put(SVNFileUtil.getFileName(file), verProps.asMap());
                }
                SvnWcDbProperties.upgradeApplyDavCache(data.root, dirRelPath, cachedProps);
            }
            this.migrateProps(dirAbsPath, data, oldFormat, area);
        }
        finally {
            access.close();
        }
        return dirBaton;
    }

    private SVNHashMap migrateTextBases(File dirAbsPath, File newWcRootAbsPath, SVNWCDbRoot root) throws SVNException {
        SVNHashMap textBasesInfo = new SVNHashMap();
        File textBaseDir = SVNWCUtils.admChild(dirAbsPath, TEXT_BASE_SUBDIR);
        File[] files = SVNFileListUtil.listFiles(textBaseDir);
        if (files == null) {
            return textBasesInfo;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isRevertBase;
            File textBasePath = fileArray[n2];
            SvnChecksum md5Checksum = null;
            SvnChecksum sha1Checksum = null;
            File tempPath = SVNFileUtil.createUniqueFile(newWcRootAbsPath, "upgrade", ".tmp", false);
            InputStream readStream = SVNFileUtil.openFileForReading(textBasePath);
            SVNChecksumInputStream readChecksummedIS = null;
            try {
                readChecksummedIS = new SVNChecksumInputStream(readStream, "SHA1");
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(readChecksummedIS);
                SVNFileUtil.closeFile(readStream);
                throw throwable;
            }
            SVNFileUtil.closeFile(readChecksummedIS);
            SVNFileUtil.closeFile(readStream);
            sha1Checksum = readChecksummedIS != null ? new SvnChecksum(SvnChecksum.Kind.sha1, readChecksummedIS.getDigest()) : null;
            readStream = SVNFileUtil.openFileForReading(textBasePath);
            try {
                readChecksummedIS = new SVNChecksumInputStream(readStream, "MD5");
            }
            finally {
                SVNFileUtil.closeFile(readChecksummedIS);
                SVNFileUtil.closeFile(readStream);
            }
            md5Checksum = readChecksummedIS != null ? new SvnChecksum(SvnChecksum.Kind.md5, readChecksummedIS.getDigest()) : null;
            SVNFileUtil.copyFile(textBasePath, tempPath, true);
            SVNSqlJetStatement stmt = root.getSDb().getStatement(SVNWCDbStatements.INSERT_OR_IGNORE_PRISTINE);
            try {
                stmt.bindChecksum(1, sha1Checksum);
                stmt.bindChecksum(2, md5Checksum);
                stmt.bindLong(3, textBasePath.length());
                stmt.exec();
            }
            finally {
                stmt.reset();
            }
            File pristinePath = SvnWcDbPristines.getPristineFuturePath(root, sha1Checksum);
            SVNFileUtil.ensureDirectoryExists(SVNFileUtil.getFileDir(pristinePath));
            SVNFileUtil.rename(tempPath, pristinePath);
            File versionedFile = this.removeSuffix(textBasePath, SVN_WC__REVERT_EXT);
            if (versionedFile != null) {
                isRevertBase = true;
            } else {
                versionedFile = this.removeSuffix(textBasePath, SVN_WC__BASE_EXT);
                isRevertBase = false;
            }
            if (versionedFile != null) {
                String versionedFileName = SVNFileUtil.getFileName(versionedFile);
                TextBaseInfo info = (TextBaseInfo)textBasesInfo.get(versionedFileName);
                if (info == null) {
                    info = new TextBaseInfo();
                }
                TextBaseFileInfo fileInfo = isRevertBase ? info.revertBase : info.normalBase;
                fileInfo.sha1Checksum = sha1Checksum;
                fileInfo.md5Checksum = md5Checksum;
                textBasesInfo.put(versionedFileName, info);
            }
            ++n2;
        }
        return textBasesInfo;
    }

    private File removeSuffix(File file, String suffix) {
        String fileName = SVNPathUtil.getAbsolutePath(file.getPath());
        if (fileName.length() > suffix.length() && fileName.endsWith(suffix)) {
            return SVNFileUtil.createFilePath(fileName.substring(0, fileName.length() - suffix.length()));
        }
        return null;
    }

    private void createPhysicalLock(File absPath) throws SVNException {
        File lockAbsPath = SvnOldUpgrade.buildLockfilePath(absPath);
        if (lockAbsPath.isFile()) {
            return;
        }
        SVNFileUtil.createEmptyFile(lockAbsPath);
    }

    public static void wipePostUpgrade(SVNWCContext ctx, File dirAbsPath, boolean isWholeAdmin) throws SVNException {
        ctx.checkCancelled();
        SVNWCAccess access = SVNWCAccess.newInstance(ctx.getEventHandler());
        access.setOptions(ctx.getOptions());
        ArrayList<File> subDirs = new ArrayList<File>();
        boolean isDoDeleteDir = false;
        try {
            isDoDeleteDir = SvnOldUpgrade.getVersionedSubdirs(access, dirAbsPath, subDirs, true, true);
        }
        catch (SVNException ex) {
            return;
        }
        for (File childAbsPath : subDirs) {
            SvnOldUpgrade.wipePostUpgrade(ctx, childAbsPath, true);
        }
        if (isWholeAdmin) {
            SVNFileUtil.deleteAll(SVNFileUtil.createFilePath(dirAbsPath, SVNFileUtil.getAdminDirectoryName()), true);
        } else {
            SvnOldUpgrade.wipeObsoleteFiles(dirAbsPath);
        }
        if (isDoDeleteDir) {
            SVNFileUtil.deleteAll(dirAbsPath, true);
        }
    }

    public static void wipeObsoleteFiles(File dirAbsPath) throws SVNException {
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, "format"), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, "entries"), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, ADM_EMPTY_FILE), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, ADM_README), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, WCPROPS_FNAME_FOR_DIR), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, WCPROPS_SUBDIR_FOR_FILES), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, WCPROPS_ALL_DATA), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, TEXT_BASE_SUBDIR), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, PROPS_SUBDIR), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, PROP_BASE_SUBDIR), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, PROP_WORKING_FOR_DIR), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, PROP_BASE_FOR_DIR), true);
        SVNFileUtil.deleteAll(SVNWCUtils.admChild(dirAbsPath, PROP_REVERT_FOR_DIR), true);
        SVNFileUtil.deleteAll(SvnOldUpgrade.buildLockfilePath(dirAbsPath), true);
    }

    private static File buildLockfilePath(File dirAbsPath) {
        return SVNWCUtils.admChild(dirAbsPath, ADM_LOCK);
    }

    private static Map<String, SVNEntry> readEntries(SVNWCAccess access, File localAbsPath) throws SVNException {
        Map entries = null;
        try {
            SVNAdminArea area = access.probeOpen(localAbsPath, false, 0);
            if (!area.getRoot().equals(localAbsPath)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "'{0}' is not versioned directory", (Object)localAbsPath);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            entries = area.getEntries();
        }
        finally {
            access.close();
        }
        return entries;
    }

    public static boolean getVersionedSubdirs(SVNWCAccess access, File localAbsPath, ArrayList<File> children, boolean isCalculateDoDeleteDir, boolean isSkipMissing) throws SVNException {
        boolean isDoDeleteDir = false;
        Map<String, SVNEntry> entries = SvnOldUpgrade.readEntries(access, localAbsPath);
        SVNEntry thisDir = null;
        for (String name : entries.keySet()) {
            SVNNodeKind kind;
            SVNEntry entry = entries.get(name);
            if ("".equals(name)) {
                thisDir = entry;
                continue;
            }
            if (entry == null || entry.getKind() != SVNNodeKind.DIR) continue;
            File childAbsPath = SVNFileUtil.createFilePath(localAbsPath, name);
            if (isSkipMissing && (kind = SVNFileType.getNodeKind(SVNFileType.getType(childAbsPath))) != SVNNodeKind.DIR) continue;
            children.add(childAbsPath);
        }
        if (isCalculateDoDeleteDir) {
            isDoDeleteDir = thisDir != null && thisDir.isScheduledForDeletion() && !thisDir.isKeepLocal();
        }
        return isDoDeleteDir;
    }

    private Set<File> getVersionedFiles(File parentRelPath, SVNSqlJetDb sDb, long wcId) throws SVNException {
        HashSet<File> children = new HashSet<File>();
        SVNSqlJetStatement stmt = sDb.getStatement(SVNWCDbStatements.SELECT_ALL_FILES);
        try {
            stmt.bindLong(1, wcId);
            stmt.bindString(2, SVNFileUtil.getFilePath(parentRelPath));
            while (stmt.next()) {
                File localRelPath = SVNFileUtil.createFilePath(stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
                if (children.contains(localRelPath)) continue;
                children.add(localRelPath);
            }
        }
        finally {
            stmt.reset();
        }
        return children;
    }

    private void migrateProps(File dirAbsPath, ISVNWCDb.SVNWCDbUpgradeData data, int originalFormat, SVNAdminArea area) throws SVNException {
        String dirAbsPathString = SVNFileUtil.getFilePath(dirAbsPath);
        String oldWcRootAbsPath = SVNPathUtil.getCommonPathAncestor(dirAbsPathString, SVNFileUtil.getFilePath(data.rootAbsPath));
        File dirRelPath = new File(SVNPathUtil.getRelativePath(oldWcRootAbsPath, dirAbsPathString));
        this.migrateNodeProps(dirAbsPath, data, "", originalFormat, area);
        Set<File> children = this.getVersionedFiles(dirRelPath, data.root.getSDb(), data.workingCopyId);
        for (File file : children) {
            this.migrateNodeProps(dirAbsPath, data, SVNFileUtil.getFileName(file), originalFormat, area);
        }
    }

    private void migrateNodeProps(File dirAbsPath, ISVNWCDb.SVNWCDbUpgradeData data, String name, int originalFormat, SVNAdminArea area) throws SVNException {
        String dirAbsPathString = SVNFileUtil.getFilePath(dirAbsPath);
        String oldWcRootAbsPath = SVNPathUtil.getCommonPathAncestor(dirAbsPathString, SVNFileUtil.getFilePath(data.rootAbsPath));
        File dirRelPath = new File(SVNPathUtil.getRelativePath(oldWcRootAbsPath, dirAbsPathString));
        File basePropsFile = area.getBasePropertiesFile(name, false);
        File revertPropsFile = area.getRevertPropertiesFile(name, false);
        File propsFile = area.getPropertiesFile(name, false);
        SVNProperties baseProps = basePropsFile.isFile() ? new SVNWCProperties(basePropsFile, null).asMap() : null;
        SVNProperties revertProps = revertPropsFile.isFile() ? new SVNWCProperties(revertPropsFile, null).asMap() : null;
        SVNProperties props = propsFile.isFile() ? new SVNWCProperties(propsFile, null).asMap() : null;
        SvnWcDbProperties.upgradeApplyProperties(data.root, data.rootAbsPath, SVNFileUtil.createFilePath(dirRelPath, name), baseProps, props, revertProps, originalFormat);
    }

    private class RepositoryInfo {
        public SVNURL repositoryRootUrl = null;
        public String UUID = null;

        private RepositoryInfo() {
        }
    }

    public class TextBaseFileInfo {
        public SvnChecksum sha1Checksum;
        public SvnChecksum md5Checksum;
    }

    public class TextBaseInfo {
        public TextBaseFileInfo normalBase;
        public TextBaseFileInfo revertBase;

        public TextBaseInfo() {
            this.normalBase = new TextBaseFileInfo();
            this.revertBase = new TextBaseFileInfo();
        }
    }
}

