/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExportEditor;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnExport;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRemoteExport
extends SvnRemoteOperationRunner<Long, SvnExport> {
    @Override
    public boolean isApplicable(SvnExport operation, SvnWcGeneration wcGeneration) throws SVNException {
        return !operation.getSource().isLocal();
    }

    @Override
    protected Long run() throws SVNException {
        SvnTarget exportSource = ((SvnExport)this.getOperation()).getSource();
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(exportSource, ((SvnExport)this.getOperation()).getRevision(), exportSource.getResolvedPegRevision(), exportSource.getFile());
        final long revNumber = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        repositoryInfo.release();
        File dstPath = ((SvnExport)this.getOperation()).getFirstTarget().getFile();
        SVNDepth depth = ((SvnExport)this.getOperation()).getDepth();
        boolean force = ((SvnExport)this.getOperation()).isForce();
        boolean expandKeywords = ((SvnExport)this.getOperation()).isExpandKeywords();
        String eolStyle = ((SvnExport)this.getOperation()).getEolStyle();
        boolean ignoreExternals = ((SvnExport)this.getOperation()).isIgnoreExternals();
        ISVNOptions options = ((SvnExport)this.getOperation()).getOptions();
        SVNNodeKind dstKind = repository.checkPath("", revNumber);
        if (dstKind == SVNNodeKind.DIR) {
            SVNExportEditor editor = new SVNExportEditor(this, repository.getLocation().toString(), dstPath, force, eolStyle, expandKeywords, options);
            repository.update(revNumber, null, depth, false, new ISVNReporterBaton(){

                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, revNumber, SVNDepth.INFINITY, true);
                    reporter.finishReport();
                }
            }, SVNCancellableEditor.newInstance(editor, this, null));
            SVNFileType fileType = SVNFileType.getType(dstPath);
            if (fileType == SVNFileType.NONE) {
                editor.openRoot(revNumber);
            }
            if (!ignoreExternals && depth == SVNDepth.INFINITY) {
                Map<String, String> externals = editor.getCollectedExternals();
                this.handleExternals(externals, repository.getLocation(), dstPath, repository.getRepositoryRoot(true));
            }
        } else if (dstKind == SVNNodeKind.FILE) {
            String url = repository.getLocation().toString();
            if (dstPath.isDirectory()) {
                dstPath = new File(dstPath, SVNEncodingUtil.uriDecode(SVNPathUtil.tail(url)));
            }
            if (dstPath.exists()) {
                if (!force) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' already exists", (Object)dstPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            } else {
                dstPath.getParentFile().mkdirs();
            }
            SVNProperties properties = new SVNProperties();
            OutputStream os = null;
            File tmpFile = SVNFileUtil.createUniqueFile(dstPath.getParentFile(), ".export", ".tmp", false);
            try {
                os = SVNFileUtil.openFileForWriting(tmpFile);
                try {
                    repository.getFile("", revNumber, properties, new SVNCancellableOutputStream(os, this));
                }
                finally {
                    SVNFileUtil.closeFile(os);
                }
                if (force && dstPath.exists()) {
                    SVNFileUtil.deleteAll(dstPath, this);
                }
                if (!expandKeywords) {
                    properties.put("svn:mime-type", "application/octet-stream");
                }
                String mimeType = properties.getStringValue("svn:mime-type");
                boolean binary = SVNProperty.isBinaryMimeType(mimeType);
                String charset = SVNTranslator.getCharset(properties.getStringValue("svnkit:charset"), mimeType, url, options);
                Map<String, byte[]> keywords = SVNTranslator.computeKeywords(properties.getStringValue("svn:keywords"), url, properties.getStringValue("svn:entry:last-author"), properties.getStringValue("svn:entry:committed-date"), properties.getStringValue("svn:entry:committed-rev"), options);
                byte[] eols = null;
                if ("native".equals(properties.getStringValue("svn:eol-style"))) {
                    eols = SVNTranslator.getEOL(eolStyle != null ? eolStyle : properties.getStringValue("svn:eol-style"), options);
                } else if (properties.containsName("svn:eol-style")) {
                    eols = SVNTranslator.getEOL(properties.getStringValue("svn:eol-style"), options);
                }
                if (binary) {
                    charset = null;
                    eols = null;
                    keywords = null;
                }
                SVNTranslator.translate(tmpFile, dstPath, charset, eols, keywords, properties.getStringValue("svn:special") != null, true);
            }
            finally {
                SVNFileUtil.deleteFile(tmpFile);
            }
            if (properties.getStringValue("svn:executable") != null) {
                SVNFileUtil.setExecutable(dstPath, true);
            }
            this.handleEvent(SVNEventFactory.createSVNEvent(dstPath, SVNNodeKind.FILE, null, -1L, SVNEventAction.UPDATE_ADD, null, null, null));
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn't exist", (Object)repository.getLocation());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        this.handleEvent(SVNEventFactory.createSVNEvent(dstPath, SVNNodeKind.NONE, null, revNumber, SVNEventAction.UPDATE_COMPLETED, null, null, null));
        return revNumber;
    }

    private void handleExternals(Map<String, String> externals, SVNURL fromUrl, File toPath, SVNURL reposRootUrl) throws SVNException {
        for (String relativePath : externals.keySet()) {
            File dirPath = new File(toPath, relativePath);
            String externalValue = externals.get(relativePath);
            SVNExternal[] exts = SVNExternal.parseExternals(dirPath, externalValue);
            SVNURL directoryUrl = fromUrl.appendPath(relativePath, false);
            int i = 0;
            while (i < exts.length) {
                File externalDirectory = new File(dirPath, exts[i].getPath());
                File parentDirectory = SVNFileUtil.getParentFile(externalDirectory);
                if (parentDirectory != null) {
                    SVNFileUtil.ensureDirectoryExists(parentDirectory);
                }
                exts[i].resolveURL(reposRootUrl, directoryUrl);
                SVNURL externalUrl = exts[i].getResolvedURL();
                SvnExport export = ((SvnExport)this.getOperation()).getOperationFactory().createExport();
                export.setSource(SvnTarget.fromURL(externalUrl, exts[i].getPegRevision()));
                export.setSingleTarget(SvnTarget.fromFile(externalDirectory));
                export.setDepth(SVNDepth.INFINITY);
                export.setExpandKeywords(((SvnExport)this.getOperation()).isExpandKeywords());
                export.setEolStyle(((SvnExport)this.getOperation()).getEolStyle());
                export.setRevision(exts[i].getRevision());
                export.setForce(true);
                export.setIgnoreExternals(false);
                export.setSleepForTimestamp(false);
                try {
                    export.run();
                }
                catch (SVNCancelException e) {
                    throw e;
                }
                catch (SVNException e) {
                    this.handleEvent(SVNEventFactory.createSVNEvent(externalDirectory, SVNNodeKind.NONE, null, -1L, SVNEventAction.FAILED_EXTERNAL, SVNEventAction.UPDATE_EXTERNAL_REMOVED, e.getErrorMessage(), null));
                }
                ++i;
            }
        }
    }
}

