/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRemoteGetInfo
extends SvnRemoteOperationRunner<SvnInfo, SvnGetInfo> {
    @Override
    public boolean isApplicable(SvnGetInfo operation, SvnWcGeneration wcGeneration) throws SVNException {
        if (super.isApplicable(operation, wcGeneration)) {
            return true;
        }
        SVNRevision revision = operation.getRevision();
        return !revision.isLocal();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected SvnInfo run() throws SVNException {
        block29: {
            block25: {
                block26: {
                    block27: {
                        block28: {
                            infoTarget = ((SvnGetInfo)this.getOperation()).getFirstTarget();
                            repositoryInfo = this.getRepositoryAccess().createRepositoryFor(infoTarget, ((SvnGetInfo)this.getOperation()).getRevision(), infoTarget.getResolvedPegRevision(), null);
                            repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
                            url = (SVNURL)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.url);
                            revNum = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
                            repositoryRootUrl = repository.getRepositoryRoot(true);
                            repositoryUUID = repository.getRepositoryUUID(true);
                            repositoryInfo.release();
                            parentURL = url.removePathTail();
                            baseName = SVNPathUtil.tail(url.getPath());
                            rootEntry = null;
                            depth = ((SvnGetInfo)this.getOperation()).getDepth();
                            pegRevision = infoTarget.getResolvedPegRevision();
                            try {
                                rootEntry = repository.info("", revNum);
                                break block25;
                            }
                            catch (SVNException e) {
                                if (e.getErrorMessage() == null || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) break block26;
                                if (!url.equals(repositoryRootUrl)) break block27;
                                if (depth.compareTo(SVNDepth.EMPTY) <= 0) break block28;
                                locks = null;
                                if (pegRevision == SVNRevision.HEAD) {
                                    try {
                                        locks = repository.getLocks("");
                                    }
                                    catch (SVNException svne) {
                                        code = svne.getErrorMessage().getErrorCode();
                                        if (code == SVNErrorCode.RA_NOT_IMPLEMENTED || code == SVNErrorCode.UNSUPPORTED_FEATURE) {
                                            locks = new SVNLock[]{};
                                        }
                                        throw svne;
                                    }
                                } else {
                                    locks = new SVNLock[]{};
                                }
                                locks = locks == null ? new SVNLock[]{} : locks;
                                locksMap = new HashMap<String, SVNLock>();
                                i = 0;
                                ** while (i < locks.length)
                            }
lbl-1000:
                            // 1 sources

                            {
                                lock = locks[i];
                                locksMap.put(lock.getPath(), lock);
                                ++i;
                                continue;
                            }
lbl42:
                            // 1 sources

                            this.pushDirInfo(repository, SVNRevision.create(revNum), "", repository.getRepositoryRoot(true), repositoryUUID, url, locksMap, depth);
                            return (SvnInfo)((SvnGetInfo)this.getOperation()).first();
                        }
                        err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Server does not support retrieving information about the repository root");
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if ((urlKind = repository.checkPath("", revNum)) == SVNNodeKind.NONE) {
                        err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", new Object[]{url, new Long(revNum)});
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    parentRepository = this.getRepositoryAccess().createRepository(parentURL, null, false);
                    dirEntries = parentRepository.getDir("", revNum, (SVNProperties)null, 57, (Collection)null);
                    for (SVNDirEntry dirEntry : dirEntries) {
                        if (!baseName.equals(dirEntry.getName())) continue;
                        rootEntry = dirEntry;
                        break;
                    }
                    if (rootEntry == null) {
                        err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", new Object[]{url, new Long(revNum)});
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    break block25;
                }
                throw e;
            }
            if (rootEntry == null || rootEntry.getKind() == SVNNodeKind.NONE) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' non-existent in revision {1}", new Object[]{url, new Long(revNum)});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            lock = null;
            if (rootEntry.getKind() == SVNNodeKind.FILE) {
                try {
                    locations = this.getRepositoryAccess().getLocations(null, SvnTarget.fromURL(url), SVNRevision.create(revNum), SVNRevision.HEAD, SVNRevision.UNDEFINED);
                    if (locations == null || !locations.hasValue(SvnRepositoryAccess.LocationsInfo.startUrl)) break block29;
                    headURL = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
                    locations.release();
                    if (!headURL.equals(url)) break block29;
                    try {
                        lock = repository.getLock("");
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage() == null || e.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                            throw e;
                        }
                    }
                }
                catch (SVNException e) {
                    code = e.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block29;
                    throw e;
                }
            }
        }
        info = this.creatSvnInfoForEntry(repositoryRootUrl, repositoryUUID, rootEntry, url, revNum, lock);
        ((SvnGetInfo)this.getOperation()).receive(SvnTarget.fromURL(url), info);
        if (depth.compareTo(SVNDepth.EMPTY) > 0 && rootEntry.getKind() == SVNNodeKind.DIR) {
            locks = null;
            if (pegRevision == SVNRevision.HEAD) {
                try {
                    locks = repository.getLocks("");
                }
                catch (SVNException svne) {
                    code = svne.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.RA_NOT_IMPLEMENTED || code == SVNErrorCode.UNSUPPORTED_FEATURE) {
                        locks = new SVNLock[]{};
                    }
                    throw svne;
                }
            } else {
                locks = new SVNLock[]{};
            }
            locks = locks == null ? new SVNLock[]{} : locks;
            locksMap = new HashMap<String, SVNLock>();
            i = 0;
            while (i < locks.length) {
                lock = locks[i];
                locksMap.put(lock.getPath(), lock);
                ++i;
            }
            this.pushDirInfo(repository, SVNRevision.create(revNum), "", repository.getRepositoryRoot(true), repositoryUUID, url, locksMap, depth);
        }
        return (SvnInfo)((SvnGetInfo)this.getOperation()).first();
    }

    private void pushDirInfo(SVNRepository repos, SVNRevision rev, String dir, SVNURL root, String uuid, SVNURL url, Map<String, SVNLock> locks, SVNDepth depth) throws SVNException {
        Collection<SVNDirEntry> children = repos.getDir(dir, rev.getNumber(), null, 59, new ArrayList());
        for (SVNDirEntry child : children) {
            SVNURL childURL = url.appendPath(child.getName(), false);
            String path = SVNPathUtil.append(dir, child.getName());
            String fsPath = "/" + SVNPathUtil.getRelativePath(root.toDecodedString(), childURL.toDecodedString());
            SVNLock lock = locks.get(fsPath);
            if (depth.compareTo(SVNDepth.IMMEDIATES) >= 0 || depth == SVNDepth.FILES && child.getKind() == SVNNodeKind.FILE) {
                SvnInfo info = this.creatSvnInfoForEntry(root, uuid, child, childURL, rev.getNumber(), lock);
                ((SvnGetInfo)this.getOperation()).receive(SvnTarget.fromURL(childURL), info);
            }
            if (depth != SVNDepth.INFINITY || child.getKind() != SVNNodeKind.DIR) continue;
            this.pushDirInfo(repos, rev, path, root, uuid, childURL, locks, depth);
        }
    }

    private SvnInfo creatSvnInfoForEntry(SVNURL root, String uuid, SVNDirEntry entry, SVNURL entryURL, long revision, SVNLock lock) {
        SvnInfo info = new SvnInfo();
        info.setKind(entry.getKind());
        info.setLastChangedAuthor(entry.getAuthor());
        info.setLastChangedDate(SVNDate.fromDate(entry.getDate()));
        info.setLastChangedRevision(entry.getRevision());
        info.setLock(lock);
        info.setRepositoryRootURL(root);
        info.setRepositoryUuid(uuid);
        info.setSize(entry.getSize());
        info.setUrl(entryURL);
        info.setRevision(revision);
        return info;
    }
}

