/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.SVNCommitItem;

public class SVNCommitPacket {
    public static final SVNCommitPacket EMPTY = new SVNCommitPacket(null, new SVNCommitItem[0], null);
    private SVNCommitItem[] myCommitItems;
    private Map myLockTokens;
    private boolean[] myIsSkipped;
    private boolean myIsDisposed;

    public SVNCommitPacket(SVNWCAccess wcAccess, SVNCommitItem[] items, Map lockTokens) {
        this.myCommitItems = items;
        this.myLockTokens = lockTokens;
        this.myIsSkipped = new boolean[items == null ? 0 : items.length];
        this.myIsDisposed = false;
        if (wcAccess != null) {
            int i = 0;
            while (i < items.length) {
                if (items[i].getWCAccess() == null) {
                    items[i].setWCAccess(wcAccess);
                }
                ++i;
            }
        }
    }

    public SVNCommitItem[] getCommitItems() {
        return this.myCommitItems;
    }

    public void setCommitItemSkipped(SVNCommitItem item, boolean skipped) {
        int index = this.getItemIndex(item);
        if (index >= 0 && index < this.myIsSkipped.length) {
            this.myIsSkipped[index] = skipped;
        }
    }

    public boolean isCommitItemSkipped(SVNCommitItem item) {
        int index = this.getItemIndex(item);
        if (index >= 0 && index < this.myIsSkipped.length) {
            return this.myIsSkipped[index];
        }
        return true;
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void dispose() throws SVNException {
        try {
            int i = 0;
            while (i < this.myCommitItems.length) {
                if (this.myCommitItems[i] != null && this.myCommitItems[i].getWCAccess() != null) {
                    this.myCommitItems[i].getWCAccess().close();
                }
                ++i;
            }
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    private int getItemIndex(SVNCommitItem item) {
        int i = 0;
        while (this.myCommitItems != null && i < this.myCommitItems.length) {
            SVNCommitItem commitItem = this.myCommitItems[i];
            if (commitItem == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Map getLockTokens() {
        return this.myLockTokens;
    }

    public SVNCommitPacket removeSkippedItems() {
        if (this == EMPTY) {
            return EMPTY;
        }
        ArrayList items = new ArrayList();
        SVNHashMap lockTokens = this.getLockTokens() == null ? null : new SVNHashMap(this.getLockTokens());
        SVNCommitItem[] filteredItems = this.filterSkippedItemsAndLockTokens(items, lockTokens);
        return new SVNCommitPacket(null, filteredItems, lockTokens);
    }

    public String toString() {
        if (EMPTY == this) {
            return "[EMPTY]";
        }
        StringBuffer result = new StringBuffer();
        result.append("SVNCommitPacket: ");
        int i = 0;
        while (i < this.myCommitItems.length) {
            SVNCommitItem commitItem = this.myCommitItems[i];
            result.append("\n");
            if (commitItem.isAdded()) {
                result.append("A");
            } else if (commitItem.isDeleted()) {
                result.append("D");
            } else if (commitItem.isContentsModified()) {
                result.append("M");
            } else {
                result.append("_");
            }
            if (commitItem.isPropertiesModified()) {
                result.append("M");
            } else {
                result.append(" ");
            }
            result.append(" ");
            if (commitItem.getPath() != null) {
                result.append(commitItem.getPath());
                result.append(" ");
            }
            result.append(commitItem.getFile().getAbsolutePath());
            result.append("\n");
            result.append(commitItem.getRevision());
            result.append(" ");
            result.append(commitItem.getURL());
            if (commitItem.isCopied()) {
                result.append("\n");
                result.append("+");
                result.append(commitItem.getCopyFromURL());
            }
            if (commitItem.isLocked()) {
                result.append("\n");
                result.append("LOCKED");
            }
            ++i;
        }
        return result.toString();
    }

    protected SVNCommitItem[] filterSkippedItemsAndLockTokens(Collection items, Map lockTokens) {
        int i = 0;
        while (this.myCommitItems != null && i < this.myCommitItems.length) {
            SVNCommitItem commitItem = this.myCommitItems[i];
            if (!this.myIsSkipped[i]) {
                items.add(commitItem);
            } else if (lockTokens != null) {
                lockTokens.remove(commitItem.getURL().toString());
            }
            ++i;
        }
        return items.toArray(new SVNCommitItem[items.size()]);
    }
}

