/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnAnnotate;
import org.tmatesoft.svn.core.wc2.SvnList;
import org.tmatesoft.svn.core.wc2.SvnLog;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNLogClient
extends SVNBasicClient {
    private SVNDiffOptions diffOptions;

    public SVNLogClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNLogClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public SVNLogClient(SvnOperationFactory of) {
        super(of);
    }

    @Override
    protected void initDefaults() {
        this.setDiffOptions(null);
    }

    public void setDiffOptions(SVNDiffOptions diffOptions) {
        if (diffOptions == null) {
            diffOptions = new SVNDiffOptions();
        }
        this.diffOptions = diffOptions;
    }

    public SVNDiffOptions getDiffOptions() {
        return this.diffOptions;
    }

    public void doAnnotate(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, ISVNAnnotateHandler handler) throws SVNException {
        SvnAnnotate annotate = this.getOperationsFactory().createAnnotate();
        annotate.addTarget(SvnTarget.fromFile(path, pegRevision));
        annotate.setStartRevision(startRevision);
        annotate.setEndRevision(endRevision);
        annotate.setDiffOptions(this.getDiffOptions());
        annotate.setReceiver(SvnCodec.annotateReceiver(handler));
        annotate.run();
    }

    public void doAnnotate(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean ignoreMimeType, ISVNAnnotateHandler handler) throws SVNException {
        SvnAnnotate annotate = this.getOperationsFactory().createAnnotate();
        annotate.addTarget(SvnTarget.fromFile(path, pegRevision));
        annotate.setStartRevision(startRevision);
        annotate.setEndRevision(endRevision);
        annotate.setIgnoreMimeType(ignoreMimeType);
        annotate.setDiffOptions(this.getDiffOptions());
        annotate.setReceiver(SvnCodec.annotateReceiver(handler));
        annotate.run();
    }

    public void doAnnotate(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean ignoreMimeType, boolean includeMergedRevisions, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        SvnAnnotate annotate = this.getOperationsFactory().createAnnotate();
        annotate.addTarget(SvnTarget.fromFile(path, pegRevision));
        annotate.setStartRevision(startRevision);
        annotate.setEndRevision(endRevision);
        annotate.setIgnoreMimeType(ignoreMimeType);
        annotate.setUseMergeHistory(includeMergedRevisions);
        annotate.setInputEncoding(inputEncoding);
        annotate.setDiffOptions(this.getDiffOptions());
        annotate.setReceiver(SvnCodec.annotateReceiver(handler));
        annotate.run();
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, ISVNAnnotateHandler handler) throws SVNException {
        SvnAnnotate annotate = this.getOperationsFactory().createAnnotate();
        annotate.addTarget(SvnTarget.fromURL(url, pegRevision));
        annotate.setStartRevision(startRevision);
        annotate.setEndRevision(endRevision);
        annotate.setDiffOptions(this.getDiffOptions());
        annotate.setReceiver(SvnCodec.annotateReceiver(handler));
        annotate.run();
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        SvnAnnotate annotate = this.getOperationsFactory().createAnnotate();
        annotate.addTarget(SvnTarget.fromURL(url, pegRevision));
        annotate.setStartRevision(startRevision);
        annotate.setEndRevision(endRevision);
        annotate.setInputEncoding(inputEncoding);
        annotate.setDiffOptions(this.getDiffOptions());
        annotate.setReceiver(SvnCodec.annotateReceiver(handler));
        annotate.run();
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean ignoreMimeType, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        SvnAnnotate annotate = this.getOperationsFactory().createAnnotate();
        annotate.addTarget(SvnTarget.fromURL(url, pegRevision));
        annotate.setStartRevision(startRevision);
        annotate.setEndRevision(endRevision);
        annotate.setIgnoreMimeType(ignoreMimeType);
        annotate.setInputEncoding(inputEncoding);
        annotate.setDiffOptions(this.getDiffOptions());
        annotate.setReceiver(SvnCodec.annotateReceiver(handler));
        annotate.run();
    }

    public void doAnnotate(SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean ignoreMimeType, boolean includeMergedRevisions, ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        SvnAnnotate annotate = this.getOperationsFactory().createAnnotate();
        annotate.addTarget(SvnTarget.fromURL(url, pegRevision));
        annotate.setStartRevision(startRevision);
        annotate.setEndRevision(endRevision);
        annotate.setIgnoreMimeType(ignoreMimeType);
        annotate.setUseMergeHistory(includeMergedRevisions);
        annotate.setInputEncoding(inputEncoding);
        annotate.setDiffOptions(this.getDiffOptions());
        annotate.setReceiver(SvnCodec.annotateReceiver(handler));
        annotate.run();
    }

    public void doLog(File[] paths, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, long limit, ISVNLogEntryHandler handler) throws SVNException {
        ArrayList<SVNRevisionRange> revisionRanges = new ArrayList<SVNRevisionRange>(1);
        revisionRanges.add(new SVNRevisionRange(startRevision, endRevision));
        this.doLog(paths, revisionRanges, SVNRevision.WORKING, stopOnCopy, discoverChangedPaths, false, limit, null, handler);
    }

    public void doLog(File[] paths, SVNRevision startRevision, SVNRevision endRevision, SVNRevision pegRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        SvnLog log = this.getOperationsFactory().createLog();
        File[] fileArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            log.addTarget(SvnTarget.fromFile(file));
            ++n2;
        }
        log.addRange(SvnRevisionRange.create(startRevision, endRevision));
        log.setStopOnCopy(stopOnCopy);
        log.setDiscoverChangedPaths(discoverChangedPaths);
        log.setUseMergeHistory(includeMergedRevisions);
        log.setLimit(limit);
        log.setRevisionProperties(revisionProperties);
        log.setReceiver(SvnCodec.logReceiver(handler));
        log.run();
    }

    public void doLog(File[] paths, Collection<SVNRevisionRange> revisionRanges, SVNRevision pegRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        SvnLog log = this.getOperationsFactory().createLog();
        File[] fileArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            log.addTarget(SvnTarget.fromFile(file, pegRevision));
            ++n2;
        }
        log.setRevisionRanges(SvnCodec.revisionRanges(revisionRanges));
        log.setStopOnCopy(stopOnCopy);
        log.setDiscoverChangedPaths(discoverChangedPaths);
        log.setUseMergeHistory(includeMergedRevisions);
        log.setLimit(limit);
        log.setRevisionProperties(revisionProperties);
        log.setReceiver(SvnCodec.logReceiver(handler));
        log.run();
    }

    public void doLog(File[] paths, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, long limit, ISVNLogEntryHandler handler) throws SVNException {
        ArrayList<SVNRevisionRange> revisionRanges = new ArrayList<SVNRevisionRange>(1);
        revisionRanges.add(new SVNRevisionRange(startRevision, endRevision));
        this.doLog(paths, revisionRanges, pegRevision, stopOnCopy, discoverChangedPaths, false, limit, null, handler);
    }

    public void doLog(SVNURL url, String[] paths, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, long limit, ISVNLogEntryHandler handler) throws SVNException {
        this.doLog(url, paths, pegRevision, startRevision, endRevision, stopOnCopy, discoverChangedPaths, false, limit, null, handler);
    }

    public void doLog(SVNURL url, String[] paths, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        SvnLog log = this.getOperationsFactory().createLog();
        log.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        log.setTargetPaths(paths);
        log.addRange(SvnRevisionRange.create(startRevision, endRevision));
        log.setStopOnCopy(stopOnCopy);
        log.setDiscoverChangedPaths(discoverChangedPaths);
        log.setUseMergeHistory(includeMergedRevisions);
        log.setLimit(limit);
        log.setRevisionProperties(revisionProperties);
        log.setReceiver(SvnCodec.logReceiver(handler));
        log.run();
    }

    public void doLog(SVNURL url, String[] paths, SVNRevision pegRevision, Collection<SVNRevisionRange> revisionRanges, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, String[] revisionProperties, ISVNLogEntryHandler handler) throws SVNException {
        SvnLog log = this.getOperationsFactory().createLog();
        log.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        log.setTargetPaths(paths);
        log.setRevisionRanges(SvnCodec.revisionRanges(revisionRanges));
        log.setStopOnCopy(stopOnCopy);
        log.setDiscoverChangedPaths(discoverChangedPaths);
        log.setUseMergeHistory(includeMergedRevisions);
        log.setLimit(limit);
        log.setRevisionProperties(revisionProperties);
        log.setReceiver(SvnCodec.logReceiver(handler));
        log.run();
    }

    public void doList(File path, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(path, pegRevision, revision, fetchLocks, recursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, handler);
    }

    public void doList(File path, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, SVNDepth depth, int entryFields, final ISVNDirEntryHandler handler) throws SVNException {
        SvnList list = this.getOperationsFactory().createList();
        list.setDepth(depth);
        list.setRevision(revision);
        list.addTarget(SvnTarget.fromFile(path, pegRevision));
        list.setFetchLocks(fetchLocks);
        list.setEntryFields(entryFields);
        list.setReceiver(new ISvnObjectReceiver<SVNDirEntry>(){

            @Override
            public void receive(SvnTarget target, SVNDirEntry object) throws SVNException {
                handler.handleDirEntry(object);
            }
        });
        list.run();
    }

    public void doList(File path, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(path, pegRevision, revision, false, recursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, handler);
    }

    public void doList(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(url, pegRevision, revision, fetchLocks, recursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, handler);
    }

    public void doList(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean fetchLocks, SVNDepth depth, int entryFields, final ISVNDirEntryHandler handler) throws SVNException {
        SvnList list = this.getOperationsFactory().createList();
        list.setDepth(depth);
        list.setRevision(revision);
        list.addTarget(SvnTarget.fromURL(url, pegRevision));
        list.setFetchLocks(fetchLocks);
        list.setEntryFields(entryFields);
        list.setReceiver(new ISvnObjectReceiver<SVNDirEntry>(){

            @Override
            public void receive(SvnTarget target, SVNDirEntry object) throws SVNException {
                handler.handleDirEntry(object);
            }
        });
        list.run();
    }

    public void doList(SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive, ISVNDirEntryHandler handler) throws SVNException {
        this.doList(url, pegRevision, revision, false, recursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES, -1, handler);
    }
}

