/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

public class DiffOptions {
    private final int flags;

    public DiffOptions(Flag ... flagset) {
        int f = 0;
        Flag[] flagArray = flagset;
        int n = flagset.length;
        int n2 = 0;
        while (n2 < n) {
            Flag flag = flagArray[n2];
            f |= flag.value;
            ++n2;
        }
        this.flags = f;
    }

    public boolean getIgnoreWhitespace() {
        return (this.flags & Flag.IgnoreWhitespace.value) != 0;
    }

    public boolean getIgnoreSpaceChange() {
        return (this.flags & Flag.IgnoreSpaceChange.value) != 0;
    }

    public boolean getIgnoreEOLStyle() {
        return (this.flags & Flag.IgnoreEOLStyle.value) != 0;
    }

    public boolean getShowFunction() {
        return (this.flags & Flag.ShowFunction.value) != 0;
    }

    public boolean getGitFormat() {
        return (this.flags & Flag.GitFormat.value) != 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        IgnoreWhitespace(1),
        IgnoreSpaceChange(2),
        IgnoreEOLStyle(4),
        ShowFunction(8),
        GitFormat(16);

        final int value;

        private Flag(int value) {
            this.value = value;
        }
    }
}

