/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.tigris.subversion.javahl.BlameCallback;
import org.tigris.subversion.javahl.BlameCallback2;

public class BlameCallbackImpl
implements BlameCallback,
BlameCallback2 {
    private List<BlameLine> lines = new ArrayList<BlameLine>();

    public void singleLine(Date changed, long revision, String author, String line) {
        this.addBlameLine(new BlameLine(revision, author, changed, line));
    }

    public void singleLine(Date date, long revision, String author, Date merged_date, long merged_revision, String merged_author, String merged_path, String line) {
        this.addBlameLine(new BlameLine(this.getRevision(revision, merged_revision), this.getAuthor(author, merged_author), this.getDate(date, merged_date), line));
    }

    private Date getDate(Date date, Date merged_date) {
        return merged_date == null ? date : merged_date;
    }

    private String getAuthor(String author, String merged_author) {
        return merged_author == null ? author : merged_author;
    }

    private long getRevision(long revision, long merged_revision) {
        return merged_revision == -1L ? revision : merged_revision;
    }

    public int numberOfLines() {
        return this.lines.size();
    }

    public BlameLine getBlameLine(int i) {
        if (i >= this.lines.size()) {
            return null;
        }
        return this.lines.get(i);
    }

    protected void addBlameLine(BlameLine blameLine) {
        this.lines.add(blameLine);
    }

    public static class BlameLine {
        private long revision;
        private String author;
        private Date changed;
        private String line;

        public BlameLine(long revision, String author, Date changed, String line) {
            this.revision = revision;
            this.author = author;
            this.changed = changed;
            this.line = line;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getChanged() {
            return this.changed;
        }

        public String getLine() {
            return this.line;
        }

        public long getRevision() {
            return this.revision;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.revision > 0L) {
                this.pad(sb, Long.toString(this.revision), 6);
                sb.append(' ');
            } else {
                sb.append("     - ");
            }
            if (this.author != null) {
                this.pad(sb, this.author, 10);
                sb.append(" ");
            } else {
                sb.append("         - ");
            }
            sb.append(this.line);
            return sb.toString();
        }

        private void pad(StringBuffer sb, String val, int len) {
            int padding = len - val.length();
            int i = 0;
            while (i < padding) {
                sb.append(' ');
                ++i;
            }
            sb.append(val);
        }
    }
}

