/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.util.EventObject;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.NodeKind;
import org.tigris.subversion.javahl.RevisionRange;

public class NotifyInformation
extends EventObject {
    private static final long serialVersionUID = 1L;
    private int action;
    private int kind;
    private String mimeType;
    private Lock lock;
    private String errMsg;
    private int contentState;
    private int propState;
    private int lockState;
    private long revision;
    private String changelistName;
    private RevisionRange mergeRange;
    private String pathPrefix;

    NotifyInformation(String path, int action, int kind, String mimeType, Lock lock, String errMsg, int contentState, int propState, int lockState, long revision, String changelistName, RevisionRange mergeRange, String pathPrefix) {
        super(path == null ? "" : path);
        this.action = action;
        this.kind = kind;
        this.mimeType = mimeType;
        this.lock = lock;
        this.errMsg = errMsg;
        this.contentState = contentState;
        this.propState = propState;
        this.lockState = lockState;
        this.revision = revision;
        this.changelistName = changelistName;
        this.mergeRange = mergeRange;
        this.pathPrefix = pathPrefix;
    }

    public NotifyInformation(ClientNotifyInformation aInfo) {
        this(aInfo.getPath(), NotifyInformation.fromAAction(aInfo.getAction()), NodeKind.fromApache(aInfo.getKind()), aInfo.getMimeType(), aInfo.getLock() == null ? null : new Lock(aInfo.getLock()), aInfo.getErrMsg(), NotifyInformation.fromAStatus(aInfo.getContentState()), NotifyInformation.fromAStatus(aInfo.getPropState()), aInfo.getLockState().ordinal(), aInfo.getRevision(), aInfo.getChangelistName(), aInfo.getMergeRange() == null ? null : new RevisionRange(aInfo.getMergeRange()), aInfo.getPathPrefix());
    }

    public String getPath() {
        return (String)this.source;
    }

    public int getAction() {
        return this.action;
    }

    public int getKind() {
        return this.kind;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Lock getLock() {
        return this.lock;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public int getContentState() {
        return this.contentState;
    }

    public int getPropState() {
        return this.propState;
    }

    public int getLockState() {
        return this.lockState;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public RevisionRange getMergeRange() {
        return this.mergeRange;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    private static int fromAStatus(ClientNotifyInformation.Status aStatus) {
        switch (aStatus) {
            default: {
                return 0;
            }
            case unknown: {
                return 1;
            }
            case unchanged: {
                return 2;
            }
            case missing: {
                return 3;
            }
            case obstructed: {
                return 4;
            }
            case changed: {
                return 5;
            }
            case merged: {
                return 6;
            }
            case conflicted: 
        }
        return 7;
    }

    private static int fromAAction(ClientNotifyInformation.Action aAction) {
        if (aAction == null) {
            return -1;
        }
        int order = aAction.ordinal();
        if (order < 27) {
            return order;
        }
        return order - 1;
    }
}

