/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.ssh.files;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rse.internal.services.ssh.Activator;
import org.eclipse.rse.internal.services.ssh.ISshService;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.services.ssh.SshServiceResources;
import org.eclipse.rse.internal.services.ssh.files.SftpHostFile;
import org.eclipse.rse.internal.services.ssh.files.SshFileUtils;
import org.eclipse.rse.services.Mutex;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.SystemElementNotFoundException;
import org.eclipse.rse.services.clientserver.messages.SystemLockTimeoutException;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.services.clientserver.messages.SystemUnexpectedErrorException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;

public class SftpFileService
extends AbstractFileService
implements ISshService,
IFilePermissionsService {
    private SSHChannelPool sshChannelPool = new SSHChannelPool();
    private final ISshSessionProvider fSessionProvider;
    private ChannelSftp fChannelSftp;
    private String fUserHome;
    private Mutex fDirChannelMutex = new Mutex();
    private long fDirChannelTimeout = 5000L;
    private String fControlEncoding = null;
    private static String defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
    private String fJSchChannelEncoding = defaultEncoding;
    private long fLastConnectFailureTime = 0L;
    private static long CONNECT_RETRY_MILLIS = 10000L;
    private static Pattern quoteForJschPattern = Pattern.compile("[*?\\\\]");

    public SftpFileService(ISshSessionProvider sessionProvider) {
        this.fSessionProvider = sessionProvider;
    }

    public ISshSessionProvider getSessionProvider() {
        return this.fSessionProvider;
    }

    public void setControlEncoding(String encoding) throws SystemMessageException {
        try {
            this.fChannelSftp.setFilenameEncoding(encoding);
            this.fJSchChannelEncoding = encoding;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.fControlEncoding = encoding;
            this.fJSchChannelEncoding = defaultEncoding;
        }
        catch (SftpException sftpException) {
            try {
                this.fChannelSftp.setFilenameEncoding("UTF-8");
                this.fJSchChannelEncoding = "UTF-8";
            }
            catch (SftpException enest) {
                throw this.makeSystemMessageException((Exception)((Object)enest));
            }
        }
        this.fControlEncoding = encoding;
    }

    protected String recode(String s) throws SystemMessageException {
        if (this.fControlEncoding == null) {
            return s;
        }
        if (this.fControlEncoding.equals(this.fJSchChannelEncoding)) {
            return s;
        }
        try {
            byte[] bytes = s.getBytes(this.fControlEncoding);
            return new String(bytes, this.fJSchChannelEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw this.makeSystemMessageException(e);
        }
    }

    protected String recodeSafe(String s) throws SystemMessageException {
        try {
            String recoded = this.recode(s);
            byte[] bytes = recoded.getBytes(this.fJSchChannelEncoding);
            String decoded = this.decode(new String(bytes, this.fJSchChannelEncoding));
            if (!s.equals(decoded)) {
                int i = 0;
                int lmax = Math.min(s.length(), decoded.length());
                while (i < lmax && s.charAt(i) == decoded.charAt(i)) {
                    ++i;
                }
                char sbad = s.charAt(i);
                String msg = "Cannot express character '" + sbad + "'(0x" + Integer.toHexString(sbad) + ") with ";
                msg = this.fControlEncoding == null || this.fControlEncoding.equals(this.fJSchChannelEncoding) ? String.valueOf(msg) + "default encoding \"" + this.fJSchChannelEncoding + "\". " : String.valueOf(msg) + "encoding \"" + this.fControlEncoding + "\" over local default encoding \"" + this.fJSchChannelEncoding + "\". ";
                msg = String.valueOf(msg) + "Please specify a different encoding in host properties.";
                throw new UnsupportedEncodingException(msg);
            }
            return recoded;
        }
        catch (UnsupportedEncodingException e) {
            SystemMessage msg = new SystemMessage("RSE", "F", "9999", 'E', e.getMessage(), "");
            throw new SystemMessageException(msg);
        }
    }

    protected String recodeSafeForJsch(String s) throws SystemMessageException {
        String recoded = this.recodeSafe(s);
        return this.quoteForJsch(recoded);
    }

    protected String decode(String s) throws SystemMessageException {
        if (this.fControlEncoding == null) {
            return s;
        }
        if (this.fControlEncoding.equals(this.fJSchChannelEncoding)) {
            return s;
        }
        try {
            byte[] bytes = s.getBytes(this.fJSchChannelEncoding);
            return new String(bytes, this.fControlEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw this.makeSystemMessageException(e);
        }
    }

    protected String quoteForJsch(String s) {
        if (quoteForJschPattern.matcher(s).find()) {
            StringBuffer buf = new StringBuffer(s.length() + 8);
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == '?' || c == '*' || c == '\\') {
                    buf.append('\\');
                }
                buf.append(c);
                ++i;
            }
            s = buf.toString();
        }
        return s;
    }

    public String getName() {
        return SshServiceResources.SftpFileService_Name;
    }

    public String getDescription() {
        return SshServiceResources.SftpFileService_Description;
    }

    public void connect() throws SystemMessageException {
        if (this.fLastConnectFailureTime > 0L && System.currentTimeMillis() - this.fLastConnectFailureTime < CONNECT_RETRY_MILLIS) {
            throw new SystemOperationFailedException("org.eclipse.rse.services.ssh", SshServiceResources.SftpFileService_Error_no_sftp);
        }
        try {
            Activator.trace("SftpFileService.connecting...");
            Session session = this.fSessionProvider.getSession();
            Channel channel = session.openChannel("sftp");
            channel.connect();
            this.fChannelSftp = (ChannelSftp)channel;
            this.setControlEncoding(this.fSessionProvider.getControlEncoding());
            this.fUserHome = this.decode(this.fChannelSftp.pwd());
            Activator.trace("SftpFileService.connected");
        }
        catch (Exception e) {
            Activator.trace("SftpFileService.connecting failed: " + e.toString());
            this.fLastConnectFailureTime = System.currentTimeMillis();
            throw new SystemOperationFailedException("org.eclipse.rse.services.ssh", SshServiceResources.SftpFileService_Error_no_sftp, e);
        }
    }

    protected boolean checkSessionConnected() {
        Session session = this.fSessionProvider.getSession();
        if (session == null) {
            return false;
        }
        if (session.isConnected()) {
            return true;
        }
        this.fSessionProvider.handleSessionLost();
        return false;
    }

    protected ChannelSftp getChannel(String task) throws SystemMessageException {
        Activator.trace(task);
        if (this.fChannelSftp == null || !this.fChannelSftp.isConnected()) {
            Activator.trace(String.valueOf(task) + ": channel not connected: " + this.fChannelSftp);
            if (this.checkSessionConnected()) {
                this.connect();
            } else {
                throw this.makeSystemMessageException(new IOException(SshServiceResources.SftpFileService_Error_JschSessionLost));
            }
        }
        return this.fChannelSftp;
    }

    protected void progressTick(IProgressMonitor monitor, int ticks) throws SystemOperationCancelledException {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new SystemOperationCancelledException();
            }
            monitor.worked(ticks);
        }
    }

    public void disconnect() {
        Activator.trace("SftpFileService.disconnect");
        if (this.fChannelSftp != null && this.fChannelSftp.isConnected()) {
            this.fChannelSftp.disconnect();
        }
        this.sshChannelPool.release();
        this.fDirChannelMutex.interruptAll();
        this.fChannelSftp = null;
    }

    private SystemMessageException makeSystemMessageException(Exception e) {
        if (e instanceof SystemMessageException) {
            return (SystemMessageException)e;
        }
        if (e instanceof SftpException) {
            SftpException sftpe = (SftpException)((Object)e);
            Object messageException = sftpe.id == 3 ? new RemoteFileSecurityException(e) : (sftpe.id == 2 ? new SystemElementNotFoundException("", "") : new RemoteFileIOException(e));
            messageException.getSystemMessage().makeSubstitution((Object)("Sftp: " + sftpe.toString()));
            return messageException;
        }
        return new RemoteFileIOException(e);
    }

    protected String concat(String parentDir, String fileName) {
        return SshFileUtils.concat(parentDir, fileName);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHostFile getFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        SftpHostFile node = null;
        SftpATTRS attrs = null;
        String fullPath = this.concat(remoteParent, fileName);
        if (!this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) {
            throw new SystemLockTimeoutException("org.eclipse.rse.services.ssh");
        }
        try {
            try {
                attrs = this.getChannel("SftpFileService.getFile: " + fullPath).lstat(this.recodeSafeForJsch(fullPath));
                Activator.trace("SftpFileService.getFile <--");
                node = this.makeHostFile(remoteParent, fileName, attrs);
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.getFile failed: " + e.toString());
                if (!(e instanceof SftpException) || ((SftpException)((Object)e)).id != 2) {
                    throw this.makeSystemMessageException(e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.fDirChannelMutex.release();
            throw throwable;
        }
        {
            Object var8_11 = null;
            this.fDirChannelMutex.release();
        }
        if (node == null) {
            boolean isRoot = remoteParent == null || remoteParent.length() == 0;
            node = new SftpHostFile(isRoot ? null : remoteParent, fileName, false, isRoot, false, 0L, 0L);
            node.setExists(false);
        }
        return node;
    }

    public boolean isConnected() {
        try {
            return this.getChannel("SftpFileService.isConnected()").isConnected();
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        if (fileFilter == null) {
            fileFilter = "*";
        }
        NamePatternMatcher filematcher = null;
        if (fileFilter.endsWith(",")) {
            String[] types = fileFilter.split(",");
            filematcher = new FileTypeMatcher(types, true);
        } else {
            filematcher = new NamePatternMatcher(fileFilter, true, true);
        }
        ArrayList<SftpHostFile> results = new ArrayList<SftpHostFile>();
        if (!this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) throw new SystemLockTimeoutException("org.eclipse.rse.services.ssh");
        boolean haveSubMonitor = false;
        try {
            try {
                Vector vv = this.getChannel("SftpFileService.internalFetch: " + parentPath).ls(this.recodeSafeForJsch(parentPath));
                this.progressTick(monitor, 40);
                if (vv.size() > 1 && monitor != null) {
                    monitor = new SubProgressMonitor(monitor, 40);
                    monitor.beginTask(null, vv.size());
                }
                int ii = 0;
                while (true) {
                    ChannelSftp.LsEntry lsEntry;
                    String fileName;
                    block22: {
                        if (ii < vv.size()) break block22;
                        Activator.trace("SftpFileService.internalFetch <--");
                        break;
                    }
                    Object obj = vv.elementAt(ii);
                    if (obj instanceof ChannelSftp.LsEntry && !".".equals(fileName = this.decode((lsEntry = (ChannelSftp.LsEntry)obj).getFilename())) && !"..".equals(fileName)) {
                        SftpATTRS attrs;
                        if (vv.size() == 1 && fileName.equals(parentPath.substring(parentPath.lastIndexOf(47) + 1)) && !(attrs = this.getChannel("SftpFileService.internalFetch: " + parentPath).stat(parentPath)).isDir()) {
                            throw new RemoteFileIOException((Exception)new IOException("Not a folder: " + parentPath));
                        }
                        if (filematcher.matches(fileName) || lsEntry.getAttrs().isDir() && fileType != 2) {
                            SftpHostFile node = this.makeHostFile(parentPath, fileName, lsEntry.getAttrs());
                            this.progressTick(monitor, 1);
                            if (this.isRightType(fileType, node)) {
                                results.add(node);
                            }
                        }
                    }
                    ++ii;
                }
            }
            catch (Exception e) {
                block21: {
                    if (e instanceof SftpException && ((SftpException)((Object)e)).id == 2) {
                        IHostFile[] iHostFileArray;
                        try {
                            SftpATTRS attrs = this.getChannel("SftpFileService.internalFetch: " + parentPath).stat(parentPath);
                            if (!attrs.isDir()) break block21;
                            iHostFileArray = new IHostFile[]{};
                        }
                        catch (Exception exception) {}
                        Object var14_17 = null;
                        this.fDirChannelMutex.release();
                        if (haveSubMonitor) {
                            monitor.done();
                            return iHostFileArray;
                        }
                        this.progressTick(monitor, 40);
                        return iHostFileArray;
                    }
                }
                if (this.checkSessionConnected()) {
                    Activator.trace("SftpFileService.internalFetch failed: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            this.fDirChannelMutex.release();
            if (haveSubMonitor) {
                monitor.done();
                throw throwable;
            }
            this.progressTick(monitor, 40);
            throw throwable;
        }
        {
            Object var14_19 = null;
            this.fDirChannelMutex.release();
            if (haveSubMonitor) {
                monitor.done();
                return results.toArray(new IHostFile[results.size()]);
            }
            this.progressTick(monitor, 40);
            return results.toArray(new IHostFile[results.size()]);
        }
    }

    private SftpHostFile makeHostFile(String parentPath, String fileName, SftpATTRS attrs) {
        boolean isRoot;
        String canonicalPath;
        String linkTarget;
        SftpATTRS attrsTarget;
        block20: {
            attrsTarget = attrs;
            linkTarget = null;
            canonicalPath = null;
            boolean bl = isRoot = parentPath == null || parentPath.length() == 0;
            if (attrs.isLink() && !isRoot) {
                try {
                    String fullPath = this.concat(parentPath, fileName);
                    boolean readlinkDone = false;
                    try {
                        linkTarget = this.decode(this.getChannel("makeHostFile.readlink").readlink(this.recode(fullPath)));
                        readlinkDone = true;
                    }
                    catch (Throwable throwable) {
                        this.getChannel("makeHostFile.chdir").cd(this.recode(fullPath));
                        canonicalPath = linkTarget = this.decode(this.getChannel("makeHostFile.pwd").pwd());
                    }
                    if (linkTarget != null && !linkTarget.equals(fullPath)) {
                        String curdir;
                        if (readlinkDone && !parentPath.equals(curdir = this.decode(this.getChannel("makeHostFile.pwd").pwd()))) {
                            this.getChannel("makeHostFile.chdir").cd(this.recode(parentPath));
                        }
                        attrsTarget = this.getChannel("SftpFileService.getFile").stat(this.recode(linkTarget));
                        if (readlinkDone && attrsTarget.isDir()) {
                            this.getChannel("makeHostFile.chdir").cd(this.recode(fullPath));
                            canonicalPath = this.decode(this.getChannel("makeHostFile.pwd").pwd());
                        }
                    } else {
                        linkTarget = null;
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof SftpException) || ((SftpException)((Object)e)).id != 2) break block20;
                    linkTarget = linkTarget == null ? ":dangling link" : ":dangling link:" + linkTarget;
                }
            }
        }
        SftpHostFile node = new SftpHostFile(isRoot ? null : parentPath, fileName, attrsTarget.isDir(), isRoot, attrs.isLink(), 1000L * (long)attrs.getMTime(), attrs.getSize());
        if (linkTarget != null) {
            node.setLinkTarget(linkTarget);
        }
        if (canonicalPath != null) {
            node.setCanonicalPath(canonicalPath);
        }
        String perms = attrsTarget.getPermissionsString();
        if (parentPath != null && parentPath.equals("/cygdrive")) {
            node.setReadable(true);
        } else if (perms.indexOf(114, 1) <= 0) {
            node.setReadable(false);
        }
        if (perms.indexOf(119, 1) <= 0) {
            node.setWritable(false);
        }
        if (node.isDirectory()) {
            if (perms.indexOf(120, 1) <= 0) {
                node.setWritable(false);
            }
        } else if (perms.indexOf(120, 1) > 0) {
            node.setExecutable(true);
        }
        if (attrs.getExtended() != null) {
            node.setExtendedData(attrs.getExtended());
        }
        HostFilePermissions permissions = new HostFilePermissions(perms, "" + attrs.getUId(), "" + attrs.getGId());
        node.setPermissions((IHostFilePermissions)permissions);
        return node;
    }

    public String getSeparator() {
        return "/";
    }

    /*
     * Exception decompiling
     */
    public void upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 259->263)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void upload(InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(stream);
            File tempFile = File.createTempFile("sftp", "temp");
            FileOutputStream os = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[1024];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
            }
            bos.close();
            this.upload(tempFile, remoteParent, remoteFile, isBinary, "", hostEncoding, monitor);
        }
        catch (Exception e) {
            throw this.makeSystemMessageException(e);
        }
    }

    /*
     * Exception decompiling
     */
    public void download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 279->283)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IHostFile getUserHome() {
        if (this.fUserHome != null) {
            int lastSlash = this.fUserHome.lastIndexOf(47);
            String name = this.fUserHome.substring(lastSlash + 1);
            String parent = lastSlash > 0 ? this.fUserHome.substring(0, lastSlash) : (lastSlash == 0 ? "/" : "");
            try {
                return this.getFile(parent, name, null);
            }
            catch (SystemMessageException systemMessageException) {
                return new SftpHostFile(null, this.fUserHome, true, true, false, 0L, 0L);
            }
        }
        return null;
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        IHostFile root = null;
        try {
            root = this.getFile(null, "/", monitor);
        }
        catch (SystemMessageException systemMessageException) {}
        if (root == null) {
            root = new SftpHostFile(null, "/", true, true, false, 0L, 0L);
        }
        return new IHostFile[]{root};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        SftpHostFile result = null;
        String fullPath = this.concat(remoteParent, fileName);
        if (!this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) throw new SystemLockTimeoutException("org.eclipse.rse.services.ssh");
        try {
            try {
                String fullPathRecoded = this.recodeSafeForJsch(this.concat(remoteParent, fileName));
                OutputStream os = this.getChannel("SftpFileService.createFile").put(fullPathRecoded);
                os.close();
                SftpATTRS attrs = this.getChannel("SftpFileService.createFile.stat").lstat(fullPathRecoded);
                result = this.makeHostFile(remoteParent, fileName, attrs);
                Activator.trace("SftpFileService.createFile ok");
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.createFile " + fullPath + " failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.fDirChannelMutex.release();
            throw throwable;
        }
        {
            Object var9_12 = null;
            this.fDirChannelMutex.release();
            return result;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        SftpHostFile result = null;
        String fullPath = this.concat(remoteParent, folderName);
        if (!this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) throw new SystemLockTimeoutException("org.eclipse.rse.services.ssh");
        try {
            try {
                String fullPathRecoded = this.recodeSafe(fullPath);
                this.getChannel("SftpFileService.createFolder").mkdir(fullPathRecoded);
                SftpATTRS attrs = this.getChannel("SftpFileService.createFolder.stat").lstat(this.quoteForJsch(fullPathRecoded));
                result = this.makeHostFile(remoteParent, folderName, attrs);
                Activator.trace("SftpFileService.createFolder ok");
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.createFolder " + fullPath + " failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.fDirChannelMutex.release();
            throw throwable;
        }
        {
            Object var8_11 = null;
            this.fDirChannelMutex.release();
            return result;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        fullPath = this.concat(remoteParent, fileName);
        Activator.trace("SftpFileService.delete.waitForLock");
        if (this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout) == false) throw new SystemLockTimeoutException("org.eclipse.rse.services.ssh");
        try {
            try {
                fullPathRecoded = this.recodeSafeForJsch(fullPath);
                attrs = null;
                try {
                    attrs = this.getChannel("SftpFileService.delete").lstat(fullPathRecoded);
                }
                catch (SftpException e) {
                    if (e.id != 2) throw e;
                    try {
                        this.getChannel("SftpFileService.delete.rm").rm(fullPathRecoded);
                    }
                    catch (Exception v0) {
                        throw new SystemElementNotFoundException("org.eclipse.rse.services.ssh", fullPath, "delete");
                    }
                }
                if (attrs == null) {
                    throw new SystemElementNotFoundException(fullPath, "delete");
                }
                if (attrs.isDir()) {
                    try {
                        this.getChannel("SftpFileService.delete.rmdir").rmdir(fullPathRecoded);
                    }
                    catch (SftpException e) {
                        if (e.id != 4) throw e;
                        fullPathQuoted = PathUtility.enQuoteUnix((String)fullPathRecoded);
                        rv = this.runCommand("rm -rf " + fullPathQuoted, monitor);
                        if (rv == 0) ** GOTO lbl31
                        throw new SystemUnexpectedErrorException("org.eclipse.rse.services.ssh");
                    }
                } else {
                    this.getChannel("SftpFileService.delete.rm").rm(fullPathRecoded);
                }
lbl31:
                // 3 sources

                Activator.trace("SftpFileService.delete ok");
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.delete " + fullPath + " failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        catch (Throwable var11_12) {
            var10_13 = null;
            this.fDirChannelMutex.release();
            throw var11_12;
        }
        {
            var10_14 = null;
            this.fDirChannelMutex.release();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        String fullPathOld = this.concat(remoteParent, oldName);
        String fullPathNew = this.concat(remoteParent, newName);
        if (!this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) throw new SystemLockTimeoutException("org.eclipse.rse.services.ssh");
        try {
            try {
                this.getChannel("SftpFileService.rename").rename(this.recode(fullPathOld), this.recodeSafeForJsch(fullPathNew));
                Activator.trace("SftpFileService.rename ok");
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.rename " + fullPathOld + " -> " + fullPathNew + " failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.fDirChannelMutex.release();
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.fDirChannelMutex.release();
            return;
        }
    }

    public void rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) throws SystemMessageException {
        this.rename(remoteParent, oldName, newName, monitor);
    }

    private boolean progressWorked(IProgressMonitor monitor, int work) {
        boolean cancelRequested = false;
        if (monitor != null) {
            monitor.worked(work);
            cancelRequested = monitor.isCanceled();
        }
        return cancelRequested;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int runCommand(String command, IProgressMonitor monitor) throws SystemMessageException {
        Channel channel;
        int result;
        block17: {
            Activator.trace("SftpFileService.runCommand " + command);
            result = -1;
            if (monitor != null) {
                monitor.beginTask(command, 20);
            }
            channel = null;
            try {
                try {
                    channel = this.fSessionProvider.getSession().openChannel("exec");
                    try {
                        ((ChannelExec)channel).setCommand(command.getBytes(this.fJSchChannelEncoding));
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        byte[] bytesDesired = command.getBytes(this.fJSchChannelEncoding);
                        String stringToSend = new String(bytesDesired);
                        byte[] bytesSent = stringToSend.getBytes();
                        if (!bytesDesired.equals(bytesSent)) {
                            throw new UnsupportedEncodingException("Cannot encode for JSch as \"" + this.fJSchChannelEncoding + "\": " + command);
                        }
                        ((ChannelExec)channel).setCommand(new String(bytesDesired));
                    }
                    channel.setInputStream(null);
                    ByteArrayOutputStream err = new ByteArrayOutputStream();
                    ((ChannelExec)channel).setErrStream((OutputStream)err);
                    InputStream in = channel.getInputStream();
                    channel.connect();
                    byte[] tmp = new byte[1024];
                    while (!channel.isClosed() && !this.progressWorked(monitor, 1)) {
                        int i;
                        while (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {}
                    }
                    result = channel.getExitStatus();
                    if (result != 0) {
                        String errorMsg = err.toString();
                        Activator.trace("SftpFileService.runCommand ok, error: " + result + ", " + errorMsg);
                        if (errorMsg.length() > 0) {
                            throw this.makeSystemMessageException(new IOException(errorMsg));
                        }
                    } else {
                        Activator.trace("SftpFileService.runCommand ok, result: " + result);
                    }
                }
                catch (Exception e) {
                    Activator.trace(command);
                    Activator.trace("SftpFileService.runCommand failed: " + e.toString());
                    throw this.makeSystemMessageException(e);
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (monitor != null) {
                    monitor.done();
                }
                if (channel == null) throw throwable;
                channel.disconnect();
                throw throwable;
            }
            {
                Object var9_13 = null;
                if (monitor == null) break block17;
            }
            monitor.done();
        }
        if (channel == null) return result;
        channel.disconnect();
        return result;
    }

    public void move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        Activator.trace("SftpFileService.move " + srcName);
        String fullPathOld = PathUtility.enQuoteUnix((String)this.recode(this.concat(srcParent, srcName)));
        String fullPathNew = PathUtility.enQuoteUnix((String)this.recodeSafe(this.concat(tgtParent, tgtName)));
        int rv = this.runCommand("mv " + fullPathOld + ' ' + fullPathNew, monitor);
        if (rv != 0) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services.ssh");
        }
    }

    public void copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        Activator.trace("SftpFileService.copy " + srcName);
        String fullPathOld = PathUtility.enQuoteUnix((String)this.recode(this.concat(srcParent, srcName)));
        String fullPathNew = PathUtility.enQuoteUnix((String)this.recodeSafe(this.concat(tgtParent, tgtName)));
        int rv = this.runCommand("cp -Rp " + fullPathOld + ' ' + fullPathNew, monitor);
        if (rv != 0) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services.ssh");
        }
    }

    public void copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        Activator.trace("SftpFileService.copyBatch " + srcNames);
        int i = 0;
        while (i < srcParents.length) {
            this.copy(srcParents[i], srcNames[i], tgtParent, srcNames[i], monitor);
            ++i;
        }
    }

    public void initService(IProgressMonitor monitor) throws SystemMessageException {
        Activator.trace("SftpFileService.initService");
        super.initService(monitor);
        this.connect();
    }

    public void uninitService(IProgressMonitor monitor) {
        Activator.trace("SftpFileService.uninitService");
        this.disconnect();
        super.uninitService(monitor);
    }

    public boolean isCaseSensitive() {
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        String path = this.concat(parent, name);
        if (!this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) throw new SystemLockTimeoutException("org.eclipse.rse.services.ssh");
        try {
            try {
                this.getChannel("SftpFileService.setLastModified").setMtime(this.recode(path), (int)(timestamp / 1000L));
                Activator.trace("SftpFileService.setLastModified ok");
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.setLastModified " + path + " failed: " + e.toString());
                throw this.makeSystemMessageException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.fDirChannelMutex.release();
            throw throwable;
        }
        {
            Object var8_9 = null;
            this.fDirChannelMutex.release();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        String path = this.concat(parent, name);
        if (!this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) throw new SystemLockTimeoutException("org.eclipse.rse.services.ssh");
        try {
            try {
                int permOld;
                SftpATTRS attr = this.getChannel("SftpFileService.setReadOnly").stat(this.recode(path));
                int permNew = permOld = attr.getPermissions();
                permNew = readOnly ? (permNew &= 0xFFFFFF6D) : (permNew |= 0x80);
                if (permNew != permOld) {
                    this.getChannel("SftpFileService.setReadOnly").chmod(permNew, this.recode(path));
                    Activator.trace("SftpFileService.setReadOnly ok");
                } else {
                    Activator.trace("SftpFileService.setReadOnly nothing-to-do");
                }
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.setReadOnly " + path + " failed: " + e.toString());
                if (!(e instanceof SftpException)) throw this.makeSystemMessageException(e);
                if (((SftpException)((Object)e)).id != 2) throw this.makeSystemMessageException(e);
                throw new SystemElementNotFoundException("org.eclipse.rse.services.ssh", path, "setReadOnly");
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.fDirChannelMutex.release();
            throw throwable;
        }
        {
            Object var9_12 = null;
            this.fDirChannelMutex.release();
            return;
        }
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        SftpBufferedInputStream stream = null;
        String remotePath = this.concat(remoteParent, remoteFile);
        try {
            String remotePathRecoded = this.recode(remotePath);
            this.getChannel("SftpFileService.getInputStream " + remoteFile);
            SSHChannel channel = this.sshChannelPool.requestChannel(1);
            stream = new SftpBufferedInputStream(channel.getChannel().get(remotePathRecoded), channel);
            Activator.trace("SftpFileService.getInputStream " + remoteFile + " ok");
        }
        catch (Exception e) {
            Activator.trace("SftpFileService.getInputStream " + remotePath + " failed: " + e.toString());
            throw this.makeSystemMessageException(e);
        }
        return stream;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        int options = isBinary ? 0 : 2;
        return this.getOutputStream(remoteParent, remoteFile, options, monitor);
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, int options, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SftpBufferedOutputStream stream = null;
        String dst = remoteParent;
        if (remoteFile != null) {
            dst = this.concat(remoteParent, remoteFile);
        }
        try {
            int mode = (options & 1) == 0 ? 0 : 2;
            this.getChannel("SftpFileService.getOutputStream " + remoteFile);
            SSHChannel channel = this.sshChannelPool.requestChannel(1);
            stream = new SftpBufferedOutputStream(channel.getChannel().put(this.recodeSafeForJsch(dst), mode), channel);
            Activator.trace("SftpFileService.getOutputStream " + remoteFile + " ok");
        }
        catch (Exception e) {
            Activator.trace("SftpFileService.getOutputStream " + dst + " failed: " + e.toString());
            throw this.makeSystemMessageException(e);
        }
        if (monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        return stream;
    }

    public IHostFilePermissions getFilePermissions(IHostFile file, IProgressMonitor monitor) throws SystemMessageException {
        if (file instanceof IHostFilePermissionsContainer) {
            return ((IHostFilePermissionsContainer)file).getPermissions();
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFilePermissions(IHostFile file, IHostFilePermissions permissions, IProgressMonitor monitor) throws SystemMessageException {
        String path = file.getAbsolutePath();
        if (!this.fDirChannelMutex.waitForLock(monitor, this.fDirChannelTimeout)) throw new SystemLockTimeoutException("org.eclipse.rse.services.ssh");
        try {
            try {
                this.getChannel("SftpFileService.setFilePermissions").chmod(permissions.getPermissionBits(), this.recode(path));
                Activator.trace("SftpFileService.setFilePermissions ok");
            }
            catch (Exception e) {
                Activator.trace("SftpFileService.setFilePermissions " + path + " failed: " + e.toString());
                if (!(e instanceof SftpException)) throw this.makeSystemMessageException(e);
                if (((SftpException)((Object)e)).id != 2) throw this.makeSystemMessageException(e);
                throw new SystemElementNotFoundException("org.eclipse.rse.services.ssh", path, "setFilePermissions");
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fDirChannelMutex.release();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fDirChannelMutex.release();
            return;
        }
    }

    public int getCapabilities(IHostFile file) {
        return 39;
    }

    public static class MyProgressMonitor
    implements SftpProgressMonitor {
        private IProgressMonitor fMonitor;
        private double fWorkPercentFactor;
        private Long fMaxWorkKB;
        private long fWorkToDate;

        public MyProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            this.fWorkPercentFactor = 1.0 / (double)max;
            this.fMaxWorkKB = new Long(max / 1024L);
            this.fWorkToDate = 0L;
            String desc = srcFile = new Path(src).lastSegment();
            if (Activator.isTracingOn()) {
                Activator.trace("Sftp-monitor: " + max + ", " + desc);
            }
            this.fMonitor.beginTask(desc, (int)max);
        }

        public boolean count(long count) {
            this.fWorkToDate += count;
            Long workToDateKB = new Long(this.fWorkToDate / 1024L);
            Double workPercent = new Double(this.fWorkPercentFactor * (double)this.fWorkToDate);
            String subDesc = MessageFormat.format(SshServiceResources.SftpFileService_Msg_Progress, workToDateKB, this.fMaxWorkKB, workPercent);
            if (Activator.isTracingOn()) {
                System.out.print('#');
            }
            this.fMonitor.subTask(subDesc);
            this.fMonitor.worked((int)count);
            return !this.fMonitor.isCanceled();
        }

        public void end() {
            if (Activator.isTracingOn()) {
                System.out.println();
                System.out.println("Sftp-monitor <--");
                System.out.flush();
            }
            this.fMonitor.done();
        }
    }

    private class SSHChannel {
        public static final int TYPE_SFTP = 1;
        private boolean available = true;
        protected boolean connected = false;
        private boolean pooledChannel = false;
        int type;
        ChannelSftp channel = null;

        public SSHChannel(int type, boolean pooledChannel) {
            this.pooledChannel = pooledChannel;
            this.type = type;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public boolean isAvailable() {
            return this.available;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void request() {
            this.available = false;
        }

        public void release() {
            if (this.pooledChannel) {
                this.available = true;
            } else {
                this.disconnect();
            }
        }

        public void connect() throws JSchException {
            if (!this.connected) {
                this.channel = this.type == 1 ? (ChannelSftp)SftpFileService.this.fSessionProvider.getSession().openChannel("sftp") : (ChannelSftp)SftpFileService.this.fSessionProvider.getSession().openChannel("exec");
                this.channel.connect();
                this.connected = true;
            }
        }

        public void disconnect() {
            this.channel.disconnect();
            this.available = true;
            this.connected = false;
        }

        public ChannelSftp getChannel() {
            return this.channel;
        }
    }

    private class SSHChannelPool {
        private Vector pool = new Vector();

        private SSHChannelPool() {
            int i = 0;
            while (i < 10) {
                SSHChannel sshChannel = new SSHChannel(1, true);
                this.pool.add(sshChannel);
                ++i;
            }
        }

        public SSHChannel requestChannel(int type) throws JSchException {
            SSHChannel sshChannel;
            Iterator iterator = this.pool.iterator();
            while (iterator.hasNext()) {
                sshChannel = (SSHChannel)iterator.next();
                if (!sshChannel.isAvailable() || sshChannel.getType() != type) continue;
                if (!sshChannel.isConnected()) {
                    sshChannel.connect();
                }
                sshChannel.request();
                return sshChannel;
            }
            iterator = this.pool.iterator();
            while (iterator.hasNext()) {
                sshChannel = (SSHChannel)iterator.next();
                if (!sshChannel.isAvailable()) continue;
                if (sshChannel.isConnected()) {
                    sshChannel.disconnect();
                }
                sshChannel.setType(type);
                sshChannel.connect();
                sshChannel.request();
                return sshChannel;
            }
            sshChannel = new SSHChannel(type, false);
            sshChannel.connect();
            return sshChannel;
        }

        public void release() {
            Iterator iterator = this.pool.iterator();
            while (iterator.hasNext()) {
                SSHChannel sshChannel = (SSHChannel)iterator.next();
                if (!sshChannel.isConnected()) continue;
                sshChannel.disconnect();
            }
        }
    }

    private static class SftpBufferedInputStream
    extends BufferedInputStream {
        private SSHChannel channel;

        public SftpBufferedInputStream(InputStream in, SSHChannel channel) {
            super(in);
            this.channel = channel;
        }

        public SftpBufferedInputStream(InputStream in, int size, SSHChannel channel) {
            super(in, size);
            this.channel = channel;
        }

        public void close() throws IOException {
            super.close();
            this.channel.release();
        }
    }

    private static class SftpBufferedOutputStream
    extends BufferedOutputStream {
        private SSHChannel channel;

        public SftpBufferedOutputStream(OutputStream out, SSHChannel channel) {
            super(out);
            this.channel = channel;
        }

        public SftpBufferedOutputStream(OutputStream out, int size, SSHChannel channel) {
            super(out, size);
            this.channel = channel;
        }

        public void close() throws IOException {
            super.close();
            this.channel.release();
        }
    }
}

