/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.module;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelThreadInformationProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.module.Messages;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.module.VirtualMachineStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.interval.TmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperimentUtils;

public class VirtualMachineCpuAnalysis
extends TmfStateSystemAnalysisModule {
    static final Set<String> REQUIRED_EVENTS = (Set)NonNullUtils.checkNotNull((Object)ImmutableSet.of());
    private static final ITmfStateValue VCPU_PREEMPT_VALUE = TmfStateValue.newValueInt((int)256);

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = this.getTrace();
        if (!(trace instanceof TmfExperiment)) {
            throw new IllegalStateException();
        }
        return new VirtualMachineStateProvider((TmfExperiment)trace);
    }

    @NonNull
    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    public String getHelpText() {
        return Messages.getMessage(Messages.VirtualMachineCPUAnalysis_Help);
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        HashSet<IAnalysisModule> modules = new HashSet<IAnalysisModule>();
        for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace())) {
            trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)trace);
            for (KernelAnalysisModule module : TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, KernelAnalysisModule.class)) {
                modules.add((IAnalysisModule)module);
            }
        }
        return modules;
    }

    private static Multimap<Integer, ITmfStateInterval> createThreadMultimap() {
        Multimap map = (Multimap)NonNullUtils.checkNotNull((Object)TreeMultimap.create((Comparator)new Comparator<Integer>(){

            @Override
            public int compare(@Nullable Integer arg0, @Nullable Integer arg1) {
                if (arg0 == null || arg1 == null) {
                    return -1;
                }
                return arg0.compareTo(arg1);
            }
        }, (Comparator)new Comparator<ITmfStateInterval>(){

            @Override
            public int compare(@Nullable ITmfStateInterval arg0, @Nullable ITmfStateInterval arg1) {
                if (arg0 == null || arg1 == null) {
                    return 0;
                }
                if (arg1.getStateValue() == VCPU_PREEMPT_VALUE && arg0.getStateValue() != VCPU_PREEMPT_VALUE) {
                    if (Long.valueOf(arg0.getEndTime()).compareTo(arg1.getStartTime()) < 0) {
                        return -1;
                    }
                    return Long.valueOf(arg0.getStartTime()).compareTo(arg1.getEndTime());
                }
                return Long.valueOf(arg0.getStartTime()).compareTo(arg1.getStartTime());
            }
        }));
        return map;
    }

    public Multimap<Integer, ITmfStateInterval> getUpdatedThreadIntervals(int vmQuark, long start, long end, long resolution, IProgressMonitor monitor) {
        Multimap<Integer, ITmfStateInterval> map = VirtualMachineCpuAnalysis.createThreadMultimap();
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            return map;
        }
        ITmfTrace trace = this.getTrace();
        if (!(trace instanceof TmfExperiment)) {
            return map;
        }
        String vmHostId = (String)NonNullUtils.checkNotNull((Object)ss.getAttributeName(vmQuark));
        KernelAnalysisModule kernelModule = (KernelAnalysisModule)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)((TmfExperiment)trace), (String)vmHostId, KernelAnalysisModule.class);
        if (kernelModule == null) {
            return map;
        }
        for (Integer tid : KernelThreadInformationProvider.getThreadIds((KernelAnalysisModule)kernelModule)) {
            if (tid == null) {
                throw new IllegalStateException();
            }
            map.putAll((Object)tid, (Iterable)KernelThreadInformationProvider.getStatusIntervalsForThread((KernelAnalysisModule)kernelModule, (Integer)tid, (long)start, (long)end, (long)resolution, (IProgressMonitor)monitor));
            if (!monitor.isCanceled()) continue;
            return map;
        }
        try {
            for (Integer vcpuQuark : ss.getSubAttributes(vmQuark, false)) {
                Long virtualCPU = Long.parseLong(ss.getAttributeName(vcpuQuark.intValue()));
                Integer statusQuark = ss.getQuarkRelative(vcpuQuark.intValue(), new String[]{"Status"});
                block7: for (ITmfStateInterval cpuInterval : StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)statusQuark, (long)start, (long)(end - 1L), (long)resolution, (IProgressMonitor)monitor)) {
                    ITmfStateValue stateValue = cpuInterval.getStateValue();
                    switch (stateValue.getType()) {
                        case INTEGER: {
                            Integer threadOnCpu;
                            int value = stateValue.unboxInt();
                            if ((value & 0x180) == 0 || (threadOnCpu = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)kernelModule, (long)virtualCPU, (long)cpuInterval.getStartTime())) == null) continue block7;
                            map.put((Object)threadOnCpu, (Object)new TmfStateInterval(cpuInterval.getStartTime(), cpuInterval.getEndTime(), threadOnCpu.intValue(), VCPU_PREEMPT_VALUE));
                            break;
                        }
                    }
                }
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            // empty catch block
        }
        return (Multimap)NonNullUtils.checkNotNull(map);
    }
}

