/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBCDIDebugger;
import org.eclipse.cdt.debug.mi.core.IGDBServerMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.IMIConstants;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.MITargetSelect;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBServerCDIDebugger
extends GDBCDIDebugger {
    @Override
    public Session createLaunchSession(ILaunchConfiguration config, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        Session session = null;
        boolean failed = false;
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            String miVersion = this.getMIVersion(config);
            File cwd = GDBServerCDIDebugger.getProjectPath(config).toFile();
            String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
            if (config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_REMOTE_TCP, false)) {
                String remote = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_HOST, "invalid");
                remote = String.valueOf(remote) + ":";
                remote = String.valueOf(remote) + config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_PORT, "invalid");
                String[] args = new String[]{"remote", remote};
                session = MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getPath().toFile(), 0, args, cwd, gdbinit, monitor);
            } else {
                MIPlugin plugin = MIPlugin.getDefault();
                Preferences prefs = plugin.getPluginPreferences();
                int launchTimeout = prefs.getInt(IMIConstants.PREF_REQUEST_LAUNCH_TIMEOUT);
                String remote = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV, "invalid");
                String remoteBaud = config.getAttribute(IGDBServerMILaunchConfigurationConstants.ATTR_DEV_SPEED, "invalid");
                session = MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getPath().toFile(), -1, null, cwd, gdbinit, monitor);
                ICDITarget[] targets = session.getTargets();
                int i = 0;
                while (i < targets.length) {
                    Target target = (Target)targets[i];
                    MISession miSession = target.getMISession();
                    CommandFactory factory = miSession.getCommandFactory();
                    MIGDBSet setRemoteBaud = factory.createMIGDBSet(new String[]{"remotebaud", remoteBaud});
                    miSession.postCommand(setRemoteBaud, launchTimeout);
                    MIInfo info = setRemoteBaud.getMIInfo();
                    if (info == null) {
                        throw new MIException(MIPlugin.getResourceString("src.GDBServerDebugger.Can_not_set_Baud"));
                    }
                    MITargetSelect select = factory.createMITargetSelect(new String[]{"remote", remote});
                    miSession.postCommand(select, launchTimeout);
                    select.getMIInfo();
                    if (info == null) {
                        throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                    }
                    ++i;
                }
            }
            this.initializeLibraries(config, session);
            Session session2 = session;
            return session2;
        }
        catch (Exception e) {
            failed = true;
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw this.newCoreException(e);
        }
        finally {
            if (failed && session != null) {
                try {
                    session.terminate();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Session createAttachSession(ILaunchConfiguration config, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        String msg = MIPlugin.getResourceString("src.GDBServerDebugger.GDBServer_attaching_unsupported");
        throw this.newCoreException(msg, null);
    }

    @Override
    public Session createCoreSession(ILaunchConfiguration config, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        String msg = MIPlugin.getResourceString("src.GDBServerDebugger.GDBServer_corefiles_unsupported");
        throw this.newCoreException(msg, null);
    }
}

