/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIList;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIDataListChangedRegistersInfo
extends MIInfo {
    int[] registers;

    public MIDataListChangedRegistersInfo(MIOutput rr) {
        super(rr);
    }

    public int[] getRegisterNumbers() {
        if (this.registers == null) {
            this.parse();
        }
        return this.registers;
    }

    void parse() {
        MIOutput out;
        MIResultRecord rr;
        ArrayList aList = new ArrayList();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("changed-registers") && (value = results[i].getMIValue()) instanceof MIList) {
                    this.parseRegisters((MIList)value, aList);
                }
                ++i;
            }
        }
        this.registers = new int[aList.size()];
        int i = 0;
        while (i < aList.size()) {
            String str = (String)aList.get(i);
            try {
                this.registers[i] = Integer.parseInt(str.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
    }

    void parseRegisters(MIList list, List aList) {
        MIValue[] values = list.getMIValues();
        int i = 0;
        while (i < values.length) {
            String str;
            if (values[i] instanceof MIConst && (str = ((MIConst)values[i]).getCString()) != null && str.length() > 0) {
                aList.add(str);
            }
            ++i;
        }
    }
}

