/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableStatus;
import org.eclipse.cdt.core.cdtvariables.IStorableCdtVariables;
import org.eclipse.cdt.core.cdtvariables.IUserVarSupplier;
import org.eclipse.cdt.core.model.util.CDTListComparator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICMultiItemsHolder;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.internal.ui.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.NewVarDialog;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.PrefPage_Abstract;
import org.eclipse.cdt.ui.newui.StringListModeControl;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.envvar.EnvVarOperationProcessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CPropertyVarsTab
extends AbstractCPropertyTab {
    private static final String VALUE_DELIMITER = " || ";
    private static final ICdtVariableManager vmgr = CCorePlugin.getDefault().getCdtVariableManager();
    private static final IUserVarSupplier fUserSup = CCorePlugin.getUserVarSupplier();
    private static final EnvCmp comparator = new EnvCmp();
    private ICConfigurationDescription cfgd = null;
    private IStorableCdtVariables prefvars = null;
    private static final String[] fHiddenMacros = new String[]{"CWD", "PWD"};
    private boolean fShowSysMacros = false;
    private Set<String> fIncorrectlyDefinedMacrosNames = new HashSet<String>();
    private TableViewer tv;
    private Label fStatusLabel;
    private StringListModeControl stringListModeControl;
    private static final String[] fEditableTableColumnProps = new String[]{"editable name", "editable type", "editable value"};
    private static final String[] fTableColumnNames = new String[]{Messages.MacrosBlock_label_header_name, Messages.MacrosBlock_label_header_type, Messages.MacrosBlock_label_header_value};
    private static final ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnPixelData(100), new ColumnPixelData(100), new ColumnPixelData(250)};

    private void handleSelectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    protected void updateButtons() {
        Object[] obs = ((IStructuredSelection)this.tv.getSelection()).toArray();
        boolean canEdit = false;
        boolean canDel = false;
        if (obs != null && obs.length > 0) {
            canEdit = obs.length == 1;
            int i = 0;
            while (i < obs.length) {
                if (obs[i] instanceof ICdtVariable && this.isUserVar((ICdtVariable)obs[i])) {
                    canDel = true;
                    break;
                }
                ++i;
            }
        }
        this.buttonSetEnabled(1, canEdit);
        this.buttonSetEnabled(2, canDel);
    }

    public void buttonPressed(int index) {
        switch (index) {
            case 0: {
                this.handleAddButton();
                break;
            }
            case 1: {
                this.handleEditButton();
                break;
            }
            case 2: {
                this.handleDelButton();
            }
        }
        this.tv.getTable().setFocus();
    }

    private void replaceMacros() {
        if (!this.page.isMultiCfg() || this.cfgd == null || CDTPrefUtil.getMultiCfgStringListWriteMode() != 8) {
            return;
        }
        ICdtVariable[] vars = this.getVariables();
        int i = 0;
        while (i < vars.length) {
            if (!this.isUserVar(vars[i])) {
                vars[i] = null;
            }
            ++i;
        }
        ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
            fUserSup.deleteAll(c);
            ICdtVariable[] iCdtVariableArray = vars;
            int n3 = vars.length;
            int n4 = 0;
            while (n4 < n3) {
                ICdtVariable macro = iCdtVariableArray[n4];
                if (macro != null) {
                    fUserSup.createMacro(macro, c);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private ICConfigurationDescription[] getCfs() {
        if (this.cfgd instanceof ICMultiItemsHolder) {
            return (ICConfigurationDescription[])((ICMultiItemsHolder)this.cfgd).getItems();
        }
        return new ICConfigurationDescription[]{this.cfgd};
    }

    private void addOrEdit(ICdtVariable macro, boolean forAll) {
        if (!this.canCreate(macro)) {
            return;
        }
        if (this.cfgd != null) {
            if (forAll) {
                ICConfigurationDescription[] iCConfigurationDescriptionArray = this.page.getCfgsEditable();
                int n = iCConfigurationDescriptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICConfigurationDescription c = iCConfigurationDescriptionArray[n2];
                    fUserSup.createMacro(macro, c);
                    ++n2;
                }
            } else if (this.page.isMultiCfg() && this.cfgd instanceof ICMultiItemsHolder) {
                ICConfigurationDescription[] iCConfigurationDescriptionArray = this.getCfs();
                int n = iCConfigurationDescriptionArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ICConfigurationDescription c = iCConfigurationDescriptionArray[n3];
                    fUserSup.createMacro(macro, c);
                    ++n3;
                }
                this.replaceMacros();
            } else {
                fUserSup.createMacro(macro, this.cfgd);
            }
        } else if (this.chkVars()) {
            this.prefvars.createMacro(macro);
        }
        this.updateData();
    }

    private void handleAddButton() {
        NewVarDialog dlg = new NewVarDialog(this.usercomp.getShell(), null, this.cfgd, this.getVariables());
        if (dlg.open() == 0) {
            this.addOrEdit(dlg.getDefinedMacro(), dlg.isForAllCfgs);
        }
    }

    private void handleEditButton() {
        NewVarDialog dlg;
        ICdtVariable[] _vars = this.getSelectedUserMacros();
        if (_vars != null && _vars.length == 1 && (dlg = new NewVarDialog(this.usercomp.getShell(), _vars[0], this.cfgd, this.getVariables())).open() == 0) {
            this.addOrEdit(dlg.getDefinedMacro(), false);
        }
    }

    private void handleDelButton() {
        ICdtVariable[] macros = this.getSelectedUserMacros();
        if (macros != null && macros.length > 0 && MessageDialog.openQuestion((Shell)this.usercomp.getShell(), (String)Messages.MacrosBlock_label_delete_confirm_title, (String)Messages.MacrosBlock_label_delete_confirm_message)) {
            int i = 0;
            while (i < macros.length) {
                if (this.cfgd != null) {
                    if (this.page.isMultiCfg() && this.cfgd instanceof ICMultiItemsHolder) {
                        ICConfigurationDescription[] cfs = (ICConfigurationDescription[])((ICMultiItemsHolder)this.cfgd).getItems();
                        int k = 0;
                        while (k < cfs.length) {
                            fUserSup.deleteMacro(macros[i].getName(), cfs[k]);
                            ++k;
                        }
                        this.replaceMacros();
                    } else {
                        fUserSup.deleteMacro(macros[i].getName(), this.cfgd);
                    }
                } else if (this.chkVars()) {
                    this.prefvars.deleteMacro(macros[i].getName());
                }
                ++i;
            }
            this.updateData();
        }
    }

    private ICdtVariable[] getSelectedUserMacros() {
        if (this.tv == null) {
            return null;
        }
        List list = ((IStructuredSelection)this.tv.getSelection()).toList();
        return list.toArray(new ICdtVariable[list.size()]);
    }

    protected void performDefaults() {
        if (MessageDialog.openQuestion((Shell)this.usercomp.getShell(), (String)Messages.MacrosBlock_label_delete_all_confirm_title, (String)Messages.MacrosBlock_label_delete_all_confirm_message)) {
            if (this.cfgd != null) {
                if (this.page.isMultiCfg() && this.cfgd instanceof ICMultiItemsHolder) {
                    ICConfigurationDescription[] cfs = (ICConfigurationDescription[])((ICMultiItemsHolder)this.cfgd).getItems();
                    int i = 0;
                    while (i < cfs.length) {
                        fUserSup.deleteAll(cfs[i]);
                        ++i;
                    }
                } else {
                    fUserSup.deleteAll(this.cfgd);
                }
            } else if (this.chkVars()) {
                this.prefvars.deleteAll();
            }
            this.updateData();
        }
    }

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.initButtons(new String[]{ADD_STR, EDIT_STR, DEL_STR});
        this.usercomp.setLayout((Layout)new GridLayout(2, true));
        this.createTableControl();
        final Button b = new Button(this.usercomp, 32);
        b.setFont(this.usercomp.getFont());
        b.setText(Messages.CPropertyVarsTab_0);
        b.setLayoutData((Object)new GridData(768));
        b.setSelection(this.fShowSysMacros);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CPropertyVarsTab.this.fShowSysMacros = b.getSelection();
                CPropertyVarsTab.this.updateData(CPropertyVarsTab.this.getResDesc());
            }
        });
        this.stringListModeControl = new StringListModeControl(this.page, this.usercomp, 1);
        this.stringListModeControl.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CPropertyVarsTab.this.updateData();
            }
        });
        this.fStatusLabel = new Label(this.usercomp, 16384);
        this.fStatusLabel.setFont(this.usercomp.getFont());
        this.fStatusLabel.setText("");
        this.fStatusLabel.setLayoutData((Object)new GridData(1));
        this.fStatusLabel.setForeground(JFaceResources.getColorRegistry().get("ERROR_COLOR"));
    }

    private void createTableControl() {
        TableViewer tableViewer = new TableViewer(this.usercomp, 68354);
        Table table = tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        int i = 0;
        while (i < fTableColumnNames.length) {
            tableLayout.addColumnData(fTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(CPropertyVarsTab.fTableColumnLayouts[i].resizable);
            tc.setText(fTableColumnNames[i]);
            ++i;
        }
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new MacroContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new MacroLabelProvider());
        tableViewer.setSorter(new ViewerSorter());
        tableViewer.setColumnProperties(fEditableTableColumnProps);
        this.tv = tableViewer;
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CPropertyVarsTab.this.handleSelectionChanged(event);
            }
        });
        tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!CPropertyVarsTab.this.tv.getSelection().isEmpty()) {
                    CPropertyVarsTab.this.buttonPressed(1);
                }
            }
        });
        table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    CPropertyVarsTab.this.buttonPressed(2);
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        table.setLayoutData((Object)gd);
    }

    private boolean canCreate(ICdtVariable v) {
        if (v == null) {
            return false;
        }
        String name = v.getName();
        if (name == null || (name = name.trim()).length() == 0) {
            return false;
        }
        if (fHiddenMacros != null) {
            int i = 0;
            while (i < fHiddenMacros.length) {
                if (fHiddenMacros[i].equals(EnvVarOperationProcessor.normalizeName((String)name))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void updateData(ICResourceDescription _cfgd) {
        if (_cfgd == null) {
            this.cfgd = null;
            this.chkVars();
        } else {
            this.cfgd = _cfgd.getConfiguration();
            this.prefvars = null;
        }
        this.updateData();
    }

    private boolean chkVars() {
        if (this.prefvars == null) {
            this.prefvars = fUserSup.getWorkspaceVariablesCopy();
        }
        return this.prefvars != null;
    }

    private void checkVariableIntegrity() {
        try {
            if (this.page.isMultiCfg() && this.cfgd instanceof ICMultiItemsHolder) {
                ICConfigurationDescription[] cfs = (ICConfigurationDescription[])((ICMultiItemsHolder)this.cfgd).getItems();
                int i = 0;
                while (i < cfs.length) {
                    vmgr.checkVariableIntegrity(cfs[i]);
                    ++i;
                }
            } else {
                vmgr.checkVariableIntegrity(this.cfgd);
            }
            this.updateState(null);
        }
        catch (CdtVariableException e) {
            this.updateState(e);
        }
    }

    private ICdtVariable[] getVariables() {
        if (this.page.isMultiCfg() && this.cfgd instanceof ICMultiItemsHolder) {
            ICMultiItemsHolder mih = (ICMultiItemsHolder)this.cfgd;
            ICConfigurationDescription[] cfs = (ICConfigurationDescription[])mih.getItems();
            Object[][] vs = new ICdtVariable[cfs.length][];
            int i = 0;
            while (i < cfs.length) {
                vs[i] = vmgr.getVariables(cfs[i]);
                ++i;
            }
            Object[] obs = CDTPrefUtil.getListForDisplay((Object[][])vs, (Comparator)comparator);
            ICdtVariable[] v = new ICdtVariable[obs.length];
            System.arraycopy(obs, 0, v, 0, obs.length);
            return v;
        }
        return vmgr.getVariables(this.cfgd);
    }

    private void updateData() {
        if (this.tv == null) {
            return;
        }
        this.checkVariableIntegrity();
        ICdtVariable[] _vars = this.getVariables();
        if (_vars == null) {
            return;
        }
        this.stringListModeControl.updateStringListModeControl();
        if (this.cfgd == null) {
            this.chkVars();
            if (this.fShowSysMacros) {
                ArrayList<ICdtVariable> lst = new ArrayList<ICdtVariable>(_vars.length);
                ICdtVariable[] uvars = this.prefvars.getMacros();
                int i = 0;
                while (i < uvars.length) {
                    lst.add(uvars[i]);
                    int j = 0;
                    while (j < _vars.length) {
                        if (_vars[j] != null && _vars[j].getName().equals(uvars[i].getName())) {
                            _vars[j] = null;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                int j = 0;
                while (j < _vars.length) {
                    if (_vars[j] != null && !vmgr.isUserVariable(_vars[j], null)) {
                        lst.add(_vars[j]);
                    }
                    ++j;
                }
                _vars = lst.toArray(new ICdtVariable[lst.size()]);
            } else {
                _vars = this.prefvars.getMacros();
            }
        }
        ArrayList<ICdtVariable> list = new ArrayList<ICdtVariable>(_vars.length);
        int i = 0;
        while (i < _vars.length) {
            if (_vars[i] != null && (this.fShowSysMacros || this.isUserVar(_vars[i]))) {
                list.add(_vars[i]);
            }
            ++i;
        }
        Collections.sort(list, CDTListComparator.getInstance());
        this.tv.setInput((Object)list.toArray(new ICdtVariable[list.size()]));
        this.updateButtons();
    }

    private void updateState(CdtVariableException e) {
        this.fIncorrectlyDefinedMacrosNames.clear();
        if (e != null) {
            this.fStatusLabel.setText(e.getMessage());
            this.fStatusLabel.setVisible(true);
            ICdtVariableStatus[] statuses = e.getVariableStatuses();
            int i = 0;
            while (i < statuses.length) {
                String name = statuses[i].getVariableName();
                if (name != null) {
                    this.fIncorrectlyDefinedMacrosNames.add(name);
                }
                ++i;
            }
        } else {
            this.fStatusLabel.setVisible(false);
        }
    }

    private boolean isUserVar(ICdtVariable v) {
        if (this.cfgd == null) {
            return this.chkVars() && this.prefvars.contains(v);
        }
        if (this.page.isMultiCfg() && this.cfgd instanceof ICMultiItemsHolder) {
            ICConfigurationDescription[] cfs = (ICConfigurationDescription[])((ICMultiItemsHolder)this.cfgd).getItems();
            int i = 0;
            while (i < cfs.length) {
                if (vmgr.isUserVariable(v, cfs[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return vmgr.isUserVariable(v, this.cfgd);
    }

    private String getString(ICdtVariable v) {
        if (fUserSup.isDynamic(v)) {
            return Messages.MacrosBlock_label_value_eclipse_dynamic;
        }
        String value = "";
        try {
            value = CdtVariableResolver.isStringListVariable((int)v.getValueType()) ? vmgr.convertStringListToString(v.getStringListValue(), VALUE_DELIMITER) : v.getStringValue();
        }
        catch (CdtVariableException cdtVariableException) {
            // empty catch block
        }
        return value;
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (this.cfgd != null) {
            if (this.page.isMultiCfg()) {
                if (src instanceof ICMultiItemsHolder && dst instanceof ICMultiItemsHolder) {
                    ICResourceDescription[] r1;
                    ICMultiItemsHolder s = (ICMultiItemsHolder)src;
                    ICMultiItemsHolder d = (ICMultiItemsHolder)dst;
                    ICResourceDescription[] r0 = (ICResourceDescription[])s.getItems();
                    if (r0.length != (r1 = (ICResourceDescription[])d.getItems()).length) {
                        return;
                    }
                    int i = 0;
                    while (i < r0.length) {
                        ICdtVariable[] vs = fUserSup.getMacros(r0[i].getConfiguration());
                        fUserSup.setMacros(vs, r1[i].getConfiguration());
                        ++i;
                    }
                }
            } else {
                ICdtVariable[] vs = fUserSup.getMacros(src.getConfiguration());
                fUserSup.setMacros(vs, dst.getConfiguration());
            }
        } else if (this.chkVars()) {
            fUserSup.storeWorkspaceVariables(true);
        }
    }

    protected void performOK() {
        if (this.chkVars()) {
            try {
                if (fUserSup.setWorkspaceVariables(this.prefvars) && this.page instanceof PrefPage_Abstract) {
                    PrefPage_Abstract.isChanged = true;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.prefvars = null;
        super.performOK();
    }

    protected void performCancel() {
        this.prefvars = null;
        super.performCancel();
    }

    public boolean canBeVisible() {
        return this.page.isForProject() || this.page.isForPrefs();
    }

    private static class EnvCmp
    implements Comparator<Object> {
        private EnvCmp() {
        }

        @Override
        public int compare(Object a0, Object a1) {
            if (a0 == null || a1 == null) {
                return 0;
            }
            if (a0 instanceof ICdtVariable && a1 instanceof ICdtVariable) {
                String s1;
                ICdtVariable x0 = (ICdtVariable)a0;
                ICdtVariable x1 = (ICdtVariable)a1;
                String s0 = x0.getName();
                if (s0 == null) {
                    s0 = "";
                }
                if ((s1 = x1.getName()) == null) {
                    s1 = "";
                }
                return s0.compareTo(s1);
            }
            return 0;
        }
    }

    private class MacroContentProvider
    implements IStructuredContentProvider {
        private MacroContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class MacroLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider,
    ITableFontProvider,
    IColorProvider {
        private MacroLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Font getFont(Object element) {
            return this.getFont(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element) {
            ICdtVariable var = (ICdtVariable)element;
            if (CPropertyVarsTab.this.isUserVar(var)) {
                return BACKGROUND_FOR_USER_VAR;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ICdtVariable var = (ICdtVariable)element;
            switch (columnIndex) {
                case 0: {
                    return var.getName();
                }
                case 1: {
                    switch (var.getValueType()) {
                        case 3: {
                            return Messages.MacrosBlock_label_type_path_file;
                        }
                        case 4: {
                            return Messages.MacrosBlock_label_type_path_file_list;
                        }
                        case 5: {
                            return Messages.MacrosBlock_label_type_path_dir;
                        }
                        case 6: {
                            return Messages.MacrosBlock_label_type_path_dir_list;
                        }
                        case 7: {
                            return Messages.MacrosBlock_label_type_path_any;
                        }
                        case 8: {
                            return Messages.MacrosBlock_label_type_path_any_list;
                        }
                        case 1: {
                            return Messages.MacrosBlock_label_type_text;
                        }
                        case 2: {
                            return Messages.MacrosBlock_label_type_text_list;
                        }
                    }
                    return "? " + var.getValueType();
                }
                case 2: {
                    return CPropertyVarsTab.this.getString(var);
                }
            }
            return "";
        }

        public Font getFont(Object element, int columnIndex) {
            ICdtVariable var = (ICdtVariable)element;
            if (columnIndex == 0 && CPropertyVarsTab.this.isUserVar(var)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (CPropertyVarsTab.this.fIncorrectlyDefinedMacrosNames.contains(((ICdtVariable)element).getName())) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return null;
        }
    }
}

