/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.filters;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.logging.aeri.core.util.StatusSwitch;
import org.eclipse.jdt.annotation.Nullable;

public class AcceptedPackagesFilter
implements Predicate<IStatus> {
    private List<Pattern> patterns;
    private boolean strict;

    public AcceptedPackagesFilter(List<Pattern> patterns) {
        this(patterns, true);
    }

    public AcceptedPackagesFilter(List<Pattern> patterns, boolean strict) {
        this.patterns = patterns;
        this.strict = strict;
    }

    public boolean apply(IStatus input) {
        if (this.strict) {
            return this.applyStrictMatching(input);
        }
        return this.applyNonStrictMatching(input);
    }

    private boolean applyNonStrictMatching(IStatus input) {
        NonStrictStatusSwitch test = new NonStrictStatusSwitch();
        TestResult res = (TestResult)((Object)Objects.firstNonNull((Object)((Object)((TestResult)((Object)test.doSwitch(input)))), (Object)((Object)TestResult.UNDEF)));
        switch (res) {
            case PASS: {
                return true;
            }
            case FAIL: {
                return false;
            }
        }
        return test.packageMatch;
    }

    private boolean applyStrictMatching(IStatus input) {
        TestResult res = (TestResult)((Object)Objects.firstNonNull((Object)((Object)((TestResult)((Object)new StrictStatusSwitch().doSwitch(input)))), (Object)((Object)TestResult.UNDEF)));
        switch (res) {
            case FAIL: {
                return false;
            }
        }
        return true;
    }

    private final class NonStrictStatusSwitch
    extends StatusSwitch<TestResult> {
        boolean packageMatch = false;

        private NonStrictStatusSwitch() {
        }

        @Override
        @Nullable
        public TestResult caseStackTraceElement(StackTraceElement stackTraceElement) {
            String label = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
            for (Pattern pattern : AcceptedPackagesFilter.this.patterns) {
                if (!pattern.matcher(label).matches()) {
                    if (this.packageMatch) {
                        return TestResult.PASS;
                    }
                    return null;
                }
                this.packageMatch = true;
            }
            return null;
        }
    }

    private final class StrictStatusSwitch
    extends StatusSwitch<TestResult> {
        private StrictStatusSwitch() {
        }

        @Override
        @Nullable
        public TestResult caseStackTraceElement(StackTraceElement stackTraceElement) {
            String label = String.valueOf(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
            for (Pattern pattern : AcceptedPackagesFilter.this.patterns) {
                if (pattern.matcher(label).matches()) continue;
                return TestResult.FAIL;
            }
            return null;
        }
    }

    static enum TestResult {
        PASS,
        FAIL,
        UNDEF;

    }
}

