/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemapping;
import org.eclipse.cdt.debug.internal.core.Trace;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;

public class Executable
extends PlatformObject {
    private final IPath executablePath;
    private final IProject project;
    private final String name;
    private final IResource resource;
    private final Map<ITranslationUnit, String> remappedPaths;
    private final ArrayList<ITranslationUnit> sourceFiles;
    private boolean refreshSourceFiles;
    private boolean remapSourceFiles;
    private ISourceFileRemapping[] remappers;
    private String[] symReaderSources;

    @Deprecated
    public static boolean isExecutableFile(IPath path) {
        return Executable.isBinaryFile(path);
    }

    public static boolean isBinaryFile(IPath path) {
        if (path.toFile().isDirectory()) {
            return false;
        }
        String ext = path.getFileExtension();
        if (ext != null) {
            boolean isNumber = true;
            int i = 0;
            while (i < ext.length()) {
                if (!Character.isDigit(ext.charAt(i))) {
                    isNumber = false;
                    break;
                }
                ++i;
            }
            if (!isNumber) {
                boolean isBinary = false;
                IContentTypeManager ctm = Platform.getContentTypeManager();
                IContentType ctbin = ctm.getContentType("org.eclipse.cdt.core.binaryFile");
                IContentType[] cts = ctm.findContentTypesFor(path.toFile().getName());
                int i2 = 0;
                while (!isBinary && i2 < cts.length) {
                    isBinary = cts[i2].isKindOf(ctbin);
                    ++i2;
                }
                if (!isBinary) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Executable) {
            Executable exe = (Executable)((Object)arg0);
            return exe.getPath().equals((Object)this.getPath());
        }
        return super.equals(arg0);
    }

    public IPath getPath() {
        return this.executablePath;
    }

    public IProject getProject() {
        return this.project;
    }

    public Executable(IPath path, IProject project, IResource resource, ISourceFileRemapping[] sourceFileRemappings) {
        this.executablePath = path;
        this.project = project;
        this.name = new File(path.toOSString()).getName();
        this.resource = resource;
        this.remappers = sourceFileRemappings;
        this.remappedPaths = new HashMap<ITranslationUnit, String>();
        this.sourceFiles = new ArrayList();
        this.refreshSourceFiles = true;
        this.remapSourceFiles = true;
    }

    public IResource getResource() {
        return this.resource;
    }

    public String toString() {
        return this.executablePath.toString();
    }

    public String getName() {
        return this.name;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IResource.class)) {
            if (this.getResource() != null) {
                return this.getResource();
            }
            return this.getProject();
        }
        return super.getAdapter(adapter);
    }

    private String remapSourceFile(String filename) {
        ISourceFileRemapping[] iSourceFileRemappingArray = this.remappers;
        int n = this.remappers.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceFileRemapping remapper = iSourceFileRemappingArray[n2];
            String remapped = remapper.remapSourceFile(this.getPath(), filename);
            if (!remapped.equals(filename)) {
                return remapped;
            }
            ++n2;
        }
        return filename;
    }

    public synchronized ITranslationUnit[] getSourceFiles(IProgressMonitor monitor) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null);
        }
        if (!this.refreshSourceFiles && !this.remapSourceFiles) {
            if (Trace.DEBUG_EXECUTABLES) {
                Trace.getTrace().trace(null, "returning cached result");
            }
            return (ITranslationUnit[])this.sourceFiles.toArray(new TranslationUnit[this.sourceFiles.size()]);
        }
        this.remappedPaths.clear();
        this.sourceFiles.clear();
        CModelManager factory = CModelManager.getDefault();
        ICProject cproject = factory.create(this.project);
        if (this.refreshSourceFiles) {
            this.symReaderSources = ExecutablesManager.getExecutablesManager().getSourceFiles(this, monitor);
        }
        if (this.symReaderSources != null && this.symReaderSources.length > 0) {
            String[] stringArray = this.symReaderSources;
            int n = this.symReaderSources.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                String filename;
                String orgPath = filename = stringArray[n2];
                filename = this.remapSourceFile(filename);
                boolean fileExists = false;
                boolean isNativeAbsPath = Util.isNativeAbsolutePath((String)filename);
                if (isNativeAbsPath) {
                    try {
                        File file = new File(filename);
                        fileExists = file.exists();
                        if (fileExists) {
                            filename = file.getCanonicalPath();
                        }
                    }
                    catch (IOException file) {
                        // empty catch block
                    }
                }
                IFile wkspFile = null;
                IFile sourceFile = this.getProject().getFile(filename);
                Path sourcePath = new Path(filename);
                if (fileExists) {
                    if (sourceFile.exists()) {
                        wkspFile = sourceFile;
                    } else {
                        IFile[] filesInWP;
                        IFile[] iFileArray = filesInWP = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(URIUtil.toURI((IPath)sourcePath));
                        int n3 = filesInWP.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IFile fileInWP = iFileArray[n4];
                            if (fileInWP.isAccessible()) {
                                wkspFile = fileInWP;
                                break;
                            }
                            ++n4;
                        }
                    }
                }
                if ((id = CoreModel.getRegistedContentTypeId((IProject)sourceFile.getProject(), (String)sourceFile.getName())) != null) {
                    TranslationUnit tu;
                    if (wkspFile != null) {
                        tu = new TranslationUnit((ICElement)cproject, wkspFile, id);
                    } else {
                        URI uri = isNativeAbsPath && sourcePath.toFile().exists() ? URIUtil.toURI((IPath)sourcePath) : URIUtil.toURI((String)filename, (boolean)true);
                        tu = new ExternalTranslationUnit((ICElement)cproject, uri, id);
                    }
                    if (!this.sourceFiles.contains(tu)) {
                        this.sourceFiles.add((ITranslationUnit)tu);
                    }
                    if (!orgPath.equals(filename)) {
                        this.remappedPaths.put((ITranslationUnit)tu, orgPath);
                    }
                }
                ++n2;
            }
        }
        this.refreshSourceFiles = false;
        this.remapSourceFiles = false;
        return (ITranslationUnit[])this.sourceFiles.toArray(new TranslationUnit[this.sourceFiles.size()]);
    }

    public void setRefreshSourceFiles(boolean refreshSourceFiles) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, (Object)refreshSourceFiles);
        }
        this.refreshSourceFiles = refreshSourceFiles;
    }

    public synchronized String getOriginalLocation(ITranslationUnit tu) {
        String orgLocation = this.remappedPaths.get(tu);
        if (orgLocation == null) {
            orgLocation = tu.getLocation().toOSString();
        }
        return orgLocation;
    }

    public void setRemapSourceFiles(boolean remapSourceFiles) {
        if (Trace.DEBUG_EXECUTABLES) {
            Trace.getTrace().traceEntry(null, (Object)remapSourceFiles);
        }
        this.remapSourceFiles = remapSourceFiles;
    }
}

