/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointHit;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISignalReceived;
import org.eclipse.cdt.debug.core.cdi.ICDIWatchpointTrigger;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIDisposable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration2;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.model.CDebugElementState;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICThread;
import org.eclipse.cdt.debug.core.model.IDummyStackFrame;
import org.eclipse.cdt.debug.core.model.IMoveToAddress;
import org.eclipse.cdt.debug.core.model.IMoveToLine;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.IResumeAtAddress;
import org.eclipse.cdt.debug.core.model.IResumeAtLine;
import org.eclipse.cdt.debug.core.model.IResumeWithoutSignal;
import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CDummyStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IStackFrame;

public class CThread
extends CDebugElement
implements ICThread,
IRestart,
IResumeWithoutSignal,
ICDIEventListener {
    private static final int MAX_STACK_DEPTH = 100;
    private ICDIThread fCDIThread;
    private ArrayList fStackFrames;
    private boolean fRefreshChildren = true;
    private ICDITargetConfiguration fConfig;
    private boolean fIsCurrent = false;
    private int fLastStackDepth = 0;
    private boolean fDisposed = false;

    public CThread(CDebugTarget target, ICDIThread cdiThread) {
        super(target);
        this.setState(cdiThread.isSuspended() ? CDebugElementState.SUSPENDED : CDebugElementState.RESUMED);
        this.setCDIThread(cdiThread);
        this.fConfig = this.getCDITarget().getConfiguration();
        this.initialize();
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.fStackFrames = new ArrayList();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        List list = Collections.EMPTY_LIST;
        try {
            list = this.computeStackFrames();
        }
        catch (DebugException e) {
            this.setStatus(2, e.getStatus().getMessage());
            throw e;
        }
        return list.toArray(new IStackFrame[list.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        return !this.getState().equals(CDebugElementState.RESUMED);
    }

    protected synchronized List computeStackFrames(boolean refreshChildren) throws DebugException {
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                this.fStackFrames = new ArrayList();
            } else if (refreshChildren) {
                int depth;
                Object frame;
                if (this.fStackFrames.size() > 0 && (frame = this.fStackFrames.get(this.fStackFrames.size() - 1)) instanceof IDummyStackFrame) {
                    this.fStackFrames.remove(frame);
                }
                if ((depth = this.getStackDepth()) >= this.getMaxStackDepth()) {
                    depth = this.getMaxStackDepth() - 1;
                }
                ICDIStackFrame[] frames = depth != 0 ? this.getCDIStackFrames(0, depth - 1) : new ICDIStackFrame[]{};
                depth = frames.length;
                if (this.fStackFrames.isEmpty()) {
                    if (frames.length > 0) {
                        this.addStackFrames(frames, 0, frames.length, false);
                    }
                } else {
                    int length;
                    int diff = depth - this.getLastStackDepth();
                    int offset = diff > 0 ? frames.length - diff : 0;
                    int n = length = diff > 0 ? diff : -diff;
                    if (offset < 0 || !this.compareStackFrames(frames, this.fStackFrames, offset, length)) {
                        this.disposeStackFrames(0, this.fStackFrames.size());
                        this.addStackFrames(frames, 0, frames.length, false);
                    }
                    if (diff < 0) {
                        this.disposeStackFrames(0, this.getLastStackDepth() - depth);
                        if (frames.length > 0) {
                            this.updateStackFrames(frames, 0, this.fStackFrames, this.fStackFrames.size());
                            if (this.fStackFrames.size() < frames.length) {
                                this.addStackFrames(frames, this.fStackFrames.size(), frames.length - this.fStackFrames.size(), true);
                            }
                        }
                    } else if (diff > 0) {
                        this.disposeStackFrames(frames.length - depth + this.getLastStackDepth(), depth - this.getLastStackDepth());
                        this.addStackFrames(frames, 0, depth - this.getLastStackDepth(), false);
                        this.updateStackFrames(frames, depth - this.getLastStackDepth(), this.fStackFrames, frames.length - depth + this.getLastStackDepth());
                    } else if (depth != 0) {
                        this.updateStackFrames(frames, 0, this.fStackFrames, frames.length);
                    }
                }
                if (depth > this.getMaxStackDepth()) {
                    this.fStackFrames.add(new CDummyStackFrame(this));
                }
                this.setLastStackDepth(depth);
                this.setRefreshChildren(false);
            }
        }
        return this.fStackFrames;
    }

    private boolean compareStackFrames(ICDIStackFrame[] newFrames, List oldFrames, int offset, int length) {
        if (offset < 0) {
            return false;
        }
        int index = offset;
        Iterator it = oldFrames.iterator();
        while (it.hasNext() && index < newFrames.length) {
            CStackFrame frame = (CStackFrame)it.next();
            if (frame.getCDIStackFrame().equals(newFrames[index++])) continue;
            return false;
        }
        return true;
    }

    protected ICDIStackFrame[] getCDIStackFrames() throws DebugException {
        return new ICDIStackFrame[0];
    }

    protected ICDIStackFrame[] getCDIStackFrames(int lowFrame, int highFrame) throws DebugException {
        try {
            ICDIThread cdiThread = this.getCDIThread();
            if (cdiThread != null) {
                return cdiThread.getStackFrames(lowFrame, highFrame);
            }
        }
        catch (CDIException e) {
            this.setStatus(1, MessageFormat.format((String)CoreModelMessages.getString("CThread.0"), (Object[])new String[]{e.getMessage()}));
            CThread.targetRequestFailed(e.getMessage(), null);
        }
        return new ICDIStackFrame[0];
    }

    protected void updateStackFrames(ICDIStackFrame[] newFrames, int offset, List oldFrames, int length) throws DebugException {
        int i = 0;
        while (i < length) {
            CStackFrame frame = (CStackFrame)oldFrames.get(offset);
            frame.setCDIStackFrame(newFrames[offset]);
            ++offset;
            ++i;
        }
    }

    protected void addStackFrames(ICDIStackFrame[] newFrames, int startIndex, int length, boolean append) {
        if (newFrames.length >= startIndex + length) {
            int i = 0;
            while (i < length) {
                if (append) {
                    this.fStackFrames.add(new CStackFrame(this, newFrames[startIndex + i]));
                } else {
                    this.fStackFrames.add(i, new CStackFrame(this, newFrames[startIndex + i]));
                }
                ++i;
            }
        }
    }

    public synchronized List computeStackFrames() throws DebugException {
        return this.computeStackFrames(this.refreshChildren());
    }

    public List computeNewStackFrames() throws DebugException {
        return this.computeStackFrames(true);
    }

    protected List createAllStackFrames(int depth, ICDIStackFrame[] frames) throws DebugException {
        ArrayList<CDebugElement> list = new ArrayList<CDebugElement>(frames.length);
        int i = 0;
        while (i < frames.length) {
            list.add(new CStackFrame(this, frames[i]));
            ++i;
        }
        if (depth > frames.length) {
            list.add(new CDummyStackFrame(this));
        }
        return list;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        List c = this.computeStackFrames();
        return c.isEmpty() ? null : (IStackFrame)c.get(0);
    }

    public String getName() throws DebugException {
        ICDIThread cdiThread = this.getCDIThread();
        return cdiThread != null ? cdiThread.toString() : "";
    }

    public IBreakpoint[] getBreakpoints() {
        ArrayList<IBreakpoint> list = new ArrayList<IBreakpoint>(1);
        if (this.isSuspended()) {
            IBreakpoint bkpt = null;
            if (this.getCurrentStateInfo() instanceof ICDIBreakpointHit) {
                bkpt = ((CDebugTarget)this.getDebugTarget()).getBreakpointManager().getBreakpoint(((ICDIBreakpointHit)this.getCurrentStateInfo()).getBreakpoint());
            } else if (this.getCurrentStateInfo() instanceof ICDIWatchpointTrigger) {
                bkpt = ((CDebugTarget)this.getDebugTarget()).getBreakpointManager().getBreakpoint(((ICDIWatchpointTrigger)this.getCurrentStateInfo()).getWatchpoint());
            }
            if (bkpt != null) {
                list.add(bkpt);
            }
        }
        return list.toArray(new IBreakpoint[list.size()]);
    }

    @Override
    public void handleDebugEvents(ICDIEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            ICDIThread cdiThread = this.getCDIThread();
            if (source instanceof ICDIThread && cdiThread != null && source.equals(cdiThread)) {
                if (event instanceof ICDISuspendedEvent) {
                    this.handleSuspendedEvent((ICDISuspendedEvent)event);
                } else if (event instanceof ICDIResumedEvent) {
                    this.handleResumedEvent((ICDIResumedEvent)event);
                } else if (event instanceof ICDIDestroyedEvent) {
                    this.handleTerminatedEvent((ICDIDestroyedEvent)event);
                } else if (event instanceof ICDIDisconnectedEvent) {
                    this.handleDisconnectedEvent((ICDIDisconnectedEvent)event);
                } else if (event instanceof ICDIChangedEvent) {
                    this.handleChangedEvent((ICDIChangedEvent)event);
                }
            }
            ++i;
        }
    }

    public boolean canResume() {
        return this.fConfig.supportsResume() && this.isSuspended();
    }

    @Override
    public boolean canRunToLine(IFile file, int lineNumber) {
        return this.canRunToLine(file.getLocation().lastSegment(), lineNumber);
    }

    @Override
    public boolean canRunToLine(String fileName, int lineNumber) {
        return this.canResume();
    }

    public boolean canSuspend() {
        CDebugElementState state = this.getState();
        return this.fConfig.supportsSuspend() && (state.equals(CDebugElementState.RESUMED) || state.equals(CDebugElementState.STEPPED));
    }

    public boolean isSuspended() {
        return this.getState().equals(CDebugElementState.SUSPENDED);
    }

    public void resume() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        CDebugElementState oldState = this.getState();
        this.setState(CDebugElementState.RESUMING);
        try {
            ICDIThread cdiThread = this.getCDIThread();
            if (cdiThread != null) {
                cdiThread.resume(false);
            }
        }
        catch (CDIException e) {
            this.setState(oldState);
            CThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    @Override
    public void runToLine(IFile file, int lineNumber, boolean skipBreakpoints) throws DebugException {
        this.runToLine(file.getLocation().lastSegment(), lineNumber, skipBreakpoints);
    }

    @Override
    public void runToLine(String fileName, int lineNumber, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToLine(fileName, lineNumber)) {
            return;
        }
        if (skipBreakpoints) {
            ((CDebugTarget)this.getDebugTarget()).skipBreakpoints(true);
        }
        CDebugElementState oldState = this.getState();
        this.setState(CDebugElementState.RESUMING);
        ICDILineLocation location = this.getCDITarget().createLineLocation(fileName, lineNumber);
        try {
            ICDIThread cdiThread = this.getCDIThread();
            if (cdiThread != null) {
                cdiThread.stepUntil(location);
            }
        }
        catch (CDIException e) {
            this.setState(oldState);
            if (skipBreakpoints) {
                ((CDebugTarget)this.getDebugTarget()).skipBreakpoints(false);
            }
            CThread.targetRequestFailed(e.getMessage(), e);
        }
    }

    public void suspend() throws DebugException {
        if (!this.canSuspend()) {
            return;
        }
        CDebugElementState oldState = this.getState();
        this.setState(CDebugElementState.SUSPENDING);
        try {
            ICDIThread cdiThread = this.getCDIThread();
            if (cdiThread != null) {
                cdiThread.suspend();
            }
        }
        catch (CDIException e) {
            this.setState(oldState);
            CThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        if (!this.fConfig.supportsStepping() || !this.canResume()) {
            return false;
        }
        return this.fStackFrames.size() > 1;
    }

    protected boolean canStep() {
        if (!this.fConfig.supportsStepping() || !this.isSuspended()) {
            return false;
        }
        return !this.fStackFrames.isEmpty();
    }

    public boolean isStepping() {
        return this.getState().equals(CDebugElementState.STEPPING) || this.getState().equals(CDebugElementState.STEPPED);
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        CDebugElementState oldState = this.getState();
        this.setState(CDebugElementState.STEPPING);
        try {
            ICDIThread cdiThread = this.getCDIThread();
            if (cdiThread != null) {
                if (!this.isInstructionsteppingEnabled()) {
                    cdiThread.stepInto(1);
                } else {
                    cdiThread.stepIntoInstruction(1);
                }
            }
        }
        catch (CDIException e) {
            this.setState(oldState);
            CThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        CDebugElementState oldState = this.getState();
        this.setState(CDebugElementState.STEPPING);
        try {
            ICDIThread cdiThread = this.getCDIThread();
            if (cdiThread != null) {
                if (!this.isInstructionsteppingEnabled()) {
                    cdiThread.stepOver(1);
                } else {
                    cdiThread.stepOverInstruction(1);
                }
            }
        }
        catch (CDIException e) {
            this.setState(oldState);
            CThread.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length == 0) {
            return;
        }
        CStackFrame f = (CStackFrame)frames[0];
        CDebugElementState oldState = this.getState();
        this.setState(CDebugElementState.STEPPING);
        try {
            f.doStepReturn();
        }
        catch (DebugException e) {
            this.setState(oldState);
            throw e;
        }
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setCDIThread(ICDIThread cdiThread) {
        this.fCDIThread = cdiThread;
    }

    protected ICDIThread getCDIThread() {
        return this.fCDIThread;
    }

    protected synchronized void preserveStackFrames() {
        Iterator it = this.fStackFrames.iterator();
        while (it.hasNext()) {
            CStackFrame frame = (CStackFrame)((IAdaptable)it.next()).getAdapter(CStackFrame.class);
            if (frame == null) continue;
            frame.preserve();
        }
        this.setRefreshChildren(true);
    }

    protected synchronized void disposeStackFrames() {
        for (Object obj : this.fStackFrames) {
            if (!(obj instanceof CStackFrame)) continue;
            ((CStackFrame)obj).dispose();
        }
        this.fStackFrames.clear();
        this.setLastStackDepth(0);
        this.resetStatus();
        this.setRefreshChildren(true);
    }

    protected void disposeStackFrames(int index, int length) {
        ArrayList<CStackFrame> removeList = new ArrayList<CStackFrame>(length);
        Iterator it = this.fStackFrames.iterator();
        int counter = 0;
        while (it.hasNext()) {
            CStackFrame frame = (CStackFrame)((IAdaptable)it.next()).getAdapter(CStackFrame.class);
            if (frame != null && counter >= index && counter < index + length) {
                frame.dispose();
                removeList.add(frame);
            }
            ++counter;
        }
        this.fStackFrames.removeAll(removeList);
    }

    protected void terminated() {
        this.setState(CDebugElementState.TERMINATED);
        this.dispose();
    }

    private void handleSuspendedEvent(ICDISuspendedEvent event) {
        if (!(this.getState().equals(CDebugElementState.RESUMED) || this.getState().equals(CDebugElementState.STEPPED) || this.getState().equals(CDebugElementState.SUSPENDING))) {
            return;
        }
        this.setState(CDebugElementState.SUSPENDED);
        ICDISessionObject reason = event.getReason();
        this.setCurrentStateInfo(reason);
        if (reason instanceof ICDIEndSteppingRange) {
            this.handleEndSteppingRange((ICDIEndSteppingRange)reason);
        } else if (reason instanceof ICDIBreakpointHit) {
            this.handleBreakpointHit((ICDIBreakpointHit)reason);
        } else if (reason instanceof ICDISignalReceived) {
            this.handleSuspendedBySignal((ICDISignalReceived)reason);
        } else {
            this.fireSuspendEvent(16);
        }
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        CDebugElementState state = CDebugElementState.RESUMED;
        int detail = 1;
        this.syncWithBackend();
        if (this.isCurrent() && event.getType() != 0) {
            this.preserveStackFrames();
            switch (event.getType()) {
                case 2: 
                case 4: {
                    detail = 1;
                    break;
                }
                case 1: 
                case 3: {
                    detail = 2;
                    break;
                }
                case 5: {
                    detail = 4;
                }
            }
            state = CDebugElementState.STEPPED;
        } else {
            this.disposeStackFrames();
            this.fireChangeEvent(512);
        }
        this.setCurrent(false);
        this.setState(state);
        this.setCurrentStateInfo(null);
        this.fireResumeEvent(detail);
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(8);
    }

    private void handleBreakpointHit(ICDIBreakpointHit breakpointHit) {
        IBreakpoint platformBreakpoint = ((CDebugTarget)this.getDebugTarget()).getBreakpointManager().getBreakpoint(breakpointHit.getBreakpoint());
        if (platformBreakpoint != null) {
            CDebugCorePlugin.getDefault().getBreakpointActionManager().executeActions(platformBreakpoint, (IAdaptable)this);
        }
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointHit(ICDIWatchpointTrigger watchPointTrigger) {
        IBreakpoint platformBreakpoint = ((CDebugTarget)this.getDebugTarget()).getBreakpointManager().getBreakpoint(watchPointTrigger.getWatchpoint());
        if (platformBreakpoint != null) {
            CDebugCorePlugin.getDefault().getBreakpointActionManager().executeActions(platformBreakpoint, (IAdaptable)this);
        }
        this.fireSuspendEvent(16);
    }

    private void handleSuspendedBySignal(ICDISignalReceived signal) {
        this.fireSuspendEvent(32);
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent event) {
        this.setState(CDebugElementState.TERMINATED);
        this.setCurrentStateInfo(null);
        this.terminated();
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent event) {
        this.setState(CDebugElementState.TERMINATED);
        this.setCurrentStateInfo(null);
        this.terminated();
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
    }

    protected void cleanup() {
        this.getCDISession().getEventManager().removeEventListener(this);
        this.disposeStackFrames();
        ICDIThread cdiThread = this.getCDIThread();
        this.setCDIThread(null);
        if (cdiThread instanceof ICDIDisposable) {
            ((ICDIDisposable)((Object)cdiThread)).dispose();
        }
    }

    private void setRefreshChildren(boolean refresh) {
        this.fRefreshChildren = refresh;
    }

    private boolean refreshChildren() {
        return this.fRefreshChildren;
    }

    @Override
    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && ((IRestart)this.getDebugTarget()).canRestart();
    }

    @Override
    public void restart() throws DebugException {
        if (this.canRestart()) {
            ((IRestart)this.getDebugTarget()).restart();
        }
    }

    protected boolean isCurrent() {
        return this.fIsCurrent;
    }

    protected void setCurrent(boolean current) {
        boolean c = current;
        if (!c && this.getCDITarget().getConfiguration() instanceof ICDITargetConfiguration2 && ((ICDITargetConfiguration2)this.getCDITarget().getConfiguration()).supportsThreadControl()) {
            c = true;
        }
        this.fIsCurrent = c;
    }

    protected int getStackDepth() throws DebugException {
        int depth = 0;
        try {
            ICDIThread cdiThread = this.getCDIThread();
            if (cdiThread != null) {
                depth = cdiThread.getStackFrameCount();
            }
        }
        catch (CDIException e) {
            this.setStatus(1, MessageFormat.format((String)CoreModelMessages.getString("CThread.1"), (Object[])new String[]{e.getMessage()}));
        }
        return depth;
    }

    protected int getMaxStackDepth() {
        return 100;
    }

    private void setLastStackDepth(int depth) {
        this.fLastStackDepth = depth;
    }

    protected int getLastStackDepth() {
        return this.fLastStackDepth;
    }

    @Override
    public Object getAdapter(Class adapter) {
        IStackFrame obj2;
        if (adapter.equals(IRunToLine.class) || adapter.equals(IRunToAddress.class) || adapter.equals(IResumeAtLine.class) || adapter.equals(IResumeAtAddress.class) || adapter.equals(IMoveToLine.class) || adapter.equals(IMoveToAddress.class)) {
            try {
                obj2 = this.getTopStackFrame();
                if (obj2 instanceof ICStackFrame) {
                    return obj2;
                }
            }
            catch (DebugException obj2) {
                // empty catch block
            }
        }
        if (adapter.equals(CDebugElementState.class)) {
            return this;
        }
        if (adapter == ICStackFrame.class) {
            try {
                obj2 = this.getTopStackFrame();
                if (obj2 instanceof ICStackFrame) {
                    return obj2;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        if (adapter == IMemoryBlockRetrieval.class) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        if (adapter == ICDIThread.class) {
            return this.getCDIThread();
        }
        return super.getAdapter(adapter);
    }

    protected void dispose() {
        this.fDisposed = true;
        this.cleanup();
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    @Override
    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && ((IResumeWithoutSignal)this.getDebugTarget()).canResumeWithoutSignal();
    }

    @Override
    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            ((IResumeWithoutSignal)this.getDebugTarget()).resumeWithoutSignal();
        }
    }

    public String toString() {
        String result = "";
        try {
            result = this.getName();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return result;
    }

    protected void resumedByTarget(int detail, List events) {
        this.syncWithBackend();
        if (this.isCurrent() && detail != 32 && detail != 0) {
            this.setState(CDebugElementState.STEPPED);
            this.preserveStackFrames();
            events.add(this.createResumeEvent(detail));
        } else {
            this.setState(CDebugElementState.RESUMED);
            this.disposeStackFrames();
        }
        this.setCurrent(false);
        this.setCurrentStateInfo(null);
    }

    protected boolean isInstructionsteppingEnabled() {
        return ((CDebugTarget)this.getDebugTarget()).isInstructionSteppingEnabled();
    }

    protected void suspendByTarget(ICDISessionObject reason, ICDIThread suspensionThread) {
        this.setState(CDebugElementState.SUSPENDED);
        this.setCurrentStateInfo(null);
        ICDIThread cdiThread = this.getCDIThread();
        if (cdiThread != null && cdiThread.equals(suspensionThread)) {
            this.setCurrent(true);
            this.setCurrentStateInfo(reason);
            if (reason instanceof ICDIEndSteppingRange) {
                this.handleEndSteppingRange((ICDIEndSteppingRange)reason);
            } else if (reason instanceof ICDIBreakpointHit) {
                this.handleBreakpointHit((ICDIBreakpointHit)reason);
            } else if (reason instanceof ICDIWatchpointTrigger) {
                this.handleWatchpointHit((ICDIWatchpointTrigger)reason);
            } else if (reason instanceof ICDISignalReceived) {
                this.handleSuspendedBySignal((ICDISignalReceived)reason);
            } else {
                this.fireSuspendEvent(16);
            }
        }
    }

    private void syncWithBackend() {
        ICDIThread cdiThread = this.getCDIThread();
        if (cdiThread == null) {
            return;
        }
        ICDIThread currentThread = null;
        try {
            currentThread = cdiThread.getTarget().getCurrentThread();
        }
        catch (CDIException cDIException) {
            // empty catch block
        }
        this.setCurrent(cdiThread.equals(currentThread));
    }
}

