/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.sourcelookup.AbsolutePathSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.CProjectSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.IMappingSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ProgramRelativePathSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupParticipant;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;

public class CSourceLookupDirector
extends AbstractSourceLookupDirector {
    private static Set<String> fSupportedTypes;
    private static Object fSupportedTypesLock;

    static {
        fSupportedTypesLock = new Object();
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new CSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        this.readSupportedContainerTypes();
        return fSupportedTypes.contains(type.getId());
    }

    public boolean contains(String source) {
        ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
        int n = iSourceContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer cont = iSourceContainerArray[n2];
            if (this.contains(cont, source)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(ICBreakpoint breakpoint) {
        try {
            String handle = breakpoint.getSourceHandle();
            ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ISourceContainer cont = iSourceContainerArray[n2];
                if (this.contains(cont, handle)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public boolean contains(IProject project) {
        ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
        int n = iSourceContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer cont = iSourceContainerArray[n2];
            if (this.contains(cont, project)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contains(ISourceContainer container, IProject project) {
        if (container instanceof CProjectSourceContainer && project.equals((Object)((CProjectSourceContainer)container).getProject())) {
            return true;
        }
        if (container instanceof ProjectSourceContainer && project.equals((Object)((ProjectSourceContainer)container).getProject())) {
            return true;
        }
        try {
            ISourceContainer[] iSourceContainerArray = container.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ISourceContainer cont = iSourceContainerArray[n2];
                if (this.contains(cont, project)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean contains(ISourceContainer container, String sourceName) {
        IProject project;
        Path path = new Path(sourceName);
        if (!path.isValidPath(sourceName)) {
            return false;
        }
        if (container instanceof IMappingSourceContainer) {
            if (((IMappingSourceContainer)container).getCompilationPath(sourceName) == null) return false;
            return true;
        }
        if (container instanceof CProjectSourceContainer) {
            IPath projPath;
            project = ((CProjectSourceContainer)container).getProject();
            if (project != null && (projPath = project.getLocation()) != null && projPath.isPrefixOf((IPath)path)) {
                IFile file = ((CProjectSourceContainer)container).getProject().getFile(path.removeFirstSegments(projPath.segmentCount()));
                if (file == null) return false;
                if (!file.exists()) return false;
                return true;
            }
        } else if (container instanceof ProjectSourceContainer) {
            project = ((ProjectSourceContainer)container).getProject();
            IPath projPath = project.getLocation();
            if (projPath != null && projPath.isPrefixOf((IPath)path)) {
                IFile file = ((ProjectSourceContainer)container).getProject().getFile(path.removeFirstSegments(projPath.segmentCount()));
                if (file == null) return false;
                if (!file.exists()) return false;
                return true;
            }
        } else if (container instanceof FolderSourceContainer) {
            IContainer folder = ((FolderSourceContainer)container).getContainer();
            IPath folderPath = folder.getLocation();
            if (folderPath != null && folderPath.isPrefixOf((IPath)path)) {
                IFile file = ((FolderSourceContainer)container).getContainer().getFile(path.removeFirstSegments(folderPath.segmentCount()));
                if (file == null) return false;
                if (!file.exists()) return false;
                return true;
            }
        } else if (container instanceof DirectorySourceContainer) {
            File dir = ((DirectorySourceContainer)container).getDirectory();
            boolean searchSubfolders = ((DirectorySourceContainer)container).isComposite();
            Path dirPath = new Path(dir.getAbsolutePath());
            if (searchSubfolders) return dirPath.isPrefixOf((IPath)path);
            if (dirPath.segmentCount() + 1 == path.segmentCount()) {
                return dirPath.isPrefixOf((IPath)path);
            }
        } else {
            if (container instanceof AbsolutePathSourceContainer) {
                return ((AbsolutePathSourceContainer)container).isValidAbsoluteFilePath(sourceName);
            }
            if (container instanceof ProgramRelativePathSourceContainer) {
                try {
                    Object[] elements = ((ProgramRelativePathSourceContainer)container).findSourceElements(sourceName);
                    if (elements.length <= 0) return false;
                    return true;
                }
                catch (CoreException e) {
                    return false;
                }
            }
        }
        try {
            ISourceContainer[] iSourceContainerArray = container.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ISourceContainer cont = iSourceContainerArray[n2];
                if (this.contains(cont, sourceName)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public IPath getCompilationPath(String sourceName) {
        ISourceContainer[] iSourceContainerArray = this.getSourceContainers();
        int n = iSourceContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceContainer container = iSourceContainerArray[n2];
            IPath path = SourceUtils.getCompilationPath(container, sourceName);
            if (path != null) {
                return path;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSupportedContainerTypes() {
        Object object = fSupportedTypesLock;
        synchronized (object) {
            if (fSupportedTypes == null) {
                fSupportedTypes = new HashSet<String>();
                String name = "org.eclipse.cdt.debug.core.supportedSourceContainerTypes";
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(name);
                if (extensionPoint != null) {
                    IExtension[] iExtensionArray = extensionPoint.getExtensions();
                    int n = iExtensionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                        int n3 = iConfigurationElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement configurationElements = iConfigurationElementArray[n4];
                            String id = configurationElements.getAttribute("id");
                            if (id != null) {
                                fSupportedTypes.add(id);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

