/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.graphic.RevisionGraphEditor;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.RevisionRootNode;
import org.eclipse.team.svn.revision.graph.graphic.SearchOptions;
import org.eclipse.team.svn.revision.graph.graphic.editpart.GraphScalableRootEditPart;
import org.eclipse.team.svn.revision.graph.graphic.editpart.RevisionEditPart;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.utility.UserInputHistory;

public class FindRevisionNodeDialog
extends Dialog {
    protected Composite parent;
    protected RevisionGraphEditor graphEditor;
    protected SearchOptions searchOptions;
    protected List<RevisionEditPart> searchResult;
    protected Label statusLabel;
    protected Combo revisionCombo;
    protected Combo pathCombo;
    protected Button nextButton;
    protected Button previousButton;
    protected UserInputHistory pathHistory;
    protected UserInputHistory revisionHistory;
    protected static final Comparator<RevisionEditPart> nodesComparator = new Comparator<RevisionEditPart>(){

        @Override
        public int compare(RevisionEditPart r1, RevisionEditPart r2) {
            int result;
            Rectangle b1 = r1.getFigure().getBounds();
            Rectangle b2 = r2.getFigure().getBounds();
            int y1 = b1.y + b1.height;
            int y2 = b2.y + b2.height;
            int x1 = b1.x;
            int x2 = b2.x;
            int n = y1 < y2 ? 1 : (result = y1 > y2 ? -1 : 0);
            if (result == 0) {
                result = x1 < x2 ? -1 : (x1 > x2 ? 1 : 0);
            }
            return result;
        }
    };

    public FindRevisionNodeDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() ^ 0x10000 | 0x10);
        this.setBlockOnOpen(false);
        this.pathHistory = new UserInputHistory("findDialogPath");
        this.revisionHistory = new UserInputHistory("findDialogRevision");
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite mainComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.verticalSpacing = 0;
        mainComposite.setLayout((Layout)layout);
        data = new GridData(1808);
        mainComposite.setLayoutData((Object)data);
        Dialog.applyDialogFont((Control)mainComposite);
        this.initializeDialogUnits((Control)mainComposite);
        Composite mainPanel = this.createMainPanel(mainComposite);
        this.dialogArea = mainPanel;
        data = new GridData(1808);
        data.widthHint = this.getPrefferedSize().x;
        this.dialogArea.setLayoutData((Object)data);
        this.parent = mainPanel;
        Composite buttonPanel = this.createButtonSection(mainComposite);
        data = new GridData();
        data.horizontalAlignment = 131072;
        data.verticalAlignment = 1024;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        buttonPanel.setLayoutData((Object)data);
        Composite statusPanel = this.createStatusAndCloseButton(mainComposite);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1024;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.verticalIndent = 5;
        statusPanel.setLayoutData((Object)data);
        org.eclipse.swt.graphics.Point defaultSize = this.dialogArea.getShell().computeSize(-1, -1, true);
        data = (GridData)this.dialogArea.getLayoutData();
        int defaultHeightHint = data.heightHint;
        data.heightHint = this.getPrefferedSize().y;
        this.dialogArea.setLayoutData((Object)data);
        org.eclipse.swt.graphics.Point prefferedSize = this.dialogArea.getShell().computeSize(-1, -1, true);
        if (prefferedSize.y < defaultSize.y) {
            data.heightHint = defaultHeightHint;
            this.dialogArea.setLayoutData((Object)data);
        }
        return mainComposite;
    }

    public final org.eclipse.swt.graphics.Point getPrefferedSize() {
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        int width = SVNTeamPreferences.getDialogInt((IPreferenceStore)store, (String)(String.valueOf(this.getDialogID()) + ".width"));
        int height = SVNTeamPreferences.getDialogInt((IPreferenceStore)store, (String)(String.valueOf(this.getDialogID()) + ".height"));
        org.eclipse.swt.graphics.Point prefSize = this.getPrefferedSizeImpl();
        width = Math.max(width, prefSize.x);
        height = Math.max(height, prefSize.y);
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    protected org.eclipse.swt.graphics.Point getPrefferedSizeImpl() {
        return new org.eclipse.swt.graphics.Point(100, 80);
    }

    protected String getDialogID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.setText(SVNRevisionGraphMessages.FindRevisionNodeDialog_Find);
        this.validate();
    }

    protected Composite createMainPanel(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite panel = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindRevisionNodeDialog.this.validate();
            }
        };
        Label pathLabel = new Label(panel, 0);
        pathLabel.setLayoutData((Object)new GridData());
        pathLabel.setText(SVNRevisionGraphMessages.FindRevisionNodeDialog_Path);
        this.pathCombo = new Combo(panel, 2052);
        data = new GridData(768);
        this.pathCombo.setLayoutData((Object)data);
        this.pathCombo.addModifyListener(listener);
        this.pathCombo.setVisibleItemCount(this.pathHistory.getDepth());
        this.pathCombo.setItems(this.pathHistory.getHistory());
        if (this.pathHistory.getDepth() > 0) {
            this.pathCombo.select(0);
        }
        Label revisionLabel = new Label(panel, 0);
        revisionLabel.setLayoutData((Object)new GridData());
        revisionLabel.setText(SVNRevisionGraphMessages.FindRevisionNodeDialog_Revision);
        this.revisionCombo = new Combo(panel, 2052);
        data = new GridData(768);
        this.revisionCombo.setLayoutData((Object)data);
        this.revisionCombo.addModifyListener(listener);
        this.revisionCombo.setVisibleItemCount(this.revisionHistory.getDepth());
        this.revisionCombo.setItems(this.revisionHistory.getHistory());
        if (this.revisionHistory.getDepth() > 0) {
            this.revisionCombo.select(0);
        }
        return panel;
    }

    protected Composite createButtonSection(Composite parent) {
        GridLayout layout = null;
        Composite panel = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        this.nextButton = this.createButton(panel, SVNRevisionGraphMessages.FindRevisionNodeDialog_Next, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindRevisionNodeDialog.this.findNext();
            }
        });
        parent.getShell().setDefaultButton(this.nextButton);
        this.previousButton = this.createButton(panel, SVNRevisionGraphMessages.FindRevisionNodeDialog_Previous, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindRevisionNodeDialog.this.findPrevious();
            }
        });
        return panel;
    }

    protected Composite createStatusAndCloseButton(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite panel = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        this.statusLabel = new Label(panel, 16384);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 0x1000000;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        this.statusLabel.setLayoutData((Object)data);
        Button closeButton = this.createButton(panel, SVNRevisionGraphMessages.FindRevisionNodeDialog_Close, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindRevisionNodeDialog.this.close();
            }
        });
        data = (GridData)closeButton.getLayoutData();
        data.horizontalAlignment = 131072;
        data.verticalAlignment = 1024;
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        return panel;
    }

    protected Button createButton(Composite parent, String text, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setText(text);
        GridData data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth((Button)button);
        button.setLayoutData((Object)data);
        button.addSelectionListener(listener);
        return button;
    }

    public void updateTarget(RevisionGraphEditor graphEditor) {
        if (this.graphEditor != graphEditor) {
            this.graphEditor = graphEditor;
            this.validate();
            this.resetSearchData();
        }
    }

    public void changeGraphModel() {
        this.resetSearchData();
    }

    protected void resetSearchData() {
        this.searchOptions = null;
        this.searchResult = null;
    }

    protected void findNext() {
        this.find(true);
    }

    protected void findPrevious() {
        this.find(false);
    }

    protected void find(boolean goNext) {
        this.doFind();
        if (!this.searchResult.isEmpty()) {
            int resultIndex;
            RevisionEditPart selection = null;
            List rawSelectedParts = this.graphEditor.getViewer().getSelectedEditParts();
            if (!rawSelectedParts.isEmpty()) {
                ArrayList<RevisionEditPart> selectedParts = new ArrayList<RevisionEditPart>();
                for (Object raw : rawSelectedParts) {
                    if (!(raw instanceof RevisionEditPart)) continue;
                    selectedParts.add((RevisionEditPart)raw);
                }
                if (!selectedParts.isEmpty()) {
                    Collections.sort(selectedParts, nodesComparator);
                    RevisionEditPart revisionEditPart = selection = goNext ? (RevisionEditPart)selectedParts.get(0) : (RevisionEditPart)selectedParts.get(selectedParts.size() - 1);
                }
            }
            if (selection != null) {
                int selectionIndex = Collections.binarySearch(this.searchResult, selection, nodesComparator);
                if (selectionIndex >= 0) {
                    resultIndex = goNext ? selectionIndex - 1 : selectionIndex + 1;
                } else {
                    selectionIndex = -(selectionIndex + 1);
                    int n = resultIndex = goNext ? selectionIndex - 1 : selectionIndex;
                }
                if (resultIndex == -1) {
                    resultIndex = this.searchResult.size() - 1;
                } else if (resultIndex == this.searchResult.size()) {
                    resultIndex = 0;
                }
            } else {
                resultIndex = goNext ? this.searchResult.size() - 1 : 0;
            }
            RevisionEditPart result = this.searchResult.get(resultIndex);
            this.showResult(result);
        } else {
            this.showNoResults();
        }
    }

    protected void doFind() {
        SearchOptions newOptions = this.getSearchOptions();
        if (!newOptions.equals(this.searchOptions)) {
            this.searchOptions = newOptions;
            this.pathHistory.addLine(this.pathCombo.getText());
            this.revisionHistory.addLine(this.revisionCombo.getText());
            RevisionRootNode rootNode = (RevisionRootNode)this.graphEditor.getModel();
            RevisionNode[] nodes = rootNode.search(newOptions);
            Map editPartRegistry = this.graphEditor.getViewer().getEditPartRegistry();
            this.searchResult = new ArrayList<RevisionEditPart>();
            RevisionNode[] revisionNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                RevisionNode node = revisionNodeArray[n2];
                RevisionEditPart editPart = (RevisionEditPart)editPartRegistry.get(node);
                if (editPart != null) {
                    this.searchResult.add(editPart);
                }
                ++n2;
            }
            Collections.sort(this.searchResult, nodesComparator);
        }
    }

    protected void showNoResults() {
        this.statusLabel.setText(SVNRevisionGraphMessages.FindRevisionNodeDialog_NotFound);
    }

    protected void showResult(RevisionEditPart editPart) {
        this.graphEditor.getViewer().select((EditPart)editPart);
        IFigure figure = editPart.getFigure();
        GraphScalableRootEditPart rootEditPart = (GraphScalableRootEditPart)this.graphEditor.getViewer().getRootEditPart();
        Viewport viewport = (Viewport)rootEditPart.getFigure();
        Point viewportLocation = viewport.getViewLocation();
        Point point = figure.getBounds().getLocation();
        figure.translateToAbsolute((Translatable)point);
        Point newViewportLocation = viewportLocation.getTranslated(point);
        viewport.setViewLocation(newViewportLocation);
        this.statusLabel.setText("");
    }

    public boolean close() {
        this.closeImpl();
        return super.close();
    }

    protected void closeImpl() {
        this.retainSize();
    }

    protected void retainSize() {
        org.eclipse.swt.graphics.Point size = this.parent.getSize();
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        SVNTeamPreferences.setDialogInt((IPreferenceStore)store, (String)(String.valueOf(this.getDialogID()) + ".width"), (int)size.x);
        SVNTeamPreferences.setDialogInt((IPreferenceStore)store, (String)(String.valueOf(this.getDialogID()) + ".height"), (int)size.y);
    }

    protected void validate() {
        String strRev;
        boolean enabled;
        boolean bl = enabled = this.graphEditor != null;
        if (enabled) {
            String path = this.getComboValue(this.pathCombo);
            String strRev2 = this.getComboValue(this.revisionCombo);
            boolean bl2 = enabled = path.length() > 0 || strRev2.length() > 0;
        }
        if (enabled && (strRev = this.getComboValue(this.revisionCombo)).length() > 0) {
            try {
                Long.parseLong(strRev);
            }
            catch (NumberFormatException numberFormatException) {
                enabled = false;
            }
        }
        if (this.nextButton != null && this.previousButton != null) {
            this.nextButton.setEnabled(enabled);
            this.previousButton.setEnabled(enabled);
        }
    }

    protected SearchOptions getSearchOptions() {
        long revision = -1L;
        String strRev = this.getComboValue(this.revisionCombo);
        if (strRev.length() > 0) {
            revision = Long.parseLong(strRev);
        }
        String path = this.getComboValue(this.pathCombo);
        if ((path = path.trim()).length() == 0) {
            path = null;
        }
        SearchOptions options = new SearchOptions(revision, path);
        return options;
    }

    protected String getComboValue(Combo combo) {
        String str = combo.getText();
        str = str.trim();
        return str;
    }
}

