/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic;

import java.util.ArrayList;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.figure.RevisionFigure;
import org.eclipse.team.svn.ui.utility.DateFormatter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class RevisionNodePropertySource
implements IPropertySource {
    protected static final String PATH_PROPERTY = "path";
    protected static final String REVISION_PROPERTY = "revision";
    protected static final String ACTION_PROPERTY = "action";
    protected static final String AUTHOR_PROPERTY = "author";
    protected static final String DATE_PROPERTY = "date";
    protected static final String COMMENT_PROPERTY = "comment";
    protected static final String COPIED_FROM_PROPERTY = "copiedFrom";
    protected static final String CHANGED_PATHS_PROPERTY = "changedPaths";
    protected static final String INCOMING_MERGES_PROPERTY = "incomingMerges";
    protected static final String OUTGOING_MERGES_PROPERTY = "outgoingMerges";
    protected final RevisionNode node;
    protected IPropertyDescriptor[] descriptors;

    public RevisionNodePropertySource(RevisionNode node) {
        this.node = node;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
            list.add(new PropertyDescriptor((Object)PATH_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_Path));
            list.add(new PropertyDescriptor((Object)REVISION_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_Revision));
            list.add(new PropertyDescriptor((Object)ACTION_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_Action));
            list.add(new PropertyDescriptor((Object)AUTHOR_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_Author));
            list.add(new PropertyDescriptor((Object)DATE_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_Date));
            list.add(new PropertyDescriptor((Object)COMMENT_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_Comment));
            if (this.node.getCopiedFrom() != null) {
                list.add(new PropertyDescriptor((Object)COPIED_FROM_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_CopiedFrom));
            }
            list.add(new PropertyDescriptor((Object)CHANGED_PATHS_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_ChangedPaths));
            if (this.node.hasIncomingMerges()) {
                list.add(new PropertyDescriptor((Object)INCOMING_MERGES_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_IncomingMerges));
            }
            if (this.node.hasOutgoingMerges()) {
                list.add(new PropertyDescriptor((Object)OUTGOING_MERGES_PROPERTY, SVNRevisionGraphMessages.RevisionNodePropertySource_OutgoingMerges));
            }
            this.descriptors = list.toArray(new IPropertyDescriptor[0]);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (PATH_PROPERTY.equals(id)) {
            return this.node.getPath();
        }
        if (REVISION_PROPERTY.equals(id)) {
            return this.node.getRevision();
        }
        if (ACTION_PROPERTY.equals(id)) {
            return RevisionFigure.getActionAsString(this.node.getAction());
        }
        if (AUTHOR_PROPERTY.equals(id)) {
            return this.node.getAuthor();
        }
        if (DATE_PROPERTY.equals(id)) {
            long date = this.node.getDate();
            return date == 0L ? SVNMessages.SVNInfo_NoDate : DateFormatter.formatDate((long)date);
        }
        if (COMMENT_PROPERTY.equals(id)) {
            return this.node.getMessage();
        }
        if (COPIED_FROM_PROPERTY.equals(id)) {
            RevisionNode copiedFrom = this.node.getCopiedFrom();
            if (copiedFrom != null) {
                return String.valueOf(copiedFrom.getPath()) + "@" + copiedFrom.getRevision();
            }
        } else {
            if (CHANGED_PATHS_PROPERTY.equals(id)) {
                return RevisionFigure.getChangedPathsAsString(this.node);
            }
            if (INCOMING_MERGES_PROPERTY.equals(id)) {
                return RevisionFigure.getIncomingMergesAsString(this.node);
            }
            if (OUTGOING_MERGES_PROPERTY.equals(id)) {
                return RevisionFigure.getOutgoingMergesAsString(this.node);
            }
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

