/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.figure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;

public class ExpandCollapseDecoration {
    public static final Image MINUS_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/minus.gif").createImage();
    public static final Image PLUS_IMAGE;
    protected static final Dimension IMAGE_SIZE;
    protected static final int EDGE_SPACING = 2;
    protected final RevisionNode revisionNode;
    protected IFigure parent;
    protected Figure decoratedFigure;
    protected boolean isShowExpanded;
    protected boolean isShowCollapsed;
    protected RevisionNode rename;
    protected List<RevisionNode> onlyCopyTo;
    protected ImageFigure topFigure;
    protected ImageFigure rightFigure;
    protected ImageFigure bottomFigure;
    protected Point topLocation;
    protected Point rightLocation;
    protected Point bottomLocation;
    protected MouseMotionListener figureMouseListener = new MouseMotionListener.Stub(){

        public void mouseExited(MouseEvent me) {
            ExpandCollapseDecoration.this.showExpanded(false);
        }
    };

    static {
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)MINUS_IMAGE);
        PLUS_IMAGE = SVNRevisionGraphPlugin.instance().getImageDescriptor("icons/plus.gif").createImage();
        SVNRevisionGraphPlugin.disposeOnShutdown((Resource)PLUS_IMAGE);
        IMAGE_SIZE = new Rectangle(MINUS_IMAGE.getBounds()).getSize();
    }

    public ExpandCollapseDecoration(RevisionNode revisionNode, IFigure parent) {
        this.revisionNode = revisionNode;
        this.parent = parent;
        this.isShowCollapsed = true;
        this.isShowExpanded = false;
    }

    protected void updateControls() {
        this.removeDecoration();
        this.addTopFigure();
        this.addRightFigure();
        this.addBottomFigure();
    }

    protected boolean isApplicableStatus(Status status) {
        return status == Status.COLLAPSED && this.isShowCollapsed || status == Status.EXPANDED && this.isShowExpanded;
    }

    protected void addTopFigure() {
        final Status status = this.getTopStatus();
        if (this.isApplicableStatus(status)) {
            this.topFigure = new ImageFigure();
            this.parent.add((IFigure)this.topFigure);
            this.topFigure.setImage(ExpandCollapseDecoration.getIcon(status));
            this.topFigure.setBounds(new Rectangle(this.topLocation, IMAGE_SIZE));
            this.topFigure.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    me.consume();
                    ExpandCollapseDecoration.this.processTop(status);
                }
            });
            this.topFigure.addMouseMotionListener(this.figureMouseListener);
        }
    }

    protected void processTop(Status status) {
        boolean isCollapsed;
        boolean bl = isCollapsed = status == Status.COLLAPSED;
        if (isCollapsed) {
            if (this.revisionNode.isNextCollapsed()) {
                this.revisionNode.setNextCollapsed(false);
            } else {
                this.revisionNode.setRenameCollapsed(false);
            }
        } else if (this.rename != null) {
            this.revisionNode.setRenameCollapsed(true);
        } else {
            this.revisionNode.setNextCollapsed(true);
        }
    }

    protected Status getTopStatus() {
        Status status = Status.NONE;
        if (this.revisionNode.isNextCollapsed() || this.revisionNode.isRenameCollapsed()) {
            status = Status.COLLAPSED;
        } else if (this.revisionNode.getNext() != null || this.rename != null) {
            status = Status.EXPANDED;
        }
        return status;
    }

    protected Point getTopLocation() {
        Rectangle bounds = this.decoratedFigure.getClientArea();
        Point midTop = bounds.getTop();
        Point result = new Point(midTop.x - ExpandCollapseDecoration.IMAGE_SIZE.width / 2, midTop.y + 2);
        return result;
    }

    protected void addRightFigure() {
        final Status status = this.getRightStatus();
        if (this.isApplicableStatus(status)) {
            this.rightFigure = new ImageFigure();
            this.parent.add((IFigure)this.rightFigure);
            this.rightFigure.setImage(ExpandCollapseDecoration.getIcon(status));
            this.rightFigure.setBounds(new Rectangle(this.rightLocation, IMAGE_SIZE));
            this.rightFigure.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    me.consume();
                    ExpandCollapseDecoration.this.processRight(status);
                }
            });
            this.rightFigure.addMouseMotionListener(this.figureMouseListener);
        }
    }

    protected Status getRightStatus() {
        Status status = Status.NONE;
        if (this.revisionNode.isCopiedToCollapsed()) {
            status = Status.COLLAPSED;
        } else if (!this.onlyCopyTo.isEmpty()) {
            status = Status.EXPANDED;
        }
        return status;
    }

    protected void processRight(Status status) {
        boolean isCollapsed = status == Status.COLLAPSED;
        this.revisionNode.setCopiedToCollapsed(!isCollapsed);
    }

    protected Point getRightLocation() {
        Rectangle bounds = this.decoratedFigure.getClientArea();
        Point midRight = bounds.getRight();
        Point result = new Point(midRight.x - ExpandCollapseDecoration.IMAGE_SIZE.width - 2, midRight.y - ExpandCollapseDecoration.IMAGE_SIZE.height / 2);
        return result;
    }

    protected void addBottomFigure() {
        final Status status = this.getBottomStatus();
        if (this.isApplicableStatus(status)) {
            this.bottomFigure = new ImageFigure();
            this.parent.add((IFigure)this.bottomFigure);
            this.bottomFigure.setImage(ExpandCollapseDecoration.getIcon(status));
            this.bottomFigure.setBounds(new Rectangle(this.bottomLocation, IMAGE_SIZE));
            this.bottomFigure.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    me.consume();
                    ExpandCollapseDecoration.this.processBottom(status);
                }
            });
            this.bottomFigure.addMouseMotionListener(this.figureMouseListener);
        }
    }

    protected Status getBottomStatus() {
        Status status = Status.NONE;
        if (this.revisionNode.isPreviousCollapsed() || this.revisionNode.isCopiedFromCollapsed()) {
            status = Status.COLLAPSED;
        } else if (this.revisionNode.getPrevious() != null || this.revisionNode.getCopiedFrom() != null) {
            status = Status.EXPANDED;
        }
        return status;
    }

    protected void processBottom(Status status) {
        boolean isCollapsed;
        boolean bl = isCollapsed = status == Status.COLLAPSED;
        if (isCollapsed) {
            if (this.revisionNode.isPreviousCollapsed()) {
                this.revisionNode.setPreviousCollapsed(false);
            } else {
                this.revisionNode.setCopiedFromCollapsed(false);
            }
        } else if (this.revisionNode.getPrevious() != null) {
            this.revisionNode.setPreviousCollapsed(true);
        } else {
            this.revisionNode.setCopiedFromCollapsed(true);
        }
    }

    protected Point getBottomLocation() {
        Rectangle bounds = this.decoratedFigure.getClientArea();
        Point bottomTop = bounds.getBottom();
        Point result = new Point(bottomTop.x - ExpandCollapseDecoration.IMAGE_SIZE.width / 2, bottomTop.y - ExpandCollapseDecoration.IMAGE_SIZE.height - 2);
        return result;
    }

    public boolean containsPoint(Point point) {
        if (this.topFigure != null && ExpandCollapseDecoration.isFigureContainsPoint((IFigure)this.topFigure, point)) {
            return true;
        }
        if (this.rightFigure != null && ExpandCollapseDecoration.isFigureContainsPoint((IFigure)this.rightFigure, point)) {
            return true;
        }
        return this.bottomFigure != null && ExpandCollapseDecoration.isFigureContainsPoint((IFigure)this.bottomFigure, point);
    }

    public static boolean isFigureContainsPoint(IFigure figure, Point point) {
        int x = point.x;
        int y = point.y;
        Rectangle bounds = figure.getBounds();
        return y >= bounds.y && y <= bounds.y + bounds.height && x >= bounds.x && x <= bounds.x + bounds.width;
    }

    protected static Image getIcon(Status status) {
        return status == Status.COLLAPSED ? PLUS_IMAGE : (status == Status.EXPANDED ? MINUS_IMAGE : null);
    }

    public void setDecoratedFigure(Figure decoratedFigure) {
        this.decoratedFigure = decoratedFigure;
        this.onlyCopyTo = null;
        this.rename = null;
        this.onlyCopyTo = new ArrayList<RevisionNode>();
        RevisionNode[] revisionNodeArray = this.revisionNode.getCopiedTo();
        int n = revisionNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RevisionNode node = revisionNodeArray[n2];
            if (node.getAction() == PathRevision.RevisionNodeAction.RENAME) {
                this.rename = node;
            } else {
                this.onlyCopyTo.add(node);
            }
            ++n2;
        }
        this.topLocation = this.getTopLocation();
        this.rightLocation = this.getRightLocation();
        this.bottomLocation = this.getBottomLocation();
        this.updateControls();
    }

    public void showExpanded(boolean isShowExpanded) {
        this.internalShowExpanded(isShowExpanded);
        this.updateControls();
    }

    public void internalShowExpanded(boolean isShowExpanded) {
        this.isShowExpanded = isShowExpanded;
    }

    public void removeDecoration() {
        if (this.topFigure != null) {
            this.parent.remove((IFigure)this.topFigure);
            this.topFigure = null;
        }
        if (this.rightFigure != null) {
            this.parent.remove((IFigure)this.rightFigure);
            this.rightFigure = null;
        }
        if (this.bottomFigure != null) {
            this.parent.remove((IFigure)this.bottomFigure);
            this.bottomFigure = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Status {
        EXPANDED,
        COLLAPSED,
        NONE;

    }
}

