/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.layout;

import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;
import org.eclipse.team.svn.revision.graph.graphic.layout.AbstractLayoutCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetInitialLocationCommand
extends AbstractLayoutCommand {
    public SetInitialLocationCommand(RevisionNode startNode) {
        super(startNode);
    }

    @Override
    public void run() {
        this.startNode.setX(0);
        this.startNode.setY(0);
        LinkedList<RevisionNode> queue = new LinkedList<RevisionNode>();
        queue.add(this.startNode);
        RevisionNode node = null;
        while ((node = (RevisionNode)queue.poll()) != null) {
            this.processCopyTo(node, queue);
            RevisionNode previous = node;
            while (previous.getNext() != null) {
                RevisionNode next = previous.getNext();
                next.setX(previous.getX());
                next.setY(previous.getY() + previous.getHeight() + 4);
                previous = next;
                this.processCopyTo(next, queue);
            }
        }
    }

    protected void processCopyTo(RevisionNode node, Queue<RevisionNode> queue) {
        RevisionNode[] copiedTos = node.getCopiedTo();
        if (copiedTos.length > 0) {
            int column = node.getX();
            int row = node.getY();
            int copyToCount = 0;
            int i = 0;
            while (i < copiedTos.length) {
                RevisionNode copiedTo = copiedTos[i];
                int nextNodeColumn = copiedTo.getAction() == PathRevision.RevisionNodeAction.RENAME ? column : column + ++copyToCount;
                copiedTo.setX(nextNodeColumn);
                copiedTo.setY(row + node.getHeight() + 4);
                queue.offer(copiedTo);
                ++i;
            }
        }
    }
}

