/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model;

import org.eclipse.cdt.core.settings.model.ACSettingEntry;
import org.eclipse.cdt.core.settings.model.ICMacroEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.internal.core.SafeStringInterner;

public final class CMacroEntry
extends ACSettingEntry
implements ICMacroEntry {
    private final String fValue;

    public CMacroEntry(String name, String value, int flags) {
        super(name, flags);
        String val = SafeStringInterner.safeIntern(value);
        this.fValue = val != null ? val : "";
    }

    @Override
    public String getValue() {
        return this.fValue;
    }

    @Override
    public final int getKind() {
        return 4;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMacroEntry other = (CMacroEntry)obj;
        return !(this.fValue == null ? other.fValue != null : !this.fValue.equals(other.fValue));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fValue == null ? 0 : this.fValue.hashCode());
        return result;
    }

    @Override
    public boolean equalsByContents(ICSettingEntry entry) {
        if (!super.equalsByContents(entry)) {
            return false;
        }
        return this.fValue.equals(((CMacroEntry)entry).fValue);
    }

    @Override
    protected String contentsToString() {
        return new StringBuffer().append(this.getName()).append('=').append(this.fValue).toString();
    }
}

