/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.javahl;

import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.CommitInfo;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.ISVNRepos;
import org.apache.subversion.javahl.ReposNotifyInformation;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.ConflictResolverCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.PatchCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.callback.ReposNotifyCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Checksum;
import org.apache.subversion.javahl.types.ConflictVersion;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.Status;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNConflictResolutionCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNPatchCallback;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.ISVNRepositoryMessageCallback;
import org.eclipse.team.svn.core.connector.ISVNRepositoryNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNAnnotationData;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNChecksum;
import org.eclipse.team.svn.core.connector.SVNCommitStatus;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConflictResolution;
import org.eclipse.team.svn.core.connector.SVNConflictVersion;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNLock;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNMergeInfo;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRepositoryNotification;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConversionUtility {
    private static Map<ClientNotifyInformation.Action, SVNNotification.PerformedAction> notifyInfoActionMap;
    private static Map<ClientNotifyInformation.Status, SVNNotification.NodeStatus> notifyInfoStatusMap;
    private static Map<ClientNotifyInformation.LockStatus, SVNNotification.NodeLock> notifyInfoLockStatusMap;
    private static Map<NodeKind, SVNEntry.Kind> nodeKindMap;
    private static Map<ConflictDescriptor.Reason, SVNConflictDescriptor.Reason> conflictReasonMap;
    private static Map<Status.Kind, SVNEntryStatus.Kind> syncStatusMap;
    private static Map<ReposNotifyInformation.NodeAction, SVNRepositoryNotification.NodeAction> repositoryNodeActionMap;
    private static Map<ReposNotifyInformation.Action, SVNRepositoryNotification.Action> repositoryActionMap;

    static {
        syncStatusMap = new HashMap<Status.Kind, SVNEntryStatus.Kind>();
        syncStatusMap.put(Status.Kind.none, SVNEntryStatus.Kind.NONE);
        syncStatusMap.put(Status.Kind.unversioned, SVNEntryStatus.Kind.UNVERSIONED);
        syncStatusMap.put(Status.Kind.normal, SVNEntryStatus.Kind.NORMAL);
        syncStatusMap.put(Status.Kind.added, SVNEntryStatus.Kind.ADDED);
        syncStatusMap.put(Status.Kind.missing, SVNEntryStatus.Kind.MISSING);
        syncStatusMap.put(Status.Kind.deleted, SVNEntryStatus.Kind.DELETED);
        syncStatusMap.put(Status.Kind.replaced, SVNEntryStatus.Kind.REPLACED);
        syncStatusMap.put(Status.Kind.modified, SVNEntryStatus.Kind.MODIFIED);
        syncStatusMap.put(Status.Kind.merged, SVNEntryStatus.Kind.MERGED);
        syncStatusMap.put(Status.Kind.conflicted, SVNEntryStatus.Kind.CONFLICTED);
        syncStatusMap.put(Status.Kind.ignored, SVNEntryStatus.Kind.IGNORED);
        syncStatusMap.put(Status.Kind.obstructed, SVNEntryStatus.Kind.OBSTRUCTED);
        syncStatusMap.put(Status.Kind.external, SVNEntryStatus.Kind.EXTERNAL);
        syncStatusMap.put(Status.Kind.incomplete, SVNEntryStatus.Kind.INCOMPLETE);
        conflictReasonMap = new HashMap<ConflictDescriptor.Reason, SVNConflictDescriptor.Reason>();
        conflictReasonMap.put(ConflictDescriptor.Reason.edited, SVNConflictDescriptor.Reason.MODIFIED);
        conflictReasonMap.put(ConflictDescriptor.Reason.obstructed, SVNConflictDescriptor.Reason.OBSTRUCTED);
        conflictReasonMap.put(ConflictDescriptor.Reason.deleted, SVNConflictDescriptor.Reason.DELETED);
        conflictReasonMap.put(ConflictDescriptor.Reason.missing, SVNConflictDescriptor.Reason.MISSING);
        conflictReasonMap.put(ConflictDescriptor.Reason.unversioned, SVNConflictDescriptor.Reason.UNVERSIONED);
        conflictReasonMap.put(ConflictDescriptor.Reason.added, SVNConflictDescriptor.Reason.ADDED);
        conflictReasonMap.put(ConflictDescriptor.Reason.replaced, SVNConflictDescriptor.Reason.REPLACED);
        nodeKindMap = new HashMap<NodeKind, SVNEntry.Kind>();
        nodeKindMap.put(NodeKind.none, SVNEntry.Kind.NONE);
        nodeKindMap.put(NodeKind.file, SVNEntry.Kind.FILE);
        nodeKindMap.put(NodeKind.dir, SVNEntry.Kind.DIR);
        nodeKindMap.put(NodeKind.unknown, SVNEntry.Kind.UNKNOWN);
        notifyInfoStatusMap = new HashMap<ClientNotifyInformation.Status, SVNNotification.NodeStatus>();
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.inapplicable, SVNNotification.NodeStatus.INAPPLICABLE);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.unknown, SVNNotification.NodeStatus.UNKNOWN);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.unchanged, SVNNotification.NodeStatus.UNCHANGED);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.missing, SVNNotification.NodeStatus.MISSING);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.obstructed, SVNNotification.NodeStatus.OBSTRUCTED);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.changed, SVNNotification.NodeStatus.CHANGED);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.merged, SVNNotification.NodeStatus.MERGED);
        notifyInfoStatusMap.put(ClientNotifyInformation.Status.conflicted, SVNNotification.NodeStatus.CONFLICTED);
        notifyInfoLockStatusMap = new HashMap<ClientNotifyInformation.LockStatus, SVNNotification.NodeLock>();
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.inapplicable, SVNNotification.NodeLock.INAPPLICABLE);
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.unknown, SVNNotification.NodeLock.UNKNOWN);
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.unchanged, SVNNotification.NodeLock.UNCHANGED);
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.locked, SVNNotification.NodeLock.LOCKED);
        notifyInfoLockStatusMap.put(ClientNotifyInformation.LockStatus.unlocked, SVNNotification.NodeLock.UNLOCKED);
        notifyInfoActionMap = new HashMap<ClientNotifyInformation.Action, SVNNotification.PerformedAction>();
        notifyInfoActionMap.put(ClientNotifyInformation.Action.add, SVNNotification.PerformedAction.ADD);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.copy, SVNNotification.PerformedAction.COPY);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.delete, SVNNotification.PerformedAction.DELETE);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.restore, SVNNotification.PerformedAction.RESTORE);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.revert, SVNNotification.PerformedAction.REVERT);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_revert, SVNNotification.PerformedAction.FAILED_REVERT);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.resolved, SVNNotification.PerformedAction.RESOLVED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.skip, SVNNotification.PerformedAction.SKIP);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_delete, SVNNotification.PerformedAction.UPDATE_DELETE);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_add, SVNNotification.PerformedAction.UPDATE_ADD);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_update, SVNNotification.PerformedAction.UPDATE_UPDATE);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_completed, SVNNotification.PerformedAction.UPDATE_COMPLETED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_external, SVNNotification.PerformedAction.UPDATE_EXTERNAL);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.status_completed, SVNNotification.PerformedAction.STATUS_COMPLETED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.status_external, SVNNotification.PerformedAction.STATUS_EXTERNAL);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_modified, SVNNotification.PerformedAction.COMMIT_MODIFIED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_added, SVNNotification.PerformedAction.COMMIT_ADDED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_deleted, SVNNotification.PerformedAction.COMMIT_DELETED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_replaced, SVNNotification.PerformedAction.COMMIT_REPLACED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_postfix_txdelta, SVNNotification.PerformedAction.COMMIT_POSTFIX_TXDELTA);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.blame_revision, SVNNotification.PerformedAction.BLAME_REVISION);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.locked, SVNNotification.PerformedAction.LOCKED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.unlocked, SVNNotification.PerformedAction.UNLOCKED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_lock, SVNNotification.PerformedAction.FAILED_LOCK);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_unlock, SVNNotification.PerformedAction.FAILED_UNLOCK);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.exists, SVNNotification.PerformedAction.EXISTS);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.changelist_set, SVNNotification.PerformedAction.CHANGELIST_SET);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.changelist_clear, SVNNotification.PerformedAction.CHANGELIST_CLEAR);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.changelist_moved, SVNNotification.PerformedAction.CHANGELIST_MOVED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_begin, SVNNotification.PerformedAction.MERGE_BEGIN);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.foreign_merge_begin, SVNNotification.PerformedAction.FOREIGN_MERGE_BEGIN);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_replaced, SVNNotification.PerformedAction.UPDATE_REPLACED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.property_added, SVNNotification.PerformedAction.PROPERTY_ADDED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.property_modified, SVNNotification.PerformedAction.PROPERTY_MODIFIED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.property_deleted, SVNNotification.PerformedAction.PROPERTY_DELETED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.property_deleted_nonexistent, SVNNotification.PerformedAction.PROPERTY_DELETED_NONEXISTENT);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.revprop_set, SVNNotification.PerformedAction.REVPROP_SET);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.revprop_deleted, SVNNotification.PerformedAction.REVPROP_DELETE);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_completed, SVNNotification.PerformedAction.MERGE_COMPLETED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.tree_conflict, SVNNotification.PerformedAction.TREE_CONFLICT);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_external, SVNNotification.PerformedAction.FAILED_EXTERNAL);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_started, SVNNotification.PerformedAction.UPDATE_STARTED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_skip_obstruction, SVNNotification.PerformedAction.UPDATE_SKIP_OBSTRUCTION);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_skip_working_only, SVNNotification.PerformedAction.UPDATE_SKIP_WORKING_ONLY);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_skip_access_denied, SVNNotification.PerformedAction.UPDATE_SKIP_ACCESS_DENIED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_external_removed, SVNNotification.PerformedAction.UPDATE_EXTERNAL_REMOVED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_shadowed_add, SVNNotification.PerformedAction.UPDATE_SHADOWED_ADD);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_shadowed_update, SVNNotification.PerformedAction.UPDATE_SHADOWED_UPDATE);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.update_shadowed_delete, SVNNotification.PerformedAction.UPDATE_SHADOWED_DELETE);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_record_info, SVNNotification.PerformedAction.MERGE_RECORD_INFO);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.upgraded_path, SVNNotification.PerformedAction.UPGRADED_PATH);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_record_info_begin, SVNNotification.PerformedAction.MERGE_RECORD_INFO_BEGIN);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.merge_elide_info, SVNNotification.PerformedAction.MERGE_ELIDE_INFO);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.patch, SVNNotification.PerformedAction.PATCH);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.patch_applied_hunk, SVNNotification.PerformedAction.PATCH_APPLIED_HUNK);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.patch_rejected_hunk, SVNNotification.PerformedAction.PATCH_REJECTED_HUNK);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.patch_hunk_already_applied, SVNNotification.PerformedAction.PATCH_HUNK_ALREADY_APPLIED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_copied, SVNNotification.PerformedAction.COMMIT_COPIED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.commit_copied_replaced, SVNNotification.PerformedAction.COMMIT_COPIED_REPLACED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.url_redirect, SVNNotification.PerformedAction.URL_REDIRECT);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.path_nonexistent, SVNNotification.PerformedAction.PATH_NONEXISTENT);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.exclude, SVNNotification.PerformedAction.EXCLUDE);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_conflict, SVNNotification.PerformedAction.FAILED_CONFLICT);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_missing, SVNNotification.PerformedAction.FAILED_MISSING);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_out_of_date, SVNNotification.PerformedAction.FAILED_OUT_OF_DATE);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_no_parent, SVNNotification.PerformedAction.FAILED_NO_PARENT);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_locked, SVNNotification.PerformedAction.FAILED_LOCKED);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.failed_forbidden_by_server, SVNNotification.PerformedAction.FAILED_FORBIDDEN_BY_SERVER);
        notifyInfoActionMap.put(ClientNotifyInformation.Action.skip_conflicted, SVNNotification.PerformedAction.SKIP_CONFLICTED);
        repositoryNodeActionMap = new HashMap<ReposNotifyInformation.NodeAction, SVNRepositoryNotification.NodeAction>();
        repositoryNodeActionMap.put(ReposNotifyInformation.NodeAction.change, SVNRepositoryNotification.NodeAction.CHANGE);
        repositoryNodeActionMap.put(ReposNotifyInformation.NodeAction.add, SVNRepositoryNotification.NodeAction.ADD);
        repositoryNodeActionMap.put(ReposNotifyInformation.NodeAction.deleted, SVNRepositoryNotification.NodeAction.DELETE);
        repositoryNodeActionMap.put(ReposNotifyInformation.NodeAction.replace, SVNRepositoryNotification.NodeAction.REPLACE);
        repositoryActionMap = new HashMap<ReposNotifyInformation.Action, SVNRepositoryNotification.Action>();
        repositoryActionMap.put(ReposNotifyInformation.Action.warning, SVNRepositoryNotification.Action.WARNING);
        repositoryActionMap.put(ReposNotifyInformation.Action.dump_rev_end, SVNRepositoryNotification.Action.DUMP_REV_END);
        repositoryActionMap.put(ReposNotifyInformation.Action.verify_rev_end, SVNRepositoryNotification.Action.VERIFY_REV_END);
        repositoryActionMap.put(ReposNotifyInformation.Action.pack_shard_start, SVNRepositoryNotification.Action.PACK_SHARD_START);
        repositoryActionMap.put(ReposNotifyInformation.Action.pack_shard_end, SVNRepositoryNotification.Action.PACK_SHARD_END);
        repositoryActionMap.put(ReposNotifyInformation.Action.pack_shard_start_revprop, SVNRepositoryNotification.Action.PACK_SHARD_START_REVPROP);
        repositoryActionMap.put(ReposNotifyInformation.Action.pack_shard_end_revprop, SVNRepositoryNotification.Action.PACK_SHARD_END_REVPROP);
        repositoryActionMap.put(ReposNotifyInformation.Action.load_txn_start, SVNRepositoryNotification.Action.LOAD_TXN_START);
        repositoryActionMap.put(ReposNotifyInformation.Action.load_txn_committed, SVNRepositoryNotification.Action.LOAD_TXN_COMMITTED);
        repositoryActionMap.put(ReposNotifyInformation.Action.load_node_start, SVNRepositoryNotification.Action.LOAD_NODE_START);
        repositoryActionMap.put(ReposNotifyInformation.Action.load_node_done, SVNRepositoryNotification.Action.LOAD_NODE_END);
        repositoryActionMap.put(ReposNotifyInformation.Action.load_copied_node, SVNRepositoryNotification.Action.LOAD_COPIED_NODE);
        repositoryActionMap.put(ReposNotifyInformation.Action.load_normalized_mergeinfo, SVNRepositoryNotification.Action.LOAD_NORMALIZED_MERGEINFO);
        repositoryActionMap.put(ReposNotifyInformation.Action.mutex_acquired, SVNRepositoryNotification.Action.MUTEX_ACQUIRED);
        repositoryActionMap.put(ReposNotifyInformation.Action.recover_start, SVNRepositoryNotification.Action.RECOVER_START);
        repositoryActionMap.put(ReposNotifyInformation.Action.upgrade_start, SVNRepositoryNotification.Action.UPGRADE_START);
    }

    public static ISVNRepos.MessageReceiver convert(final ISVNRepositoryMessageCallback cb) {
        return cb == null ? null : new ISVNRepos.MessageReceiver(){

            public void receiveMessageLine(String message) {
                cb.nextMessage(message);
            }
        };
    }

    public static ReposNotifyCallback convert(final ISVNRepositoryNotificationCallback cb) {
        return cb == null ? null : new ReposNotifyCallback(){

            public void onNotify(ReposNotifyInformation info) {
                cb.notify(ConversionUtility.convert(info));
            }
        };
    }

    public static SVNRepositoryNotification convert(ReposNotifyInformation info) {
        SVNRepositoryNotification.NodeAction nodeAction = repositoryNodeActionMap.get((Object)info.getNodeAction());
        SVNRepositoryNotification.Action action = repositoryActionMap.get((Object)info.getAction());
        return new SVNRepositoryNotification(info.getPath(), nodeAction == null ? SVNRepositoryNotification.NodeAction.UNKNOWN : nodeAction, action == null ? SVNRepositoryNotification.Action.UNKNOWN : action, info.getRevision(), info.getWarning(), info.getShard(), info.getNewRevision(), info.getOldRevision());
    }

    public static SVNCommitStatus convert(CommitInfo info) {
        return new SVNCommitStatus(info.getPostCommitError(), info.getReposRoot(), info.getRevision(), info.getDate() != null ? info.getDate().getTime() : 0L, info.getAuthor());
    }

    public static PatchCallback convert(final ISVNPatchCallback callback) {
        if (callback == null) {
            return null;
        }
        return new PatchCallback(){

            public boolean singlePatch(String pathFromPatchfile, String patchPath, String rejectPath) {
                return callback.singlePatch(pathFromPatchfile, patchPath, rejectPath);
            }
        };
    }

    public static ProplistCallback convert(final ISVNPropertyCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ProplistCallback(){

            @Override
            public void singlePath(String path, Map<String, byte[]> properties) {
                SVNProperty[] data = new SVNProperty[properties.size()];
                int i = 0;
                for (Map.Entry<String, byte[]> entry : properties.entrySet()) {
                    data[i] = new SVNProperty(entry.getKey(), entry.getValue());
                    ++i;
                }
                callback.next(new ISVNPropertyCallback.Pair(path, data), new ISVNPropertyCallback.Pair[0]);
            }
        };
    }

    public static Map<String, String> convertRevPropsToSVN(Map revProps) {
        if (revProps == null) {
            return null;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (Map.Entry entry : revProps.entrySet()) {
            if (entry.getKey().equals("svn:date")) {
                Date date = (Date)entry.getValue();
                retVal.put("svn:date", date == null ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z").format(date));
                continue;
            }
            retVal.put((String)entry.getKey(), (String)entry.getValue());
        }
        return retVal;
    }

    public static Map convertRevPropsFromSVN(Map<String, byte[]> revProps, DateFormat formatter, Calendar tDate) {
        if (revProps == null) {
            return null;
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        for (Map.Entry<String, byte[]> entry : revProps.entrySet()) {
            if (entry.getKey().equals("svn:date")) {
                String dateStr = new String(entry.getValue());
                if (dateStr.length() != 27 || dateStr.charAt(26) != 'Z') continue;
                try {
                    formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
                    tDate = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    tDate.setTime(formatter.parse(String.valueOf(dateStr.substring(0, 23)) + " UTC"));
                    retVal.put("svn:date", tDate.getTime());
                }
                catch (ParseException parseException) {
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            String str = null;
            try {
                str = new String(entry.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                str = new String(entry.getValue());
            }
            retVal.put(entry.getKey(), str);
        }
        return retVal;
    }

    public static LogMessageCallback convert(final ISVNLogEntryCallback callback) {
        if (callback == null) {
            return null;
        }
        return new LogMessageCallback(){
            private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
            private Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

            @Override
            public void singleMessage(Set<ChangePath> changedPaths, long revision, Map<String, byte[]> revprops, boolean hasChildren) {
                SVNLogEntry entry = this.convert(changedPaths == null ? null : changedPaths.toArray(new ChangePath[changedPaths.size()]), revision, revprops, hasChildren);
                callback.next(entry);
            }

            private SVNLogEntry convert(ChangePath[] changedPaths, long revision, Map<String, byte[]> revProps, boolean hasChildren) {
                if (revProps == null) {
                    return new SVNLogEntry(revision, 0L, null, null, ConversionUtility.convert(changedPaths), hasChildren);
                }
                Map tRevProps = ConversionUtility.convertRevPropsFromSVN(revProps, this.formatter, this.date);
                Date date = tRevProps == null ? null : (Date)tRevProps.get("svn:date");
                return new SVNLogEntry(revision, date == null ? 0L : date.getTime(), tRevProps == null ? null : (String)tRevProps.get("svn:author"), tRevProps == null ? null : (String)tRevProps.get("svn:log"), ConversionUtility.convert(changedPaths), hasChildren);
            }
        };
    }

    public static CopySource[] convert(SVNEntryRevisionReference[] info) {
        if (info == null) {
            return null;
        }
        CopySource[] retVal = new CopySource[info.length];
        int i = 0;
        while (i < info.length) {
            retVal[i] = ConversionUtility.convert(info[i]);
            ++i;
        }
        return retVal;
    }

    public static CopySource convert(SVNEntryRevisionReference info) {
        return info == null ? null : new CopySource(info.path, ConversionUtility.convert(info.revision), ConversionUtility.convert(info.pegRevision));
    }

    public static InfoCallback convert(final ISVNEntryInfoCallback callback) {
        if (callback == null) {
            return null;
        }
        return new InfoCallback(){

            public void singleInfo(Info info) {
                callback.next(ConversionUtility.convert(info));
            }
        };
    }

    public static StatusCallback convert(final ISVNEntryStatusCallback cb) {
        if (cb == null) {
            return null;
        }
        return new StatusCallback(){

            public void doStatus(String path, Status st) {
                cb.next(ConversionUtility.convert(st));
            }
        };
    }

    public static ConflictResolverCallback convert(final ISVNConflictResolutionCallback callback) {
        if (callback == null) {
            return null;
        }
        return new ConflictResolverCallback(){

            public ConflictResult resolve(ConflictDescriptor descrip) throws SubversionException {
                try {
                    return ConversionUtility.convert(callback.resolve(ConversionUtility.convert(descrip)));
                }
                catch (SVNConnectorException ex) {
                    throw ClientException.fromException(ex);
                }
            }
        };
    }

    public static SVNConflictDescriptor[] convert(Set<ConflictDescriptor> descr) {
        SVNConflictDescriptor[] retVal = null;
        if (descr != null) {
            retVal = new SVNConflictDescriptor[descr.size()];
            int i = 0;
            for (ConflictDescriptor svnConflictDescriptor : descr) {
                retVal[i++] = ConversionUtility.convert(svnConflictDescriptor);
            }
        }
        return retVal;
    }

    public static SVNConflictDescriptor convert(ConflictDescriptor descr) {
        if (descr == null) {
            return null;
        }
        ConflictDescriptor.Kind tKind = descr.getKind();
        SVNConflictDescriptor.Kind kind = SVNConflictDescriptor.Kind.CONTENT;
        if (tKind == ConflictDescriptor.Kind.property) {
            kind = SVNConflictDescriptor.Kind.PROPERTIES;
        } else if (tKind == ConflictDescriptor.Kind.tree) {
            kind = SVNConflictDescriptor.Kind.TREE;
        }
        ConflictDescriptor.Action tAction = descr.getAction();
        SVNConflictDescriptor.Action action = SVNConflictDescriptor.Action.ADD;
        if (tAction == ConflictDescriptor.Action.edit) {
            action = SVNConflictDescriptor.Action.MODIFY;
        } else if (tAction == ConflictDescriptor.Action.delete) {
            action = SVNConflictDescriptor.Action.DELETE;
        } else if (tAction == ConflictDescriptor.Action.replace) {
            action = SVNConflictDescriptor.Action.REPLACE;
        }
        SVNConflictDescriptor.Reason reason = conflictReasonMap.get((Object)descr.getReason());
        ConflictDescriptor.Operation tOperation = descr.getOperation();
        SVNConflictDescriptor.Operation operation = SVNConflictDescriptor.Operation.NONE;
        if (tOperation == ConflictDescriptor.Operation.merge) {
            operation = SVNConflictDescriptor.Operation.MERGE;
        } else if (tOperation == ConflictDescriptor.Operation.switched) {
            operation = SVNConflictDescriptor.Operation.SWITCHED;
        } else if (tOperation == ConflictDescriptor.Operation.update) {
            operation = SVNConflictDescriptor.Operation.UPDATE;
        }
        return descr == null ? null : new SVNConflictDescriptor(descr.getPath(), kind, ConversionUtility.convert(descr.getNodeKind()), descr.getPropertyName(), descr.isBinary(), descr.getMIMEType(), action, reason == null ? SVNConflictDescriptor.Reason.MODIFIED : reason, operation, descr.getBasePath(), descr.getTheirPath(), descr.getMyPath(), descr.getMergedPath(), ConversionUtility.convert(descr.getSrcLeftVersion()), ConversionUtility.convert(descr.getSrcRightVersion()));
    }

    public static SVNConflictVersion convert(ConflictVersion conflictVersion) {
        return conflictVersion == null ? null : new SVNConflictVersion(conflictVersion.getReposURL(), conflictVersion.getPegRevision(), conflictVersion.getPathInRepos(), ConversionUtility.convert(conflictVersion.getNodeKind()));
    }

    public static ConflictResult convert(SVNConflictResolution result) {
        return result == null ? null : new ConflictResult(ConversionUtility.convertConflictChoice(result.choice), result.mergedPath);
    }

    public static SVNMergeInfo convert(Mergeinfo info) {
        String[] paths;
        if (info == null) {
            return null;
        }
        SVNMergeInfo retVal = new SVNMergeInfo();
        String[] stringArray = paths = info.getPaths() == null ? null : info.getPaths().toArray(new String[info.getPaths().size()]);
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                retVal.addRevisions(paths[i], ConversionUtility.convert(info.getRevisionRange(paths[i]).toArray(new RevisionRange[0])));
                ++i;
            }
        }
        return retVal;
    }

    public static RevisionRange[] convert(SVNRevisionRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        RevisionRange[] retVal = new RevisionRange[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            retVal[i] = ConversionUtility.convert(ranges[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNRevisionRange[] convert(RevisionRange[] ranges) {
        if (ranges == null) {
            return null;
        }
        SVNRevisionRange[] retVal = new SVNRevisionRange[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            retVal[i] = ConversionUtility.convert(ranges[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNRevisionRange convert(RevisionRange range) {
        return range == null ? null : new SVNRevisionRange(ConversionUtility.convert(range.getFromRevision()), ConversionUtility.convert(range.getToRevision()));
    }

    public static RevisionRange convert(SVNRevisionRange range) {
        return range == null ? null : new RevisionRange(ConversionUtility.convert(range.from), ConversionUtility.convert(range.to));
    }

    public static SVNEntryInfo[] convert(Info[] infos) {
        if (infos == null) {
            return null;
        }
        SVNEntryInfo[] retVal = new SVNEntryInfo[infos.length];
        int i = 0;
        while (i < infos.length) {
            retVal[i] = ConversionUtility.convert(infos[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNChecksum convert(Checksum checksum) {
        return checksum == null ? null : new SVNChecksum(checksum.getKind() == Checksum.Kind.MD5 ? SVNChecksum.Kind.MD5 : SVNChecksum.Kind.SHA1, checksum.getDigest());
    }

    public static SVNEntryInfo convert(Info info) {
        if (info == null) {
            return null;
        }
        Info.ScheduleKind tScheduleKind = info.getSchedule();
        SVNEntryInfo.ScheduledOperation scheduleKind = SVNEntryInfo.ScheduledOperation.NORMAL;
        if (tScheduleKind == Info.ScheduleKind.add) {
            scheduleKind = SVNEntryInfo.ScheduledOperation.ADD;
        } else if (tScheduleKind == Info.ScheduleKind.delete) {
            scheduleKind = SVNEntryInfo.ScheduledOperation.DELETE;
        } else if (tScheduleKind == Info.ScheduleKind.replace) {
            scheduleKind = SVNEntryInfo.ScheduledOperation.REPLACE;
        }
        long changeTime = info.getTextTime() == null ? 0L : info.getTextTime().getTime();
        return new SVNEntryInfo(info.getPath(), info.getWcroot(), info.getUrl(), info.getRev(), ConversionUtility.convert(info.getKind()), info.getReposRootUrl(), info.getReposUUID(), info.getLastChangedRev(), info.getLastChangedDate() == null ? 0L : info.getLastChangedDate().getTime(), info.getLastChangedAuthor(), ConversionUtility.convert(info.getLock()), info.isHasWcInfo(), scheduleKind, info.getCopyFromUrl(), info.getCopyFromRev(), changeTime, changeTime, ConversionUtility.convert(info.getChecksum()), info.getChangelistName(), info.getWorkingSize(), info.getReposSize(), ConversionUtility.convertDepth(info.getDepth()), ConversionUtility.convert(info.getConflicts()));
    }

    public static SVNLogPath[] convert(ChangePath[] paths) {
        if (paths == null) {
            return null;
        }
        SVNLogPath[] retVal = new SVNLogPath[paths.length];
        int i = 0;
        while (i < paths.length) {
            retVal[i] = ConversionUtility.convert(paths[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNLogPath convert(ChangePath path) {
        if (path == null) {
            return null;
        }
        ChangePath.Action tAction = path.getAction();
        SVNLogPath.ChangeType action = SVNLogPath.ChangeType.ADDED;
        if (tAction == ChangePath.Action.delete) {
            action = SVNLogPath.ChangeType.DELETED;
        } else if (tAction == ChangePath.Action.modify) {
            action = SVNLogPath.ChangeType.MODIFIED;
        } else if (tAction == ChangePath.Action.replace) {
            action = SVNLogPath.ChangeType.REPLACED;
        }
        return new SVNLogPath(path.getPath(), action, path.getCopySrcPath(), path.getCopySrcRevision());
    }

    public static SVNProperty[] convertRevProps(Map<String, byte[]> data) {
        if (data == null) {
            return null;
        }
        SVNProperty[] retVal = new SVNProperty[data.size()];
        int i = 0;
        for (Map.Entry<String, byte[]> entry : data.entrySet()) {
            retVal[i] = new SVNProperty(entry.getKey(), entry.getValue());
            ++i;
        }
        return retVal;
    }

    public static SVNChangeStatus[] convert(Status[] st) {
        if (st == null) {
            return null;
        }
        SVNChangeStatus[] retVal = new SVNChangeStatus[st.length];
        int i = 0;
        while (i < st.length) {
            retVal[i] = ConversionUtility.convert(st[i]);
            ++i;
        }
        return retVal;
    }

    public static SVNChangeStatus convert(Status st) {
        if (st == null) {
            return null;
        }
        SVNEntryStatus.Kind textStatus = syncStatusMap.get((Object)st.getTextStatus());
        SVNEntryStatus.Kind propStatus = syncStatusMap.get((Object)st.getPropStatus());
        SVNEntryStatus.Kind repoTextStatus = syncStatusMap.get((Object)st.getRepositoryTextStatus());
        SVNEntryStatus.Kind repoPropStatus = syncStatusMap.get((Object)st.getRepositoryPropStatus());
        return new SVNChangeStatus(st.getPath(), st.getUrl(), ConversionUtility.convert(st.getNodeKind()), st.getRevisionNumber(), st.getLastChangedRevisionNumber(), st.getLastChangedDate() == null ? 0L : st.getLastChangedDate().getTime(), st.getLastCommitAuthor(), textStatus == null ? SVNEntryStatus.Kind.NONE : textStatus, propStatus == null ? SVNEntryStatus.Kind.NONE : propStatus, repoTextStatus == null ? SVNEntryStatus.Kind.NONE : repoTextStatus, repoPropStatus == null ? SVNEntryStatus.Kind.NONE : repoPropStatus, st.isLocked(), st.isCopied(), st.isSwitched(), ConversionUtility.convert(st.getLocalLock()), ConversionUtility.convert(st.getReposLock()), st.getReposLastCmtRevisionNumber(), st.getReposLastCmtDate() == null ? 0L : st.getReposLastCmtDate().getTime(), ConversionUtility.convert(st.getReposKind()), st.getReposLastCmtAuthor(), st.isFileExternal(), st.isConflicted(), null, st.getChangelist());
    }

    public static SVNEntry.Kind convert(NodeKind kind) {
        SVNEntry.Kind retVal = nodeKindMap.get((Object)kind);
        return retVal == null ? SVNEntry.Kind.UNKNOWN : retVal;
    }

    public static SVNNotification.PerformedAction convert(ClientNotifyInformation.Action action) {
        SVNNotification.PerformedAction retVal = notifyInfoActionMap.get((Object)action);
        return retVal == null ? SVNNotification.PerformedAction._UNKNOWN_ACTION : retVal;
    }

    public static SVNNotification.NodeStatus convert(ClientNotifyInformation.Status status) {
        SVNNotification.NodeStatus retVal = notifyInfoStatusMap.get((Object)status);
        return retVal == null ? SVNNotification.NodeStatus.UNKNOWN : retVal;
    }

    public static SVNNotification.NodeLock convert(ClientNotifyInformation.LockStatus status) {
        SVNNotification.NodeLock retVal = notifyInfoLockStatusMap.get((Object)status);
        return retVal == null ? SVNNotification.NodeLock.UNKNOWN : retVal;
    }

    public static SVNLock convert(Lock lock) {
        return lock == null ? null : new SVNLock(lock.getOwner(), lock.getPath(), lock.getToken(), lock.getComment(), lock.getCreationDate() == null ? 0L : lock.getCreationDate().getTime(), lock.getExpirationDate() == null ? 0L : lock.getExpirationDate().getTime());
    }

    public static BlameCallback convert(final ISVNAnnotationCallback cb) {
        if (cb == null) {
            return null;
        }
        return new BlameCallback(){
            private DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
            private Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

            @Override
            public void singleLine(long lineNum, long revision, Map<String, byte[]> revProps, long mergedRevision, Map<String, byte[]> mergedRevProps, String mergedPath, String line, boolean localChange) throws ClientException {
                Map tRevProps = ConversionUtility.convertRevPropsFromSVN(revProps, this.formatter, this.date);
                Map tMergedRevProps = ConversionUtility.convertRevPropsFromSVN(mergedRevProps, this.formatter, this.date);
                Date date = tRevProps == null ? null : (Date)tRevProps.get("svn:date");
                String author = tRevProps == null ? null : (String)tRevProps.get("svn:author");
                Date mergedDate = tMergedRevProps == null ? null : (Date)tMergedRevProps.get("svn:date");
                String mergedAuthor = tMergedRevProps == null ? null : (String)tMergedRevProps.get("svn:author");
                cb.annotate(line, new SVNAnnotationData(lineNum, localChange, revision, date == null ? 0L : date.getTime(), author, mergedRevision, mergedDate == null ? 0L : mergedDate.getTime(), mergedAuthor, mergedPath));
            }
        };
    }

    public static SVNRevision convert(Revision rev) {
        if (rev != null) {
            Revision.Kind kind = rev.getKind();
            if (kind == Revision.Kind.base) {
                return SVNRevision.BASE;
            }
            if (kind == Revision.Kind.committed) {
                return SVNRevision.COMMITTED;
            }
            if (kind == Revision.Kind.head) {
                return SVNRevision.HEAD;
            }
            if (kind == Revision.Kind.previous) {
                return SVNRevision.PREVIOUS;
            }
            if (kind == Revision.Kind.working) {
                return SVNRevision.WORKING;
            }
            if (kind == Revision.Kind.unspecified) {
                return SVNRevision.START;
            }
            if (kind == Revision.Kind.number) {
                return SVNRevision.fromNumber((long)((Revision.Number)rev).getNumber());
            }
            return SVNRevision.fromDate((long)((Revision.DateSpec)rev).getDate().getTime());
        }
        return null;
    }

    public static Mergeinfo.LogKind convertLogKind(SVNMergeInfo.LogKind logKind) {
        return logKind == SVNMergeInfo.LogKind.ELIGIBLE ? Mergeinfo.LogKind.eligible : Mergeinfo.LogKind.merged;
    }

    public static SVNDepth convertDepth(Depth depth) {
        if (depth == Depth.exclude) {
            return SVNDepth.EXCLUDE;
        }
        if (depth == Depth.empty) {
            return SVNDepth.EMPTY;
        }
        if (depth == Depth.files) {
            return SVNDepth.FILES;
        }
        if (depth == Depth.immediates) {
            return SVNDepth.IMMEDIATES;
        }
        if (depth == Depth.infinity) {
            return SVNDepth.INFINITY;
        }
        return SVNDepth.UNKNOWN;
    }

    public static Depth convertDepth(SVNDepth depth) {
        switch (depth) {
            case EXCLUDE: {
                return Depth.exclude;
            }
            case EMPTY: {
                return Depth.empty;
            }
            case FILES: {
                return Depth.files;
            }
            case IMMEDIATES: {
                return Depth.immediates;
            }
            case INFINITY: {
                return Depth.infinity;
            }
        }
        return Depth.unknown;
    }

    public static SVNConflictResolution.Choice convertConflictChoice(ConflictResult.Choice choice) {
        if (choice == ConflictResult.Choice.chooseBase) {
            return SVNConflictResolution.Choice.CHOOSE_BASE;
        }
        if (choice == ConflictResult.Choice.chooseTheirsFull) {
            return SVNConflictResolution.Choice.CHOOSE_REMOTE_FULL;
        }
        if (choice == ConflictResult.Choice.chooseMineFull) {
            return SVNConflictResolution.Choice.CHOOSE_LOCAL_FULL;
        }
        if (choice == ConflictResult.Choice.chooseTheirsConflict) {
            return SVNConflictResolution.Choice.CHOOSE_REMOTE;
        }
        if (choice == ConflictResult.Choice.chooseMineConflict) {
            return SVNConflictResolution.Choice.CHOOSE_LOCAL;
        }
        if (choice == ConflictResult.Choice.chooseMerged) {
            return SVNConflictResolution.Choice.CHOOSE_MERGED;
        }
        return SVNConflictResolution.Choice.POSTPONE;
    }

    public static ConflictResult.Choice convertConflictChoice(SVNConflictResolution.Choice choice) {
        switch (choice) {
            case CHOOSE_BASE: {
                return ConflictResult.Choice.chooseBase;
            }
            case CHOOSE_REMOTE_FULL: {
                return ConflictResult.Choice.chooseTheirsFull;
            }
            case CHOOSE_LOCAL_FULL: {
                return ConflictResult.Choice.chooseMineFull;
            }
            case CHOOSE_REMOTE: {
                return ConflictResult.Choice.chooseTheirsConflict;
            }
            case CHOOSE_LOCAL: {
                return ConflictResult.Choice.chooseMineConflict;
            }
            case CHOOSE_MERGED: {
                return ConflictResult.Choice.chooseMerged;
            }
        }
        return ConflictResult.Choice.postpone;
    }

    public static Revision convert(SVNRevision rev) {
        if (rev != null) {
            switch (rev.getKind()) {
                case BASE: {
                    return Revision.BASE;
                }
                case COMMITTED: {
                    return Revision.COMMITTED;
                }
                case HEAD: {
                    return Revision.HEAD;
                }
                case PREVIOUS: {
                    return Revision.PREVIOUS;
                }
                case WORKING: {
                    return Revision.WORKING;
                }
                case START: {
                    return Revision.START;
                }
                case NUMBER: {
                    return Revision.getInstance(((SVNRevision.Number)rev).getNumber());
                }
            }
            return Revision.getInstance(new Date(((SVNRevision.Date)rev).getDate()));
        }
        return null;
    }

    public static SVNNotification convert(ClientNotifyInformation info) {
        return info == null ? null : new SVNNotification(info.getPath(), ConversionUtility.convert(info.getAction()), ConversionUtility.convert(info.getKind()), info.getMimeType(), ConversionUtility.convert(info.getLock()), info.getErrMsg(), ConversionUtility.convert(info.getContentState()), ConversionUtility.convert(info.getPropState()), ConversionUtility.convert(info.getLockState()), info.getRevision());
    }

    public static ISVNNotificationCallback convert(ClientNotifyCallback notify2) {
        return notify2 == null ? null : ((Notify2Wrapper)notify2).getNotify2();
    }

    public static ClientNotifyCallback convert(ISVNNotificationCallback notify2) {
        return notify2 == null ? null : new Notify2Wrapper(notify2);
    }

    public static String convertZeroCodedLine(String source) {
        if (source != null) {
            byte[] data = new byte[source.length()];
            int i = 0;
            while (i < data.length) {
                data[i] = (byte)source.charAt(i);
                ++i;
            }
            source = new String(data);
        }
        return source;
    }

    private ConversionUtility() {
    }

    public static class Notify2Wrapper
    implements ClientNotifyCallback {
        protected ISVNNotificationCallback notify;

        public Notify2Wrapper(ISVNNotificationCallback notify) {
            this.notify = notify;
        }

        public ISVNNotificationCallback getNotify2() {
            return this.notify;
        }

        public void onNotify(ClientNotifyInformation info) {
            this.notify.notify(ConversionUtility.convert(info));
        }
    }
}

