/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.javahl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.CommitItem;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.ChangelistCallback;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.Status;
import org.eclipse.team.svn.core.connector.ISVNAnnotationCallback;
import org.eclipse.team.svn.core.connector.ISVNChangeListCallback;
import org.eclipse.team.svn.core.connector.ISVNConflictResolutionCallback;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNCredentialsPrompt;
import org.eclipse.team.svn.core.connector.ISVNDiffStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryInfoCallback;
import org.eclipse.team.svn.core.connector.ISVNEntryStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNImportFilterCallback;
import org.eclipse.team.svn.core.connector.ISVNLogEntryCallback;
import org.eclipse.team.svn.core.connector.ISVNMergeStatusCallback;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNPatchCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNPropertyCallback;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConflictResolution;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNDiffStatus;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNMergeInfo;
import org.eclipse.team.svn.core.connector.SVNMergeStatus;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.utility.SVNNotificationComposite;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.polarion.team.svn.connector.javahl.ConversionUtility;
import org.polarion.team.svn.connector.javahl.JavaHLService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHLConnector
extends JavaHLService
implements ISVNConnector {
    protected ISVNClient client = new SVNClient();
    protected ISVNCredentialsPrompt prompt;
    protected SVNNotificationComposite composite = new SVNNotificationComposite();
    protected ISVNNotificationCallback installedNotify2;
    protected boolean commitMissingFiles;
    protected ISVNConflictResolutionCallback conflictResolver;
    protected String sslCertificate;
    protected String sslPassphrase;

    public JavaHLConnector() {
        this.client.notification2(ConversionUtility.convert((ISVNNotificationCallback)this.composite));
    }

    public String getConfigDirectory() throws SVNConnectorException {
        this.fireAsked("getConfigDirectory", null);
        try {
            String retVal = this.client.getConfigDirectory();
            this.fireSucceeded("getConfigDirectory", null, retVal);
            return retVal;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getConfigDirectory", null);
            return null;
        }
    }

    public void setConfigDirectory(String configDir) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("configDir", configDir);
        this.fireAsked("setConfigDirectory", parameters);
        configDir = (String)parameters.get("configDir");
        try {
            this.client.setConfigDirectory(configDir);
            this.fireSucceeded("getConfigDirectory", parameters, null);
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "setConfigDirectory", parameters);
        }
    }

    public void setUsername(String username) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        this.fireAsked("setUsername", parameters);
        username = (String)parameters.get("username");
        this.client.username(username == null ? "" : username);
        this.fireSucceeded("setUsername", parameters, null);
    }

    public void setPassword(String password) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("password", password);
        this.fireAsked("setUsername", parameters);
        password = (String)parameters.get("password");
        this.client.password(password == null ? "" : password);
        this.fireSucceeded("setUsername", parameters, null);
    }

    public boolean isCredentialsCacheEnabled() {
        this.fireAsked("isCredentialsCacheEnabled", null);
        this.fireSucceeded("isCredentialsCacheEnabled", null, Boolean.TRUE);
        return true;
    }

    public void setCredentialsCacheEnabled(boolean cacheCredentials) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("cacheCredentials", cacheCredentials);
        this.fireAsked("setCredentialsCacheEnabled", parameters);
        cacheCredentials = (Boolean)parameters.get("cacheCredentials");
        this.fireFailed("setCredentialsCacheEnabled", parameters, null);
    }

    public void setPrompt(ISVNCredentialsPrompt prompt) {
        RepositoryInfoPrompt repositoryInfoPrompt;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("prompt", prompt);
        this.fireAsked("setPrompt", parameters);
        prompt = (ISVNCredentialsPrompt)parameters.get("prompt");
        if (prompt == null) {
            repositoryInfoPrompt = null;
        } else {
            this.prompt = prompt;
            RepositoryInfoPrompt repositoryInfoPrompt2 = new RepositoryInfoPrompt(this.prompt);
            repositoryInfoPrompt = repositoryInfoPrompt2;
        }
        this.client.setPrompt(repositoryInfoPrompt);
        this.fireSucceeded("setPrompt", parameters, null);
    }

    public ISVNCredentialsPrompt getPrompt() {
        this.fireAsked("getPrompt", null);
        this.fireSucceeded("getPrompt", null, this.prompt);
        return this.prompt;
    }

    public void setProxy(String host, int port, String username, String password) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("host", host);
        parameters.put("port", port);
        parameters.put("username", username);
        parameters.put("password", password);
        this.fireAsked("setProxy", parameters);
        host = (String)parameters.get("host");
        port = (Integer)parameters.get("port");
        username = (String)parameters.get("username");
        password = (String)parameters.get("password");
        this.fireFailed("setProxy", parameters, null);
    }

    public void setClientSSLCertificate(String certPath, String passphrase) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("certPath", certPath);
        parameters.put("passphrase", passphrase);
        this.fireAsked("setClientSSLCertificate", parameters);
        certPath = (String)parameters.get("certPath");
        passphrase = (String)parameters.get("passphrase");
        this.sslCertificate = certPath == null || certPath.trim().length() == 0 ? null : certPath;
        this.sslPassphrase = passphrase;
        this.fireSucceeded("setClientSSLCertificate", parameters, null);
    }

    public boolean isSSLCertificateCacheEnabled() {
        this.fireAsked("isSSLCertificateCacheEnabled", null);
        this.fireSucceeded("isSSLCertificateCacheEnabled", null, Boolean.TRUE);
        return true;
    }

    public void setSSLCertificateCacheEnabled(boolean enabled) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("enabled", enabled);
        this.fireAsked("setSSLCertificateCacheEnabled", parameters);
        enabled = (Boolean)parameters.get("enabled");
        this.fireFailed("setSSLCertificateCacheEnabled", parameters, null);
    }

    public void setSSHCredentials(String username, String privateKeyPath, String passphrase, int port) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        parameters.put("privateKeyPath", privateKeyPath);
        parameters.put("passphrase", passphrase);
        parameters.put("port", port);
        this.fireAsked("setSSHCredentials", parameters);
        username = (String)parameters.get("username");
        privateKeyPath = (String)parameters.get("privateKeyPath");
        passphrase = (String)parameters.get("passphrase");
        port = (Integer)parameters.get("port");
        this.fireFailed("setSSHCredentials", parameters, null);
    }

    public void setSSHCredentials(String username, String password, int port) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("username", username);
        parameters.put("password", password);
        parameters.put("port", port);
        this.fireAsked("setSSHCredentialsPassword", parameters);
        username = (String)parameters.get("username");
        password = (String)parameters.get("password");
        port = (Integer)parameters.get("port");
        this.fireFailed("setSSHCredentialsPassword", parameters, null);
    }

    public void setCommitMissingFiles(boolean commitMissingFiles) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("commitMissingFiles", commitMissingFiles);
        this.fireAsked("setCommitMissingFiles", parameters);
        this.commitMissingFiles = commitMissingFiles = ((Boolean)parameters.get("commitMissingFiles")).booleanValue();
        this.fireSucceeded("setCommitMissingFiles", parameters, null);
    }

    public boolean isCommitMissingFiles() {
        this.fireAsked("isCommitMissingFiles", null);
        this.fireSucceeded("isCommitMissingFiles", null, this.commitMissingFiles);
        return this.commitMissingFiles;
    }

    public void setNotificationCallback(ISVNNotificationCallback notify) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("notify", notify);
        this.fireAsked("setNotificationCallback", parameters);
        notify = (ISVNNotificationCallback)parameters.get("notify");
        if (this.installedNotify2 != null) {
            this.composite.remove(this.installedNotify2);
        }
        this.installedNotify2 = notify;
        if (this.installedNotify2 != null) {
            this.composite.add(this.installedNotify2);
        }
        this.fireSucceeded("setNotificationCallback", parameters, null);
    }

    public ISVNNotificationCallback getNotificationCallback() {
        this.fireAsked("getNotificationCallback", null);
        this.fireSucceeded("getNotificationCallback", null, this.installedNotify2);
        return this.installedNotify2;
    }

    public long checkout(SVNEntryRevisionReference fromReference, String destPath, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("fromReference", fromReference);
        parameters.put("destPath", destPath);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("checkout", parameters);
        fromReference = (SVNEntryRevisionReference)parameters.get("fromReference");
        destPath = (String)parameters.get("destPath");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long retVal = this.client.checkout(fromReference.path, destPath, ConversionUtility.convert(fromReference.revision), ConversionUtility.convert(fromReference.pegRevision), ConversionUtility.convertDepth(depth), (options & 1L) != 0L, (options & 2L) != 0L);
            this.fireSucceeded("checkout", parameters, retVal);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "checkout", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void lock(String[] path, String comment, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("comment", comment);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("lock", parameters);
        path = (String[])parameters.get("path");
        comment = (String)parameters.get("comment");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.lock(new HashSet<String>(Arrays.asList(path)), comment, (options & 4L) != 0L);
                this.fireSucceeded("lock", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "lock", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void unlock(String[] path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("unlock", parameters);
        path = (String[])parameters.get("path");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.unlock(new HashSet<String>(Arrays.asList(path)), (options & 4L) != 0L);
                this.fireSucceeded("unlock", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "unlock", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void add(String path, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("add", parameters);
        path = (String)parameters.get("path");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.add(path, ConversionUtility.convertDepth(depth), (options & 4L) != 0L, (options & 0x100L) != 0L, (options & 8L) != 0L);
                this.fireSucceeded("add", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "add", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void commit(String[] path, String message, String[] changeLists, SVNDepth depth, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("message", message);
        parameters.put("changeLists", changeLists);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("commit", parameters);
        path = (String[])parameters.get("path");
        message = (String)parameters.get("message");
        changeLists = (String[])parameters.get("changeLists");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        boolean noUnlock = (options & 0x10L) != 0L;
        boolean keepChangelist = (options & 0x20L) != 0L;
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                if (this.commitMissingFiles) {
                    int i = 0;
                    while (i < path.length && !monitor.isActivityCancelled()) {
                        this.client.status(path[i], ConversionUtility.convertDepth(depth), false, false, false, true, null, new StatusCallback(){

                            public void doStatus(String path, Status status) {
                                if (status.getTextStatus() == Status.Kind.missing) {
                                    try {
                                        JavaHLConnector.this.client.remove(new HashSet<String>(Arrays.asList(path)), true, false, null, null, null);
                                    }
                                    catch (ClientException clientException) {}
                                }
                            }
                        });
                        ++i;
                    }
                }
                if (depth != SVNDepth.INFINITY) {
                    HashSet<String> fullSet = new HashSet<String>(Arrays.asList(path));
                    HashSet<String> deleted = new HashSet<String>();
                    Arrays.sort(path);
                    int i = 0;
                    while (i < path.length && !monitor.isActivityCancelled()) {
                        File toCheck = new File(path[i]);
                        if (toCheck.isDirectory()) {
                            final Status[] st = new Status[1];
                            this.client.status(path[i], ConversionUtility.convertDepth(SVNDepth.EMPTY), false, false, false, false, null, new StatusCallback(){

                                public void doStatus(String path, Status status) {
                                    st[0] = status;
                                }
                            });
                            if (st[0] != null && st[0].getTextStatus() == Status.Kind.deleted) {
                                deleted.add(path[i]);
                                String root = path[i];
                                while (i < path.length && !monitor.isActivityCancelled()) {
                                    if (path[i].startsWith(root) && (path[i].length() == root.length() || path[i].charAt(root.length()) == '\\' || path[i].charAt(root.length()) == '/')) {
                                        fullSet.remove(path[i]);
                                        ++i;
                                        continue;
                                    }
                                    --i;
                                    break;
                                }
                            }
                        }
                        ++i;
                    }
                    if (deleted.size() > 0) {
                        if (fullSet.size() == 0) {
                            path = deleted.toArray(new String[deleted.size()]);
                            depth = SVNDepth.INFINITY;
                        } else {
                            path = fullSet.toArray(new String[fullSet.size()]);
                            String[] deletedPath = deleted.toArray(new String[deleted.size()]);
                            this.composite.add((ISVNNotificationCallback)wrapper);
                            wrapper.start();
                            CommitInfo info1 = new CommitInfo(monitor);
                            CommitInfo info2 = new CommitInfo(monitor);
                            this.client.commit(new HashSet<String>(Arrays.asList(path)), ConversionUtility.convertDepth(depth), noUnlock, keepChangelist, changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), info1);
                            this.client.commit(new HashSet<String>(Arrays.asList(deletedPath)), ConversionUtility.convertDepth(SVNDepth.INFINITY), noUnlock, keepChangelist, changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), info2);
                            if (info1.info != null && info1.info.getPostCommitError() != null) {
                                parameters.put("lastPostCommitError", info1.info.getPostCommitError());
                            }
                            if (info2.info != null && info2.info.getPostCommitError() != null) {
                                parameters.put("lastPostCommitError", info2.info.getPostCommitError());
                            }
                            this.fireSucceeded("commit", parameters, null);
                        }
                    }
                }
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                CommitInfo info1 = new CommitInfo(monitor);
                this.client.commit(new HashSet<String>(Arrays.asList(path)), ConversionUtility.convertDepth(depth), noUnlock, keepChangelist, changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), info1);
                if (info1.info != null && info1.info.getPostCommitError() != null) {
                    parameters.put("lastPostCommitError", info1.info.getPostCommitError());
                }
                this.fireSucceeded("commit", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "commit", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public long[] update(String[] path, SVNRevision revision, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("revision", revision);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("update", parameters);
        path = (String[])parameters.get("path");
        revision = (SVNRevision)parameters.get("revision");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long[] retVal = this.client.update(new HashSet<String>(Arrays.asList(path)), ConversionUtility.convert(revision), ConversionUtility.convertDepth(depth), (options & 0x4000L) != 0L, (options & 8L) != 0L, (options & 1L) != 0L, (options & 2L) != 0L);
            this.fireSucceeded("update", parameters, retVal);
            long[] lArray = retVal;
            return lArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "update", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public long switchTo(String path, SVNEntryRevisionReference toReference, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("toReference", toReference);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("switchTo", parameters);
        path = (String)parameters.get("path");
        toReference = (SVNEntryRevisionReference)parameters.get("toReference");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long retVal = this.client.doSwitch(path, toReference.path, ConversionUtility.convert(toReference.revision), ConversionUtility.convert(toReference.pegRevision), ConversionUtility.convertDepth(depth), (options & 0x4000L) != 0L, (options & 1L) != 0L, (options & 2L) != 0L, (options & 0x200L) != 0L);
            this.fireSucceeded("switchTo", parameters, retVal);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "switchTo", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void revert(String path, SVNDepth depth, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("revert", parameters);
        path = (String)parameters.get("path");
        depth = (SVNDepth)parameters.get("depth");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.revert(path, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists));
                this.fireSucceeded("revert", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "revert", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void status(String path, SVNDepth depth, long options, String[] changeLists, ISVNEntryStatusCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("status", parameters);
        path = (String)parameters.get("path");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        callback = (ISVNEntryStatusCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.status(path, ConversionUtility.convertDepth(depth), (options & 0x40L) != 0L, (options & 0x80L) != 0L, (options & 0x100L) != 0L, (options & 1L) != 0L, changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convert(callback));
                this.fireSucceeded("status", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "status", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void relocate(String from, String to, String path, SVNDepth depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("from", from);
        parameters.put("to", to);
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("monitor", monitor);
        this.fireAsked("relocate", parameters);
        from = (String)parameters.get("from");
        to = (String)parameters.get("to");
        path = (String)parameters.get("path");
        depth = (SVNDepth)parameters.get("depth");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.relocate(from, to, path, depth == SVNDepth.INFINITY);
                this.fireSucceeded("relocate", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "relocate", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void cleanup(String path, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("monitor", monitor);
        this.fireAsked("cleanup", parameters);
        path = (String)parameters.get("path");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.cleanup(path);
                this.fireSucceeded("cleanup", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "cleanup", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void mergeTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String localPath, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("localPath", localPath);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("mergeTwo", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        localPath = (String)parameters.get("localPath");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.merge(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), localPath, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                this.fireSucceeded("mergeTwo", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "mergeTwo", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void merge(SVNEntryReference reference, SVNRevisionRange[] revisions, String localPath, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revisions", revisions);
        parameters.put("localPath", localPath);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("merge", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revisions = (SVNRevisionRange[])parameters.get("revisions");
        localPath = (String)parameters.get("localPath");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.merge(reference.path, ConversionUtility.convert(reference.pegRevision), Arrays.asList(ConversionUtility.convert(revisions)), localPath, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                this.fireSucceeded("merge", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "merge", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void mergeReintegrate(SVNEntryReference reference, String localPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("localPath", localPath);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("mergeReintegrate", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        localPath = (String)parameters.get("localPath");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.mergeReintegrate(reference.path, ConversionUtility.convert(reference.pegRevision), localPath, (options & 0x400L) != 0L);
                this.fireSucceeded("mergeReintegrate", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "mergeReintegrate", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNMergeInfo getMergeInfo(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("monitor", monitor);
        this.fireAsked("getMergeInfo", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNMergeInfo retVal = ConversionUtility.convert(this.client.getMergeinfo(reference.path, ConversionUtility.convert(reference.pegRevision)));
            this.fireSucceeded("getMergeInfo", parameters, retVal);
            SVNMergeInfo sVNMergeInfo = retVal;
            return sVNMergeInfo;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getMergeInfo", parameters);
        }
        catch (SubversionException ex) {
            this.handleSubversionException(ex, "getMergeInfo", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void listMergeInfoLog(SVNMergeInfo.LogKind logKind, SVNEntryReference reference, SVNEntryReference mergeSourceReference, SVNRevisionRange mergeSourceRange, String[] revProps, SVNDepth depth, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("logKind", logKind);
        parameters.put("reference", reference);
        parameters.put("mergeSourceReference", mergeSourceReference);
        parameters.put("mergeSourceRange", mergeSourceRange);
        parameters.put("revProps", revProps);
        parameters.put("options", options);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("listMergeInfoLog", parameters);
        logKind = (SVNMergeInfo.LogKind)parameters.get("logKind");
        reference = (SVNEntryReference)parameters.get("reference");
        mergeSourceReference = (SVNEntryReference)parameters.get("mergeSourceReference");
        mergeSourceRange = (SVNRevisionRange)parameters.get("mergeSourceRange");
        revProps = (String[])parameters.get("revProps");
        options = (Long)parameters.get("options");
        cb = (ISVNLogEntryCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.getMergeinfoLog(ConversionUtility.convertLogKind(logKind), reference.path, ConversionUtility.convert(reference.pegRevision), mergeSourceReference.path, ConversionUtility.convert(mergeSourceReference.pegRevision), (options & 0x40000L) != 0L, ConversionUtility.convertDepth(depth), new HashSet<String>(Arrays.asList(revProps)), ConversionUtility.convert(cb));
                this.fireSucceeded("listMergeInfoLog", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "listMergeInfoLog", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public String[] suggestMergeSources(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("monitor", monitor);
        this.fireAsked("suggestMergeSources", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            Set<String> tmp = this.client.suggestMergeSources(reference.path, ConversionUtility.convert(reference.pegRevision));
            String[] retVal = tmp == null ? null : tmp.toArray(new String[tmp.size()]);
            this.fireSucceeded("suggestMergeSources", parameters, retVal);
            String[] stringArray = retVal;
            return stringArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "suggestMergeSources", parameters);
        }
        catch (SubversionException ex) {
            this.handleSubversionException(ex, "suggestMergeSources", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void resolve(String path, SVNConflictResolution.Choice conflictResult, SVNDepth depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("conflictResult", conflictResult);
        parameters.put("depth", depth);
        parameters.put("monitor", monitor);
        this.fireAsked("resolve", parameters);
        path = (String)parameters.get("path");
        conflictResult = (SVNConflictResolution.Choice)parameters.get("conflictResult");
        depth = (SVNDepth)parameters.get("depth");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.resolve(path, ConversionUtility.convertDepth(depth), ConversionUtility.convertConflictChoice(conflictResult));
                this.fireSucceeded("resolve", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "resolve", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
            catch (SubversionException ex) {
                this.handleSubversionException(ex, "resolve", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void setConflictResolver(ISVNConflictResolutionCallback listener) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("listener", listener);
        this.fireAsked("setConflictResolver", parameters);
        this.conflictResolver = listener = (ISVNConflictResolutionCallback)parameters.get("listener");
        this.client.setConflictResolver(ConversionUtility.convert(listener));
        this.fireSucceeded("setConflictResolver", parameters, null);
    }

    public ISVNConflictResolutionCallback getConflictResolver() {
        this.fireAsked("getConflictResolver", null);
        this.fireSucceeded("getConflictResolver", null, this.conflictResolver);
        return this.conflictResolver;
    }

    public void addToChangeList(String[] paths, String changelist, SVNDepth depth, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("paths", paths);
        parameters.put("changelist", changelist);
        parameters.put("depth", depth);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("addToChangeList", parameters);
        paths = (String[])parameters.get("paths");
        changelist = (String)parameters.get("changelist");
        depth = (SVNDepth)parameters.get("depth");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.addToChangelist(new HashSet<String>(Arrays.asList(paths)), changelist, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists));
                this.fireSucceeded("addToChangeList", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "addToChangeList", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void removeFromChangeLists(String[] paths, SVNDepth depth, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("paths", paths);
        parameters.put("depth", depth);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("removeFromChangeLists", parameters);
        paths = (String[])parameters.get("paths");
        depth = (SVNDepth)parameters.get("depth");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.removeFromChangelists(new HashSet<String>(Arrays.asList(paths)), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists));
                this.fireSucceeded("removeFromChangeLists", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeFromChangeLists", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void dumpChangeLists(String[] changeLists, String rootPath, SVNDepth depth, ISVNChangeListCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("changeLists", changeLists);
        parameters.put("rootPath", rootPath);
        parameters.put("depth", depth);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("dumpChangeLists", parameters);
        changeLists = (String[])parameters.get("changeLists");
        rootPath = (String)parameters.get("rootPath");
        depth = (SVNDepth)parameters.get("depth");
        final ISVNChangeListCallback cb1 = (ISVNChangeListCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.getChangelists(rootPath, Arrays.asList(changeLists), ConversionUtility.convertDepth(depth), new ChangelistCallback(){

                    public void doChangelist(String path, String changelist) {
                        cb1.next(path, changelist);
                    }
                });
                this.fireSucceeded("dumpChangeLists", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "dumpChangeLists", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void merge(SVNEntryReference reference, SVNRevisionRange[] revisions, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.merge(reference, null, revisions, mergePath, mergeStatus, options, monitor);
    }

    public void merge(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.merge((SVNEntryReference)reference1, reference2, null, mergePath, mergeStatus, options, monitor);
    }

    public void mergeStatus(SVNEntryReference reference, SVNRevisionRange[] revisions, String path, SVNDepth depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus(reference, null, revisions, path, depth, options, cb, monitor);
    }

    public void mergeStatus(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String path, SVNDepth depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus((SVNEntryReference)reference1, reference2, null, path, depth, options, cb, monitor);
    }

    public void merge(SVNEntryReference reference, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.merge(reference, null, null, mergePath, mergeStatus, options, monitor);
    }

    public void mergeStatus(SVNEntryReference reference, String mergePath, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        this.mergeStatus(reference, null, null, mergePath, SVNDepth.INFINITY, options, cb, monitor);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void merge(SVNEntryReference reference1, SVNEntryRevisionReference reference2, SVNRevisionRange[] revisions, String mergePath, SVNMergeStatus[] mergeStatus, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                i = 0;
                if (true) ** GOTO lbl54
                do {
                    localFile = new File(mergeStatus[i].path);
                    if (mergeStatus[i].textStatus == SVNEntryStatus.Kind.DELETED) {
                        this.client.remove(new HashSet<String>(Arrays.asList(new String[]{mergeStatus[i].path})), (options & 4L) != 0L, false, null, null, null);
                    } else if (mergeStatus[i].textStatus == SVNEntryStatus.Kind.ADDED || mergeStatus[i].textStatus == SVNEntryStatus.Kind.MODIFIED && ((options & 4L) != 0L || !localFile.exists()) || mergeStatus[i].textStatus == SVNEntryStatus.Kind.CONFLICTED && (options & 4L) != 0L) {
                        if (localFile.exists()) {
                            localFile.delete();
                        }
                        parent = localFile.getParentFile();
                        while (!parent.exists() && parent.getParentFile() != null) {
                            tmp = parent.getParentFile();
                            if (tmp.exists()) {
                                localFile.getParentFile().mkdirs();
                                this.client.add(parent.getAbsolutePath(), ConversionUtility.convertDepth(SVNDepth.INFINITY), true, false, false);
                                break;
                            }
                            parent = tmp;
                        }
                        src = new CopySource(mergeStatus[i].endUrl, ConversionUtility.convert(reference2 == null ? (revisions != null ? revisions[revisions.length - 1].to : reference1.pegRevision) : reference2.revision), ConversionUtility.convert(reference2 == null ? reference1.pegRevision : reference2.pegRevision));
                        tmp = File.createTempFile("mergeCopyTarget", ".tmp", localFile.getParentFile());
                        tmp.delete();
                        this.client.copy(Arrays.asList(new CopySource[]{src}), tmp.getAbsolutePath(), true, false, false, null, null, null);
                        data = new Map[1];
                        this.client.properties(tmp.getAbsolutePath(), null, null, ConversionUtility.convertDepth(SVNDepth.EMPTY), null, new ProplistCallback(){

                            @Override
                            public void singlePath(String path, Map<String, byte[]> properties) {
                                data[0] = properties;
                            }
                        });
                        this.client.revert(tmp.getAbsolutePath(), ConversionUtility.convertDepth(SVNDepth.INFINITY), null);
                        tmp.renameTo(new File(mergeStatus[i].path));
                        try {
                            this.client.add(mergeStatus[i].path, ConversionUtility.convertDepth(SVNDepth.INFINITY), true, false, false);
                        }
                        catch (ClientException v0) {}
                        if (data[0] != null) {
                            for (Map.Entry<K, V> entry : data[0].entrySet()) {
                                this.client.propertySetLocal(new HashSet<String>(Arrays.asList(new String[]{mergeStatus[i].path})), (String)entry.getKey(), (byte[])entry.getValue(), ConversionUtility.convertDepth(SVNDepth.EMPTY), null, false);
                            }
                        }
                    } else if (reference2 != null) {
                        this.client.merge(mergeStatus[i].startUrl, ConversionUtility.convert(((SVNEntryRevisionReference)reference1).revision), mergeStatus[i].endUrl, ConversionUtility.convert(reference2.revision), mergeStatus[i].path, (options & 4L) != 0L, ConversionUtility.convertDepth(SVNDepth.FILES), (options & 512L) != 0L, false, (options & 2048L) != 0L);
                    } else if (revisions != null) {
                        this.client.merge(mergeStatus[i].endUrl, ConversionUtility.convert(reference1.pegRevision), Arrays.asList(ConversionUtility.convert(revisions)), mergeStatus[i].path, (options & 4L) != 0L, ConversionUtility.convertDepth(SVNDepth.FILES), (options & 512L) != 0L, false, (options & 2048L) != 0L);
                    } else {
                        this.client.mergeReintegrate(mergeStatus[i].endUrl, ConversionUtility.convert(reference1.pegRevision), mergeStatus[i].path, false);
                    }
                    ++i;
lbl54:
                    // 2 sources

                    if (i >= mergeStatus.length) return;
                } while (!monitor.isActivityCancelled());
                return;
            }
            catch (ClientException ex) {
                this.handleClientException(ex, null, null);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
                return;
            }
            catch (IOException e) {
                throw new SVNConnectorException((Throwable)e);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void mergeStatus(SVNEntryReference reference1, SVNEntryRevisionReference reference2, SVNRevisionRange[] revisions, String path, SVNDepth depth, long options, ISVNMergeStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        final ArrayList tmp = new ArrayList();
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor){

            public void notify(SVNNotification arg0) {
                super.notify(arg0);
                tmp.add(arg0);
            }
        };
        try {
            try {
                String endUrlPref;
                SVNLogEntry[] entries;
                SVNRevision to;
                SVNRevision from;
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                if (reference2 != null) {
                    this.client.merge(reference1.path, ConversionUtility.convert(((SVNEntryRevisionReference)reference1).revision), reference2.path, ConversionUtility.convert(reference2.revision), path, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                } else if (revisions != null) {
                    this.client.merge(reference1.path, ConversionUtility.convert(reference1.pegRevision), Arrays.asList(ConversionUtility.convert(revisions)), path, (options & 4L) != 0L, ConversionUtility.convertDepth(depth), (options & 0x200L) != 0L, (options & 0x400L) != 0L, (options & 0x800L) != 0L);
                } else {
                    this.client.mergeReintegrate(reference1.path, ConversionUtility.convert(reference1.pegRevision), path, (options & 0x400L) != 0L);
                }
                Object object = reference2 == null ? (revisions != null ? revisions[0].from : SVNRevision.fromNumber((long)1L)) : (from = ((SVNEntryRevisionReference)reference1).revision);
                SVNRevision sVNRevision = reference2 == null ? (revisions != null ? revisions[revisions.length - 1].to : reference1.pegRevision) : (to = reference2.revision);
                if (from.getKind() != SVNRevision.Kind.NUMBER) {
                    entries = SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)reference1, (SVNRevision)from, (SVNRevision)SVNRevision.fromNumber((long)1L), (long)0L, (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)monitor);
                    from = SVNRevision.fromNumber((long)entries[0].revision);
                }
                if (to.getKind() != SVNRevision.Kind.NUMBER) {
                    entries = SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)(reference2 == null ? reference1 : reference2), (SVNRevision)to, (SVNRevision)SVNRevision.fromNumber((long)1L), (long)0L, (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)monitor);
                    to = SVNRevision.fromNumber((long)entries[0].revision);
                }
                if (reference2 != null && from.equals((Object)to)) {
                    from = SVNRevision.fromNumber((long)(((SVNRevision.Number)to).getNumber() - 1L));
                }
                boolean reversed = reference2 == null ? SVNUtility.compareRevisions((SVNRevision)from, (SVNRevision)to, (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference1.path, reference1.pegRevision, from), (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference1.path, reference1.pegRevision, to), (ISVNConnector)this) == 1 : SVNUtility.compareRevisions((SVNRevision)from, (SVNRevision)to, (SVNEntryRevisionReference)((SVNEntryRevisionReference)reference1), (SVNEntryRevisionReference)reference2, (ISVNConnector)this) == 1;
                int i = 0;
                String startUrlPref = reference1.path;
                String string = endUrlPref = reference2 == null ? reference1.path : reference2.path;
                SVNLogEntry[] allMsgs = reversed ? SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)(reference2 == null ? reference1 : this.getValidReference((SVNEntryReference)reference2, from, monitor)), (SVNRevision)from, (SVNRevision)to, (long)262144L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)monitor) : SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)(reference2 == null ? reference1 : reference2), (SVNRevision)to, (SVNRevision)from, (long)262144L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)monitor);
                long minRev = ((SVNRevision.Number)(reversed ? to : from)).getNumber();
                Iterator it = tmp.iterator();
                while (it.hasNext()) {
                    if (monitor.isActivityCancelled()) {
                        return;
                    }
                    SVNNotification state = (SVNNotification)it.next();
                    SVNEntry.Kind kind = state.kind;
                    String tPath = state.path.substring(path.length());
                    String startUrl = SVNUtility.normalizeURL((String)(String.valueOf(startUrlPref) + tPath));
                    String endUrl = SVNUtility.normalizeURL((String)(String.valueOf(endUrlPref) + tPath));
                    boolean skipped = state.action == SVNNotification.PerformedAction.SKIP;
                    SVNEntryStatus.Kind cState = SVNEntryStatus.Kind.NONE;
                    SVNEntryStatus.Kind pState = SVNEntryStatus.Kind.NONE;
                    boolean hasTreeConflict = state.action == SVNNotification.PerformedAction.TREE_CONFLICT;
                    SVNConflictDescriptor treeConflict = null;
                    if (hasTreeConflict) {
                        SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)new SVNEntryRevisionReference(state.path), (SVNDepth)SVNDepth.EMPTY, (ISVNProgressMonitor)monitor);
                        if (infos.length > 0 && infos[0].treeConflicts != null && infos[0].treeConflicts.length > 0) {
                            treeConflict = infos[0].treeConflicts[0];
                            kind = infos[0].kind;
                            if (treeConflict.conflictKind == SVNConflictDescriptor.Kind.CONTENT) {
                                cState = SVNEntryStatus.Kind.CONFLICTED;
                            } else {
                                pState = SVNEntryStatus.Kind.CONFLICTED;
                            }
                        } else {
                            hasTreeConflict = false;
                        }
                    }
                    if (state.action == SVNNotification.PerformedAction.UPDATE_ADD) {
                        cState = SVNEntryStatus.Kind.ADDED;
                    } else if (state.action == SVNNotification.PerformedAction.UPDATE_DELETE) {
                        cState = SVNEntryStatus.Kind.DELETED;
                    } else if (state.action == SVNNotification.PerformedAction.UPDATE_UPDATE) {
                        SVNEntryStatus.Kind kind2 = state.propState == SVNNotification.NodeStatus.CHANGED ? SVNEntryStatus.Kind.MODIFIED : (pState = state.propState == SVNNotification.NodeStatus.CONFLICTED ? SVNEntryStatus.Kind.CONFLICTED : SVNEntryStatus.Kind.NONE);
                        cState = state.contentState == SVNNotification.NodeStatus.CHANGED || state.contentState == SVNNotification.NodeStatus.MERGED ? SVNEntryStatus.Kind.MODIFIED : (state.contentState == SVNNotification.NodeStatus.CONFLICTED ? SVNEntryStatus.Kind.CONFLICTED : SVNEntryStatus.Kind.NONE);
                    } else if (state.action == SVNNotification.PerformedAction.SKIP) {
                        if (state.contentState == SVNNotification.NodeStatus.MISSING) {
                            try {
                                SVNRevision pegRev = reference1.pegRevision;
                                if (reference2 != null) {
                                    pegRev = reference2.pegRevision;
                                }
                                SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)new SVNEntryRevisionReference(endUrl, pegRev, to), (SVNDepth)SVNDepth.EMPTY, (ISVNProgressMonitor)monitor);
                                pState = SVNEntryStatus.Kind.MODIFIED;
                                cState = SVNEntryStatus.Kind.MODIFIED;
                            }
                            catch (Exception exception) {
                                cState = SVNEntryStatus.Kind.DELETED;
                            }
                        } else if (state.contentState == SVNNotification.NodeStatus.OBSTRUCTED) {
                            cState = SVNEntryStatus.Kind.ADDED;
                        }
                    }
                    if (cState != SVNEntryStatus.Kind.NONE || pState != SVNEntryStatus.Kind.NONE || hasTreeConflict) {
                        int idx;
                        long startRevision = -1L;
                        long endRevision = -1L;
                        long date = 0L;
                        String author = null;
                        String message = null;
                        monitor.progress(i, tmp.size(), JavaHLConnector.makeItemState(state));
                        if (cState == SVNEntryStatus.Kind.ADDED && !reversed || cState == SVNEntryStatus.Kind.DELETED && reversed || hasTreeConflict && (treeConflict.action == SVNConflictDescriptor.Action.ADD && !reversed || treeConflict.action == SVNConflictDescriptor.Action.DELETE && reversed)) {
                            idx = this.getLogIndex(allMsgs, endUrl, false);
                            if (idx != -1) {
                                endRevision = allMsgs[idx].revision;
                                date = allMsgs[idx].date;
                                author = allMsgs[idx].author;
                                message = allMsgs[idx].message;
                            }
                        } else if (cState == SVNEntryStatus.Kind.MODIFIED || cState == SVNEntryStatus.Kind.CONFLICTED || pState == SVNEntryStatus.Kind.MODIFIED || pState == SVNEntryStatus.Kind.CONFLICTED || hasTreeConflict && treeConflict.action == SVNConflictDescriptor.Action.MODIFY) {
                            idx = this.getLogIndex(allMsgs, endUrl, false);
                            if (idx != -1) {
                                endRevision = allMsgs[idx].revision;
                                date = allMsgs[idx].date;
                                author = allMsgs[idx].author;
                                message = allMsgs[idx].message;
                            }
                            startRevision = (idx = this.getLogIndex(allMsgs, startUrl, true)) != -1 ? Math.max(allMsgs[idx].revision, minRev) : minRev;
                        } else {
                            idx = this.getLogIndex(allMsgs, endUrl, false);
                            if (idx != -1) {
                                endRevision = allMsgs[idx].revision;
                                date = allMsgs[idx].date;
                                author = allMsgs[idx].author;
                                message = allMsgs[idx].message;
                            } else {
                                idx = this.getLogIndex(allMsgs, startUrl, false);
                                if (idx != -1) {
                                    endUrl = startUrl;
                                    endRevision = allMsgs[idx].revision;
                                    date = allMsgs[idx].date;
                                    author = allMsgs[idx].author;
                                    message = allMsgs[idx].message;
                                }
                            }
                            idx = this.getLogIndex(allMsgs, startUrl, true);
                            long l = startRevision = idx != -1 ? Math.max(allMsgs[idx].revision, minRev) : minRev;
                        }
                        if (reversed) {
                            startRevision = endRevision;
                            endRevision = allMsgs[allMsgs.length - 1].revision;
                            date = allMsgs[allMsgs.length - 1].date;
                            author = allMsgs[allMsgs.length - 1].author;
                            message = allMsgs[allMsgs.length - 1].message;
                        }
                        cb.next(new SVNMergeStatus(startUrl, endUrl, state.path, kind, cState, pState, startRevision, endRevision, date, author, message, skipped, hasTreeConflict, treeConflict));
                    }
                    ++i;
                }
                return;
            }
            catch (ClientException ex) {
                this.handleClientException(ex, null, null);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
                return;
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    protected SVNEntryReference getValidReference(SVNEntryReference referenceToExisting, SVNRevision lastRevision, ISVNProgressMonitor monitor) throws SVNConnectorException {
        if (referenceToExisting.pegRevision == null) {
            referenceToExisting = new SVNEntryReference(referenceToExisting.path, SVNRevision.HEAD);
        }
        if (referenceToExisting.pegRevision.getKind() != SVNRevision.Kind.HEAD && referenceToExisting.pegRevision.getKind() != SVNRevision.Kind.NUMBER) {
            throw new RuntimeException("Unexpected revision kind. Kind: " + referenceToExisting.pegRevision.getKind());
        }
        if (lastRevision.getKind() != SVNRevision.Kind.NUMBER) {
            throw new RuntimeException("Unexpected last revision kind. Kind: " + lastRevision.getKind());
        }
        if (referenceToExisting.pegRevision.getKind() == SVNRevision.Kind.HEAD) {
            return referenceToExisting;
        }
        long start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber();
        long end = ((SVNRevision.Number)lastRevision).getNumber();
        while (end > start) {
            referenceToExisting = this.getLastValidReference(referenceToExisting, lastRevision, monitor);
            if (referenceToExisting.pegRevision.equals((Object)lastRevision)) continue;
            start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber() + 1L;
            SVNEntryReference tRef = new SVNEntryReference(referenceToExisting.path, (SVNRevision)SVNRevision.fromNumber((long)start));
            while (!this.exists(tRef, monitor)) {
                tRef = new SVNEntryReference(tRef.path.substring(0, tRef.path.lastIndexOf("/")), tRef.pegRevision);
            }
            SVNLogEntry[] log = SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)tRef, (SVNRevision)tRef.pegRevision, (SVNRevision)referenceToExisting.pegRevision, (long)262144L, (String[])ISVNConnector.DEFAULT_LOG_ENTRY_PROPS, (long)0L, (ISVNProgressMonitor)monitor);
            SVNLogPath[] paths = log[0].changedPaths;
            boolean renamed = false;
            if (paths != null) {
                String decodedUrl = SVNUtility.decodeURL((String)referenceToExisting.path);
                int k = 0;
                while (k < paths.length) {
                    int idx;
                    if (paths[k].copiedFromPath != null && (idx = decodedUrl.indexOf(paths[k].copiedFromPath)) != -1 && (decodedUrl.charAt(idx + paths[k].copiedFromPath.length()) == '/' || decodedUrl.endsWith(paths[k].copiedFromPath))) {
                        decodedUrl = String.valueOf(decodedUrl.substring(0, idx)) + paths[k].path + decodedUrl.substring(idx + paths[k].copiedFromPath.length());
                        tRef = new SVNEntryReference(SVNUtility.encodeURL((String)decodedUrl), tRef.pegRevision);
                        renamed = true;
                        break;
                    }
                    ++k;
                }
            }
            referenceToExisting = tRef;
            if (renamed) continue;
            return referenceToExisting;
        }
        return referenceToExisting;
    }

    protected SVNEntryReference getLastValidReference(SVNEntryReference referenceToExisting, SVNRevision lastRevision, ISVNProgressMonitor monitor) {
        long start = ((SVNRevision.Number)referenceToExisting.pegRevision).getNumber();
        long end = ((SVNRevision.Number)lastRevision).getNumber();
        do {
            long middle;
            SVNEntryReference tRef;
            if (this.exists(tRef = new SVNEntryReference(referenceToExisting.path, (SVNRevision)SVNRevision.fromNumber((long)(middle = end - (end - start) / 2L))), monitor)) {
                start = middle;
                referenceToExisting = tRef;
                continue;
            }
            if (end - start == 1L) break;
            end = middle;
        } while (end > start);
        return referenceToExisting;
    }

    protected boolean exists(SVNEntryReference reference, ISVNProgressMonitor monitor) {
        try {
            SVNUtility.logEntries((ISVNConnector)this, (SVNEntryReference)reference, (SVNRevision)reference.pegRevision, (SVNRevision)reference.pegRevision, (long)0L, (String[])ISVNConnector.EMPTY_LOG_ENTRY_PROPS, (long)1L, (ISVNProgressMonitor)monitor);
            return true;
        }
        catch (SVNConnectorException sVNConnectorException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getLogIndex(SVNLogEntry[] msgs, String url, boolean last) {
        String decodedUrl = SVNUtility.decodeURL((String)url);
        int retVal = -1;
        int j = 0;
        while (j < msgs.length) {
            SVNLogPath[] paths = msgs[j].changedPaths;
            if (paths != null) {
                int maxPathIdx = -1;
                int maxPathLen = 0;
                int k = 0;
                while (k < paths.length) {
                    int idx;
                    if (paths[k] != null && decodedUrl.endsWith(paths[k].path)) {
                        if (!last) return j;
                        if (paths[k].copiedFromPath != null) {
                            maxPathIdx = k;
                            maxPathLen = paths[k].path.length();
                        }
                        retVal = paths[k].action == SVNLogPath.ChangeType.ADDED ? j : -1;
                    } else if (paths[k].copiedFromPath != null && (idx = decodedUrl.indexOf(paths[k].path)) != -1 && (decodedUrl.charAt(idx + paths[k].path.length()) == '/' || decodedUrl.endsWith(paths[k].path)) && paths[k].path.length() > maxPathLen) {
                        maxPathIdx = k;
                        maxPathLen = paths[k].path.length();
                    }
                    ++k;
                }
                if (maxPathIdx != -1) {
                    int idx = decodedUrl.indexOf(paths[maxPathIdx].path);
                    decodedUrl = String.valueOf(decodedUrl.substring(0, idx)) + paths[maxPathIdx].copiedFromPath + decodedUrl.substring(idx + paths[maxPathIdx].path.length());
                }
            }
            ++j;
        }
        return retVal;
    }

    public void importTo(String path, String url, String message, SVNDepth depth, long options, Map revProps, ISVNImportFilterCallback filter, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("url", url);
        parameters.put("message", message);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("filter", filter);
        parameters.put("monitor", monitor);
        this.fireAsked("importTo", parameters);
        path = (String)parameters.get("path");
        url = (String)parameters.get("url");
        message = (String)parameters.get("message");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        filter = (ISVNImportFilterCallback)parameters.get("filter");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.doImport(path, url, ConversionUtility.convertDepth(depth), (options & 0x100L) != 0L, (options & 0x1000L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), new CommitInfo(monitor));
                this.fireSucceeded("importTo", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "importTo", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public long exportTo(SVNEntryRevisionReference fromReference, String destPath, String nativeEOL, SVNDepth depth, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("fromReference", fromReference);
        parameters.put("destPath", destPath);
        parameters.put("nativeEOL", nativeEOL);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("exportTo", parameters);
        fromReference = (SVNEntryRevisionReference)parameters.get("fromReference");
        destPath = (String)parameters.get("destPath");
        nativeEOL = (String)parameters.get("nativeEOL");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            long retVal = this.client.doExport(fromReference.path, destPath, ConversionUtility.convert(fromReference.revision), ConversionUtility.convert(fromReference.pegRevision), (options & 4L) != 0L, (options & 1L) != 0L, ConversionUtility.convertDepth(depth), nativeEOL);
            this.fireSucceeded("exportTo", parameters, retVal);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "exportTo", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return 0L;
    }

    public void diffTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String relativeToDir, String fileName, SVNDepth depth, long options, String[] changeLists, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("relativeToDir", relativeToDir);
        parameters.put("fileName", fileName);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("diffTwoFile", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        relativeToDir = (String)parameters.get("relativeToDir");
        fileName = (String)parameters.get("fileName");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.diff(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), relativeToDir, fileName, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L);
                this.fireSucceeded("diffTwoFile", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffTwoFile", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diff(SVNEntryReference reference, SVNRevisionRange range, String relativeToDir, String fileName, SVNDepth depth, long options, String[] changeLists, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("range", range);
        parameters.put("relativeToDir", relativeToDir);
        parameters.put("fileName", fileName);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("diff", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        range = (SVNRevisionRange)parameters.get("range");
        relativeToDir = (String)parameters.get("relativeToDir");
        fileName = (String)parameters.get("fileName");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.diff(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(range.from), ConversionUtility.convert(range.to), relativeToDir, fileName, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L);
                this.fireSucceeded("diff", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diff", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, String relativeToDir, OutputStream stream, SVNDepth depth, long options, String[] changeLists, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        block21: {
            File tmpFile;
            JavaHLService.ProgressMonitorWrapper wrapper;
            block23: {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("reference1", reference1);
                parameters.put("reference2", reference2);
                parameters.put("relativeToDir", relativeToDir);
                parameters.put("stream", stream);
                parameters.put("depth", depth);
                parameters.put("options", options);
                parameters.put("changeLists", changeLists);
                parameters.put("monitor", monitor);
                this.fireAsked("diffTwoStream", parameters);
                reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
                reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
                relativeToDir = (String)parameters.get("relativeToDir");
                stream = (OutputStream)parameters.get("stream");
                depth = (SVNDepth)parameters.get("depth");
                options = (Long)parameters.get("options");
                changeLists = (String[])parameters.get("changeLists");
                monitor = (ISVNProgressMonitor)parameters.get("monitor");
                wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
                tmpFile = null;
                FileInputStream inputStream = null;
                try {
                    this.composite.add((ISVNNotificationCallback)wrapper);
                    wrapper.start();
                    tmpFile = File.createTempFile("diff", "tmp");
                    this.client.diff(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), relativeToDir, tmpFile.getAbsolutePath(), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L);
                    inputStream = new FileInputStream(tmpFile);
                    byte[] buffer = new byte[8192];
                    int len = 0;
                    while ((len = inputStream.read(buffer)) > 0) {
                        stream.write(buffer, 0, len);
                    }
                    this.fireSucceeded("diffTwoStream", parameters, null);
                }
                catch (ClientException ex) {
                    this.handleClientException(ex, "diffTwoStream", parameters);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    wrapper.finish();
                    this.composite.remove((ISVNNotificationCallback)wrapper);
                    break block21;
                }
                catch (IOException ex) {
                    block22: {
                        try {
                            this.handleCustomException(ex, "diffTwoStream", parameters);
                            if (inputStream == null) break block22;
                        }
                        catch (Throwable throwable) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (tmpFile != null) {
                                tmpFile.delete();
                            }
                            wrapper.finish();
                            this.composite.remove((ISVNNotificationCallback)wrapper);
                            throw throwable;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    wrapper.finish();
                    this.composite.remove((ISVNNotificationCallback)wrapper);
                    break block21;
                }
                if (inputStream == null) break block23;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diff(SVNEntryReference reference, SVNRevisionRange range, String relativeToDir, OutputStream stream, SVNDepth depth, long options, String[] changeLists, long outputOptions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        block21: {
            File tmpFile;
            JavaHLService.ProgressMonitorWrapper wrapper;
            block23: {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                parameters.put("reference", reference);
                parameters.put("range", range);
                parameters.put("relativeToDir", relativeToDir);
                parameters.put("stream", stream);
                parameters.put("depth", depth);
                parameters.put("options", options);
                parameters.put("changeLists", changeLists);
                parameters.put("monitor", monitor);
                this.fireAsked("diffStream", parameters);
                reference = (SVNEntryReference)parameters.get("reference");
                range = (SVNRevisionRange)parameters.get("range");
                relativeToDir = (String)parameters.get("relativeToDir");
                stream = (OutputStream)parameters.get("stream");
                depth = (SVNDepth)parameters.get("depth");
                options = (Long)parameters.get("options");
                changeLists = (String[])parameters.get("changeLists");
                monitor = (ISVNProgressMonitor)parameters.get("monitor");
                wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
                tmpFile = null;
                FileInputStream inputStream = null;
                try {
                    this.composite.add((ISVNNotificationCallback)wrapper);
                    wrapper.start();
                    tmpFile = File.createTempFile("diff", "tmp");
                    this.client.diff(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(range.from), ConversionUtility.convert(range.to), relativeToDir, tmpFile.getAbsolutePath(), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (options & 0x2000L) != 0L, (options & 4L) != 0L, (options & 0x400000L) != 0L);
                    inputStream = new FileInputStream(tmpFile);
                    byte[] buffer = new byte[8192];
                    int len = 0;
                    while ((len = inputStream.read(buffer)) > 0) {
                        stream.write(buffer, 0, len);
                    }
                    this.fireSucceeded("diffStream", parameters, null);
                }
                catch (ClientException ex) {
                    this.handleClientException(ex, "diffStream", parameters);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    wrapper.finish();
                    this.composite.remove((ISVNNotificationCallback)wrapper);
                    break block21;
                }
                catch (IOException ex) {
                    block22: {
                        try {
                            this.handleCustomException(ex, "diffTwoStream", parameters);
                            if (inputStream == null) break block22;
                        }
                        catch (Throwable throwable) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (tmpFile != null) {
                                tmpFile.delete();
                            }
                            wrapper.finish();
                            this.composite.remove((ISVNNotificationCallback)wrapper);
                            throw throwable;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpFile != null) {
                        tmpFile.delete();
                    }
                    wrapper.finish();
                    this.composite.remove((ISVNNotificationCallback)wrapper);
                    break block21;
                }
                if (inputStream == null) break block23;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffStatusTwo(SVNEntryRevisionReference reference1, SVNEntryRevisionReference reference2, SVNDepth depth, long options, String[] changeLists, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference1", reference1);
        parameters.put("reference2", reference2);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("diffStatusTwo", parameters);
        reference1 = (SVNEntryRevisionReference)parameters.get("reference1");
        reference2 = (SVNEntryRevisionReference)parameters.get("reference2");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        cb = (ISVNDiffStatusCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)reference1, (SVNDepth)SVNDepth.EMPTY, (ISVNProgressMonitor)monitor);
        boolean isFile = infos.length > 0 && infos[0] != null && infos[0].kind == SVNEntry.Kind.FILE;
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                DiffCallback callback = new DiffCallback(reference1.path, reference2.path, isFile, cb);
                this.client.diffSummarize(reference1.path, ConversionUtility.convert(reference1.revision), reference2.path, ConversionUtility.convert(reference2.revision), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (DiffSummaryCallback)callback);
                callback.doLastDiff();
                this.fireSucceeded("diffStatusTwo", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffStatusTwo", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void diffStatus(SVNEntryReference reference, SVNRevisionRange range, SVNDepth depth, long options, String[] changeLists, ISVNDiffStatusCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("range", range);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("diffStatus", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        range = (SVNRevisionRange)parameters.get("range");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        cb = (ISVNDiffStatusCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)this, (SVNEntryRevisionReference)new SVNEntryRevisionReference(reference, range.from), (SVNDepth)SVNDepth.EMPTY, (ISVNProgressMonitor)monitor);
        boolean isFile = infos.length > 0 && infos[0] != null && infos[0].kind == SVNEntry.Kind.FILE;
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                DiffCallback callback = new DiffCallback(reference.path, reference.path, isFile, cb);
                this.client.diffSummarize(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(range.from), ConversionUtility.convert(range.to), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 0x200L) != 0L, (DiffSummaryCallback)callback);
                callback.doLastDiff();
                this.fireSucceeded("diffStatus", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "diffStatus", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void getInfo(SVNEntryRevisionReference reference, SVNDepth depth, String[] changeLists, ISVNEntryInfoCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("depth", depth);
        parameters.put("changeLists", changeLists);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("getInfo", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        depth = (SVNDepth)parameters.get("depth");
        changeLists = (String[])parameters.get("changeLists");
        cb = (ISVNEntryInfoCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.info2(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convert(cb));
                this.fireSucceeded("getInfo", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "getInfo", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void streamFileContent(SVNEntryRevisionReference reference, int bufferSize, OutputStream stream, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("bufferSize", bufferSize);
        parameters.put("stream", stream);
        parameters.put("monitor", monitor);
        this.fireAsked("streamFileContent", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        bufferSize = (Integer)parameters.get("bufferSize");
        stream = (OutputStream)parameters.get("stream");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.streamFileContent(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), stream);
                this.fireSucceeded("streamFileContent", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "streamFileContent", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void mkdir(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("mkdir", parameters);
        path = (String[])parameters.get("path");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.mkdir(new HashSet<String>(Arrays.asList(path)), (options & 8L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), new CommitInfo(monitor));
                this.fireSucceeded("mkdir", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "mkdir", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void moveLocal(String[] srcPaths, String dstPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("dstPath", dstPath);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("moveLocal", parameters);
        srcPaths = (String[])parameters.get("srcPaths");
        dstPath = (String)parameters.get("dstPath");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.move(new HashSet<String>(Arrays.asList(srcPaths)), dstPath, (options & 4L) != 0L, true, false, null, null, null);
                this.fireSucceeded("moveLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "moveLocal", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void moveRemote(String[] srcPaths, String dstPath, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("dstPath", dstPath);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("moveRemote", parameters);
        srcPaths = (String[])parameters.get("srcPaths");
        dstPath = (String)parameters.get("dstPath");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.move(new HashSet<String>(Arrays.asList(srcPaths)), dstPath, (options & 4L) != 0L, (options & 0x8000L) != 0L, (options & 8L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), new CommitInfo(monitor));
                this.fireSucceeded("moveRemote", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "moveRemote", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void copyLocal(SVNEntryRevisionReference[] srcPaths, String destPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("destPath", destPath);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("copyLocal", parameters);
        srcPaths = (SVNEntryRevisionReference[])parameters.get("srcPaths");
        destPath = (String)parameters.get("destPath");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                CopySource[] srcs = new CopySource[srcPaths.length];
                int i = 0;
                while (i < srcPaths.length) {
                    srcs[i] = new CopySource(srcPaths[i].path, (Revision)(srcPaths[i].revision != null && srcPaths[i].revision.getKind() == SVNRevision.Kind.WORKING ? null : ConversionUtility.convert(srcPaths[i].revision)), null);
                    ++i;
                }
                this.client.copy(Arrays.asList(srcs), destPath, true, false, (options & 1L) != 0L, null, null, null);
                this.fireSucceeded("copyLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "copyLocal", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void copyRemote(SVNEntryRevisionReference[] srcPaths, String destPath, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("srcPaths", srcPaths);
        parameters.put("destPath", destPath);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("copyRemote", parameters);
        srcPaths = (SVNEntryRevisionReference[])parameters.get("srcPaths");
        destPath = (String)parameters.get("destPath");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.copy(Arrays.asList(ConversionUtility.convert(srcPaths)), destPath, (options & 0x8000L) != 0L, (options & 8L) != 0L, false, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), new CommitInfo(monitor));
                this.fireSucceeded("copyRemote", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "copyRemote", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void removeRemote(String[] path, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("removeRemote", parameters);
        path = (String[])parameters.get("path");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.remove(new HashSet<String>(Arrays.asList(path)), (options & 4L) != 0L, false, ConversionUtility.convertRevPropsToSVN(revProps), new CommitMessage(message), new CommitInfo(monitor));
                this.fireSucceeded("removeRemote", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeRemote", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void removeLocal(String[] path, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("removeLocal", parameters);
        path = (String[])parameters.get("path");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.remove(new HashSet<String>(Arrays.asList(path)), (options & 4L) != 0L, (options & 0x10000L) != 0L, null, null, null);
                this.fireSucceeded("removeLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeLocal", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void listHistoryLog(SVNEntryReference reference, SVNRevisionRange[] revisionRanges, String[] revProps, long limit, long options, ISVNLogEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revisionRanges", revisionRanges);
        parameters.put("revProps", revProps);
        parameters.put("limit", limit);
        parameters.put("options", options);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("listHistoryLog", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revisionRanges = (SVNRevisionRange[])parameters.get("revisionRanges");
        revProps = (String[])parameters.get("revProps");
        limit = (Long)parameters.get("limit");
        options = (Long)parameters.get("options");
        cb = (ISVNLogEntryCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                if (revProps == null) {
                    throw new NullPointerException("revProps argument cannot be null");
                }
                this.client.logMessages(reference.path, ConversionUtility.convert(reference.pegRevision), Arrays.asList(ConversionUtility.convert(revisionRanges)), (options & 0x20000L) != 0L, (options & 0x40000L) != 0L, (options & 0x80000L) != 0L, new HashSet<String>(Arrays.asList(revProps)), limit, ConversionUtility.convert(cb));
                this.fireSucceeded("listHistoryLog", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "listHistoryLog", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void annotate(SVNEntryReference reference, SVNRevision revisionStart, SVNRevision revisionEnd, long options, ISVNAnnotationCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("revisionStart", revisionStart);
        parameters.put("revisionEnd", revisionEnd);
        parameters.put("options", options);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("annotate", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        revisionStart = (SVNRevision)parameters.get("revisionStart");
        revisionEnd = (SVNRevision)parameters.get("revisionEnd");
        options = (Long)parameters.get("options");
        callback = (ISVNAnnotationCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.blame(reference.path, ConversionUtility.convert(reference.pegRevision), ConversionUtility.convert(revisionStart), ConversionUtility.convert(revisionEnd), (options & 0x100000L) != 0L, (options & 0x80000L) != 0L, ConversionUtility.convert(callback));
                this.fireSucceeded("annotate", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "annotate", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void listEntries(SVNEntryRevisionReference reference, SVNDepth depth, int direntFields, long options, ISVNEntryCallback cb, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("depth", depth);
        parameters.put("direntFields", direntFields);
        parameters.put("options", options);
        parameters.put("cb", cb);
        parameters.put("monitor", monitor);
        this.fireAsked("list", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        depth = (SVNDepth)parameters.get("depth");
        direntFields = (Integer)parameters.get("direntFields");
        options = (Long)parameters.get("options");
        final ISVNEntryCallback cb1 = (ISVNEntryCallback)parameters.get("cb");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.list(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), direntFields, (options & 0x200000L) != 0L, new ListCallback(){

                    public void doEntry(DirEntry dirent, Lock lock) {
                        String path = dirent.getPath();
                        if (path != null && path.length() != 0 || dirent.getNodeKind() == NodeKind.file) {
                            Date date = dirent.getLastChanged();
                            cb1.next(new SVNEntry(path, dirent.getLastChangedRevisionNumber(), date == null ? 0L : date.getTime(), dirent.getLastAuthor(), dirent.getHasProps(), ConversionUtility.convert(dirent.getNodeKind()), dirent.getSize(), ConversionUtility.convert(lock)));
                        }
                    }
                });
                this.fireSucceeded("list", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "list", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void listProperties(SVNEntryRevisionReference reference, SVNDepth depth, String[] changeLists, long options, ISVNPropertyCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("depth", depth);
        parameters.put("changeLists", changeLists);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("getProperties", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        depth = (SVNDepth)parameters.get("depth");
        changeLists = (String[])parameters.get("changeLists");
        callback = (ISVNPropertyCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.properties(reference.path, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision), ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), ConversionUtility.convert(callback));
                this.fireSucceeded("getProperties", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "getProperties", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNProperty getProperty(SVNEntryRevisionReference reference, String name, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("name", name);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("getProperty", parameters);
        reference = (SVNEntryRevisionReference)parameters.get("reference");
        name = (String)parameters.get("name");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            byte[] data = this.client.propertyGet(reference.path, name, ConversionUtility.convert(reference.revision), ConversionUtility.convert(reference.pegRevision));
            SVNProperty retVal = data != null ? new SVNProperty(name, data) : null;
            this.fireSucceeded("getProperty", parameters, retVal);
            SVNProperty sVNProperty = retVal;
            return sVNProperty;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getProperty", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void setPropertyLocal(String[] path, SVNProperty property, SVNDepth depth, long options, String[] changeLists, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("property", property);
        parameters.put("depth", depth);
        parameters.put("options", options);
        parameters.put("changeLists", changeLists);
        parameters.put("monitor", monitor);
        this.fireAsked("setPropertyLocal", parameters);
        path = (String[])parameters.get("path");
        property = (SVNProperty)parameters.get("property");
        depth = (SVNDepth)parameters.get("depth");
        options = (Long)parameters.get("options");
        changeLists = (String[])parameters.get("changeLists");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.propertySetLocal(new HashSet<String>(Arrays.asList(path)), property.name, property.binValue, ConversionUtility.convertDepth(depth), changeLists == null ? null : Arrays.asList(changeLists), (options & 4L) != 0L);
                this.fireSucceeded("setPropertyLocal", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "setPropertyLocal", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void setPropertyRemote(SVNEntryReference reference, SVNProperty property, String message, long options, Map revProps, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("property", property);
        parameters.put("message", message);
        parameters.put("options", options);
        parameters.put("revProps", revProps);
        parameters.put("monitor", monitor);
        this.fireAsked("setPropertyRemote", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        property = (SVNProperty)parameters.get("property");
        message = (String)parameters.get("message");
        options = (Long)parameters.get("options");
        revProps = (Map)parameters.get("revProps");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.propertySetRemote(reference.path, ((SVNRevision.Number)reference.pegRevision).getNumber(), property.name, property.binValue, new CommitMessage(message), (options & 4L) != 0L, ConversionUtility.convertRevPropsToSVN(revProps), new CommitInfo(monitor));
                this.fireSucceeded("setPropertyRemote", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "setPropertyRemote", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public SVNProperty[] listRevisionProperties(SVNEntryReference reference, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("monitor", monitor);
        this.fireAsked("listRevisionProperties", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNProperty[] retVal = ConversionUtility.convertRevProps(this.client.revProperties(reference.path, ConversionUtility.convert(reference.pegRevision)));
            this.fireSucceeded("listRevisionProperties", parameters, retVal);
            SVNProperty[] sVNPropertyArray = retVal;
            return sVNPropertyArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "listRevisionProperties", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public SVNProperty getRevisionProperty(SVNEntryReference reference, String name, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("name", name);
        parameters.put("monitor", monitor);
        this.fireAsked("getRevisionProperty", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        name = (String)parameters.get("name");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNNotificationCallback)wrapper);
            wrapper.start();
            SVNProperty retVal = new SVNProperty(name, this.client.revProperty(reference.path, name, ConversionUtility.convert(reference.pegRevision)));
            this.fireSucceeded("getRevisionProperty", parameters, retVal);
            SVNProperty sVNProperty = retVal;
            return sVNProperty;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "getRevisionProperty", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
        return null;
    }

    public void setRevisionProperty(SVNEntryReference reference, SVNProperty property, String originalValue, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("property", property);
        parameters.put("originalValue", originalValue);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("setRevisionProperty", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        property = (SVNProperty)parameters.get("property");
        originalValue = (String)parameters.get("originalValue");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.setRevProperty(reference.path, property.name, ConversionUtility.convert(reference.pegRevision), property.value, originalValue, (options & 4L) != 0L);
                this.fireSucceeded("setRevisionProperty", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "setRevisionProperty", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void upgrade(String path, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("monitor", monitor);
        this.fireAsked("upgrade", parameters);
        path = (String)parameters.get("path");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.upgrade(path);
                this.fireSucceeded("upgrade", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "upgrade", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void patch(String patchPath, String targetPath, int stripCount, long options, ISVNPatchCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("patchPath", patchPath);
        parameters.put("targetPath", targetPath);
        parameters.put("stripCount", stripCount);
        parameters.put("options", options);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("patch", parameters);
        patchPath = (String)parameters.get("patchPath");
        targetPath = (String)parameters.get("targetPath");
        stripCount = (Integer)parameters.get("stripCount");
        options = (Long)parameters.get("options");
        callback = (ISVNPatchCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNNotificationCallback)wrapper);
                wrapper.start();
                this.client.patch(patchPath, targetPath, (options & 0x400L) != 0L, stripCount, (options & 0x800000L) != 0L, (options & 0x1000000L) != 0L, (options & 0x2000000L) != 0L, ConversionUtility.convert(callback));
                this.fireSucceeded("patch", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "patch", parameters);
                wrapper.finish();
                this.composite.remove((ISVNNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNNotificationCallback)wrapper);
        }
    }

    public void dispose() {
        this.client.dispose();
    }

    protected void handleCustomException(Throwable ex, String methodName, Map<String, Object> parameters) throws SVNConnectorException {
        SVNConnectorException exception = new SVNConnectorException(ex);
        this.fireFailed(methodName, parameters, exception);
        throw exception;
    }

    @Override
    protected void cancelOperation() throws Exception {
        this.client.cancelOperation();
    }

    protected class CommitInfo
    implements CommitCallback {
        public org.apache.subversion.javahl.CommitInfo info;
        private ISVNProgressMonitor monitor;

        public CommitInfo(ISVNProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void commitInfo(org.apache.subversion.javahl.CommitInfo info) {
            this.info = info;
            this.monitor.commitStatus(ConversionUtility.convert(info));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CommitMessage
    implements CommitMessageCallback {
        private String message;

        public CommitMessage(String message) {
            this.message = message == null ? "" : message;
        }

        @Override
        public String getLogMessage(Set<CommitItem> elementsToBeCommitted) {
            return this.message;
        }
    }

    private class DiffCallback
    implements DiffSummaryCallback {
        private String prev;
        private String next;
        private boolean isFile;
        private SVNDiffStatus savedDiff;
        private ISVNDiffStatusCallback cb;

        public DiffCallback(String prev, String next, boolean isFile, ISVNDiffStatusCallback cb) {
            this.prev = SVNUtility.decodeURL((String)prev);
            this.next = SVNUtility.decodeURL((String)next);
            this.isFile = isFile;
            this.cb = cb;
        }

        public void onSummary(DiffSummary descriptor) {
            SVNEntryStatus.Kind propChangeType;
            SVNEntryStatus.Kind changeType = SVNEntryStatus.Kind.NORMAL;
            if (descriptor.getDiffKind() == DiffSummary.DiffKind.added) {
                changeType = SVNEntryStatus.Kind.ADDED;
            } else if (descriptor.getDiffKind() == DiffSummary.DiffKind.deleted) {
                changeType = SVNEntryStatus.Kind.DELETED;
            } else if (descriptor.getDiffKind() == DiffSummary.DiffKind.modified) {
                changeType = SVNEntryStatus.Kind.MODIFIED;
            }
            SVNEntryStatus.Kind kind = propChangeType = descriptor.propsChanged() ? SVNEntryStatus.Kind.MODIFIED : SVNEntryStatus.Kind.NORMAL;
            if (changeType != SVNEntryStatus.Kind.NORMAL || propChangeType != SVNEntryStatus.Kind.NORMAL) {
                String tPath1;
                String tPath2 = tPath1 = descriptor.getPath();
                if (tPath1.length() == 0 || this.isFile) {
                    tPath1 = this.prev;
                    tPath2 = this.next;
                } else {
                    tPath1 = String.valueOf(this.prev) + "/" + tPath1;
                    tPath2 = String.valueOf(this.next) + "/" + tPath2;
                }
                SVNDiffStatus status = new SVNDiffStatus(SVNUtility.encodeURL((String)tPath1), SVNUtility.encodeURL((String)tPath2), ConversionUtility.convert(descriptor.getNodeKind()), changeType, propChangeType);
                if (this.savedDiff != null) {
                    if (this.savedDiff.pathPrev.equals(status.pathPrev) && this.savedDiff.pathNext.equals(status.pathNext) && this.savedDiff.textStatus == SVNEntryStatus.Kind.DELETED && status.textStatus == SVNEntryStatus.Kind.ADDED) {
                        this.savedDiff = new SVNDiffStatus(SVNUtility.encodeURL((String)tPath1), SVNUtility.encodeURL((String)tPath2), ConversionUtility.convert(descriptor.getNodeKind()), SVNEntryStatus.Kind.REPLACED, SVNEntryStatus.Kind.NORMAL);
                        status = null;
                    }
                    this.cb.next(this.savedDiff);
                }
                this.savedDiff = status;
            }
        }

        public void doLastDiff() {
            if (this.savedDiff != null) {
                this.cb.next(this.savedDiff);
            }
        }
    }

    protected class RepositoryInfoPrompt
    implements UserPasswordCallback {
        protected ISVNCredentialsPrompt prompt;

        public RepositoryInfoPrompt(ISVNCredentialsPrompt prompt) {
            this.prompt = prompt;
        }

        public boolean prompt(String realm, String username) {
            return this.prompt.prompt(null, realm);
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            return this.prompt.prompt(null, realm);
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return this.prompt.askTrustSSLServer(null, (String)info, (boolean)allowPermanently).id;
        }

        public String getUsername() {
            return this.prompt.getUsername();
        }

        public String getPassword() {
            return this.prompt.getPassword();
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return false;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            if (question.indexOf("certificate filename") != -1) {
                if (JavaHLConnector.this.sslCertificate != null) {
                    String retVal = JavaHLConnector.this.sslCertificate;
                    return retVal;
                }
                if (!this.prompt.promptSSL(null, realm)) {
                    return null;
                }
                JavaHLConnector.this.sslPassphrase = this.prompt.getSSLClientCertPassword();
                return this.prompt.getSSLClientCertPath();
            }
            if (question.indexOf("certificate passphrase") != -1) {
                if (JavaHLConnector.this.sslPassphrase != null) {
                    String retVal = JavaHLConnector.this.sslPassphrase;
                    return retVal;
                }
                if (!this.prompt.promptSSL(null, realm)) {
                    return null;
                }
                return this.prompt.getSSLClientCertPassword();
            }
            return null;
        }

        public String askQuestion(String realm, String question, boolean showAnswer) {
            return null;
        }

        public boolean userAllowedSave() {
            return this.prompt.isSaveCredentialsEnabled();
        }
    }
}

