/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.editor.WikiTextDocumentProvider;
import org.eclipse.mylyn.wikitext.ui.editor.WikiTextSourcePartitioning;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public abstract class AbstractWikiTextDocumentProvider
extends StorageDocumentProvider
implements WikiTextDocumentProvider {
    private MarkupLanguage markupLanguage;

    protected void setupDocument(Object element, IDocument document) {
        super.setupDocument(element, document);
        WikiTextSourcePartitioning.configurePartitioning(document, this.markupLanguage);
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    @Override
    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        IFile file;
        if (element instanceof IAdaptable && (file = (IFile)((IAdaptable)element).getAdapter(IFile.class)) != null) {
            return new ResourceMarkerAnnotationModel((IResource)file);
        }
        return new AnnotationModel();
    }

    protected abstract void doSaveDocument(IProgressMonitor var1, Object var2, IDocument var3, boolean var4) throws CoreException;
}

