/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.indexdiff.GitResourceDeltaVisitor;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffUpdateJob;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.InterIndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;

public class IndexDiffCacheEntry {
    private static final int RESOURCE_LIST_UPDATE_LIMIT = 1000;
    private Repository repository;
    private volatile IndexDiffData indexDiffData;
    private Job reloadJob;
    private volatile boolean reloadJobIsInitializing;
    private IndexDiffUpdateJob updateJob;
    private DirCache lastIndex;
    private ReentrantLock lock = new ReentrantLock(true);
    private Set<IndexDiffChangedListener> listeners = new HashSet<IndexDiffChangedListener>();
    private final ListenerHandle indexChangedListenerHandle;
    private final ListenerHandle refsChangedListenerHandle;
    private IResourceChangeListener resourceChangeListener;
    private static Semaphore parallelism = new Semaphore(2);

    public IndexDiffCacheEntry(Repository repository) {
        this.repository = repository;
        this.indexChangedListenerHandle = repository.getListenerList().addIndexChangedListener(new IndexChangedListener(){

            public void onIndexChanged(IndexChangedEvent event) {
                IndexDiffCacheEntry.this.refreshIndexDelta();
            }
        });
        this.refsChangedListenerHandle = repository.getListenerList().addRefsChangedListener(new RefsChangedListener(){

            public void onRefsChanged(RefsChangedEvent event) {
                IndexDiffCacheEntry.this.scheduleReloadJob("RefsChanged");
            }
        });
        this.scheduleReloadJob("IndexDiffCacheEntry construction");
        this.createResourceChangeListener();
        if (!repository.isBare()) {
            try {
                this.lastIndex = repository.readDirCache();
            }
            catch (IOException ex) {
                Activator.error(MessageFormat.format(CoreText.IndexDiffCacheEntry_errorCalculatingIndexDelta, repository), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexDiffChangedListener(IndexDiffChangedListener listener) {
        Set<IndexDiffChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexDiffChangedListener(IndexDiffChangedListener listener) {
        Set<IndexDiffChangedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public Job createRefreshResourcesAndIndexDiffJob() {
        String repositoryName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
        String jobName = MessageFormat.format(CoreText.IndexDiffCacheEntry_refreshingProjects, repositoryName);
        WorkspaceJob job = new WorkspaceJob(jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    IProject[] validOpenProjects = ProjectUtil.getValidOpenProjects(IndexDiffCacheEntry.this.repository);
                    ProjectUtil.refreshResources((IResource[])validOpenProjects, monitor);
                }
                catch (CoreException e) {
                    return Activator.error(e.getMessage(), e);
                }
                IndexDiffCacheEntry.this.refresh();
                return Status.OK_STATUS;
            }
        };
        job.setRule(RuleUtil.getRule(this.repository));
        return job;
    }

    public void refresh() {
        this.scheduleReloadJob("Refresh called");
    }

    public void refreshFiles(Collection<String> filesToRefresh) {
        List<IResource> resources = Collections.emptyList();
        this.scheduleUpdateJob(filesToRefresh, resources);
    }

    private void refreshIndexDelta() {
        if (this.repository.isBare()) {
            return;
        }
        try {
            DirCache currentIndex = this.repository.readDirCache();
            DirCache oldIndex = this.lastIndex;
            this.lastIndex = currentIndex;
            if (oldIndex == null) {
                this.refresh();
                return;
            }
            TreeSet<String> paths = new TreeSet<String>();
            Throwable throwable = null;
            Object var5_7 = null;
            try (TreeWalk walk = new TreeWalk(this.repository);){
                walk.addTree((AbstractTreeIterator)new DirCacheIterator(oldIndex));
                walk.addTree((AbstractTreeIterator)new DirCacheIterator(currentIndex));
                walk.setFilter((TreeFilter)new InterIndexDiffFilter());
                while (walk.next()) {
                    if (walk.isSubtree()) {
                        walk.enterSubtree();
                        continue;
                    }
                    paths.add(walk.getPathString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!paths.isEmpty()) {
                this.refreshFiles(paths);
            }
        }
        catch (IOException ex) {
            Activator.error(MessageFormat.format(CoreText.IndexDiffCacheEntry_errorCalculatingIndexDelta, this.repository), ex);
            this.scheduleReloadJob("Exception while calculating index delta, doing full reload instead");
        }
    }

    public IndexDiffData getIndexDiff() {
        return this.indexDiffData;
    }

    protected void scheduleReloadJob(final String trigger) {
        if (this.reloadJob != null) {
            if (this.reloadJobIsInitializing) {
                return;
            }
            this.reloadJob.cancel();
        }
        if (this.updateJob != null) {
            this.updateJob.cleanupAndCancel();
        }
        if (!this.checkRepository()) {
            return;
        }
        this.reloadJob = new Job(this.getReloadJobName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IndexDiffCacheEntry.this.reloadJobIsInitializing = true;
                    IndexDiffCacheEntry.this.waitForWorkspaceLock(monitor);
                }
                finally {
                    IndexDiffCacheEntry.this.reloadJobIsInitializing = false;
                }
                IndexDiffCacheEntry.this.lock.lock();
                try {
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    parallelism.acquire();
                    long startTime = System.currentTimeMillis();
                    IndexDiffData result = IndexDiffCacheEntry.this.calcIndexDiffDataFull(monitor, this.getName());
                    if (monitor.isCanceled() || result == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IndexDiffCacheEntry.this.indexDiffData = result;
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        long time = System.currentTimeMillis() - startTime;
                        StringBuilder message = new StringBuilder(this.getTraceMessage(time));
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), message.append(IndexDiffCacheEntry.this.indexDiffData.toString()).toString());
                    }
                    IndexDiffCacheEntry.this.notifyListeners();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (IOException e) {
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), "Calculating IndexDiff failed", (Throwable)e);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InterruptedException interruptedException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    IndexDiffCacheEntry.this.lock.unlock();
                    parallelism.release();
                }
            }

            private String getTraceMessage(long time) {
                return NLS.bind((String)"\nUpdated IndexDiffData in {0} ms\nReason: {1}\nRepository: {2}\n", (Object[])new Object[]{time, trigger, IndexDiffCacheEntry.this.repository.getWorkTree().getName()});
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.INDEX_DIFF_CACHE_UPDATE.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        this.reloadJob.setSystem(true);
        this.reloadJob.schedule();
    }

    private boolean checkRepository() {
        if (Activator.getDefault() == null) {
            return false;
        }
        return this.repository.getDirectory().exists();
    }

    private void waitForWorkspaceLock(IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            try {
                Job.getJobManager().beginRule((ISchedulingRule)root, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                Job.getJobManager().endRule((ISchedulingRule)root);
                return;
            }
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)root);
        }
    }

    protected void scheduleUpdateJob(Collection<String> filesToUpdate, Collection<IResource> resourcesToUpdate) {
        if (!this.checkRepository()) {
            return;
        }
        if (this.reloadJob != null && this.reloadJobIsInitializing) {
            return;
        }
        if (this.shouldReload(filesToUpdate)) {
            this.scheduleReloadJob("Too many resources changed: " + filesToUpdate.size());
            return;
        }
        if (this.updateJob != null) {
            this.updateJob.addChanges(filesToUpdate, resourcesToUpdate);
            return;
        }
        this.updateJob = new IndexDiffUpdateJob(this.getUpdateJobName(), 10L){

            @Override
            protected IStatus updateIndexDiff(Collection<String> files, Collection<IResource> resources, IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (IndexDiffCacheEntry.this.shouldReload(files)) {
                    IndexDiffCacheEntry.this.scheduleReloadJob("Too many resources changed: " + files.size());
                    return Status.CANCEL_STATUS;
                }
                IndexDiffCacheEntry.this.waitForWorkspaceLock(monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                IndexDiffCacheEntry.this.lock.lock();
                try {
                    long startTime = System.currentTimeMillis();
                    IndexDiffData result = IndexDiffCacheEntry.this.calcIndexDiffDataIncremental(monitor, this.getName(), files, resources);
                    if (monitor.isCanceled() || result == null) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IndexDiffCacheEntry.this.indexDiffData = result;
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        long time = System.currentTimeMillis() - startTime;
                        StringBuilder message = new StringBuilder(NLS.bind((String)"Updated IndexDiffData based on resource list (length = {0}) in {1} ms\n", (Object)resources.size(), (Object)time));
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), message.append(IndexDiffCacheEntry.this.indexDiffData.toString()).toString());
                    }
                    IndexDiffCacheEntry.this.notifyListeners();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (IOException e) {
                    if (GitTraceLocation.INDEXDIFFCACHE.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.INDEXDIFFCACHE.getLocation(), "Calculating IndexDiff failed", (Throwable)e);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    IndexDiffCacheEntry.this.lock.unlock();
                }
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.INDEX_DIFF_CACHE_UPDATE.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        this.updateJob.addChanges(filesToUpdate, resourcesToUpdate);
    }

    protected boolean shouldReload(Collection<String> filesToUpdate) {
        return filesToUpdate.size() > 1000;
    }

    private IndexDiffData calcIndexDiffDataIncremental(IProgressMonitor monitor, String jobName, Collection<String> filesToUpdate, Collection<IResource> resourcesToUpdate) throws IOException {
        if (this.indexDiffData == null) {
            return this.calcIndexDiffDataFull(monitor, jobName);
        }
        EclipseGitProgressTransformer jgitMonitor = new EclipseGitProgressTransformer(monitor);
        List<String> treeFilterPaths = this.calcTreeFilterPaths(filesToUpdate);
        WorkingTreeIterator iterator = IteratorService.createInitialIterator(this.repository);
        if (iterator == null) {
            return null;
        }
        IndexDiff diffForChangedResources = new IndexDiff(this.repository, "HEAD", iterator);
        diffForChangedResources.setFilter(PathFilterGroup.createFromStrings(treeFilterPaths));
        diffForChangedResources.diff((ProgressMonitor)jgitMonitor, 0, 0, jobName);
        return new IndexDiffData(this.indexDiffData, filesToUpdate, resourcesToUpdate, diffForChangedResources);
    }

    private List<String> calcTreeFilterPaths(Collection<String> filesToUpdate) {
        ArrayList<String> paths = new ArrayList<String>();
        for (String fileToUpdate : filesToUpdate) {
            for (String untrackedFolder : this.indexDiffData.getUntrackedFolders()) {
                if (!fileToUpdate.startsWith(untrackedFolder)) continue;
                paths.add(untrackedFolder);
            }
            paths.add(fileToUpdate);
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        IndexDiffChangedListener[] tmpListeners;
        Set<IndexDiffChangedListener> set = this.listeners;
        synchronized (set) {
            tmpListeners = this.listeners.toArray(new IndexDiffChangedListener[this.listeners.size()]);
        }
        int i = 0;
        while (i < tmpListeners.length) {
            try {
                tmpListeners[i].indexDiffChanged(this.repository, this.indexDiffData);
            }
            catch (RuntimeException e) {
                Activator.logError("Exception occured in an IndexDiffChangedListener", e);
            }
            ++i;
        }
    }

    private IndexDiffData calcIndexDiffDataFull(IProgressMonitor monitor, String jobName) throws IOException {
        EclipseGitProgressTransformer jgitMonitor = new EclipseGitProgressTransformer(monitor);
        WorkingTreeIterator iterator = IteratorService.createInitialIterator(this.repository);
        if (iterator == null) {
            return null;
        }
        IndexDiff newIndexDiff = new IndexDiff(this.repository, "HEAD", iterator);
        newIndexDiff.diff((ProgressMonitor)jgitMonitor, 0, 0, jobName);
        return new IndexDiffData(newIndexDiff);
    }

    private String getReloadJobName() {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
        return MessageFormat.format(CoreText.IndexDiffCacheEntry_reindexing, repoName);
    }

    private String getUpdateJobName() {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository);
        return MessageFormat.format(CoreText.IndexDiffCacheEntry_reindexingIncrementally, repoName);
    }

    private void createResourceChangeListener() {
        this.resourceChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                GitResourceDeltaVisitor visitor = new GitResourceDeltaVisitor(IndexDiffCacheEntry.this.repository);
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e) {
                    Activator.logError(e.getMessage(), e);
                    return;
                }
                Collection<String> filesToUpdate = visitor.getFilesToUpdate();
                if (visitor.getGitIgnoreChanged()) {
                    IndexDiffCacheEntry.this.scheduleReloadJob("A .gitignore changed");
                } else if (IndexDiffCacheEntry.this.indexDiffData == null) {
                    IndexDiffCacheEntry.this.scheduleReloadJob("Resource changed, no diff available");
                } else if (!filesToUpdate.isEmpty()) {
                    IndexDiffCacheEntry.this.scheduleUpdateJob(filesToUpdate, visitor.getResourcesToUpdate());
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected IndexDiffUpdateJob getUpdateJob() {
        return this.updateJob;
    }

    public void dispose() {
        this.indexChangedListenerHandle.remove();
        this.refsChangedListenerHandle.remove();
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
    }
}

