/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.storage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.io.AutoCRLFInputStream;
import org.eclipse.osgi.util.NLS;

public class GitBlobStorage
implements IEncodedStorage {
    protected final Repository db;
    protected final String path;
    protected final ObjectId blobId;
    private String charset;

    public GitBlobStorage(Repository repository, String path, ObjectId blob) {
        this.db = repository;
        this.path = path;
        this.blobId = blob;
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.open();
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.BlobStorage_errorReadingBlob, (Object)this.blobId.name(), (Object)this.path), e));
        }
    }

    private InputStream open() throws IOException, CoreException, IncorrectObjectTypeException {
        if (this.blobId == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            WorkingTreeOptions workingTreeOptions = (WorkingTreeOptions)this.db.getConfig().get(WorkingTreeOptions.KEY);
            ObjectStream objectInputStream = this.db.open((AnyObjectId)this.blobId, 3).openStream();
            switch (workingTreeOptions.getAutoCRLF()) {
                case FALSE: 
                case INPUT: {
                    return objectInputStream;
                }
            }
            return new AutoCRLFInputStream((InputStream)objectInputStream, true);
        }
        catch (MissingObjectException notFound) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.BlobStorage_blobNotFound, (Object)this.blobId.name(), (Object)this.path), notFound));
        }
    }

    public IPath getFullPath() {
        return Path.fromPortableString((String)this.path);
    }

    public String getName() {
        int last = this.path.lastIndexOf(47);
        return last >= 0 ? this.path.substring(last + 1) : this.path;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.blobId, this.db, this.path});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GitBlobStorage other = (GitBlobStorage)obj;
        if (this.blobId == null ? other.blobId != null : !this.blobId.equals((AnyObjectId)other.blobId)) {
            return false;
        }
        if (this.db == null ? other.db != null : !this.db.equals(other.db)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public IPath getAbsolutePath() {
        if (this.db.isBare()) {
            return null;
        }
        return new Path(String.valueOf(this.db.getWorkTree().getAbsolutePath()) + File.separatorChar + this.path);
    }

    public String getCharset() throws CoreException {
        if (this.charset == null) {
            this.charset = CompareCoreUtils.getResourceEncoding(this.db, this.path);
        }
        return this.charset;
    }
}

