/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model;

public enum TraceLogLevel {
    TRACE_EMERG("TRACE_EMERG"),
    TRACE_ALERT("TRACE_ALERT"),
    TRACE_CRIT("TRACE_CRIT"),
    TRACE_ERR("TRACE_ERR"),
    TRACE_WARNING("TRACE_WARNING"),
    TRACE_NOTICE("TRACE_NOTICE"),
    TRACE_INFO("TRACE_INFO"),
    TRACE_DEBUG_SYSTEM("TRACE_DEBUG_SYSTEM"),
    TRACE_DEBUG_PROGRAM("TRACE_DEBUG_PROGRAM"),
    TRACE_DEBUG_PROCESS("TRACE_DEBUG_PROCESS"),
    TRACE_DEBUG_MODULE("TRACE_DEBUG_MODULE"),
    TRACE_DEBUG_UNIT("TRACE_DEBUG_UNIT"),
    TRACE_DEBUG_FUNCTION("TRACE_DEBUG_FUNCTION"),
    TRACE_DEBUG_LINE("TRACE_DEBUG_LINE"),
    TRACE_DEBUG("TRACE_DEBUG"),
    LEVEL_UNKNOWN("LEVEL_UNKNOWN");

    private final String fInName;

    private TraceLogLevel(String name) {
        this.fInName = name;
    }

    public String getInName() {
        return this.fInName;
    }

    public static TraceLogLevel valueOfString(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        TraceLogLevel[] traceLogLevelArray = TraceLogLevel.values();
        int n = traceLogLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceLogLevel tllevel = traceLogLevelArray[n2];
            if (tllevel.getInName().equalsIgnoreCase(name)) {
                return tllevel;
            }
            ++n2;
        }
        return LEVEL_UNKNOWN;
    }
}

