/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.action;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.internal.gprof.dialog.OpenGmonDialog;
import org.eclipse.linuxtools.internal.gprof.view.GmonView;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PlatformUI;

public class OpenGmonAction
implements IEditorLauncher {
    public void open(IPath file) {
        String s = this.getDefaultBinary(file);
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        OpenGmonDialog d = new OpenGmonDialog(shell, s, file);
        if (d.open() != 0) {
            return;
        }
        String binaryPath = d.getBinaryFile();
        IProject project = null;
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
        if (f != null) {
            project = f.getProject();
        }
        GmonView.displayGprofView(binaryPath, file.toOSString(), project);
    }

    private String getDefaultBinary(IPath file) {
        ICProject cproject;
        IProject project = null;
        IFile c = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
        if (c != null && (project = c.getProject()) != null && project.exists() && (cproject = CoreModel.getDefault().create(project)) != null) {
            try {
                IBinary[] b = cproject.getBinaryContainer().getBinaries();
                if (b != null && b.length > 0 && b[0] != null) {
                    IResource r = b[0].getResource();
                    return r.getLocation().toOSString();
                }
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
        return "";
    }
}

