/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.core.operation.local.DiffViewerSettings;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.DiffViewerFileAssociationsComposite;
import org.eclipse.team.svn.ui.preferences.AbstractSVNTeamPreferencesPage;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SVNTeamDiffViewerPage
extends AbstractSVNTeamPreferencesPage {
    protected DiffViewerFileAssociationsComposite fileAssociationsComposite;
    protected DiffViewerSettings diffSettings;

    public void init(IWorkbench workbench) {
        this.setDescription(SVNUIMessages.SVNTeamDiffViewerPage_Description);
    }

    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)layout);
        this.fileAssociationsComposite = new DiffViewerFileAssociationsComposite(composite, this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.diffViewerPreferencesContext");
        return composite;
    }

    protected void initializeControls() {
        this.fileAssociationsComposite.initializeControls(this.diffSettings);
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        this.diffSettings = DiffViewerSettings.getDefaultDiffViewerSettings();
    }

    protected void loadValues(IPreferenceStore store) {
        this.diffSettings = SVNTeamDiffViewerPage.loadDiffViewerSettings(store);
    }

    protected void saveValues(IPreferenceStore store) {
        SVNTeamDiffViewerPage.saveDiffViewerSettings(this.diffSettings, store);
    }

    public static DiffViewerSettings loadDiffViewerSettings() {
        return SVNTeamDiffViewerPage.loadDiffViewerSettings(SVNTeamUIPlugin.instance().getPreferenceStore());
    }

    public static DiffViewerSettings loadDiffViewerSettings(IPreferenceStore store) {
        DiffViewerSettings diffSettings = new DiffViewerSettings();
        String encodedString = SVNTeamPreferences.getDiffViewerString(store, "resources.specific.parameters");
        String[] stringArray = FileUtility.decodeStringToArray((String)encodedString);
        if (stringArray.length > 0 && stringArray.length % 7 == 0) {
            int paramsCount = stringArray.length / 7;
            int i = 0;
            while (i < paramsCount) {
                String[] strings = new String[7];
                int j = 0;
                while (j < 7) {
                    strings[j] = stringArray[i * 7 + j];
                    ++j;
                }
                DiffViewerSettings.ResourceSpecificParameters param = DiffViewerSettings.ResourceSpecificParameters.createFromStrings((String[])strings);
                if (param != null) {
                    diffSettings.addResourceSpecificParameters(param);
                }
                ++i;
            }
        }
        return diffSettings;
    }

    public static void saveDiffViewerSettings(DiffViewerSettings diffSettings, IPreferenceStore store) {
        SVNTeamDiffViewerPage.saveDiffViewerSettings(diffSettings, store, false);
    }

    public static void saveDiffViewerSettings(DiffViewerSettings diffSettings, IPreferenceStore store, boolean isDefault) {
        DiffViewerSettings.ResourceSpecificParameters[] resourceParams = diffSettings.getResourceSpecificParameters();
        if (resourceParams.length > 0) {
            String[] stringArray = new String[7 * resourceParams.length];
            int i = 0;
            while (i < resourceParams.length) {
                DiffViewerSettings.ResourceSpecificParameters resourceParam = resourceParams[i];
                String[] strings = resourceParam.getAsStrings();
                System.arraycopy(strings, 0, stringArray, 7 * i, strings.length);
                ++i;
            }
            String encodedString = FileUtility.encodeArrayToString((String[])stringArray);
            SVNTeamPreferences.setDiffViewerString(store, "resources.specific.parameters", encodedString, isDefault);
        } else {
            SVNTeamPreferences.setDiffViewerString(store, "resources.specific.parameters", "", isDefault);
        }
    }
}

