/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.UpdateSubscriber;
import org.eclipse.team.svn.ui.action.IResourceSelector;
import org.eclipse.team.svn.ui.synchronize.FilteredSynchronizeModelOperation;
import org.eclipse.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;

public abstract class AbstractSynchronizeModelAction
extends SynchronizeModelAction {
    protected IResourceSelector syncInfoSelector;

    public AbstractSynchronizeModelAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
        this.setEnabled(false);
        this.setToolTipText(text);
        this.createSyncInfoSelector();
    }

    public AbstractSynchronizeModelAction(String text, ISynchronizePageConfiguration configuration, ISelectionProvider selectionProvider) {
        super(text, configuration, selectionProvider);
        this.setEnabled(false);
        this.setToolTipText(text);
        this.createSyncInfoSelector();
    }

    protected final SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        IActionOperation op = this.getOperation(configuration, elements);
        return new FilteredSynchronizeModelOperation(configuration, elements, op);
    }

    protected abstract IActionOperation getOperation(ISynchronizePageConfiguration var1, IDiffElement[] var2);

    protected void createSyncInfoSelector() {
        this.syncInfoSelector = new IResourceSelector(){

            public IResource[] getSelectedResources() {
                return this.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(IStateFilter.SF_ALL, false));
            }

            public IResource[] getSelectedResources(IStateFilter filter) {
                if (filter instanceof ISyncStateFilter) {
                    return this.getSelectedResources((ISyncStateFilter)filter);
                }
                return this.getSelectedResources(new ISyncStateFilter.StateFilterWrapper(filter, false));
            }

            public IResource[] getSelectedResourcesRecursive(IStateFilter filter) {
                return this.getSelectedResources(filter);
            }

            public IResource[] getSelectedResourcesRecursive(IStateFilter filter, int depth) {
                return this.getSelectedResources(filter);
            }

            private IResource[] getSelectedResources(ISyncStateFilter filter) {
                AbstractSVNSyncInfo[] infos = AbstractSynchronizeModelAction.this.getSVNSyncInfos();
                HashSet<Object> retVal = new HashSet<Object>();
                int i = 0;
                while (i < infos.length) {
                    ILocalResource local = infos[i].getLocalResource();
                    ILocalResource remote = infos[i].getRemoteChangeResource();
                    if (remote instanceof IResourceChange && filter.acceptRemote(remote.getResource(), remote.getStatus(), remote.getChangeMask()) || filter.accept(local)) {
                        retVal.add(local.getResource());
                    }
                    ++i;
                }
                if (filter.acceptGroupNodes()) {
                    HashSet<ISynchronizeModelElement> selection = new HashSet<ISynchronizeModelElement>(Arrays.asList(AbstractSynchronizeModelAction.this.getSelectedElements()));
                    IDiffElement[] iDiffElementArray = AbstractSynchronizeModelAction.this.getFilteredDiffElements();
                    int n = iDiffElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDiffElement element = iDiffElementArray[n2];
                        if (element instanceof ISynchronizeModelElement && retVal.contains(((ISynchronizeModelElement)element).getResource())) {
                            IDiffContainer parent = element.getParent();
                            ArrayList<IResource> parents = new ArrayList<IResource>();
                            while (parent != null && parent instanceof ISynchronizeModelElement && ((ISynchronizeModelElement)parent).getResource() != null) {
                                IResource parentResource = ((ISynchronizeModelElement)parent).getResource();
                                try {
                                    ILocalResource local;
                                    AbstractSVNSyncInfo info = (AbstractSVNSyncInfo)UpdateSubscriber.instance().getSyncInfo(parentResource);
                                    if (info != null && !IStateFilter.SF_UNVERSIONED_EXTERNAL.accept(local = info.getLocalResource())) {
                                        parents.add(parentResource);
                                    }
                                    if (selection.contains(parent)) {
                                        retVal.addAll(parents);
                                        break;
                                    }
                                    parent = parent.getParent();
                                }
                                catch (Exception e) {
                                    LoggedOperation.reportError((String)this.getClass().getName(), (Throwable)e);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                return retVal.toArray(new IResource[retVal.size()]);
            }
        };
    }

    public IResource getSelectedResource() {
        ISynchronizeModelElement[] selection = this.getSelectedElements();
        return selection.length == 0 ? null : this.getSelectedElements()[0].getResource();
    }

    public IResource[] getAllSelectedResources() {
        ISynchronizeModelElement[] selection;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        ISynchronizeModelElement[] iSynchronizeModelElementArray = selection = this.getSelectedElements();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizeModelElement modelElement = iSynchronizeModelElementArray[n2];
            IResource resource = modelElement.getResource();
            if (resource != null) {
                resources.add(resource);
            }
            ++n2;
        }
        return resources.toArray(new IResource[0]);
    }

    public AbstractSVNSyncInfo getSelectedSVNSyncInfo() {
        ISynchronizeModelElement[] selection = this.getSelectedElements();
        if (selection.length == 0 || !(selection[0] instanceof SyncInfoModelElement)) {
            return null;
        }
        return (AbstractSVNSyncInfo)((SyncInfoModelElement)selection[0]).getSyncInfo();
    }

    public AbstractSVNSyncInfo[] getSVNSyncInfos() {
        ArrayList<AbstractSVNSyncInfo> filtered = new ArrayList<AbstractSVNSyncInfo>();
        IDiffElement[] iDiffElementArray = this.getFilteredDiffElements();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement e = iDiffElementArray[n2];
            filtered.add((AbstractSVNSyncInfo)((SyncInfoModelElement)e).getSyncInfo());
            ++n2;
        }
        return filtered.toArray(new AbstractSVNSyncInfo[filtered.size()]);
    }

    protected ISynchronizeModelElement[] getSelectedElements() {
        ArrayList<ISynchronizeModelElement> retVal = new ArrayList<ISynchronizeModelElement>();
        IStructuredSelection selection = this.getStructuredSelection();
        for (Object element : selection) {
            if (!(element instanceof ISynchronizeModelElement)) continue;
            retVal.add((ISynchronizeModelElement)element);
        }
        return retVal.toArray(new ISynchronizeModelElement[retVal.size()]);
    }

    public IResourceSelector getSyncInfoSelector() {
        return this.syncInfoSelector;
    }
}

