/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.merge;

import java.util.Collection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSubscriber;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.MergeSubscriber;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.operation.MergeScope;
import org.eclipse.team.svn.ui.synchronize.AbstractSVNParticipant;
import org.eclipse.team.svn.ui.synchronize.AbstractSynchronizeActionGroup;
import org.eclipse.team.svn.ui.synchronize.SynchronizeLabelDecorator;
import org.eclipse.team.svn.ui.utility.OverlayedImageDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeParticipant
extends AbstractSVNParticipant {
    public static final String PARTICIPANT_ID = MergeParticipant.class.getName();
    public static final int SUPPORTED_MODES = 15;
    protected IPropertyChangeListener configurationListener;

    public MergeParticipant() {
    }

    public MergeParticipant(ISynchronizeScope scope) {
        super(scope);
    }

    @Override
    public AbstractSVNSubscriber getMatchingSubscriber() {
        MergeSubscriber subscriber = MergeSubscriber.instance();
        MergeScope scope = (MergeScope)this.getScope();
        subscriber.setMergeScopeHelper(scope.getMergeScopeHelper());
        return subscriber;
    }

    @Override
    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    protected String getParticipantId() {
        return PARTICIPANT_ID;
    }

    @Override
    protected Collection<AbstractSynchronizeActionGroup> getActionGroups() {
        return ExtensionsManager.getInstance().getCurrentSynchronizeActionContributor().getMergeContributions();
    }

    @Override
    protected int getSupportedModes() {
        return 15;
    }

    @Override
    protected int getDefaultMode() {
        return 4;
    }

    protected String getShortTaskName() {
        return SVNUIMessages.MergeView_TaskName;
    }

    @Override
    protected ILabelDecorator createLabelDecorator(ISynchronizePageConfiguration configuration) {
        return new MergeLabelDecorator(configuration);
    }

    protected class MergeLabelDecorator
    extends SynchronizeLabelDecorator {
        public MergeLabelDecorator(ISynchronizePageConfiguration configuration) {
            super(configuration);
        }

        public Image decorateImage(Image image, Object element) {
            ILocalResource local;
            AbstractSVNSyncInfo info = this.getSyncInfo(element);
            if (info != null && (info.getKind() & 0xF) == 15 && IStateFilter.SF_PREREPLACEDREPLACED.accept(local = info.getLocalResource())) {
                return this.registerImageDescriptor(new OverlayedImageDescriptor(image, AbstractSVNParticipant.OVR_REPLACED_CONF, new Point(22, 16), OverlayedImageDescriptor.RIGHT | OverlayedImageDescriptor.CENTER_V));
            }
            return super.decorateImage(image, element);
        }
    }
}

