/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.copymove;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.wizard.AbstractSVNWizard;
import org.eclipse.team.svn.ui.wizard.copymove.CommentWizardPage;
import org.eclipse.team.svn.ui.wizard.copymove.SelectDestinationPage;

public class CopyMoveWizard
extends AbstractSVNWizard {
    protected SelectDestinationPage destinationPage;
    protected CommentWizardPage commentPage;
    protected IRepositoryResource[] selectedResources;
    protected boolean isMove;
    protected IRepositoryResource destination;
    protected String comment;
    protected String newName;

    public CopyMoveWizard(IRepositoryResource[] selectedResources, boolean isMove) {
        this.selectedResources = selectedResources;
        this.isMove = isMove;
        this.setWindowTitle(this.isMove ? SVNUIMessages.MoveToAction_Select_Title : SVNUIMessages.CopyToAction_Select_Title);
    }

    public void addPages() {
        this.destinationPage = new SelectDestinationPage(this.selectedResources);
        this.addPage((IWizardPage)this.destinationPage);
        this.commentPage = new CommentWizardPage(this.isMove);
        this.addPage((IWizardPage)this.commentPage);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof SelectDestinationPage) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        this.destination = this.destinationPage.getDestination();
        this.newName = this.destinationPage.getNewResourceName();
        this.comment = this.commentPage.getComment();
        return true;
    }

    public String getComment() {
        return this.comment;
    }

    public String getNewName() {
        return this.newName;
    }

    public IRepositoryResource getDestination() {
        return this.destination;
    }
}

