/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.IResumeAtLineTarget;
import org.eclipse.cdt.debug.internal.ui.actions.RetargetAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class RetargetResumeAtLineAction
extends RetargetAction {
    private DebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;

    @Override
    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fWindow).removeDebugContextListener((IDebugContextListener)this.fContextListener);
        super.dispose();
    }

    @Override
    public void init(IWorkbenchWindow window) {
        super.init(window);
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(window);
        service.addDebugContextListener((IDebugContextListener)this.fContextListener);
        ISelection activeContext = service.getActiveContext();
        this.fContextListener.contextActivated(activeContext);
    }

    @Override
    protected boolean canPerformAction(Object target, ISelection selection, IWorkbenchPart part) {
        return this.fTargetElement != null && ((IResumeAtLineTarget)target).canResumeAtLine(part, selection, this.fTargetElement);
    }

    @Override
    protected Class getAdapterClass() {
        return IResumeAtLineTarget.class;
    }

    @Override
    protected void performAction(Object target, ISelection selection, IWorkbenchPart part) throws CoreException {
        ((IResumeAtLineTarget)target).resumeAtLine(part, selection, this.fTargetElement);
    }

    @Override
    protected String getOperationUnavailableMessage() {
        return ActionMessages.getString("RetargetResumeAtLineAction.0");
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fTargetElement == null) {
            action.setEnabled(false);
        } else {
            super.selectionChanged(action, selection);
        }
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        protected void contextActivated(ISelection selection) {
            IAction action;
            IStructuredSelection ss;
            RetargetResumeAtLineAction.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                RetargetResumeAtLineAction.this.fTargetElement = (ISuspendResume)DebugPlugin.getAdapter((Object)ss.getFirstElement(), ISuspendResume.class);
            }
            if ((action = RetargetResumeAtLineAction.this.getAction()) != null) {
                action.setEnabled(RetargetResumeAtLineAction.this.fTargetElement != null && RetargetResumeAtLineAction.this.hasTargetAdapter());
            }
        }

        public void debugContextChanged(DebugContextEvent event) {
            this.contextActivated(event.getContext());
        }
    }
}

