/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.disassembly.editor;

import org.eclipse.cdt.debug.core.disassembly.IDisassemblyContextProvider;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.actions.breakpoints.CBreakpointPropertiesRulerAction;
import org.eclipse.cdt.debug.internal.ui.actions.breakpoints.EnableDisableBreakpointRulerAction;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DisassemblyDocumentProvider;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DisassemblyPane;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.DocumentContentProvider;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualDocument;
import org.eclipse.cdt.debug.internal.ui.disassembly.viewer.VirtualSourceViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.ToggleBreakpointAction;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DisassemblyEditor
extends EditorPart
implements ITextEditor,
IReusableEditor,
IDebugContextListener,
IPropertyChangeListener {
    private DisassemblyPane fDisassemblyPane = new DisassemblyPane("#DisassemblyEditorContext", "#DisassemblyEditorRulerContext");

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        ((DisassemblyDocumentProvider)this.getDocumentProvider()).getDocumentPresentation(input).addPropertyChangeListener(this);
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.fDisassemblyPane.create(parent);
        this.createActions();
        if (this.getSite() != null) {
            this.getSite().registerContextMenu(this.fDisassemblyPane.getViewContextMenuId(), this.fDisassemblyPane.getTextMenuManager(), (ISelectionProvider)this.getViewer());
        }
        if (this.getSite() != null) {
            this.getSite().registerContextMenu(this.fDisassemblyPane.getRulerContextMenuId(), this.fDisassemblyPane.getTextMenuManager(), (ISelectionProvider)this.getViewer());
        }
        VirtualSourceViewer viewer = this.fDisassemblyPane.getViewer();
        IEditorInput input = this.getEditorInput();
        if (input instanceof DisassemblyEditorInput) {
            Object debugContext = ((DisassemblyEditorInput)input).getDebugContext();
            VirtualDocument document = (VirtualDocument)this.getDocumentProvider().getDocument((Object)input);
            IAnnotationModel annotationModel = this.getDocumentProvider().getAnnotationModel((Object)input);
            viewer.setDocument((IDocument)document, annotationModel);
            ((VirtualDocument)viewer.getDocument()).getContentProvider().changeInput(viewer, document.getPresentationContext(), null, debugContext, document.getCurrentOffset());
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
        ((DisassemblyDocumentProvider)this.getDocumentProvider()).getDocumentPresentation(this.getEditorInput()).removePropertyChangeListener(this);
        this.getDocumentProvider().disconnect((Object)this.getEditorInput());
        this.fDisassemblyPane.dispose();
        super.dispose();
    }

    public final void setInput(IEditorInput input) {
        super.setInput(input);
        Object debugContext = ((DisassemblyEditorInput)input).getDebugContext();
        try {
            this.getDocumentProvider().connect((Object)input);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        VirtualDocument document = (VirtualDocument)this.getDocumentProvider().getDocument((Object)input);
        VirtualSourceViewer viewer = this.getViewer();
        if (document != null && viewer != null) {
            DocumentContentProvider contentProvider = document.getContentProvider();
            Object oldInput = contentProvider.getInput();
            contentProvider.changeInput(this.getViewer(), document.getPresentationContext(), oldInput, debugContext, document.getCurrentOffset());
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        DisassemblyEditorInput oldInput;
        Object disassemblyContext;
        IDisassemblyContextProvider contextProvider;
        IStructuredSelection ss;
        Object context;
        ISelection selection = event.getContext();
        if (selection instanceof IStructuredSelection && (context = (ss = (IStructuredSelection)selection).getFirstElement()) != null && (contextProvider = this.getDisassemblyContextProvider(context)) != null && (disassemblyContext = contextProvider.getDisassemblyContext(context)) != null && (oldInput = (DisassemblyEditorInput)this.getEditorInput()).getDisassemblyContext().equals(disassemblyContext)) {
            this.setInput(new DisassemblyEditorInput(context, disassemblyContext));
        }
    }

    private IDisassemblyContextProvider getDisassemblyContextProvider(Object element) {
        IDisassemblyContextProvider adapter = null;
        if (element instanceof IDisassemblyContextProvider) {
            adapter = (IDisassemblyContextProvider)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            adapter = (IDisassemblyContextProvider)adaptable.getAdapter(IDisassemblyContextProvider.class);
        }
        return adapter;
    }

    private VirtualSourceViewer getViewer() {
        return this.fDisassemblyPane.getViewer();
    }

    public void close(boolean save) {
    }

    public void doRevertToSaved() {
    }

    public IAction getAction(String actionId) {
        return null;
    }

    public IDocumentProvider getDocumentProvider() {
        return CDebugUIPlugin.getDefault().getDisassemblyEditorManager().getDocumentProvider();
    }

    public IRegion getHighlightRange() {
        return null;
    }

    public ISelectionProvider getSelectionProvider() {
        VirtualSourceViewer viewer = this.getViewer();
        return viewer != null ? viewer.getSelectionProvider() : null;
    }

    public boolean isEditable() {
        return false;
    }

    public void removeActionActivationCode(String actionId) {
    }

    public void resetHighlightRange() {
    }

    public void selectAndReveal(int offset, int length) {
    }

    public void setAction(String actionID, IAction action) {
        this.fDisassemblyPane.setAction(actionID, action);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
    }

    public boolean showsHighlightRangeOnly() {
        return false;
    }

    protected void createActions() {
        IVerticalRuler ruler = this.fDisassemblyPane.getVerticalRuler();
        Object action = new ToggleBreakpointAction((IWorkbenchPart)this, null, (IVerticalRulerInfo)ruler);
        this.setAction(IInternalCDebugUIConstants.ACTION_TOGGLE_BREAKPOINT, (IAction)action);
        action = new EnableDisableBreakpointRulerAction((IWorkbenchPart)this, (IVerticalRulerInfo)ruler);
        this.setAction(IInternalCDebugUIConstants.ACTION_ENABLE_DISABLE_BREAKPOINT, (IAction)action);
        action = new CBreakpointPropertiesRulerAction((IWorkbenchPart)this, (IVerticalRulerInfo)ruler);
        this.setAction(IInternalCDebugUIConstants.ACTION_BREAKPOINT_PROPERTIES, (IAction)action);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getViewer().refresh();
    }

    public Object getAdapter(Class adapter) {
        if (IDocument.class.equals((Object)adapter)) {
            return this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        }
        return super.getAdapter(adapter);
    }
}

