/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.code.flow;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.rewrite.util.ASTNodes;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.DoWhileFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.ForFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.GenericConditionalFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.RangeBasedForFlowInfo;
import org.eclipse.cdt.internal.corext.refactoring.code.flow.Selection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;

public class InputFlowAnalyzer
extends FlowAnalyzer {
    private Selection fSelection;
    private boolean fDoLoopReentrance;
    private LoopReentranceVisitor fLoopReentranceVisitor;
    private GotoReentranceVisitor fGotoReentranceVisitor;

    public InputFlowAnalyzer(FlowContext context, Selection selection, boolean doLoopReentrance) {
        super(context);
        this.fSelection = selection;
        Assert.isNotNull((Object)this.fSelection);
        this.fDoLoopReentrance = doLoopReentrance;
    }

    public FlowInfo perform(IASTFunctionDefinition node) {
        node.accept((ASTVisitor)this);
        if (this.fDoLoopReentrance) {
            GotoLoopRegion[] gotoRegions;
            GotoAnalyzer gotoAnalyzer = new GotoAnalyzer();
            node.accept((ASTVisitor)gotoAnalyzer);
            GotoLoopRegion[] gotoLoopRegionArray = gotoRegions = gotoAnalyzer.getGotoRegions();
            int n = gotoRegions.length;
            int n2 = 0;
            while (n2 < n) {
                GotoLoopRegion loopRegion = gotoLoopRegionArray[n2];
                if (this.fSelection.coveredBy(loopRegion)) {
                    GenericSequentialFlowInfo info = this.createSequential();
                    info.merge(this.getFlowInfo((IASTNode)node), this.fFlowContext);
                    this.fGotoReentranceVisitor = new GotoReentranceVisitor(this.fFlowContext, this.fSelection, loopRegion);
                    FlowInfo gotoInfo = this.fGotoReentranceVisitor.process(node);
                    info.merge(gotoInfo, this.fFlowContext);
                    this.setFlowInfo((IASTNode)node, info);
                    break;
                }
                ++n2;
            }
        }
        return this.getFlowInfo((IASTNode)node);
    }

    @Override
    protected boolean traverseNode(IASTNode node) {
        if (this.fSelection.covers(node)) {
            return false;
        }
        if (node instanceof IASTLabelStatement) {
            return true;
        }
        return ASTNodes.endOffset((IASTNode)node) >= this.fSelection.getEnd();
    }

    @Override
    protected boolean shouldCreateReturnFlowInfo(IASTReturnStatement node) {
        return ASTNodes.offset((IASTNode)node) >= this.fSelection.getEnd();
    }

    @Override
    public int visit(IASTDoStatement node) {
        this.createLoopReentranceVisitor((IASTNode)node);
        return super.visit(node);
    }

    @Override
    public int visit(ICPPASTRangeBasedForStatement node) {
        this.createLoopReentranceVisitor((IASTNode)node);
        return super.visit(node);
    }

    @Override
    public int visit(IASTForStatement node) {
        this.createLoopReentranceVisitor((IASTNode)node);
        return super.visit(node);
    }

    @Override
    public int visit(IASTWhileStatement node) {
        this.createLoopReentranceVisitor((IASTNode)node);
        return super.visit(node);
    }

    private void createLoopReentranceVisitor(IASTNode node) {
        if (this.fLoopReentranceVisitor == null && this.fDoLoopReentrance && this.fSelection.coveredBy(node)) {
            this.fLoopReentranceVisitor = new LoopReentranceVisitor(this.fFlowContext, this.fSelection, node);
        }
    }

    @Override
    public int leave(IASTConditionalExpression node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        IASTExpression thenPart = node.getPositiveResultExpression();
        IASTExpression elsePart = node.getNegativeResultExpression();
        if (thenPart != null && this.fSelection.coveredBy((IASTNode)thenPart) || elsePart != null && this.fSelection.coveredBy((IASTNode)elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo((IASTNode)node, info);
            this.leaveConditional(info, (IASTNode)node.getLogicalConditionExpression(), new IASTNode[]{thenPart, elsePart});
            return 1;
        }
        return super.leave(node);
    }

    @Override
    public int leave(IASTDoStatement node) {
        super.leave(node);
        this.handleLoopReentrance((IASTNode)node);
        return 1;
    }

    @Override
    public int leave(IASTIfStatement node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        IASTStatement thenPart = node.getThenClause();
        IASTStatement elsePart = node.getElseClause();
        if (thenPart != null && this.fSelection.coveredBy((IASTNode)thenPart) || elsePart != null && this.fSelection.coveredBy((IASTNode)elsePart)) {
            GenericSequentialFlowInfo info = this.createSequential();
            this.setFlowInfo((IASTNode)node, info);
            this.leaveConditional(info, (IASTNode)node.getConditionExpression(), new IASTNode[]{thenPart, elsePart});
            return 1;
        }
        return super.leave(node);
    }

    @Override
    public int leave(ICPPASTRangeBasedForStatement node) {
        super.leave(node);
        this.handleLoopReentrance((IASTNode)node);
        return 1;
    }

    @Override
    public int leave(IASTForStatement node) {
        super.leave(node);
        this.handleLoopReentrance((IASTNode)node);
        return 1;
    }

    @Override
    public int leave(IASTSwitchStatement node) {
        if (this.skipNode((IASTNode)node)) {
            return 1;
        }
        FlowAnalyzer.SwitchData data = this.createSwitchData(node);
        IRegion[] ranges = data.getRanges();
        int i = 0;
        while (i < ranges.length) {
            IRegion range = ranges[i];
            if (this.fSelection.coveredBy(range)) {
                GenericSequentialFlowInfo info = this.createSequential();
                this.setFlowInfo((IASTNode)node, info);
                info.merge(this.getFlowInfo((IASTNode)node.getControllerExpression()), this.fFlowContext);
                info.merge(data.getInfo(i), this.fFlowContext);
                info.removeLabel(null);
                return 1;
            }
            ++i;
        }
        return super.leave(node, data);
    }

    @Override
    public int leave(IASTWhileStatement node) {
        super.leave(node);
        this.handleLoopReentrance((IASTNode)node);
        return 1;
    }

    private void leaveConditional(GenericSequentialFlowInfo info, IASTNode condition, IASTNode[] branches) {
        info.merge(this.getFlowInfo(condition), this.fFlowContext);
        IASTNode[] iASTNodeArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode branch = iASTNodeArray[n2];
            if (branch != null && this.fSelection.coveredBy(branch)) {
                info.merge(this.getFlowInfo(branch), this.fFlowContext);
                break;
            }
            ++n2;
        }
    }

    private void handleLoopReentrance(IASTNode node) {
        if (this.fLoopReentranceVisitor == null || this.fLoopReentranceVisitor.getLoopNode() != node) {
            return;
        }
        this.fLoopReentranceVisitor.process(node);
        GenericSequentialFlowInfo info = this.createSequential();
        info.merge(this.getFlowInfo(node), this.fFlowContext);
        info.merge(this.fLoopReentranceVisitor.getFlowInfo(node), this.fFlowContext);
        this.setFlowInfo(node, info);
    }

    private static boolean isBefore(IASTNode node1, IASTNode node2) {
        return CPPSemantics.declaredBefore((Object)node1, (IASTNode)node2, (boolean)false);
    }

    private static class GotoAnalyzer
    extends ASTVisitor {
        private GotoLoopRegion[] gotoRegions = new GotoLoopRegion[0];

        public GotoAnalyzer() {
            this.shouldVisitStatements = true;
        }

        public int visit(IASTStatement node) {
            if (!(node instanceof IASTLabelStatement)) {
                return 3;
            }
            IASTLabelStatement labelStatement = (IASTLabelStatement)node;
            IASTName labelName = ((IASTLabelStatement)node).getName();
            IBinding binding = labelName.resolveBinding();
            IASTName[] references = labelStatement.getTranslationUnit().getReferences(binding);
            IASTLabelStatement lastGotoStatement = null;
            IASTName[] iASTNameArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName name = iASTNameArray[n2];
                if (name.getPropertyInParent() == IASTGotoStatement.NAME) {
                    IASTLabelStatement lastStatement;
                    IASTGotoStatement gotoStatement = (IASTGotoStatement)name.getParent();
                    IASTLabelStatement iASTLabelStatement = lastStatement = lastGotoStatement != null ? lastGotoStatement : labelStatement;
                    if (InputFlowAnalyzer.isBefore((IASTNode)lastStatement, (IASTNode)gotoStatement)) {
                        lastGotoStatement = gotoStatement;
                    }
                }
                ++n2;
            }
            if (lastGotoStatement == null) {
                return 3;
            }
            GotoLoopRegion newRegion = new GotoLoopRegion(labelStatement, (IASTGotoStatement)lastGotoStatement);
            boolean gaps = false;
            int i = 0;
            while (i < this.gotoRegions.length) {
                GotoLoopRegion existing = this.gotoRegions[i];
                if (existing == null) break;
                if (InputFlowAnalyzer.isBefore((IASTNode)newRegion.firstLabelStatement, (IASTNode)existing.lastGotoStatement)) {
                    if (InputFlowAnalyzer.isBefore((IASTNode)existing.lastGotoStatement, (IASTNode)newRegion.lastGotoStatement)) {
                        existing.lastGotoStatement = newRegion.lastGotoStatement;
                        int j = i + 1;
                        while (j < this.gotoRegions.length) {
                            newRegion = this.gotoRegions[j];
                            if (newRegion == null) break;
                            if (InputFlowAnalyzer.isBefore((IASTNode)newRegion.firstLabelStatement, (IASTNode)existing.lastGotoStatement) && InputFlowAnalyzer.isBefore((IASTNode)existing.lastGotoStatement, (IASTNode)newRegion.lastGotoStatement)) {
                                existing.lastGotoStatement = newRegion.lastGotoStatement;
                            }
                            this.gotoRegions[j] = null;
                            gaps = true;
                            ++j;
                        }
                    }
                    newRegion = null;
                    break;
                }
                ++i;
            }
            if (gaps) {
                ArrayUtil.compact((Object[])this.gotoRegions);
            } else if (newRegion != null) {
                this.gotoRegions = (GotoLoopRegion[])ArrayUtil.append((Object[])this.gotoRegions, (Object)newRegion);
            }
            return 1;
        }

        public GotoLoopRegion[] getGotoRegions() {
            return (GotoLoopRegion[])ArrayUtil.trim((Object[])this.gotoRegions);
        }
    }

    private static class GotoLoopRegion
    implements IRegion {
        final IASTLabelStatement firstLabelStatement;
        IASTGotoStatement lastGotoStatement;

        GotoLoopRegion(IASTLabelStatement firstLabelStatement, IASTGotoStatement lastGotoStatement) {
            this.firstLabelStatement = firstLabelStatement;
            this.lastGotoStatement = lastGotoStatement;
        }

        public int getOffset() {
            return ASTNodes.offset((IASTNode)this.firstLabelStatement);
        }

        public int getLength() {
            return ASTNodes.endOffset((IASTNode)this.lastGotoStatement) - this.getOffset();
        }
    }

    private static class GotoReentranceVisitor
    extends FlowAnalyzer {
        private final Selection selection;
        private final GotoLoopRegion loopRegion;

        public GotoReentranceVisitor(FlowContext context, Selection selection, GotoLoopRegion loopRegion) {
            super(context);
            this.selection = selection;
            this.loopRegion = loopRegion;
        }

        @Override
        protected boolean traverseNode(IASTNode node) {
            return !this.selection.covers(node) && !InputFlowAnalyzer.isBefore(node, (IASTNode)this.loopRegion.firstLabelStatement) && !InputFlowAnalyzer.isBefore((IASTNode)this.loopRegion.lastGotoStatement, node);
        }

        @Override
        protected boolean shouldCreateReturnFlowInfo(IASTReturnStatement node) {
            return ASTNodes.endOffset((IASTNode)node) <= this.selection.getEnd();
        }

        public FlowInfo process(IASTFunctionDefinition node) {
            node.accept((ASTVisitor)this);
            return this.getFlowInfo((IASTNode)node);
        }
    }

    private static class LoopReentranceVisitor
    extends FlowAnalyzer {
        private final Selection selection;
        private final IASTNode loopNode;

        public LoopReentranceVisitor(FlowContext context, Selection selection, IASTNode loopNode) {
            super(context);
            this.selection = selection;
            this.loopNode = loopNode;
        }

        @Override
        protected boolean traverseNode(IASTNode node) {
            return true;
        }

        @Override
        protected boolean shouldCreateReturnFlowInfo(IASTReturnStatement node) {
            return ASTNodes.endOffset((IASTNode)node) <= this.selection.getEnd();
        }

        protected IASTNode getLoopNode() {
            return this.loopNode;
        }

        public void process(IASTNode node) {
            try {
                this.fFlowContext.setLoopReentranceMode(true);
                node.accept((ASTVisitor)this);
            }
            finally {
                this.fFlowContext.setLoopReentranceMode(false);
            }
        }

        @Override
        public int leave(IASTDoStatement node) {
            if (this.skipNode((IASTNode)node)) {
                return 1;
            }
            DoWhileFlowInfo info = this.createDoWhile();
            this.setFlowInfo((IASTNode)node, info);
            info.mergeAction(this.getFlowInfo((IASTNode)node.getBody()), this.fFlowContext);
            info.removeLabel(null);
            return 1;
        }

        @Override
        public int leave(ICPPASTRangeBasedForStatement node) {
            if (this.skipNode((IASTNode)node)) {
                return 1;
            }
            FlowInfo paramInfo = this.getFlowInfo((IASTNode)node.getDeclaration());
            FlowInfo expressionInfo = this.getFlowInfo((IASTNode)node.getInitializerClause());
            FlowInfo actionInfo = this.getFlowInfo((IASTNode)node.getBody());
            RangeBasedForFlowInfo forInfo = this.createRangeBasedFor();
            this.setFlowInfo((IASTNode)node, forInfo);
            if (node == this.loopNode) {
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                forInfo.mergeInitializerClause(expressionInfo, this.fFlowContext);
                forInfo.mergeDeclaration(paramInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
            return 1;
        }

        @Override
        public int leave(IASTForStatement node) {
            if (this.skipNode((IASTNode)node)) {
                return 1;
            }
            GenericSequentialFlowInfo initInfo = this.createSequential((IASTNode)node.getInitializerStatement());
            FlowInfo conditionInfo = this.getFlowInfo((IASTNode)node.getConditionExpression());
            GenericSequentialFlowInfo incrementInfo = this.createSequential((IASTNode)node.getIterationExpression());
            FlowInfo actionInfo = this.getFlowInfo((IASTNode)node.getBody());
            ForFlowInfo forInfo = this.createFor();
            this.setFlowInfo((IASTNode)node, forInfo);
            if (node == this.loopNode) {
                forInfo.mergeIncrement(incrementInfo, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            } else {
                GenericConditionalFlowInfo initIncr = new GenericConditionalFlowInfo();
                initIncr.merge(initInfo, this.fFlowContext);
                initIncr.merge(incrementInfo, this.fFlowContext);
                forInfo.mergeAccessModeSequential(initIncr, this.fFlowContext);
                forInfo.mergeCondition(conditionInfo, this.fFlowContext);
                forInfo.mergeAction(actionInfo, this.fFlowContext);
            }
            forInfo.removeLabel(null);
            return 1;
        }
    }
}

